/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutomationHybridRunbookWorkerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/automation_hybrid_runbook_worker#automation_account_name AutomationHybridRunbookWorker#automation_account_name}
    */
    readonly automationAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/automation_hybrid_runbook_worker#id AutomationHybridRunbookWorker#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/automation_hybrid_runbook_worker#resource_group_name AutomationHybridRunbookWorker#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/automation_hybrid_runbook_worker#vm_resource_id AutomationHybridRunbookWorker#vm_resource_id}
    */
    readonly vmResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/automation_hybrid_runbook_worker#worker_group_name AutomationHybridRunbookWorker#worker_group_name}
    */
    readonly workerGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/automation_hybrid_runbook_worker#worker_id AutomationHybridRunbookWorker#worker_id}
    */
    readonly workerId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/automation_hybrid_runbook_worker#timeouts AutomationHybridRunbookWorker#timeouts}
    */
    readonly timeouts?: AutomationHybridRunbookWorkerTimeouts;
}
export interface AutomationHybridRunbookWorkerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/automation_hybrid_runbook_worker#create AutomationHybridRunbookWorker#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/automation_hybrid_runbook_worker#delete AutomationHybridRunbookWorker#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/automation_hybrid_runbook_worker#read AutomationHybridRunbookWorker#read}
    */
    readonly read?: string;
}
export declare function automationHybridRunbookWorkerTimeoutsToTerraform(struct?: AutomationHybridRunbookWorkerTimeouts | cdktf.IResolvable): any;
export declare function automationHybridRunbookWorkerTimeoutsToHclTerraform(struct?: AutomationHybridRunbookWorkerTimeouts | cdktf.IResolvable): any;
export declare class AutomationHybridRunbookWorkerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationHybridRunbookWorkerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationHybridRunbookWorkerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/automation_hybrid_runbook_worker azurerm_automation_hybrid_runbook_worker}
*/
export declare class AutomationHybridRunbookWorker extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_automation_hybrid_runbook_worker";
    /**
    * Generates CDKTF code for importing a AutomationHybridRunbookWorker resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AutomationHybridRunbookWorker to import
    * @param importFromId The id of the existing AutomationHybridRunbookWorker that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/automation_hybrid_runbook_worker#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AutomationHybridRunbookWorker to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/automation_hybrid_runbook_worker azurerm_automation_hybrid_runbook_worker} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutomationHybridRunbookWorkerConfig
    */
    constructor(scope: Construct, id: string, config: AutomationHybridRunbookWorkerConfig);
    private _automationAccountName?;
    get automationAccountName(): string;
    set automationAccountName(value: string);
    get automationAccountNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ip(): string;
    get lastSeenDateTime(): string;
    get registrationDateTime(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _vmResourceId?;
    get vmResourceId(): string;
    set vmResourceId(value: string);
    get vmResourceIdInput(): string | undefined;
    private _workerGroupName?;
    get workerGroupName(): string;
    set workerGroupName(value: string);
    get workerGroupNameInput(): string | undefined;
    private _workerId?;
    get workerId(): string;
    set workerId(value: string);
    get workerIdInput(): string | undefined;
    get workerName(): string;
    get workerType(): string;
    private _timeouts;
    get timeouts(): AutomationHybridRunbookWorkerTimeoutsOutputReference;
    putTimeouts(value: AutomationHybridRunbookWorkerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AutomationHybridRunbookWorkerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
