/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BotChannelSlackConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack#bot_name BotChannelSlack#bot_name}
    */
    readonly botName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack#client_id BotChannelSlack#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack#client_secret BotChannelSlack#client_secret}
    */
    readonly clientSecret: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack#id BotChannelSlack#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack#landing_page_url BotChannelSlack#landing_page_url}
    */
    readonly landingPageUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack#location BotChannelSlack#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack#resource_group_name BotChannelSlack#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack#signing_secret BotChannelSlack#signing_secret}
    */
    readonly signingSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack#verification_token BotChannelSlack#verification_token}
    */
    readonly verificationToken: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack#timeouts BotChannelSlack#timeouts}
    */
    readonly timeouts?: BotChannelSlackTimeouts;
}
export interface BotChannelSlackTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack#create BotChannelSlack#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack#delete BotChannelSlack#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack#read BotChannelSlack#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack#update BotChannelSlack#update}
    */
    readonly update?: string;
}
export declare function botChannelSlackTimeoutsToTerraform(struct?: BotChannelSlackTimeouts | cdktf.IResolvable): any;
export declare function botChannelSlackTimeoutsToHclTerraform(struct?: BotChannelSlackTimeouts | cdktf.IResolvable): any;
export declare class BotChannelSlackTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BotChannelSlackTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BotChannelSlackTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack azurerm_bot_channel_slack}
*/
export declare class BotChannelSlack extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_bot_channel_slack";
    /**
    * Generates CDKTF code for importing a BotChannelSlack resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the BotChannelSlack to import
    * @param importFromId The id of the existing BotChannelSlack that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the BotChannelSlack to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_channel_slack azurerm_bot_channel_slack} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BotChannelSlackConfig
    */
    constructor(scope: Construct, id: string, config: BotChannelSlackConfig);
    private _botName?;
    get botName(): string;
    set botName(value: string);
    get botNameInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _landingPageUrl?;
    get landingPageUrl(): string;
    set landingPageUrl(value: string);
    resetLandingPageUrl(): void;
    get landingPageUrlInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _signingSecret?;
    get signingSecret(): string;
    set signingSecret(value: string);
    resetSigningSecret(): void;
    get signingSecretInput(): string | undefined;
    private _verificationToken?;
    get verificationToken(): string;
    set verificationToken(value: string);
    get verificationTokenInput(): string | undefined;
    private _timeouts;
    get timeouts(): BotChannelSlackTimeoutsOutputReference;
    putTimeouts(value: BotChannelSlackTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BotChannelSlackTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
