/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BotServiceAzureBotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#cmk_key_vault_key_url BotServiceAzureBot#cmk_key_vault_key_url}
    */
    readonly cmkKeyVaultKeyUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#developer_app_insights_api_key BotServiceAzureBot#developer_app_insights_api_key}
    */
    readonly developerAppInsightsApiKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#developer_app_insights_application_id BotServiceAzureBot#developer_app_insights_application_id}
    */
    readonly developerAppInsightsApplicationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#developer_app_insights_key BotServiceAzureBot#developer_app_insights_key}
    */
    readonly developerAppInsightsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#display_name BotServiceAzureBot#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#endpoint BotServiceAzureBot#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#icon_url BotServiceAzureBot#icon_url}
    */
    readonly iconUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#id BotServiceAzureBot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#local_authentication_enabled BotServiceAzureBot#local_authentication_enabled}
    */
    readonly localAuthenticationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#location BotServiceAzureBot#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#luis_app_ids BotServiceAzureBot#luis_app_ids}
    */
    readonly luisAppIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#luis_key BotServiceAzureBot#luis_key}
    */
    readonly luisKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#microsoft_app_id BotServiceAzureBot#microsoft_app_id}
    */
    readonly microsoftAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#microsoft_app_msi_id BotServiceAzureBot#microsoft_app_msi_id}
    */
    readonly microsoftAppMsiId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#microsoft_app_tenant_id BotServiceAzureBot#microsoft_app_tenant_id}
    */
    readonly microsoftAppTenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#microsoft_app_type BotServiceAzureBot#microsoft_app_type}
    */
    readonly microsoftAppType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#name BotServiceAzureBot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#public_network_access_enabled BotServiceAzureBot#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#resource_group_name BotServiceAzureBot#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#sku BotServiceAzureBot#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#streaming_endpoint_enabled BotServiceAzureBot#streaming_endpoint_enabled}
    */
    readonly streamingEndpointEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#tags BotServiceAzureBot#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#timeouts BotServiceAzureBot#timeouts}
    */
    readonly timeouts?: BotServiceAzureBotTimeouts;
}
export interface BotServiceAzureBotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#create BotServiceAzureBot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#delete BotServiceAzureBot#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#read BotServiceAzureBot#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#update BotServiceAzureBot#update}
    */
    readonly update?: string;
}
export declare function botServiceAzureBotTimeoutsToTerraform(struct?: BotServiceAzureBotTimeouts | cdktf.IResolvable): any;
export declare function botServiceAzureBotTimeoutsToHclTerraform(struct?: BotServiceAzureBotTimeouts | cdktf.IResolvable): any;
export declare class BotServiceAzureBotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BotServiceAzureBotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BotServiceAzureBotTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot azurerm_bot_service_azure_bot}
*/
export declare class BotServiceAzureBot extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_bot_service_azure_bot";
    /**
    * Generates CDKTF code for importing a BotServiceAzureBot resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the BotServiceAzureBot to import
    * @param importFromId The id of the existing BotServiceAzureBot that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the BotServiceAzureBot to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/bot_service_azure_bot azurerm_bot_service_azure_bot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BotServiceAzureBotConfig
    */
    constructor(scope: Construct, id: string, config: BotServiceAzureBotConfig);
    private _cmkKeyVaultKeyUrl?;
    get cmkKeyVaultKeyUrl(): string;
    set cmkKeyVaultKeyUrl(value: string);
    resetCmkKeyVaultKeyUrl(): void;
    get cmkKeyVaultKeyUrlInput(): string | undefined;
    private _developerAppInsightsApiKey?;
    get developerAppInsightsApiKey(): string;
    set developerAppInsightsApiKey(value: string);
    resetDeveloperAppInsightsApiKey(): void;
    get developerAppInsightsApiKeyInput(): string | undefined;
    private _developerAppInsightsApplicationId?;
    get developerAppInsightsApplicationId(): string;
    set developerAppInsightsApplicationId(value: string);
    resetDeveloperAppInsightsApplicationId(): void;
    get developerAppInsightsApplicationIdInput(): string | undefined;
    private _developerAppInsightsKey?;
    get developerAppInsightsKey(): string;
    set developerAppInsightsKey(value: string);
    resetDeveloperAppInsightsKey(): void;
    get developerAppInsightsKeyInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _iconUrl?;
    get iconUrl(): string;
    set iconUrl(value: string);
    resetIconUrl(): void;
    get iconUrlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _localAuthenticationEnabled?;
    get localAuthenticationEnabled(): boolean | cdktf.IResolvable;
    set localAuthenticationEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthenticationEnabled(): void;
    get localAuthenticationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _luisAppIds?;
    get luisAppIds(): string[];
    set luisAppIds(value: string[]);
    resetLuisAppIds(): void;
    get luisAppIdsInput(): string[] | undefined;
    private _luisKey?;
    get luisKey(): string;
    set luisKey(value: string);
    resetLuisKey(): void;
    get luisKeyInput(): string | undefined;
    private _microsoftAppId?;
    get microsoftAppId(): string;
    set microsoftAppId(value: string);
    get microsoftAppIdInput(): string | undefined;
    private _microsoftAppMsiId?;
    get microsoftAppMsiId(): string;
    set microsoftAppMsiId(value: string);
    resetMicrosoftAppMsiId(): void;
    get microsoftAppMsiIdInput(): string | undefined;
    private _microsoftAppTenantId?;
    get microsoftAppTenantId(): string;
    set microsoftAppTenantId(value: string);
    resetMicrosoftAppTenantId(): void;
    get microsoftAppTenantIdInput(): string | undefined;
    private _microsoftAppType?;
    get microsoftAppType(): string;
    set microsoftAppType(value: string);
    resetMicrosoftAppType(): void;
    get microsoftAppTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _streamingEndpointEnabled?;
    get streamingEndpointEnabled(): boolean | cdktf.IResolvable;
    set streamingEndpointEnabled(value: boolean | cdktf.IResolvable);
    resetStreamingEndpointEnabled(): void;
    get streamingEndpointEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): BotServiceAzureBotTimeoutsOutputReference;
    putTimeouts(value: BotServiceAzureBotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BotServiceAzureBotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
