/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ChaosStudioCapabilityConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/chaos_studio_capability#capability_type ChaosStudioCapability#capability_type}
    */
    readonly capabilityType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/chaos_studio_capability#chaos_studio_target_id ChaosStudioCapability#chaos_studio_target_id}
    */
    readonly chaosStudioTargetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/chaos_studio_capability#id ChaosStudioCapability#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/chaos_studio_capability#timeouts ChaosStudioCapability#timeouts}
    */
    readonly timeouts?: ChaosStudioCapabilityTimeouts;
}
export interface ChaosStudioCapabilityTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/chaos_studio_capability#create ChaosStudioCapability#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/chaos_studio_capability#delete ChaosStudioCapability#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/chaos_studio_capability#read ChaosStudioCapability#read}
    */
    readonly read?: string;
}
export declare function chaosStudioCapabilityTimeoutsToTerraform(struct?: ChaosStudioCapabilityTimeouts | cdktf.IResolvable): any;
export declare function chaosStudioCapabilityTimeoutsToHclTerraform(struct?: ChaosStudioCapabilityTimeouts | cdktf.IResolvable): any;
export declare class ChaosStudioCapabilityTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ChaosStudioCapabilityTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ChaosStudioCapabilityTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/chaos_studio_capability azurerm_chaos_studio_capability}
*/
export declare class ChaosStudioCapability extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_chaos_studio_capability";
    /**
    * Generates CDKTF code for importing a ChaosStudioCapability resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ChaosStudioCapability to import
    * @param importFromId The id of the existing ChaosStudioCapability that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/chaos_studio_capability#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ChaosStudioCapability to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/chaos_studio_capability azurerm_chaos_studio_capability} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ChaosStudioCapabilityConfig
    */
    constructor(scope: Construct, id: string, config: ChaosStudioCapabilityConfig);
    private _capabilityType?;
    get capabilityType(): string;
    set capabilityType(value: string);
    get capabilityTypeInput(): string | undefined;
    private _chaosStudioTargetId?;
    get chaosStudioTargetId(): string;
    set chaosStudioTargetId(value: string);
    get chaosStudioTargetIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get urn(): string;
    private _timeouts;
    get timeouts(): ChaosStudioCapabilityTimeoutsOutputReference;
    putTimeouts(value: ChaosStudioCapabilityTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ChaosStudioCapabilityTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
