/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CognitiveAccountRaiBlocklistConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/cognitive_account_rai_blocklist#cognitive_account_id CognitiveAccountRaiBlocklist#cognitive_account_id}
    */
    readonly cognitiveAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/cognitive_account_rai_blocklist#description CognitiveAccountRaiBlocklist#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/cognitive_account_rai_blocklist#id CognitiveAccountRaiBlocklist#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/cognitive_account_rai_blocklist#name CognitiveAccountRaiBlocklist#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/cognitive_account_rai_blocklist#timeouts CognitiveAccountRaiBlocklist#timeouts}
    */
    readonly timeouts?: CognitiveAccountRaiBlocklistTimeouts;
}
export interface CognitiveAccountRaiBlocklistTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/cognitive_account_rai_blocklist#create CognitiveAccountRaiBlocklist#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/cognitive_account_rai_blocklist#delete CognitiveAccountRaiBlocklist#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/cognitive_account_rai_blocklist#read CognitiveAccountRaiBlocklist#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/cognitive_account_rai_blocklist#update CognitiveAccountRaiBlocklist#update}
    */
    readonly update?: string;
}
export declare function cognitiveAccountRaiBlocklistTimeoutsToTerraform(struct?: CognitiveAccountRaiBlocklistTimeouts | cdktf.IResolvable): any;
export declare function cognitiveAccountRaiBlocklistTimeoutsToHclTerraform(struct?: CognitiveAccountRaiBlocklistTimeouts | cdktf.IResolvable): any;
export declare class CognitiveAccountRaiBlocklistTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CognitiveAccountRaiBlocklistTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CognitiveAccountRaiBlocklistTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/cognitive_account_rai_blocklist azurerm_cognitive_account_rai_blocklist}
*/
export declare class CognitiveAccountRaiBlocklist extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cognitive_account_rai_blocklist";
    /**
    * Generates CDKTF code for importing a CognitiveAccountRaiBlocklist resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CognitiveAccountRaiBlocklist to import
    * @param importFromId The id of the existing CognitiveAccountRaiBlocklist that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/cognitive_account_rai_blocklist#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CognitiveAccountRaiBlocklist to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/cognitive_account_rai_blocklist azurerm_cognitive_account_rai_blocklist} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CognitiveAccountRaiBlocklistConfig
    */
    constructor(scope: Construct, id: string, config: CognitiveAccountRaiBlocklistConfig);
    private _cognitiveAccountId?;
    get cognitiveAccountId(): string;
    set cognitiveAccountId(value: string);
    get cognitiveAccountIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): CognitiveAccountRaiBlocklistTimeoutsOutputReference;
    putTimeouts(value: CognitiveAccountRaiBlocklistTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CognitiveAccountRaiBlocklistTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
