/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DashboardGrafanaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#api_key_enabled DashboardGrafana#api_key_enabled}
    */
    readonly apiKeyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#auto_generated_domain_name_label_scope DashboardGrafana#auto_generated_domain_name_label_scope}
    */
    readonly autoGeneratedDomainNameLabelScope?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#deterministic_outbound_ip_enabled DashboardGrafana#deterministic_outbound_ip_enabled}
    */
    readonly deterministicOutboundIpEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#grafana_major_version DashboardGrafana#grafana_major_version}
    */
    readonly grafanaMajorVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#id DashboardGrafana#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#location DashboardGrafana#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#name DashboardGrafana#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#public_network_access_enabled DashboardGrafana#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#resource_group_name DashboardGrafana#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#sku DashboardGrafana#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#tags DashboardGrafana#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#zone_redundancy_enabled DashboardGrafana#zone_redundancy_enabled}
    */
    readonly zoneRedundancyEnabled?: boolean | cdktf.IResolvable;
    /**
    * azure_monitor_workspace_integrations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#azure_monitor_workspace_integrations DashboardGrafana#azure_monitor_workspace_integrations}
    */
    readonly azureMonitorWorkspaceIntegrations?: DashboardGrafanaAzureMonitorWorkspaceIntegrations[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#identity DashboardGrafana#identity}
    */
    readonly identity?: DashboardGrafanaIdentity;
    /**
    * smtp block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#smtp DashboardGrafana#smtp}
    */
    readonly smtp?: DashboardGrafanaSmtp;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#timeouts DashboardGrafana#timeouts}
    */
    readonly timeouts?: DashboardGrafanaTimeouts;
}
export interface DashboardGrafanaAzureMonitorWorkspaceIntegrations {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#resource_id DashboardGrafana#resource_id}
    */
    readonly resourceId: string;
}
export declare function dashboardGrafanaAzureMonitorWorkspaceIntegrationsToTerraform(struct?: DashboardGrafanaAzureMonitorWorkspaceIntegrations | cdktf.IResolvable): any;
export declare function dashboardGrafanaAzureMonitorWorkspaceIntegrationsToHclTerraform(struct?: DashboardGrafanaAzureMonitorWorkspaceIntegrations | cdktf.IResolvable): any;
export declare class DashboardGrafanaAzureMonitorWorkspaceIntegrationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardGrafanaAzureMonitorWorkspaceIntegrations | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardGrafanaAzureMonitorWorkspaceIntegrations | cdktf.IResolvable | undefined);
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    get resourceIdInput(): string | undefined;
}
export declare class DashboardGrafanaAzureMonitorWorkspaceIntegrationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardGrafanaAzureMonitorWorkspaceIntegrations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardGrafanaAzureMonitorWorkspaceIntegrationsOutputReference;
}
export interface DashboardGrafanaIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#identity_ids DashboardGrafana#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#type DashboardGrafana#type}
    */
    readonly type: string;
}
export declare function dashboardGrafanaIdentityToTerraform(struct?: DashboardGrafanaIdentityOutputReference | DashboardGrafanaIdentity): any;
export declare function dashboardGrafanaIdentityToHclTerraform(struct?: DashboardGrafanaIdentityOutputReference | DashboardGrafanaIdentity): any;
export declare class DashboardGrafanaIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardGrafanaIdentity | undefined;
    set internalValue(value: DashboardGrafanaIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface DashboardGrafanaSmtp {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#enabled DashboardGrafana#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#from_address DashboardGrafana#from_address}
    */
    readonly fromAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#from_name DashboardGrafana#from_name}
    */
    readonly fromName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#host DashboardGrafana#host}
    */
    readonly host: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#password DashboardGrafana#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#start_tls_policy DashboardGrafana#start_tls_policy}
    */
    readonly startTlsPolicy: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#user DashboardGrafana#user}
    */
    readonly user: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#verification_skip_enabled DashboardGrafana#verification_skip_enabled}
    */
    readonly verificationSkipEnabled?: boolean | cdktf.IResolvable;
}
export declare function dashboardGrafanaSmtpToTerraform(struct?: DashboardGrafanaSmtpOutputReference | DashboardGrafanaSmtp): any;
export declare function dashboardGrafanaSmtpToHclTerraform(struct?: DashboardGrafanaSmtpOutputReference | DashboardGrafanaSmtp): any;
export declare class DashboardGrafanaSmtpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardGrafanaSmtp | undefined;
    set internalValue(value: DashboardGrafanaSmtp | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _fromAddress?;
    get fromAddress(): string;
    set fromAddress(value: string);
    get fromAddressInput(): string | undefined;
    private _fromName?;
    get fromName(): string;
    set fromName(value: string);
    resetFromName(): void;
    get fromNameInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _startTlsPolicy?;
    get startTlsPolicy(): string;
    set startTlsPolicy(value: string);
    get startTlsPolicyInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    get userInput(): string | undefined;
    private _verificationSkipEnabled?;
    get verificationSkipEnabled(): boolean | cdktf.IResolvable;
    set verificationSkipEnabled(value: boolean | cdktf.IResolvable);
    resetVerificationSkipEnabled(): void;
    get verificationSkipEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DashboardGrafanaTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#create DashboardGrafana#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#delete DashboardGrafana#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#read DashboardGrafana#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#update DashboardGrafana#update}
    */
    readonly update?: string;
}
export declare function dashboardGrafanaTimeoutsToTerraform(struct?: DashboardGrafanaTimeouts | cdktf.IResolvable): any;
export declare function dashboardGrafanaTimeoutsToHclTerraform(struct?: DashboardGrafanaTimeouts | cdktf.IResolvable): any;
export declare class DashboardGrafanaTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardGrafanaTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardGrafanaTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana azurerm_dashboard_grafana}
*/
export declare class DashboardGrafana extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_dashboard_grafana";
    /**
    * Generates CDKTF code for importing a DashboardGrafana resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DashboardGrafana to import
    * @param importFromId The id of the existing DashboardGrafana that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DashboardGrafana to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dashboard_grafana azurerm_dashboard_grafana} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DashboardGrafanaConfig
    */
    constructor(scope: Construct, id: string, config: DashboardGrafanaConfig);
    private _apiKeyEnabled?;
    get apiKeyEnabled(): boolean | cdktf.IResolvable;
    set apiKeyEnabled(value: boolean | cdktf.IResolvable);
    resetApiKeyEnabled(): void;
    get apiKeyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autoGeneratedDomainNameLabelScope?;
    get autoGeneratedDomainNameLabelScope(): string;
    set autoGeneratedDomainNameLabelScope(value: string);
    resetAutoGeneratedDomainNameLabelScope(): void;
    get autoGeneratedDomainNameLabelScopeInput(): string | undefined;
    private _deterministicOutboundIpEnabled?;
    get deterministicOutboundIpEnabled(): boolean | cdktf.IResolvable;
    set deterministicOutboundIpEnabled(value: boolean | cdktf.IResolvable);
    resetDeterministicOutboundIpEnabled(): void;
    get deterministicOutboundIpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get endpoint(): string;
    private _grafanaMajorVersion?;
    get grafanaMajorVersion(): string;
    set grafanaMajorVersion(value: string);
    get grafanaMajorVersionInput(): string | undefined;
    get grafanaVersion(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIp(): string[];
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zoneRedundancyEnabled?;
    get zoneRedundancyEnabled(): boolean | cdktf.IResolvable;
    set zoneRedundancyEnabled(value: boolean | cdktf.IResolvable);
    resetZoneRedundancyEnabled(): void;
    get zoneRedundancyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _azureMonitorWorkspaceIntegrations;
    get azureMonitorWorkspaceIntegrations(): DashboardGrafanaAzureMonitorWorkspaceIntegrationsList;
    putAzureMonitorWorkspaceIntegrations(value: DashboardGrafanaAzureMonitorWorkspaceIntegrations[] | cdktf.IResolvable): void;
    resetAzureMonitorWorkspaceIntegrations(): void;
    get azureMonitorWorkspaceIntegrationsInput(): cdktf.IResolvable | DashboardGrafanaAzureMonitorWorkspaceIntegrations[] | undefined;
    private _identity;
    get identity(): DashboardGrafanaIdentityOutputReference;
    putIdentity(value: DashboardGrafanaIdentity): void;
    resetIdentity(): void;
    get identityInput(): DashboardGrafanaIdentity | undefined;
    private _smtp;
    get smtp(): DashboardGrafanaSmtpOutputReference;
    putSmtp(value: DashboardGrafanaSmtp): void;
    resetSmtp(): void;
    get smtpInput(): DashboardGrafanaSmtp | undefined;
    private _timeouts;
    get timeouts(): DashboardGrafanaTimeoutsOutputReference;
    putTimeouts(value: DashboardGrafanaTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DashboardGrafanaTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
