/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermContainerRegistryCacheRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/container_registry_cache_rule#container_registry_id DataAzurermContainerRegistryCacheRule#container_registry_id}
    */
    readonly containerRegistryId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/container_registry_cache_rule#id DataAzurermContainerRegistryCacheRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/container_registry_cache_rule#name DataAzurermContainerRegistryCacheRule#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/container_registry_cache_rule#timeouts DataAzurermContainerRegistryCacheRule#timeouts}
    */
    readonly timeouts?: DataAzurermContainerRegistryCacheRuleTimeouts;
}
export interface DataAzurermContainerRegistryCacheRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/container_registry_cache_rule#read DataAzurermContainerRegistryCacheRule#read}
    */
    readonly read?: string;
}
export declare function dataAzurermContainerRegistryCacheRuleTimeoutsToTerraform(struct?: DataAzurermContainerRegistryCacheRuleTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermContainerRegistryCacheRuleTimeoutsToHclTerraform(struct?: DataAzurermContainerRegistryCacheRuleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermContainerRegistryCacheRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermContainerRegistryCacheRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermContainerRegistryCacheRuleTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/container_registry_cache_rule azurerm_container_registry_cache_rule}
*/
export declare class DataAzurermContainerRegistryCacheRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_container_registry_cache_rule";
    /**
    * Generates CDKTF code for importing a DataAzurermContainerRegistryCacheRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermContainerRegistryCacheRule to import
    * @param importFromId The id of the existing DataAzurermContainerRegistryCacheRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/container_registry_cache_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermContainerRegistryCacheRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/container_registry_cache_rule azurerm_container_registry_cache_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermContainerRegistryCacheRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermContainerRegistryCacheRuleConfig);
    private _containerRegistryId?;
    get containerRegistryId(): string;
    set containerRegistryId(value: string);
    get containerRegistryIdInput(): string | undefined;
    get credentialSetId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get sourceRepo(): string;
    get targetRepo(): string;
    private _timeouts;
    get timeouts(): DataAzurermContainerRegistryCacheRuleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermContainerRegistryCacheRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermContainerRegistryCacheRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
