/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermExtendedLocationCustomLocationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/extended_location_custom_location#id DataAzurermExtendedLocationCustomLocation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/extended_location_custom_location#name DataAzurermExtendedLocationCustomLocation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/extended_location_custom_location#resource_group_name DataAzurermExtendedLocationCustomLocation#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/extended_location_custom_location#timeouts DataAzurermExtendedLocationCustomLocation#timeouts}
    */
    readonly timeouts?: DataAzurermExtendedLocationCustomLocationTimeouts;
}
export interface DataAzurermExtendedLocationCustomLocationAuthentication {
}
export declare function dataAzurermExtendedLocationCustomLocationAuthenticationToTerraform(struct?: DataAzurermExtendedLocationCustomLocationAuthentication): any;
export declare function dataAzurermExtendedLocationCustomLocationAuthenticationToHclTerraform(struct?: DataAzurermExtendedLocationCustomLocationAuthentication): any;
export declare class DataAzurermExtendedLocationCustomLocationAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermExtendedLocationCustomLocationAuthentication | undefined;
    set internalValue(value: DataAzurermExtendedLocationCustomLocationAuthentication | undefined);
    get type(): string;
    get value(): string;
}
export declare class DataAzurermExtendedLocationCustomLocationAuthenticationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermExtendedLocationCustomLocationAuthenticationOutputReference;
}
export interface DataAzurermExtendedLocationCustomLocationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/extended_location_custom_location#read DataAzurermExtendedLocationCustomLocation#read}
    */
    readonly read?: string;
}
export declare function dataAzurermExtendedLocationCustomLocationTimeoutsToTerraform(struct?: DataAzurermExtendedLocationCustomLocationTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermExtendedLocationCustomLocationTimeoutsToHclTerraform(struct?: DataAzurermExtendedLocationCustomLocationTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermExtendedLocationCustomLocationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermExtendedLocationCustomLocationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermExtendedLocationCustomLocationTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/extended_location_custom_location azurerm_extended_location_custom_location}
*/
export declare class DataAzurermExtendedLocationCustomLocation extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_extended_location_custom_location";
    /**
    * Generates CDKTF code for importing a DataAzurermExtendedLocationCustomLocation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermExtendedLocationCustomLocation to import
    * @param importFromId The id of the existing DataAzurermExtendedLocationCustomLocation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/extended_location_custom_location#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermExtendedLocationCustomLocation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/extended_location_custom_location azurerm_extended_location_custom_location} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermExtendedLocationCustomLocationConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermExtendedLocationCustomLocationConfig);
    private _authentication;
    get authentication(): DataAzurermExtendedLocationCustomLocationAuthenticationList;
    get clusterExtensionIds(): string[];
    get displayName(): string;
    get hostResourceId(): string;
    get hostType(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get namespace(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermExtendedLocationCustomLocationTimeoutsOutputReference;
    putTimeouts(value: DataAzurermExtendedLocationCustomLocationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermExtendedLocationCustomLocationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
