/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKeyVaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/key_vault#id DataAzurermKeyVault#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/key_vault#name DataAzurermKeyVault#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/key_vault#resource_group_name DataAzurermKeyVault#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/key_vault#timeouts DataAzurermKeyVault#timeouts}
    */
    readonly timeouts?: DataAzurermKeyVaultTimeouts;
}
export interface DataAzurermKeyVaultAccessPolicy {
}
export declare function dataAzurermKeyVaultAccessPolicyToTerraform(struct?: DataAzurermKeyVaultAccessPolicy): any;
export declare function dataAzurermKeyVaultAccessPolicyToHclTerraform(struct?: DataAzurermKeyVaultAccessPolicy): any;
export declare class DataAzurermKeyVaultAccessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKeyVaultAccessPolicy | undefined;
    set internalValue(value: DataAzurermKeyVaultAccessPolicy | undefined);
    get applicationId(): string;
    get certificatePermissions(): string[];
    get keyPermissions(): string[];
    get objectId(): string;
    get secretPermissions(): string[];
    get storagePermissions(): string[];
    get tenantId(): string;
}
export declare class DataAzurermKeyVaultAccessPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKeyVaultAccessPolicyOutputReference;
}
export interface DataAzurermKeyVaultNetworkAcls {
}
export declare function dataAzurermKeyVaultNetworkAclsToTerraform(struct?: DataAzurermKeyVaultNetworkAcls): any;
export declare function dataAzurermKeyVaultNetworkAclsToHclTerraform(struct?: DataAzurermKeyVaultNetworkAcls): any;
export declare class DataAzurermKeyVaultNetworkAclsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKeyVaultNetworkAcls | undefined;
    set internalValue(value: DataAzurermKeyVaultNetworkAcls | undefined);
    get bypass(): string;
    get defaultAction(): string;
    get ipRules(): string[];
    get virtualNetworkSubnetIds(): string[];
}
export declare class DataAzurermKeyVaultNetworkAclsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKeyVaultNetworkAclsOutputReference;
}
export interface DataAzurermKeyVaultTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/key_vault#read DataAzurermKeyVault#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultTimeoutsToTerraform(struct?: DataAzurermKeyVaultTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermKeyVaultTimeoutsToHclTerraform(struct?: DataAzurermKeyVaultTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKeyVaultTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKeyVaultTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermKeyVaultTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/key_vault azurerm_key_vault}
*/
export declare class DataAzurermKeyVault extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_key_vault";
    /**
    * Generates CDKTF code for importing a DataAzurermKeyVault resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermKeyVault to import
    * @param importFromId The id of the existing DataAzurermKeyVault that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/key_vault#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermKeyVault to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/key_vault azurerm_key_vault} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKeyVaultConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultConfig);
    private _accessPolicy;
    get accessPolicy(): DataAzurermKeyVaultAccessPolicyList;
    get enableRbacAuthorization(): cdktf.IResolvable;
    get enabledForDeployment(): cdktf.IResolvable;
    get enabledForDiskEncryption(): cdktf.IResolvable;
    get enabledForTemplateDeployment(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkAcls;
    get networkAcls(): DataAzurermKeyVaultNetworkAclsList;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    get purgeProtectionEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get tenantId(): string;
    get vaultUri(): string;
    private _timeouts;
    get timeouts(): DataAzurermKeyVaultTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKeyVaultTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermKeyVaultTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
