/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetworkManagerNetworkGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/network_manager_network_group#id DataAzurermNetworkManagerNetworkGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/network_manager_network_group#name DataAzurermNetworkManagerNetworkGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/network_manager_network_group#network_manager_id DataAzurermNetworkManagerNetworkGroup#network_manager_id}
    */
    readonly networkManagerId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/network_manager_network_group#timeouts DataAzurermNetworkManagerNetworkGroup#timeouts}
    */
    readonly timeouts?: DataAzurermNetworkManagerNetworkGroupTimeouts;
}
export interface DataAzurermNetworkManagerNetworkGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/network_manager_network_group#read DataAzurermNetworkManagerNetworkGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetworkManagerNetworkGroupTimeoutsToTerraform(struct?: DataAzurermNetworkManagerNetworkGroupTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermNetworkManagerNetworkGroupTimeoutsToHclTerraform(struct?: DataAzurermNetworkManagerNetworkGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetworkManagerNetworkGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNetworkManagerNetworkGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNetworkManagerNetworkGroupTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/network_manager_network_group azurerm_network_manager_network_group}
*/
export declare class DataAzurermNetworkManagerNetworkGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_network_manager_network_group";
    /**
    * Generates CDKTF code for importing a DataAzurermNetworkManagerNetworkGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNetworkManagerNetworkGroup to import
    * @param importFromId The id of the existing DataAzurermNetworkManagerNetworkGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/network_manager_network_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNetworkManagerNetworkGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/network_manager_network_group azurerm_network_manager_network_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetworkManagerNetworkGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetworkManagerNetworkGroupConfig);
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkManagerId?;
    get networkManagerId(): string;
    set networkManagerId(value: string);
    get networkManagerIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermNetworkManagerNetworkGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetworkManagerNetworkGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNetworkManagerNetworkGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
