/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNginxApiKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_api_key#id DataAzurermNginxApiKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_api_key#name DataAzurermNginxApiKey#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_api_key#nginx_deployment_id DataAzurermNginxApiKey#nginx_deployment_id}
    */
    readonly nginxDeploymentId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_api_key#timeouts DataAzurermNginxApiKey#timeouts}
    */
    readonly timeouts?: DataAzurermNginxApiKeyTimeouts;
}
export interface DataAzurermNginxApiKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_api_key#read DataAzurermNginxApiKey#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNginxApiKeyTimeoutsToTerraform(struct?: DataAzurermNginxApiKeyTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermNginxApiKeyTimeoutsToHclTerraform(struct?: DataAzurermNginxApiKeyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNginxApiKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNginxApiKeyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNginxApiKeyTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_api_key azurerm_nginx_api_key}
*/
export declare class DataAzurermNginxApiKey extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_nginx_api_key";
    /**
    * Generates CDKTF code for importing a DataAzurermNginxApiKey resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNginxApiKey to import
    * @param importFromId The id of the existing DataAzurermNginxApiKey that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_api_key#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNginxApiKey to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_api_key azurerm_nginx_api_key} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNginxApiKeyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNginxApiKeyConfig);
    get endDateTime(): string;
    get hint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nginxDeploymentId?;
    get nginxDeploymentId(): string;
    set nginxDeploymentId(value: string);
    get nginxDeploymentIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermNginxApiKeyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNginxApiKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNginxApiKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
