/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNginxDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_deployment#id DataAzurermNginxDeployment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_deployment#name DataAzurermNginxDeployment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_deployment#resource_group_name DataAzurermNginxDeployment#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_deployment#timeouts DataAzurermNginxDeployment#timeouts}
    */
    readonly timeouts?: DataAzurermNginxDeploymentTimeouts;
}
export interface DataAzurermNginxDeploymentAutoScaleProfile {
}
export declare function dataAzurermNginxDeploymentAutoScaleProfileToTerraform(struct?: DataAzurermNginxDeploymentAutoScaleProfile): any;
export declare function dataAzurermNginxDeploymentAutoScaleProfileToHclTerraform(struct?: DataAzurermNginxDeploymentAutoScaleProfile): any;
export declare class DataAzurermNginxDeploymentAutoScaleProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNginxDeploymentAutoScaleProfile | undefined;
    set internalValue(value: DataAzurermNginxDeploymentAutoScaleProfile | undefined);
    get maxCapacity(): number;
    get minCapacity(): number;
    get name(): string;
}
export declare class DataAzurermNginxDeploymentAutoScaleProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNginxDeploymentAutoScaleProfileOutputReference;
}
export interface DataAzurermNginxDeploymentFrontendPrivate {
}
export declare function dataAzurermNginxDeploymentFrontendPrivateToTerraform(struct?: DataAzurermNginxDeploymentFrontendPrivate): any;
export declare function dataAzurermNginxDeploymentFrontendPrivateToHclTerraform(struct?: DataAzurermNginxDeploymentFrontendPrivate): any;
export declare class DataAzurermNginxDeploymentFrontendPrivateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNginxDeploymentFrontendPrivate | undefined;
    set internalValue(value: DataAzurermNginxDeploymentFrontendPrivate | undefined);
    get allocationMethod(): string;
    get ipAddress(): string;
    get subnetId(): string;
}
export declare class DataAzurermNginxDeploymentFrontendPrivateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNginxDeploymentFrontendPrivateOutputReference;
}
export interface DataAzurermNginxDeploymentFrontendPublic {
}
export declare function dataAzurermNginxDeploymentFrontendPublicToTerraform(struct?: DataAzurermNginxDeploymentFrontendPublic): any;
export declare function dataAzurermNginxDeploymentFrontendPublicToHclTerraform(struct?: DataAzurermNginxDeploymentFrontendPublic): any;
export declare class DataAzurermNginxDeploymentFrontendPublicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNginxDeploymentFrontendPublic | undefined;
    set internalValue(value: DataAzurermNginxDeploymentFrontendPublic | undefined);
    get ipAddress(): string[];
}
export declare class DataAzurermNginxDeploymentFrontendPublicList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNginxDeploymentFrontendPublicOutputReference;
}
export interface DataAzurermNginxDeploymentIdentity {
}
export declare function dataAzurermNginxDeploymentIdentityToTerraform(struct?: DataAzurermNginxDeploymentIdentity): any;
export declare function dataAzurermNginxDeploymentIdentityToHclTerraform(struct?: DataAzurermNginxDeploymentIdentity): any;
export declare class DataAzurermNginxDeploymentIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNginxDeploymentIdentity | undefined;
    set internalValue(value: DataAzurermNginxDeploymentIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermNginxDeploymentIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNginxDeploymentIdentityOutputReference;
}
export interface DataAzurermNginxDeploymentLoggingStorageAccount {
}
export declare function dataAzurermNginxDeploymentLoggingStorageAccountToTerraform(struct?: DataAzurermNginxDeploymentLoggingStorageAccount): any;
export declare function dataAzurermNginxDeploymentLoggingStorageAccountToHclTerraform(struct?: DataAzurermNginxDeploymentLoggingStorageAccount): any;
export declare class DataAzurermNginxDeploymentLoggingStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNginxDeploymentLoggingStorageAccount | undefined;
    set internalValue(value: DataAzurermNginxDeploymentLoggingStorageAccount | undefined);
    get containerName(): string;
    get name(): string;
}
export declare class DataAzurermNginxDeploymentLoggingStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNginxDeploymentLoggingStorageAccountOutputReference;
}
export interface DataAzurermNginxDeploymentNetworkInterface {
}
export declare function dataAzurermNginxDeploymentNetworkInterfaceToTerraform(struct?: DataAzurermNginxDeploymentNetworkInterface): any;
export declare function dataAzurermNginxDeploymentNetworkInterfaceToHclTerraform(struct?: DataAzurermNginxDeploymentNetworkInterface): any;
export declare class DataAzurermNginxDeploymentNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNginxDeploymentNetworkInterface | undefined;
    set internalValue(value: DataAzurermNginxDeploymentNetworkInterface | undefined);
    get subnetId(): string;
}
export declare class DataAzurermNginxDeploymentNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNginxDeploymentNetworkInterfaceOutputReference;
}
export interface DataAzurermNginxDeploymentWebApplicationFirewallStatusAttackSignaturesPackage {
}
export declare function dataAzurermNginxDeploymentWebApplicationFirewallStatusAttackSignaturesPackageToTerraform(struct?: DataAzurermNginxDeploymentWebApplicationFirewallStatusAttackSignaturesPackage): any;
export declare function dataAzurermNginxDeploymentWebApplicationFirewallStatusAttackSignaturesPackageToHclTerraform(struct?: DataAzurermNginxDeploymentWebApplicationFirewallStatusAttackSignaturesPackage): any;
export declare class DataAzurermNginxDeploymentWebApplicationFirewallStatusAttackSignaturesPackageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNginxDeploymentWebApplicationFirewallStatusAttackSignaturesPackage | undefined;
    set internalValue(value: DataAzurermNginxDeploymentWebApplicationFirewallStatusAttackSignaturesPackage | undefined);
    get revisionDatetime(): string;
    get version(): string;
}
export declare class DataAzurermNginxDeploymentWebApplicationFirewallStatusAttackSignaturesPackageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNginxDeploymentWebApplicationFirewallStatusAttackSignaturesPackageOutputReference;
}
export interface DataAzurermNginxDeploymentWebApplicationFirewallStatusBotSignaturesPackage {
}
export declare function dataAzurermNginxDeploymentWebApplicationFirewallStatusBotSignaturesPackageToTerraform(struct?: DataAzurermNginxDeploymentWebApplicationFirewallStatusBotSignaturesPackage): any;
export declare function dataAzurermNginxDeploymentWebApplicationFirewallStatusBotSignaturesPackageToHclTerraform(struct?: DataAzurermNginxDeploymentWebApplicationFirewallStatusBotSignaturesPackage): any;
export declare class DataAzurermNginxDeploymentWebApplicationFirewallStatusBotSignaturesPackageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNginxDeploymentWebApplicationFirewallStatusBotSignaturesPackage | undefined;
    set internalValue(value: DataAzurermNginxDeploymentWebApplicationFirewallStatusBotSignaturesPackage | undefined);
    get revisionDatetime(): string;
    get version(): string;
}
export declare class DataAzurermNginxDeploymentWebApplicationFirewallStatusBotSignaturesPackageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNginxDeploymentWebApplicationFirewallStatusBotSignaturesPackageOutputReference;
}
export interface DataAzurermNginxDeploymentWebApplicationFirewallStatusComponentVersions {
}
export declare function dataAzurermNginxDeploymentWebApplicationFirewallStatusComponentVersionsToTerraform(struct?: DataAzurermNginxDeploymentWebApplicationFirewallStatusComponentVersions): any;
export declare function dataAzurermNginxDeploymentWebApplicationFirewallStatusComponentVersionsToHclTerraform(struct?: DataAzurermNginxDeploymentWebApplicationFirewallStatusComponentVersions): any;
export declare class DataAzurermNginxDeploymentWebApplicationFirewallStatusComponentVersionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNginxDeploymentWebApplicationFirewallStatusComponentVersions | undefined;
    set internalValue(value: DataAzurermNginxDeploymentWebApplicationFirewallStatusComponentVersions | undefined);
    get wafEngineVersion(): string;
    get wafNginxVersion(): string;
}
export declare class DataAzurermNginxDeploymentWebApplicationFirewallStatusComponentVersionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNginxDeploymentWebApplicationFirewallStatusComponentVersionsOutputReference;
}
export interface DataAzurermNginxDeploymentWebApplicationFirewallStatusThreatCampaignsPackage {
}
export declare function dataAzurermNginxDeploymentWebApplicationFirewallStatusThreatCampaignsPackageToTerraform(struct?: DataAzurermNginxDeploymentWebApplicationFirewallStatusThreatCampaignsPackage): any;
export declare function dataAzurermNginxDeploymentWebApplicationFirewallStatusThreatCampaignsPackageToHclTerraform(struct?: DataAzurermNginxDeploymentWebApplicationFirewallStatusThreatCampaignsPackage): any;
export declare class DataAzurermNginxDeploymentWebApplicationFirewallStatusThreatCampaignsPackageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNginxDeploymentWebApplicationFirewallStatusThreatCampaignsPackage | undefined;
    set internalValue(value: DataAzurermNginxDeploymentWebApplicationFirewallStatusThreatCampaignsPackage | undefined);
    get revisionDatetime(): string;
    get version(): string;
}
export declare class DataAzurermNginxDeploymentWebApplicationFirewallStatusThreatCampaignsPackageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNginxDeploymentWebApplicationFirewallStatusThreatCampaignsPackageOutputReference;
}
export interface DataAzurermNginxDeploymentWebApplicationFirewallStatus {
}
export declare function dataAzurermNginxDeploymentWebApplicationFirewallStatusToTerraform(struct?: DataAzurermNginxDeploymentWebApplicationFirewallStatus): any;
export declare function dataAzurermNginxDeploymentWebApplicationFirewallStatusToHclTerraform(struct?: DataAzurermNginxDeploymentWebApplicationFirewallStatus): any;
export declare class DataAzurermNginxDeploymentWebApplicationFirewallStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNginxDeploymentWebApplicationFirewallStatus | undefined;
    set internalValue(value: DataAzurermNginxDeploymentWebApplicationFirewallStatus | undefined);
    private _attackSignaturesPackage;
    get attackSignaturesPackage(): DataAzurermNginxDeploymentWebApplicationFirewallStatusAttackSignaturesPackageList;
    private _botSignaturesPackage;
    get botSignaturesPackage(): DataAzurermNginxDeploymentWebApplicationFirewallStatusBotSignaturesPackageList;
    private _componentVersions;
    get componentVersions(): DataAzurermNginxDeploymentWebApplicationFirewallStatusComponentVersionsList;
    private _threatCampaignsPackage;
    get threatCampaignsPackage(): DataAzurermNginxDeploymentWebApplicationFirewallStatusThreatCampaignsPackageList;
}
export declare class DataAzurermNginxDeploymentWebApplicationFirewallStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNginxDeploymentWebApplicationFirewallStatusOutputReference;
}
export interface DataAzurermNginxDeploymentWebApplicationFirewall {
}
export declare function dataAzurermNginxDeploymentWebApplicationFirewallToTerraform(struct?: DataAzurermNginxDeploymentWebApplicationFirewall): any;
export declare function dataAzurermNginxDeploymentWebApplicationFirewallToHclTerraform(struct?: DataAzurermNginxDeploymentWebApplicationFirewall): any;
export declare class DataAzurermNginxDeploymentWebApplicationFirewallOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNginxDeploymentWebApplicationFirewall | undefined;
    set internalValue(value: DataAzurermNginxDeploymentWebApplicationFirewall | undefined);
    get activationStateEnabled(): cdktf.IResolvable;
    private _status;
    get status(): DataAzurermNginxDeploymentWebApplicationFirewallStatusList;
}
export declare class DataAzurermNginxDeploymentWebApplicationFirewallList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNginxDeploymentWebApplicationFirewallOutputReference;
}
export interface DataAzurermNginxDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_deployment#read DataAzurermNginxDeployment#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNginxDeploymentTimeoutsToTerraform(struct?: DataAzurermNginxDeploymentTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermNginxDeploymentTimeoutsToHclTerraform(struct?: DataAzurermNginxDeploymentTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNginxDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNginxDeploymentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNginxDeploymentTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_deployment azurerm_nginx_deployment}
*/
export declare class DataAzurermNginxDeployment extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_nginx_deployment";
    /**
    * Generates CDKTF code for importing a DataAzurermNginxDeployment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNginxDeployment to import
    * @param importFromId The id of the existing DataAzurermNginxDeployment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_deployment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNginxDeployment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/nginx_deployment azurerm_nginx_deployment} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNginxDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNginxDeploymentConfig);
    private _autoScaleProfile;
    get autoScaleProfile(): DataAzurermNginxDeploymentAutoScaleProfileList;
    get automaticUpgradeChannel(): string;
    get capacity(): number;
    get dataplaneApiEndpoint(): string;
    get diagnoseSupportEnabled(): cdktf.IResolvable;
    get email(): string;
    private _frontendPrivate;
    get frontendPrivate(): DataAzurermNginxDeploymentFrontendPrivateList;
    private _frontendPublic;
    get frontendPublic(): DataAzurermNginxDeploymentFrontendPublicList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermNginxDeploymentIdentityList;
    get ipAddress(): string;
    get location(): string;
    private _loggingStorageAccount;
    get loggingStorageAccount(): DataAzurermNginxDeploymentLoggingStorageAccountList;
    get managedResourceGroup(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkInterface;
    get networkInterface(): DataAzurermNginxDeploymentNetworkInterfaceList;
    get nginxVersion(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _webApplicationFirewall;
    get webApplicationFirewall(): DataAzurermNginxDeploymentWebApplicationFirewallList;
    private _timeouts;
    get timeouts(): DataAzurermNginxDeploymentTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNginxDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNginxDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
