/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermOracleAutonomousDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/oracle_autonomous_database#id DataAzurermOracleAutonomousDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/oracle_autonomous_database#name DataAzurermOracleAutonomousDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/oracle_autonomous_database#resource_group_name DataAzurermOracleAutonomousDatabase#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/oracle_autonomous_database#timeouts DataAzurermOracleAutonomousDatabase#timeouts}
    */
    readonly timeouts?: DataAzurermOracleAutonomousDatabaseTimeouts;
}
export interface DataAzurermOracleAutonomousDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/oracle_autonomous_database#read DataAzurermOracleAutonomousDatabase#read}
    */
    readonly read?: string;
}
export declare function dataAzurermOracleAutonomousDatabaseTimeoutsToTerraform(struct?: DataAzurermOracleAutonomousDatabaseTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermOracleAutonomousDatabaseTimeoutsToHclTerraform(struct?: DataAzurermOracleAutonomousDatabaseTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermOracleAutonomousDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermOracleAutonomousDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermOracleAutonomousDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/oracle_autonomous_database azurerm_oracle_autonomous_database}
*/
export declare class DataAzurermOracleAutonomousDatabase extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_oracle_autonomous_database";
    /**
    * Generates CDKTF code for importing a DataAzurermOracleAutonomousDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermOracleAutonomousDatabase to import
    * @param importFromId The id of the existing DataAzurermOracleAutonomousDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/oracle_autonomous_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermOracleAutonomousDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/oracle_autonomous_database azurerm_oracle_autonomous_database} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermOracleAutonomousDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermOracleAutonomousDatabaseConfig);
    get actualUsedDataStorageSizeInTbs(): number;
    get allocatedStorageSizeInTbs(): number;
    get allowedIps(): number[];
    get autoScalingEnabled(): cdktf.IResolvable;
    get autoScalingForStorageEnabled(): cdktf.IResolvable;
    get autonomousDatabaseId(): string;
    get availableUpgradeVersions(): string[];
    get backupRetentionPeriodInDays(): number;
    get characterSet(): string;
    get computeCount(): number;
    get cpuCoreCount(): number;
    get dataStorageSizeInGbs(): number;
    get dataStorageSizeInTbs(): number;
    get dbNodeStorageSizeInGbs(): number;
    get dbVersion(): string;
    get displayName(): string;
    get failedDataRecoveryInSeconds(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get inMemoryAreaInGbs(): number;
    get lifecycleDetails(): string;
    get localAdgAutoFailoverMaxDataLossLimit(): number;
    get localDataGuardEnabled(): cdktf.IResolvable;
    get location(): string;
    get memoryPerOracleComputeUnitInGbs(): number;
    get mtlsConnectionRequired(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nationalCharacterSet(): string;
    get nextLongTermBackupTimeStamp(): string;
    get ociUrl(): string;
    get ocid(): string;
    get peerDbId(): string;
    get peerDbIds(): string[];
    get preview(): cdktf.IResolvable;
    get previewVersionWithServiceTermsAccepted(): cdktf.IResolvable;
    get privateEndpoint(): string;
    get privateEndpointIp(): string;
    get privateEndpointLabel(): string;
    get provisionableCpus(): number[];
    get remoteDataGuardEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get serviceConsoleUrl(): string;
    get sqlWebDeveloperUrl(): string;
    get subnetId(): string;
    get supportedRegionsToCloneTo(): string[];
    private _tags;
    get tags(): cdktf.StringMap;
    get timeCreated(): string;
    get timeDataGuardRoleChanged(): string;
    get timeDeletionOfFreeAutonomousDatabase(): string;
    get timeLocalDataGuardEnabledOn(): string;
    get timeMaintenanceBegin(): string;
    get timeMaintenanceEnd(): string;
    get timeOfLastFailover(): string;
    get timeOfLastRefresh(): string;
    get timeOfLastRefreshPoint(): string;
    get timeOfLastSwitchover(): string;
    get timeReclamationOfFreeAutonomousDatabase(): string;
    get usedDataStorageSizeInGbs(): number;
    get usedDataStorageSizeInTbs(): number;
    get virtualNetworkId(): string;
    private _timeouts;
    get timeouts(): DataAzurermOracleAutonomousDatabaseTimeoutsOutputReference;
    putTimeouts(value: DataAzurermOracleAutonomousDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermOracleAutonomousDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
