/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPolicyAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/policy_assignment#id DataAzurermPolicyAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/policy_assignment#name DataAzurermPolicyAssignment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/policy_assignment#scope_id DataAzurermPolicyAssignment#scope_id}
    */
    readonly scopeId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/policy_assignment#timeouts DataAzurermPolicyAssignment#timeouts}
    */
    readonly timeouts?: DataAzurermPolicyAssignmentTimeouts;
}
export interface DataAzurermPolicyAssignmentIdentity {
}
export declare function dataAzurermPolicyAssignmentIdentityToTerraform(struct?: DataAzurermPolicyAssignmentIdentity): any;
export declare function dataAzurermPolicyAssignmentIdentityToHclTerraform(struct?: DataAzurermPolicyAssignmentIdentity): any;
export declare class DataAzurermPolicyAssignmentIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermPolicyAssignmentIdentity | undefined;
    set internalValue(value: DataAzurermPolicyAssignmentIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermPolicyAssignmentIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermPolicyAssignmentIdentityOutputReference;
}
export interface DataAzurermPolicyAssignmentNonComplianceMessage {
}
export declare function dataAzurermPolicyAssignmentNonComplianceMessageToTerraform(struct?: DataAzurermPolicyAssignmentNonComplianceMessage): any;
export declare function dataAzurermPolicyAssignmentNonComplianceMessageToHclTerraform(struct?: DataAzurermPolicyAssignmentNonComplianceMessage): any;
export declare class DataAzurermPolicyAssignmentNonComplianceMessageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermPolicyAssignmentNonComplianceMessage | undefined;
    set internalValue(value: DataAzurermPolicyAssignmentNonComplianceMessage | undefined);
    get content(): string;
    get policyDefinitionReferenceId(): string;
}
export declare class DataAzurermPolicyAssignmentNonComplianceMessageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermPolicyAssignmentNonComplianceMessageOutputReference;
}
export interface DataAzurermPolicyAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/policy_assignment#read DataAzurermPolicyAssignment#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPolicyAssignmentTimeoutsToTerraform(struct?: DataAzurermPolicyAssignmentTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermPolicyAssignmentTimeoutsToHclTerraform(struct?: DataAzurermPolicyAssignmentTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPolicyAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPolicyAssignmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermPolicyAssignmentTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/policy_assignment azurerm_policy_assignment}
*/
export declare class DataAzurermPolicyAssignment extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_policy_assignment";
    /**
    * Generates CDKTF code for importing a DataAzurermPolicyAssignment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermPolicyAssignment to import
    * @param importFromId The id of the existing DataAzurermPolicyAssignment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/policy_assignment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermPolicyAssignment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/policy_assignment azurerm_policy_assignment} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPolicyAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPolicyAssignmentConfig);
    get description(): string;
    get displayName(): string;
    get enforce(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermPolicyAssignmentIdentityList;
    get location(): string;
    get metadata(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nonComplianceMessage;
    get nonComplianceMessage(): DataAzurermPolicyAssignmentNonComplianceMessageList;
    get notScopes(): string[];
    get parameters(): string;
    get policyDefinitionId(): string;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermPolicyAssignmentTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPolicyAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermPolicyAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
