/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermServicePlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/service_plan#id DataAzurermServicePlan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/service_plan#name DataAzurermServicePlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/service_plan#resource_group_name DataAzurermServicePlan#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/service_plan#timeouts DataAzurermServicePlan#timeouts}
    */
    readonly timeouts?: DataAzurermServicePlanTimeouts;
}
export interface DataAzurermServicePlanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/service_plan#read DataAzurermServicePlan#read}
    */
    readonly read?: string;
}
export declare function dataAzurermServicePlanTimeoutsToTerraform(struct?: DataAzurermServicePlanTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermServicePlanTimeoutsToHclTerraform(struct?: DataAzurermServicePlanTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermServicePlanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermServicePlanTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermServicePlanTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/service_plan azurerm_service_plan}
*/
export declare class DataAzurermServicePlan extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_service_plan";
    /**
    * Generates CDKTF code for importing a DataAzurermServicePlan resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermServicePlan to import
    * @param importFromId The id of the existing DataAzurermServicePlan that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/service_plan#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermServicePlan to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/service_plan azurerm_service_plan} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermServicePlanConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermServicePlanConfig);
    get appServiceEnvironmentId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kind(): string;
    get location(): string;
    get maximumElasticWorkerCount(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get osType(): string;
    get perSiteScalingEnabled(): cdktf.IResolvable;
    get reserved(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get workerCount(): number;
    get zoneBalancingEnabled(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermServicePlanTimeoutsOutputReference;
    putTimeouts(value: DataAzurermServicePlanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermServicePlanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
