/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStorageContainersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_containers#id DataAzurermStorageContainers#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_containers#name_prefix DataAzurermStorageContainers#name_prefix}
    */
    readonly namePrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_containers#storage_account_id DataAzurermStorageContainers#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_containers#timeouts DataAzurermStorageContainers#timeouts}
    */
    readonly timeouts?: DataAzurermStorageContainersTimeouts;
}
export interface DataAzurermStorageContainersContainers {
}
export declare function dataAzurermStorageContainersContainersToTerraform(struct?: DataAzurermStorageContainersContainers): any;
export declare function dataAzurermStorageContainersContainersToHclTerraform(struct?: DataAzurermStorageContainersContainers): any;
export declare class DataAzurermStorageContainersContainersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageContainersContainers | undefined;
    set internalValue(value: DataAzurermStorageContainersContainers | undefined);
    get dataPlaneId(): string;
    get name(): string;
    get resourceManagerId(): string;
}
export declare class DataAzurermStorageContainersContainersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageContainersContainersOutputReference;
}
export interface DataAzurermStorageContainersTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_containers#read DataAzurermStorageContainers#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStorageContainersTimeoutsToTerraform(struct?: DataAzurermStorageContainersTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermStorageContainersTimeoutsToHclTerraform(struct?: DataAzurermStorageContainersTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStorageContainersTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStorageContainersTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermStorageContainersTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_containers azurerm_storage_containers}
*/
export declare class DataAzurermStorageContainers extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_storage_containers";
    /**
    * Generates CDKTF code for importing a DataAzurermStorageContainers resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermStorageContainers to import
    * @param importFromId The id of the existing DataAzurermStorageContainers that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_containers#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermStorageContainers to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_containers azurerm_storage_containers} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStorageContainersConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStorageContainersConfig);
    private _containers;
    get containers(): DataAzurermStorageContainersContainersList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string;
    set namePrefix(value: string);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermStorageContainersTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStorageContainersTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermStorageContainersTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
