/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStorageShareConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_share#id DataAzurermStorageShare#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_share#metadata DataAzurermStorageShare#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_share#name DataAzurermStorageShare#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_share#storage_account_id DataAzurermStorageShare#storage_account_id}
    */
    readonly storageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_share#storage_account_name DataAzurermStorageShare#storage_account_name}
    */
    readonly storageAccountName?: string;
    /**
    * acl block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_share#acl DataAzurermStorageShare#acl}
    */
    readonly acl?: DataAzurermStorageShareAcl[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_share#timeouts DataAzurermStorageShare#timeouts}
    */
    readonly timeouts?: DataAzurermStorageShareTimeouts;
}
export interface DataAzurermStorageShareAclAccessPolicy {
}
export declare function dataAzurermStorageShareAclAccessPolicyToTerraform(struct?: DataAzurermStorageShareAclAccessPolicy): any;
export declare function dataAzurermStorageShareAclAccessPolicyToHclTerraform(struct?: DataAzurermStorageShareAclAccessPolicy): any;
export declare class DataAzurermStorageShareAclAccessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageShareAclAccessPolicy | undefined;
    set internalValue(value: DataAzurermStorageShareAclAccessPolicy | undefined);
    get expiry(): string;
    get permissions(): string;
    get start(): string;
}
export declare class DataAzurermStorageShareAclAccessPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageShareAclAccessPolicyOutputReference;
}
export interface DataAzurermStorageShareAcl {
}
export declare function dataAzurermStorageShareAclToTerraform(struct?: DataAzurermStorageShareAcl | cdktf.IResolvable): any;
export declare function dataAzurermStorageShareAclToHclTerraform(struct?: DataAzurermStorageShareAcl | cdktf.IResolvable): any;
export declare class DataAzurermStorageShareAclOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageShareAcl | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermStorageShareAcl | cdktf.IResolvable | undefined);
    private _accessPolicy;
    get accessPolicy(): DataAzurermStorageShareAclAccessPolicyList;
    get id(): string;
}
export declare class DataAzurermStorageShareAclList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataAzurermStorageShareAcl[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageShareAclOutputReference;
}
export interface DataAzurermStorageShareTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_share#read DataAzurermStorageShare#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStorageShareTimeoutsToTerraform(struct?: DataAzurermStorageShareTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermStorageShareTimeoutsToHclTerraform(struct?: DataAzurermStorageShareTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStorageShareTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStorageShareTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermStorageShareTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_share azurerm_storage_share}
*/
export declare class DataAzurermStorageShare extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_storage_share";
    /**
    * Generates CDKTF code for importing a DataAzurermStorageShare resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermStorageShare to import
    * @param importFromId The id of the existing DataAzurermStorageShare that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_share#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermStorageShare to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/data-sources/storage_share azurerm_storage_share} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStorageShareConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStorageShareConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get quota(): number;
    get resourceManagerId(): string;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    resetStorageAccountName(): void;
    get storageAccountNameInput(): string | undefined;
    private _acl;
    get acl(): DataAzurermStorageShareAclList;
    putAcl(value: DataAzurermStorageShareAcl[] | cdktf.IResolvable): void;
    resetAcl(): void;
    get aclInput(): cdktf.IResolvable | DataAzurermStorageShareAcl[] | undefined;
    private _timeouts;
    get timeouts(): DataAzurermStorageShareTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStorageShareTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermStorageShareTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
