/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DevCenterGalleryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dev_center_gallery#dev_center_id DevCenterGallery#dev_center_id}
    */
    readonly devCenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dev_center_gallery#id DevCenterGallery#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dev_center_gallery#name DevCenterGallery#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dev_center_gallery#shared_gallery_id DevCenterGallery#shared_gallery_id}
    */
    readonly sharedGalleryId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dev_center_gallery#timeouts DevCenterGallery#timeouts}
    */
    readonly timeouts?: DevCenterGalleryTimeouts;
}
export interface DevCenterGalleryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dev_center_gallery#create DevCenterGallery#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dev_center_gallery#delete DevCenterGallery#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dev_center_gallery#read DevCenterGallery#read}
    */
    readonly read?: string;
}
export declare function devCenterGalleryTimeoutsToTerraform(struct?: DevCenterGalleryTimeouts | cdktf.IResolvable): any;
export declare function devCenterGalleryTimeoutsToHclTerraform(struct?: DevCenterGalleryTimeouts | cdktf.IResolvable): any;
export declare class DevCenterGalleryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DevCenterGalleryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DevCenterGalleryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dev_center_gallery azurerm_dev_center_gallery}
*/
export declare class DevCenterGallery extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_dev_center_gallery";
    /**
    * Generates CDKTF code for importing a DevCenterGallery resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DevCenterGallery to import
    * @param importFromId The id of the existing DevCenterGallery that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dev_center_gallery#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DevCenterGallery to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dev_center_gallery azurerm_dev_center_gallery} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DevCenterGalleryConfig
    */
    constructor(scope: Construct, id: string, config: DevCenterGalleryConfig);
    private _devCenterId?;
    get devCenterId(): string;
    set devCenterId(value: string);
    get devCenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sharedGalleryId?;
    get sharedGalleryId(): string;
    set sharedGalleryId(value: string);
    get sharedGalleryIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DevCenterGalleryTimeoutsOutputReference;
    putTimeouts(value: DevCenterGalleryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DevCenterGalleryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
