/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DynatraceTagRulesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#id DynatraceTagRules#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#monitor_id DynatraceTagRules#monitor_id}
    */
    readonly monitorId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#name DynatraceTagRules#name}
    */
    readonly name: string;
    /**
    * log_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#log_rule DynatraceTagRules#log_rule}
    */
    readonly logRule?: DynatraceTagRulesLogRule;
    /**
    * metric_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#metric_rule DynatraceTagRules#metric_rule}
    */
    readonly metricRule?: DynatraceTagRulesMetricRule;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#timeouts DynatraceTagRules#timeouts}
    */
    readonly timeouts?: DynatraceTagRulesTimeouts;
}
export interface DynatraceTagRulesLogRuleFilteringTag {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#action DynatraceTagRules#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#name DynatraceTagRules#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#value DynatraceTagRules#value}
    */
    readonly value: string;
}
export declare function dynatraceTagRulesLogRuleFilteringTagToTerraform(struct?: DynatraceTagRulesLogRuleFilteringTag | cdktf.IResolvable): any;
export declare function dynatraceTagRulesLogRuleFilteringTagToHclTerraform(struct?: DynatraceTagRulesLogRuleFilteringTag | cdktf.IResolvable): any;
export declare class DynatraceTagRulesLogRuleFilteringTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DynatraceTagRulesLogRuleFilteringTag | cdktf.IResolvable | undefined;
    set internalValue(value: DynatraceTagRulesLogRuleFilteringTag | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class DynatraceTagRulesLogRuleFilteringTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DynatraceTagRulesLogRuleFilteringTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DynatraceTagRulesLogRuleFilteringTagOutputReference;
}
export interface DynatraceTagRulesLogRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#send_activity_logs_enabled DynatraceTagRules#send_activity_logs_enabled}
    */
    readonly sendActivityLogsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#send_azure_active_directory_logs_enabled DynatraceTagRules#send_azure_active_directory_logs_enabled}
    */
    readonly sendAzureActiveDirectoryLogsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#send_subscription_logs_enabled DynatraceTagRules#send_subscription_logs_enabled}
    */
    readonly sendSubscriptionLogsEnabled?: boolean | cdktf.IResolvable;
    /**
    * filtering_tag block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#filtering_tag DynatraceTagRules#filtering_tag}
    */
    readonly filteringTag: DynatraceTagRulesLogRuleFilteringTag[] | cdktf.IResolvable;
}
export declare function dynatraceTagRulesLogRuleToTerraform(struct?: DynatraceTagRulesLogRuleOutputReference | DynatraceTagRulesLogRule): any;
export declare function dynatraceTagRulesLogRuleToHclTerraform(struct?: DynatraceTagRulesLogRuleOutputReference | DynatraceTagRulesLogRule): any;
export declare class DynatraceTagRulesLogRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DynatraceTagRulesLogRule | undefined;
    set internalValue(value: DynatraceTagRulesLogRule | undefined);
    private _sendActivityLogsEnabled?;
    get sendActivityLogsEnabled(): boolean | cdktf.IResolvable;
    set sendActivityLogsEnabled(value: boolean | cdktf.IResolvable);
    resetSendActivityLogsEnabled(): void;
    get sendActivityLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sendAzureActiveDirectoryLogsEnabled?;
    get sendAzureActiveDirectoryLogsEnabled(): boolean | cdktf.IResolvable;
    set sendAzureActiveDirectoryLogsEnabled(value: boolean | cdktf.IResolvable);
    resetSendAzureActiveDirectoryLogsEnabled(): void;
    get sendAzureActiveDirectoryLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sendSubscriptionLogsEnabled?;
    get sendSubscriptionLogsEnabled(): boolean | cdktf.IResolvable;
    set sendSubscriptionLogsEnabled(value: boolean | cdktf.IResolvable);
    resetSendSubscriptionLogsEnabled(): void;
    get sendSubscriptionLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filteringTag;
    get filteringTag(): DynatraceTagRulesLogRuleFilteringTagList;
    putFilteringTag(value: DynatraceTagRulesLogRuleFilteringTag[] | cdktf.IResolvable): void;
    get filteringTagInput(): cdktf.IResolvable | DynatraceTagRulesLogRuleFilteringTag[] | undefined;
}
export interface DynatraceTagRulesMetricRuleFilteringTag {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#action DynatraceTagRules#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#name DynatraceTagRules#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#value DynatraceTagRules#value}
    */
    readonly value: string;
}
export declare function dynatraceTagRulesMetricRuleFilteringTagToTerraform(struct?: DynatraceTagRulesMetricRuleFilteringTag | cdktf.IResolvable): any;
export declare function dynatraceTagRulesMetricRuleFilteringTagToHclTerraform(struct?: DynatraceTagRulesMetricRuleFilteringTag | cdktf.IResolvable): any;
export declare class DynatraceTagRulesMetricRuleFilteringTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DynatraceTagRulesMetricRuleFilteringTag | cdktf.IResolvable | undefined;
    set internalValue(value: DynatraceTagRulesMetricRuleFilteringTag | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class DynatraceTagRulesMetricRuleFilteringTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DynatraceTagRulesMetricRuleFilteringTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DynatraceTagRulesMetricRuleFilteringTagOutputReference;
}
export interface DynatraceTagRulesMetricRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#sending_metrics_enabled DynatraceTagRules#sending_metrics_enabled}
    */
    readonly sendingMetricsEnabled?: boolean | cdktf.IResolvable;
    /**
    * filtering_tag block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#filtering_tag DynatraceTagRules#filtering_tag}
    */
    readonly filteringTag: DynatraceTagRulesMetricRuleFilteringTag[] | cdktf.IResolvable;
}
export declare function dynatraceTagRulesMetricRuleToTerraform(struct?: DynatraceTagRulesMetricRuleOutputReference | DynatraceTagRulesMetricRule): any;
export declare function dynatraceTagRulesMetricRuleToHclTerraform(struct?: DynatraceTagRulesMetricRuleOutputReference | DynatraceTagRulesMetricRule): any;
export declare class DynatraceTagRulesMetricRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DynatraceTagRulesMetricRule | undefined;
    set internalValue(value: DynatraceTagRulesMetricRule | undefined);
    private _sendingMetricsEnabled?;
    get sendingMetricsEnabled(): boolean | cdktf.IResolvable;
    set sendingMetricsEnabled(value: boolean | cdktf.IResolvable);
    resetSendingMetricsEnabled(): void;
    get sendingMetricsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filteringTag;
    get filteringTag(): DynatraceTagRulesMetricRuleFilteringTagList;
    putFilteringTag(value: DynatraceTagRulesMetricRuleFilteringTag[] | cdktf.IResolvable): void;
    get filteringTagInput(): cdktf.IResolvable | DynatraceTagRulesMetricRuleFilteringTag[] | undefined;
}
export interface DynatraceTagRulesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#create DynatraceTagRules#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#delete DynatraceTagRules#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#read DynatraceTagRules#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#update DynatraceTagRules#update}
    */
    readonly update?: string;
}
export declare function dynatraceTagRulesTimeoutsToTerraform(struct?: DynatraceTagRulesTimeouts | cdktf.IResolvable): any;
export declare function dynatraceTagRulesTimeoutsToHclTerraform(struct?: DynatraceTagRulesTimeouts | cdktf.IResolvable): any;
export declare class DynatraceTagRulesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DynatraceTagRulesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DynatraceTagRulesTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules azurerm_dynatrace_tag_rules}
*/
export declare class DynatraceTagRules extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_dynatrace_tag_rules";
    /**
    * Generates CDKTF code for importing a DynatraceTagRules resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DynatraceTagRules to import
    * @param importFromId The id of the existing DynatraceTagRules that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DynatraceTagRules to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/dynatrace_tag_rules azurerm_dynatrace_tag_rules} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynatraceTagRulesConfig
    */
    constructor(scope: Construct, id: string, config: DynatraceTagRulesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _monitorId?;
    get monitorId(): string;
    set monitorId(value: string);
    get monitorIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _logRule;
    get logRule(): DynatraceTagRulesLogRuleOutputReference;
    putLogRule(value: DynatraceTagRulesLogRule): void;
    resetLogRule(): void;
    get logRuleInput(): DynatraceTagRulesLogRule | undefined;
    private _metricRule;
    get metricRule(): DynatraceTagRulesMetricRuleOutputReference;
    putMetricRule(value: DynatraceTagRulesMetricRule): void;
    resetMetricRule(): void;
    get metricRuleInput(): DynatraceTagRulesMetricRule | undefined;
    private _timeouts;
    get timeouts(): DynatraceTagRulesTimeoutsOutputReference;
    putTimeouts(value: DynatraceTagRulesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DynatraceTagRulesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
