/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventgridPartnerConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration#default_maximum_expiration_time_in_days EventgridPartnerConfiguration#default_maximum_expiration_time_in_days}
    */
    readonly defaultMaximumExpirationTimeInDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration#id EventgridPartnerConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration#resource_group_name EventgridPartnerConfiguration#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration#tags EventgridPartnerConfiguration#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * partner_authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration#partner_authorization EventgridPartnerConfiguration#partner_authorization}
    */
    readonly partnerAuthorization?: EventgridPartnerConfigurationPartnerAuthorization[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration#timeouts EventgridPartnerConfiguration#timeouts}
    */
    readonly timeouts?: EventgridPartnerConfigurationTimeouts;
}
export interface EventgridPartnerConfigurationPartnerAuthorization {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration#authorization_expiration_time_in_utc EventgridPartnerConfiguration#authorization_expiration_time_in_utc}
    */
    readonly authorizationExpirationTimeInUtc?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration#partner_name EventgridPartnerConfiguration#partner_name}
    */
    readonly partnerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration#partner_registration_id EventgridPartnerConfiguration#partner_registration_id}
    */
    readonly partnerRegistrationId: string;
}
export declare function eventgridPartnerConfigurationPartnerAuthorizationToTerraform(struct?: EventgridPartnerConfigurationPartnerAuthorization | cdktf.IResolvable): any;
export declare function eventgridPartnerConfigurationPartnerAuthorizationToHclTerraform(struct?: EventgridPartnerConfigurationPartnerAuthorization | cdktf.IResolvable): any;
export declare class EventgridPartnerConfigurationPartnerAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EventgridPartnerConfigurationPartnerAuthorization | cdktf.IResolvable | undefined;
    set internalValue(value: EventgridPartnerConfigurationPartnerAuthorization | cdktf.IResolvable | undefined);
    private _authorizationExpirationTimeInUtc?;
    get authorizationExpirationTimeInUtc(): string;
    set authorizationExpirationTimeInUtc(value: string);
    resetAuthorizationExpirationTimeInUtc(): void;
    get authorizationExpirationTimeInUtcInput(): string | undefined;
    private _partnerName?;
    get partnerName(): string;
    set partnerName(value: string);
    get partnerNameInput(): string | undefined;
    private _partnerRegistrationId?;
    get partnerRegistrationId(): string;
    set partnerRegistrationId(value: string);
    get partnerRegistrationIdInput(): string | undefined;
}
export declare class EventgridPartnerConfigurationPartnerAuthorizationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: EventgridPartnerConfigurationPartnerAuthorization[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EventgridPartnerConfigurationPartnerAuthorizationOutputReference;
}
export interface EventgridPartnerConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration#create EventgridPartnerConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration#delete EventgridPartnerConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration#read EventgridPartnerConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration#update EventgridPartnerConfiguration#update}
    */
    readonly update?: string;
}
export declare function eventgridPartnerConfigurationTimeoutsToTerraform(struct?: EventgridPartnerConfigurationTimeouts | cdktf.IResolvable): any;
export declare function eventgridPartnerConfigurationTimeoutsToHclTerraform(struct?: EventgridPartnerConfigurationTimeouts | cdktf.IResolvable): any;
export declare class EventgridPartnerConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventgridPartnerConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: EventgridPartnerConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration azurerm_eventgrid_partner_configuration}
*/
export declare class EventgridPartnerConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_eventgrid_partner_configuration";
    /**
    * Generates CDKTF code for importing a EventgridPartnerConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the EventgridPartnerConfiguration to import
    * @param importFromId The id of the existing EventgridPartnerConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the EventgridPartnerConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/eventgrid_partner_configuration azurerm_eventgrid_partner_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventgridPartnerConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: EventgridPartnerConfigurationConfig);
    private _defaultMaximumExpirationTimeInDays?;
    get defaultMaximumExpirationTimeInDays(): number;
    set defaultMaximumExpirationTimeInDays(value: number);
    resetDefaultMaximumExpirationTimeInDays(): void;
    get defaultMaximumExpirationTimeInDaysInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _partnerAuthorization;
    get partnerAuthorization(): EventgridPartnerConfigurationPartnerAuthorizationList;
    putPartnerAuthorization(value: EventgridPartnerConfigurationPartnerAuthorization[] | cdktf.IResolvable): void;
    resetPartnerAuthorization(): void;
    get partnerAuthorizationInput(): cdktf.IResolvable | EventgridPartnerConfigurationPartnerAuthorization[] | undefined;
    private _timeouts;
    get timeouts(): EventgridPartnerConfigurationTimeoutsOutputReference;
    putTimeouts(value: EventgridPartnerConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | EventgridPartnerConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
