/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExpressRoutePortAuthorizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/express_route_port_authorization#express_route_port_name ExpressRoutePortAuthorization#express_route_port_name}
    */
    readonly expressRoutePortName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/express_route_port_authorization#id ExpressRoutePortAuthorization#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/express_route_port_authorization#name ExpressRoutePortAuthorization#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/express_route_port_authorization#resource_group_name ExpressRoutePortAuthorization#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/express_route_port_authorization#timeouts ExpressRoutePortAuthorization#timeouts}
    */
    readonly timeouts?: ExpressRoutePortAuthorizationTimeouts;
}
export interface ExpressRoutePortAuthorizationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/express_route_port_authorization#create ExpressRoutePortAuthorization#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/express_route_port_authorization#delete ExpressRoutePortAuthorization#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/express_route_port_authorization#read ExpressRoutePortAuthorization#read}
    */
    readonly read?: string;
}
export declare function expressRoutePortAuthorizationTimeoutsToTerraform(struct?: ExpressRoutePortAuthorizationTimeouts | cdktf.IResolvable): any;
export declare function expressRoutePortAuthorizationTimeoutsToHclTerraform(struct?: ExpressRoutePortAuthorizationTimeouts | cdktf.IResolvable): any;
export declare class ExpressRoutePortAuthorizationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExpressRoutePortAuthorizationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ExpressRoutePortAuthorizationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/express_route_port_authorization azurerm_express_route_port_authorization}
*/
export declare class ExpressRoutePortAuthorization extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_express_route_port_authorization";
    /**
    * Generates CDKTF code for importing a ExpressRoutePortAuthorization resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ExpressRoutePortAuthorization to import
    * @param importFromId The id of the existing ExpressRoutePortAuthorization that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/express_route_port_authorization#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ExpressRoutePortAuthorization to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/express_route_port_authorization azurerm_express_route_port_authorization} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExpressRoutePortAuthorizationConfig
    */
    constructor(scope: Construct, id: string, config: ExpressRoutePortAuthorizationConfig);
    get authorizationKey(): string;
    get authorizationUseStatus(): string;
    private _expressRoutePortName?;
    get expressRoutePortName(): string;
    set expressRoutePortName(value: string);
    get expressRoutePortNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ExpressRoutePortAuthorizationTimeoutsOutputReference;
    putTimeouts(value: ExpressRoutePortAuthorizationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ExpressRoutePortAuthorizationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
