/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IothubDeviceUpdateInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance#device_update_account_id IothubDeviceUpdateInstance#device_update_account_id}
    */
    readonly deviceUpdateAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance#diagnostic_enabled IothubDeviceUpdateInstance#diagnostic_enabled}
    */
    readonly diagnosticEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance#id IothubDeviceUpdateInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance#iothub_id IothubDeviceUpdateInstance#iothub_id}
    */
    readonly iothubId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance#name IothubDeviceUpdateInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance#tags IothubDeviceUpdateInstance#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * diagnostic_storage_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance#diagnostic_storage_account IothubDeviceUpdateInstance#diagnostic_storage_account}
    */
    readonly diagnosticStorageAccount?: IothubDeviceUpdateInstanceDiagnosticStorageAccount;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance#timeouts IothubDeviceUpdateInstance#timeouts}
    */
    readonly timeouts?: IothubDeviceUpdateInstanceTimeouts;
}
export interface IothubDeviceUpdateInstanceDiagnosticStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance#connection_string IothubDeviceUpdateInstance#connection_string}
    */
    readonly connectionString: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance#id IothubDeviceUpdateInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function iothubDeviceUpdateInstanceDiagnosticStorageAccountToTerraform(struct?: IothubDeviceUpdateInstanceDiagnosticStorageAccountOutputReference | IothubDeviceUpdateInstanceDiagnosticStorageAccount): any;
export declare function iothubDeviceUpdateInstanceDiagnosticStorageAccountToHclTerraform(struct?: IothubDeviceUpdateInstanceDiagnosticStorageAccountOutputReference | IothubDeviceUpdateInstanceDiagnosticStorageAccount): any;
export declare class IothubDeviceUpdateInstanceDiagnosticStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IothubDeviceUpdateInstanceDiagnosticStorageAccount | undefined;
    set internalValue(value: IothubDeviceUpdateInstanceDiagnosticStorageAccount | undefined);
    private _connectionString?;
    get connectionString(): string;
    set connectionString(value: string);
    get connectionStringInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export interface IothubDeviceUpdateInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance#create IothubDeviceUpdateInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance#delete IothubDeviceUpdateInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance#read IothubDeviceUpdateInstance#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance#update IothubDeviceUpdateInstance#update}
    */
    readonly update?: string;
}
export declare function iothubDeviceUpdateInstanceTimeoutsToTerraform(struct?: IothubDeviceUpdateInstanceTimeouts | cdktf.IResolvable): any;
export declare function iothubDeviceUpdateInstanceTimeoutsToHclTerraform(struct?: IothubDeviceUpdateInstanceTimeouts | cdktf.IResolvable): any;
export declare class IothubDeviceUpdateInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IothubDeviceUpdateInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IothubDeviceUpdateInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance azurerm_iothub_device_update_instance}
*/
export declare class IothubDeviceUpdateInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_iothub_device_update_instance";
    /**
    * Generates CDKTF code for importing a IothubDeviceUpdateInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the IothubDeviceUpdateInstance to import
    * @param importFromId The id of the existing IothubDeviceUpdateInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the IothubDeviceUpdateInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/iothub_device_update_instance azurerm_iothub_device_update_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IothubDeviceUpdateInstanceConfig
    */
    constructor(scope: Construct, id: string, config: IothubDeviceUpdateInstanceConfig);
    private _deviceUpdateAccountId?;
    get deviceUpdateAccountId(): string;
    set deviceUpdateAccountId(value: string);
    get deviceUpdateAccountIdInput(): string | undefined;
    private _diagnosticEnabled?;
    get diagnosticEnabled(): boolean | cdktf.IResolvable;
    set diagnosticEnabled(value: boolean | cdktf.IResolvable);
    resetDiagnosticEnabled(): void;
    get diagnosticEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _iothubId?;
    get iothubId(): string;
    set iothubId(value: string);
    get iothubIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _diagnosticStorageAccount;
    get diagnosticStorageAccount(): IothubDeviceUpdateInstanceDiagnosticStorageAccountOutputReference;
    putDiagnosticStorageAccount(value: IothubDeviceUpdateInstanceDiagnosticStorageAccount): void;
    resetDiagnosticStorageAccount(): void;
    get diagnosticStorageAccountInput(): IothubDeviceUpdateInstanceDiagnosticStorageAccount | undefined;
    private _timeouts;
    get timeouts(): IothubDeviceUpdateInstanceTimeoutsOutputReference;
    putTimeouts(value: IothubDeviceUpdateInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IothubDeviceUpdateInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
