/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KeyVaultCertificateContactsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/key_vault_certificate_contacts#id KeyVaultCertificateContacts#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/key_vault_certificate_contacts#key_vault_id KeyVaultCertificateContacts#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * contact block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/key_vault_certificate_contacts#contact KeyVaultCertificateContacts#contact}
    */
    readonly contact?: KeyVaultCertificateContactsContact[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/key_vault_certificate_contacts#timeouts KeyVaultCertificateContacts#timeouts}
    */
    readonly timeouts?: KeyVaultCertificateContactsTimeouts;
}
export interface KeyVaultCertificateContactsContact {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/key_vault_certificate_contacts#email KeyVaultCertificateContacts#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/key_vault_certificate_contacts#name KeyVaultCertificateContacts#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/key_vault_certificate_contacts#phone KeyVaultCertificateContacts#phone}
    */
    readonly phone?: string;
}
export declare function keyVaultCertificateContactsContactToTerraform(struct?: KeyVaultCertificateContactsContact | cdktf.IResolvable): any;
export declare function keyVaultCertificateContactsContactToHclTerraform(struct?: KeyVaultCertificateContactsContact | cdktf.IResolvable): any;
export declare class KeyVaultCertificateContactsContactOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KeyVaultCertificateContactsContact | cdktf.IResolvable | undefined;
    set internalValue(value: KeyVaultCertificateContactsContact | cdktf.IResolvable | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _phone?;
    get phone(): string;
    set phone(value: string);
    resetPhone(): void;
    get phoneInput(): string | undefined;
}
export declare class KeyVaultCertificateContactsContactList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KeyVaultCertificateContactsContact[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KeyVaultCertificateContactsContactOutputReference;
}
export interface KeyVaultCertificateContactsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/key_vault_certificate_contacts#create KeyVaultCertificateContacts#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/key_vault_certificate_contacts#delete KeyVaultCertificateContacts#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/key_vault_certificate_contacts#read KeyVaultCertificateContacts#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/key_vault_certificate_contacts#update KeyVaultCertificateContacts#update}
    */
    readonly update?: string;
}
export declare function keyVaultCertificateContactsTimeoutsToTerraform(struct?: KeyVaultCertificateContactsTimeouts | cdktf.IResolvable): any;
export declare function keyVaultCertificateContactsTimeoutsToHclTerraform(struct?: KeyVaultCertificateContactsTimeouts | cdktf.IResolvable): any;
export declare class KeyVaultCertificateContactsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultCertificateContactsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KeyVaultCertificateContactsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/key_vault_certificate_contacts azurerm_key_vault_certificate_contacts}
*/
export declare class KeyVaultCertificateContacts extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_key_vault_certificate_contacts";
    /**
    * Generates CDKTF code for importing a KeyVaultCertificateContacts resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KeyVaultCertificateContacts to import
    * @param importFromId The id of the existing KeyVaultCertificateContacts that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/key_vault_certificate_contacts#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KeyVaultCertificateContacts to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/key_vault_certificate_contacts azurerm_key_vault_certificate_contacts} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KeyVaultCertificateContactsConfig
    */
    constructor(scope: Construct, id: string, config: KeyVaultCertificateContactsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _contact;
    get contact(): KeyVaultCertificateContactsContactList;
    putContact(value: KeyVaultCertificateContactsContact[] | cdktf.IResolvable): void;
    resetContact(): void;
    get contactInput(): cdktf.IResolvable | KeyVaultCertificateContactsContact[] | undefined;
    private _timeouts;
    get timeouts(): KeyVaultCertificateContactsTimeoutsOutputReference;
    putTimeouts(value: KeyVaultCertificateContactsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KeyVaultCertificateContactsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
