/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedLustreFileSystemConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#id ManagedLustreFileSystem#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#location ManagedLustreFileSystem#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#name ManagedLustreFileSystem#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#resource_group_name ManagedLustreFileSystem#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#sku_name ManagedLustreFileSystem#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#storage_capacity_in_tb ManagedLustreFileSystem#storage_capacity_in_tb}
    */
    readonly storageCapacityInTb: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#subnet_id ManagedLustreFileSystem#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#tags ManagedLustreFileSystem#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#zones ManagedLustreFileSystem#zones}
    */
    readonly zones: string[];
    /**
    * encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#encryption_key ManagedLustreFileSystem#encryption_key}
    */
    readonly encryptionKey?: ManagedLustreFileSystemEncryptionKey;
    /**
    * hsm_setting block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#hsm_setting ManagedLustreFileSystem#hsm_setting}
    */
    readonly hsmSetting?: ManagedLustreFileSystemHsmSetting;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#identity ManagedLustreFileSystem#identity}
    */
    readonly identity?: ManagedLustreFileSystemIdentity;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#maintenance_window ManagedLustreFileSystem#maintenance_window}
    */
    readonly maintenanceWindow: ManagedLustreFileSystemMaintenanceWindow;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#timeouts ManagedLustreFileSystem#timeouts}
    */
    readonly timeouts?: ManagedLustreFileSystemTimeouts;
}
export interface ManagedLustreFileSystemEncryptionKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#key_url ManagedLustreFileSystem#key_url}
    */
    readonly keyUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#source_vault_id ManagedLustreFileSystem#source_vault_id}
    */
    readonly sourceVaultId: string;
}
export declare function managedLustreFileSystemEncryptionKeyToTerraform(struct?: ManagedLustreFileSystemEncryptionKeyOutputReference | ManagedLustreFileSystemEncryptionKey): any;
export declare function managedLustreFileSystemEncryptionKeyToHclTerraform(struct?: ManagedLustreFileSystemEncryptionKeyOutputReference | ManagedLustreFileSystemEncryptionKey): any;
export declare class ManagedLustreFileSystemEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedLustreFileSystemEncryptionKey | undefined;
    set internalValue(value: ManagedLustreFileSystemEncryptionKey | undefined);
    private _keyUrl?;
    get keyUrl(): string;
    set keyUrl(value: string);
    get keyUrlInput(): string | undefined;
    private _sourceVaultId?;
    get sourceVaultId(): string;
    set sourceVaultId(value: string);
    get sourceVaultIdInput(): string | undefined;
}
export interface ManagedLustreFileSystemHsmSetting {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#container_id ManagedLustreFileSystem#container_id}
    */
    readonly containerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#import_prefix ManagedLustreFileSystem#import_prefix}
    */
    readonly importPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#logging_container_id ManagedLustreFileSystem#logging_container_id}
    */
    readonly loggingContainerId: string;
}
export declare function managedLustreFileSystemHsmSettingToTerraform(struct?: ManagedLustreFileSystemHsmSettingOutputReference | ManagedLustreFileSystemHsmSetting): any;
export declare function managedLustreFileSystemHsmSettingToHclTerraform(struct?: ManagedLustreFileSystemHsmSettingOutputReference | ManagedLustreFileSystemHsmSetting): any;
export declare class ManagedLustreFileSystemHsmSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedLustreFileSystemHsmSetting | undefined;
    set internalValue(value: ManagedLustreFileSystemHsmSetting | undefined);
    private _containerId?;
    get containerId(): string;
    set containerId(value: string);
    get containerIdInput(): string | undefined;
    private _importPrefix?;
    get importPrefix(): string;
    set importPrefix(value: string);
    resetImportPrefix(): void;
    get importPrefixInput(): string | undefined;
    private _loggingContainerId?;
    get loggingContainerId(): string;
    set loggingContainerId(value: string);
    get loggingContainerIdInput(): string | undefined;
}
export interface ManagedLustreFileSystemIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#identity_ids ManagedLustreFileSystem#identity_ids}
    */
    readonly identityIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#type ManagedLustreFileSystem#type}
    */
    readonly type: string;
}
export declare function managedLustreFileSystemIdentityToTerraform(struct?: ManagedLustreFileSystemIdentityOutputReference | ManagedLustreFileSystemIdentity): any;
export declare function managedLustreFileSystemIdentityToHclTerraform(struct?: ManagedLustreFileSystemIdentityOutputReference | ManagedLustreFileSystemIdentity): any;
export declare class ManagedLustreFileSystemIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedLustreFileSystemIdentity | undefined;
    set internalValue(value: ManagedLustreFileSystemIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    get identityIdsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ManagedLustreFileSystemMaintenanceWindow {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#day_of_week ManagedLustreFileSystem#day_of_week}
    */
    readonly dayOfWeek: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#time_of_day_in_utc ManagedLustreFileSystem#time_of_day_in_utc}
    */
    readonly timeOfDayInUtc: string;
}
export declare function managedLustreFileSystemMaintenanceWindowToTerraform(struct?: ManagedLustreFileSystemMaintenanceWindowOutputReference | ManagedLustreFileSystemMaintenanceWindow): any;
export declare function managedLustreFileSystemMaintenanceWindowToHclTerraform(struct?: ManagedLustreFileSystemMaintenanceWindowOutputReference | ManagedLustreFileSystemMaintenanceWindow): any;
export declare class ManagedLustreFileSystemMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedLustreFileSystemMaintenanceWindow | undefined;
    set internalValue(value: ManagedLustreFileSystemMaintenanceWindow | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    get dayOfWeekInput(): string | undefined;
    private _timeOfDayInUtc?;
    get timeOfDayInUtc(): string;
    set timeOfDayInUtc(value: string);
    get timeOfDayInUtcInput(): string | undefined;
}
export interface ManagedLustreFileSystemTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#create ManagedLustreFileSystem#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#delete ManagedLustreFileSystem#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#read ManagedLustreFileSystem#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#update ManagedLustreFileSystem#update}
    */
    readonly update?: string;
}
export declare function managedLustreFileSystemTimeoutsToTerraform(struct?: ManagedLustreFileSystemTimeouts | cdktf.IResolvable): any;
export declare function managedLustreFileSystemTimeoutsToHclTerraform(struct?: ManagedLustreFileSystemTimeouts | cdktf.IResolvable): any;
export declare class ManagedLustreFileSystemTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedLustreFileSystemTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedLustreFileSystemTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system azurerm_managed_lustre_file_system}
*/
export declare class ManagedLustreFileSystem extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_managed_lustre_file_system";
    /**
    * Generates CDKTF code for importing a ManagedLustreFileSystem resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ManagedLustreFileSystem to import
    * @param importFromId The id of the existing ManagedLustreFileSystem that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ManagedLustreFileSystem to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/managed_lustre_file_system azurerm_managed_lustre_file_system} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedLustreFileSystemConfig
    */
    constructor(scope: Construct, id: string, config: ManagedLustreFileSystemConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get mgsAddress(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _storageCapacityInTb?;
    get storageCapacityInTb(): number;
    set storageCapacityInTb(value: number);
    get storageCapacityInTbInput(): number | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    get zonesInput(): string[] | undefined;
    private _encryptionKey;
    get encryptionKey(): ManagedLustreFileSystemEncryptionKeyOutputReference;
    putEncryptionKey(value: ManagedLustreFileSystemEncryptionKey): void;
    resetEncryptionKey(): void;
    get encryptionKeyInput(): ManagedLustreFileSystemEncryptionKey | undefined;
    private _hsmSetting;
    get hsmSetting(): ManagedLustreFileSystemHsmSettingOutputReference;
    putHsmSetting(value: ManagedLustreFileSystemHsmSetting): void;
    resetHsmSetting(): void;
    get hsmSettingInput(): ManagedLustreFileSystemHsmSetting | undefined;
    private _identity;
    get identity(): ManagedLustreFileSystemIdentityOutputReference;
    putIdentity(value: ManagedLustreFileSystemIdentity): void;
    resetIdentity(): void;
    get identityInput(): ManagedLustreFileSystemIdentity | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): ManagedLustreFileSystemMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: ManagedLustreFileSystemMaintenanceWindow): void;
    get maintenanceWindowInput(): ManagedLustreFileSystemMaintenanceWindow | undefined;
    private _timeouts;
    get timeouts(): ManagedLustreFileSystemTimeoutsOutputReference;
    putTimeouts(value: ManagedLustreFileSystemTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ManagedLustreFileSystemTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
