/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NginxApiKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/nginx_api_key#end_date_time NginxApiKey#end_date_time}
    */
    readonly endDateTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/nginx_api_key#id NginxApiKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/nginx_api_key#name NginxApiKey#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/nginx_api_key#nginx_deployment_id NginxApiKey#nginx_deployment_id}
    */
    readonly nginxDeploymentId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/nginx_api_key#secret_text NginxApiKey#secret_text}
    */
    readonly secretText: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/nginx_api_key#timeouts NginxApiKey#timeouts}
    */
    readonly timeouts?: NginxApiKeyTimeouts;
}
export interface NginxApiKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/nginx_api_key#create NginxApiKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/nginx_api_key#delete NginxApiKey#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/nginx_api_key#read NginxApiKey#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/nginx_api_key#update NginxApiKey#update}
    */
    readonly update?: string;
}
export declare function nginxApiKeyTimeoutsToTerraform(struct?: NginxApiKeyTimeouts | cdktf.IResolvable): any;
export declare function nginxApiKeyTimeoutsToHclTerraform(struct?: NginxApiKeyTimeouts | cdktf.IResolvable): any;
export declare class NginxApiKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NginxApiKeyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NginxApiKeyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/nginx_api_key azurerm_nginx_api_key}
*/
export declare class NginxApiKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_nginx_api_key";
    /**
    * Generates CDKTF code for importing a NginxApiKey resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NginxApiKey to import
    * @param importFromId The id of the existing NginxApiKey that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/nginx_api_key#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NginxApiKey to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/nginx_api_key azurerm_nginx_api_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NginxApiKeyConfig
    */
    constructor(scope: Construct, id: string, config: NginxApiKeyConfig);
    private _endDateTime?;
    get endDateTime(): string;
    set endDateTime(value: string);
    get endDateTimeInput(): string | undefined;
    get hint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nginxDeploymentId?;
    get nginxDeploymentId(): string;
    set nginxDeploymentId(value: string);
    get nginxDeploymentIdInput(): string | undefined;
    private _secretText?;
    get secretText(): string;
    set secretText(value: string);
    get secretTextInput(): string | undefined;
    private _timeouts;
    get timeouts(): NginxApiKeyTimeoutsOutputReference;
    putTimeouts(value: NginxApiKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NginxApiKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
