/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PaloAltoNextGenerationFirewallVirtualNetworkPanoramaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#id PaloAltoNextGenerationFirewallVirtualNetworkPanorama#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#location PaloAltoNextGenerationFirewallVirtualNetworkPanorama#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#marketplace_offer_id PaloAltoNextGenerationFirewallVirtualNetworkPanorama#marketplace_offer_id}
    */
    readonly marketplaceOfferId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#name PaloAltoNextGenerationFirewallVirtualNetworkPanorama#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#panorama_base64_config PaloAltoNextGenerationFirewallVirtualNetworkPanorama#panorama_base64_config}
    */
    readonly panoramaBase64Config: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#plan_id PaloAltoNextGenerationFirewallVirtualNetworkPanorama#plan_id}
    */
    readonly planId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#resource_group_name PaloAltoNextGenerationFirewallVirtualNetworkPanorama#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#tags PaloAltoNextGenerationFirewallVirtualNetworkPanorama#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * destination_nat block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#destination_nat PaloAltoNextGenerationFirewallVirtualNetworkPanorama#destination_nat}
    */
    readonly destinationNat?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNat[] | cdktf.IResolvable;
    /**
    * dns_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#dns_settings PaloAltoNextGenerationFirewallVirtualNetworkPanorama#dns_settings}
    */
    readonly dnsSettings?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDnsSettings;
    /**
    * network_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#network_profile PaloAltoNextGenerationFirewallVirtualNetworkPanorama#network_profile}
    */
    readonly networkProfile: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfile;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#timeouts PaloAltoNextGenerationFirewallVirtualNetworkPanorama#timeouts}
    */
    readonly timeouts?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaTimeouts;
}
export interface PaloAltoNextGenerationFirewallVirtualNetworkPanoramaPanorama {
}
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaPanoramaToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaPanorama): any;
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaPanoramaToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaPanorama): any;
export declare class PaloAltoNextGenerationFirewallVirtualNetworkPanoramaPanoramaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaPanorama | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaPanorama | undefined);
    get deviceGroupName(): string;
    get hostName(): string;
    get name(): string;
    get panoramaServer1(): string;
    get panoramaServer2(): string;
    get templateName(): string;
    get virtualMachineSshKey(): string;
}
export declare class PaloAltoNextGenerationFirewallVirtualNetworkPanoramaPanoramaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaPanoramaOutputReference;
}
export interface PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatBackendConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#port PaloAltoNextGenerationFirewallVirtualNetworkPanorama#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#public_ip_address PaloAltoNextGenerationFirewallVirtualNetworkPanorama#public_ip_address}
    */
    readonly publicIpAddress: string;
}
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatBackendConfigToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatBackendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatBackendConfig): any;
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatBackendConfigToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatBackendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatBackendConfig): any;
export declare class PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatBackendConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatBackendConfig | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatBackendConfig | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _publicIpAddress?;
    get publicIpAddress(): string;
    set publicIpAddress(value: string);
    get publicIpAddressInput(): string | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatFrontendConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#port PaloAltoNextGenerationFirewallVirtualNetworkPanorama#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#public_ip_address_id PaloAltoNextGenerationFirewallVirtualNetworkPanorama#public_ip_address_id}
    */
    readonly publicIpAddressId: string;
}
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatFrontendConfigToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatFrontendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatFrontendConfig): any;
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatFrontendConfigToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatFrontendConfigOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatFrontendConfig): any;
export declare class PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatFrontendConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatFrontendConfig | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatFrontendConfig | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _publicIpAddressId?;
    get publicIpAddressId(): string;
    set publicIpAddressId(value: string);
    get publicIpAddressIdInput(): string | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNat {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#name PaloAltoNextGenerationFirewallVirtualNetworkPanorama#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#protocol PaloAltoNextGenerationFirewallVirtualNetworkPanorama#protocol}
    */
    readonly protocol: string;
    /**
    * backend_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#backend_config PaloAltoNextGenerationFirewallVirtualNetworkPanorama#backend_config}
    */
    readonly backendConfig?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatBackendConfig;
    /**
    * frontend_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#frontend_config PaloAltoNextGenerationFirewallVirtualNetworkPanorama#frontend_config}
    */
    readonly frontendConfig?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatFrontendConfig;
}
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNat | cdktf.IResolvable): any;
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNat | cdktf.IResolvable): any;
export declare class PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNat | cdktf.IResolvable | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNat | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _backendConfig;
    get backendConfig(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatBackendConfigOutputReference;
    putBackendConfig(value: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatBackendConfig): void;
    resetBackendConfig(): void;
    get backendConfigInput(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatBackendConfig | undefined;
    private _frontendConfig;
    get frontendConfig(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatFrontendConfigOutputReference;
    putFrontendConfig(value: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatFrontendConfig): void;
    resetFrontendConfig(): void;
    get frontendConfigInput(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatFrontendConfig | undefined;
}
export declare class PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNat[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatOutputReference;
}
export interface PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDnsSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#dns_servers PaloAltoNextGenerationFirewallVirtualNetworkPanorama#dns_servers}
    */
    readonly dnsServers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#use_azure_dns PaloAltoNextGenerationFirewallVirtualNetworkPanorama#use_azure_dns}
    */
    readonly useAzureDns?: boolean | cdktf.IResolvable;
}
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaDnsSettingsToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDnsSettingsOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDnsSettings): any;
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaDnsSettingsToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDnsSettingsOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDnsSettings): any;
export declare class PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDnsSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDnsSettings | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDnsSettings | undefined);
    get azureDnsServers(): string[];
    private _dnsServers?;
    get dnsServers(): string[];
    set dnsServers(value: string[]);
    resetDnsServers(): void;
    get dnsServersInput(): string[] | undefined;
    private _useAzureDns?;
    get useAzureDns(): boolean | cdktf.IResolvable;
    set useAzureDns(value: boolean | cdktf.IResolvable);
    resetUseAzureDns(): void;
    get useAzureDnsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileVnetConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#trusted_subnet_id PaloAltoNextGenerationFirewallVirtualNetworkPanorama#trusted_subnet_id}
    */
    readonly trustedSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#untrusted_subnet_id PaloAltoNextGenerationFirewallVirtualNetworkPanorama#untrusted_subnet_id}
    */
    readonly untrustedSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#virtual_network_id PaloAltoNextGenerationFirewallVirtualNetworkPanorama#virtual_network_id}
    */
    readonly virtualNetworkId: string;
}
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileVnetConfigurationToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileVnetConfigurationOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileVnetConfiguration): any;
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileVnetConfigurationToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileVnetConfigurationOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileVnetConfiguration): any;
export declare class PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileVnetConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileVnetConfiguration | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileVnetConfiguration | undefined);
    get ipOfTrustForUserDefinedRoutes(): string;
    private _trustedSubnetId?;
    get trustedSubnetId(): string;
    set trustedSubnetId(value: string);
    resetTrustedSubnetId(): void;
    get trustedSubnetIdInput(): string | undefined;
    private _untrustedSubnetId?;
    get untrustedSubnetId(): string;
    set untrustedSubnetId(value: string);
    resetUntrustedSubnetId(): void;
    get untrustedSubnetIdInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    get virtualNetworkIdInput(): string | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#egress_nat_ip_address_ids PaloAltoNextGenerationFirewallVirtualNetworkPanorama#egress_nat_ip_address_ids}
    */
    readonly egressNatIpAddressIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#public_ip_address_ids PaloAltoNextGenerationFirewallVirtualNetworkPanorama#public_ip_address_ids}
    */
    readonly publicIpAddressIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#trusted_address_ranges PaloAltoNextGenerationFirewallVirtualNetworkPanorama#trusted_address_ranges}
    */
    readonly trustedAddressRanges?: string[];
    /**
    * vnet_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#vnet_configuration PaloAltoNextGenerationFirewallVirtualNetworkPanorama#vnet_configuration}
    */
    readonly vnetConfiguration: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileVnetConfiguration;
}
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfile): any;
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileOutputReference | PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfile): any;
export declare class PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfile | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfile | undefined);
    private _egressNatIpAddressIds?;
    get egressNatIpAddressIds(): string[];
    set egressNatIpAddressIds(value: string[]);
    resetEgressNatIpAddressIds(): void;
    get egressNatIpAddressIdsInput(): string[] | undefined;
    get egressNatIpAddresses(): string[];
    private _publicIpAddressIds?;
    get publicIpAddressIds(): string[];
    set publicIpAddressIds(value: string[]);
    get publicIpAddressIdsInput(): string[] | undefined;
    get publicIpAddresses(): string[];
    private _trustedAddressRanges?;
    get trustedAddressRanges(): string[];
    set trustedAddressRanges(value: string[]);
    resetTrustedAddressRanges(): void;
    get trustedAddressRangesInput(): string[] | undefined;
    private _vnetConfiguration;
    get vnetConfiguration(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileVnetConfigurationOutputReference;
    putVnetConfiguration(value: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileVnetConfiguration): void;
    get vnetConfigurationInput(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileVnetConfiguration | undefined;
}
export interface PaloAltoNextGenerationFirewallVirtualNetworkPanoramaTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#create PaloAltoNextGenerationFirewallVirtualNetworkPanorama#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#delete PaloAltoNextGenerationFirewallVirtualNetworkPanorama#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#read PaloAltoNextGenerationFirewallVirtualNetworkPanorama#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#update PaloAltoNextGenerationFirewallVirtualNetworkPanorama#update}
    */
    readonly update?: string;
}
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaTimeoutsToTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaTimeouts | cdktf.IResolvable): any;
export declare function paloAltoNextGenerationFirewallVirtualNetworkPanoramaTimeoutsToHclTerraform(struct?: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaTimeouts | cdktf.IResolvable): any;
export declare class PaloAltoNextGenerationFirewallVirtualNetworkPanoramaTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama azurerm_palo_alto_next_generation_firewall_virtual_network_panorama}
*/
export declare class PaloAltoNextGenerationFirewallVirtualNetworkPanorama extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_palo_alto_next_generation_firewall_virtual_network_panorama";
    /**
    * Generates CDKTF code for importing a PaloAltoNextGenerationFirewallVirtualNetworkPanorama resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PaloAltoNextGenerationFirewallVirtualNetworkPanorama to import
    * @param importFromId The id of the existing PaloAltoNextGenerationFirewallVirtualNetworkPanorama that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PaloAltoNextGenerationFirewallVirtualNetworkPanorama to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/palo_alto_next_generation_firewall_virtual_network_panorama azurerm_palo_alto_next_generation_firewall_virtual_network_panorama} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PaloAltoNextGenerationFirewallVirtualNetworkPanoramaConfig
    */
    constructor(scope: Construct, id: string, config: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _marketplaceOfferId?;
    get marketplaceOfferId(): string;
    set marketplaceOfferId(value: string);
    resetMarketplaceOfferId(): void;
    get marketplaceOfferIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _panorama;
    get panorama(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaPanoramaList;
    private _panoramaBase64Config?;
    get panoramaBase64Config(): string;
    set panoramaBase64Config(value: string);
    get panoramaBase64ConfigInput(): string | undefined;
    private _planId?;
    get planId(): string;
    set planId(value: string);
    resetPlanId(): void;
    get planIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _destinationNat;
    get destinationNat(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNatList;
    putDestinationNat(value: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNat[] | cdktf.IResolvable): void;
    resetDestinationNat(): void;
    get destinationNatInput(): cdktf.IResolvable | PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDestinationNat[] | undefined;
    private _dnsSettings;
    get dnsSettings(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDnsSettingsOutputReference;
    putDnsSettings(value: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDnsSettings): void;
    resetDnsSettings(): void;
    get dnsSettingsInput(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaDnsSettings | undefined;
    private _networkProfile;
    get networkProfile(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfileOutputReference;
    putNetworkProfile(value: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfile): void;
    get networkProfileInput(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaNetworkProfile | undefined;
    private _timeouts;
    get timeouts(): PaloAltoNextGenerationFirewallVirtualNetworkPanoramaTimeoutsOutputReference;
    putTimeouts(value: PaloAltoNextGenerationFirewallVirtualNetworkPanoramaTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PaloAltoNextGenerationFirewallVirtualNetworkPanoramaTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
