/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PortalTenantConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/portal_tenant_configuration#id PortalTenantConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/portal_tenant_configuration#private_markdown_storage_enforced PortalTenantConfiguration#private_markdown_storage_enforced}
    */
    readonly privateMarkdownStorageEnforced: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/portal_tenant_configuration#timeouts PortalTenantConfiguration#timeouts}
    */
    readonly timeouts?: PortalTenantConfigurationTimeouts;
}
export interface PortalTenantConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/portal_tenant_configuration#create PortalTenantConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/portal_tenant_configuration#delete PortalTenantConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/portal_tenant_configuration#read PortalTenantConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/portal_tenant_configuration#update PortalTenantConfiguration#update}
    */
    readonly update?: string;
}
export declare function portalTenantConfigurationTimeoutsToTerraform(struct?: PortalTenantConfigurationTimeouts | cdktf.IResolvable): any;
export declare function portalTenantConfigurationTimeoutsToHclTerraform(struct?: PortalTenantConfigurationTimeouts | cdktf.IResolvable): any;
export declare class PortalTenantConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PortalTenantConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PortalTenantConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/portal_tenant_configuration azurerm_portal_tenant_configuration}
*/
export declare class PortalTenantConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_portal_tenant_configuration";
    /**
    * Generates CDKTF code for importing a PortalTenantConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PortalTenantConfiguration to import
    * @param importFromId The id of the existing PortalTenantConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/portal_tenant_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PortalTenantConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/portal_tenant_configuration azurerm_portal_tenant_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PortalTenantConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: PortalTenantConfigurationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _privateMarkdownStorageEnforced?;
    get privateMarkdownStorageEnforced(): boolean | cdktf.IResolvable;
    set privateMarkdownStorageEnforced(value: boolean | cdktf.IResolvable);
    get privateMarkdownStorageEnforcedInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): PortalTenantConfigurationTimeoutsOutputReference;
    putTimeouts(value: PortalTenantConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PortalTenantConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
