/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AzurermProviderConfig {
    /**
    * The Azure DevOps Pipeline Service Connection ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#ado_pipeline_service_connection_id AzurermProvider#ado_pipeline_service_connection_id}
    */
    readonly adoPipelineServiceConnectionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#auxiliary_tenant_ids AzurermProvider#auxiliary_tenant_ids}
    */
    readonly auxiliaryTenantIds?: string[];
    /**
    * Base64 encoded PKCS#12 certificate bundle to use when authenticating as a Service Principal using a Client Certificate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#client_certificate AzurermProvider#client_certificate}
    */
    readonly clientCertificate?: string;
    /**
    * The password associated with the Client Certificate. For use when authenticating as a Service Principal using a Client Certificate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#client_certificate_password AzurermProvider#client_certificate_password}
    */
    readonly clientCertificatePassword?: string;
    /**
    * The path to the Client Certificate associated with the Service Principal for use when authenticating as a Service Principal using a Client Certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#client_certificate_path AzurermProvider#client_certificate_path}
    */
    readonly clientCertificatePath?: string;
    /**
    * The Client ID which should be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#client_id AzurermProvider#client_id}
    */
    readonly clientId?: string;
    /**
    * The path to a file containing the Client ID which should be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#client_id_file_path AzurermProvider#client_id_file_path}
    */
    readonly clientIdFilePath?: string;
    /**
    * The Client Secret which should be used. For use When authenticating as a Service Principal using a Client Secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#client_secret AzurermProvider#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The path to a file containing the Client Secret which should be used. For use When authenticating as a Service Principal using a Client Secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#client_secret_file_path AzurermProvider#client_secret_file_path}
    */
    readonly clientSecretFilePath?: string;
    /**
    * This will disable the x-ms-correlation-request-id header.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#disable_correlation_request_id AzurermProvider#disable_correlation_request_id}
    */
    readonly disableCorrelationRequestId?: boolean | cdktf.IResolvable;
    /**
    * This will disable the Terraform Partner ID which is used if a custom `partner_id` isn't specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#disable_terraform_partner_id AzurermProvider#disable_terraform_partner_id}
    */
    readonly disableTerraformPartnerId?: boolean | cdktf.IResolvable;
    /**
    * The Cloud Environment which should be used. Possible values are public, usgovernment, and china. Defaults to public. Not used and should not be specified when `metadata_host` is specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#environment AzurermProvider#environment}
    */
    readonly environment?: string;
    /**
    * The Hostname which should be used for the Azure Metadata Service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#metadata_host AzurermProvider#metadata_host}
    */
    readonly metadataHost?: string;
    /**
    * The API version to use for Managed Service Identity (IMDS) - for cases where the default API version is not supported by the endpoint. e.g. for Azure Container Apps.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#msi_api_version AzurermProvider#msi_api_version}
    */
    readonly msiApiVersion?: string;
    /**
    * The path to a custom endpoint for Managed Service Identity - in most circumstances this should be detected automatically.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#msi_endpoint AzurermProvider#msi_endpoint}
    */
    readonly msiEndpoint?: string;
    /**
    * The bearer token for the request to the OIDC provider. For use when authenticating as a Service Principal using OpenID Connect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#oidc_request_token AzurermProvider#oidc_request_token}
    */
    readonly oidcRequestToken?: string;
    /**
    * The URL for the OIDC provider from which to request an ID token. For use when authenticating as a Service Principal using OpenID Connect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#oidc_request_url AzurermProvider#oidc_request_url}
    */
    readonly oidcRequestUrl?: string;
    /**
    * The OIDC ID token for use when authenticating as a Service Principal using OpenID Connect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#oidc_token AzurermProvider#oidc_token}
    */
    readonly oidcToken?: string;
    /**
    * The path to a file containing an OIDC ID token for use when authenticating as a Service Principal using OpenID Connect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#oidc_token_file_path AzurermProvider#oidc_token_file_path}
    */
    readonly oidcTokenFilePath?: string;
    /**
    * A GUID/UUID that is registered with Microsoft to facilitate partner resource usage attribution.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#partner_id AzurermProvider#partner_id}
    */
    readonly partnerId?: string;
    /**
    * The set of Resource Providers which should be automatically registered for the subscription.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#resource_provider_registrations AzurermProvider#resource_provider_registrations}
    */
    readonly resourceProviderRegistrations?: string;
    /**
    * A list of Resource Providers to explicitly register for the subscription, in addition to those specified by the `resource_provider_registrations` property.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#resource_providers_to_register AzurermProvider#resource_providers_to_register}
    */
    readonly resourceProvidersToRegister?: string[];
    /**
    * Should the AzureRM Provider skip registering all of the Resource Providers that it supports, if they're not already registered?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#skip_provider_registration AzurermProvider#skip_provider_registration}
    */
    readonly skipProviderRegistration?: boolean | cdktf.IResolvable;
    /**
    * Should the AzureRM Provider use Azure AD Authentication when accessing the Storage Data Plane APIs?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#storage_use_azuread AzurermProvider#storage_use_azuread}
    */
    readonly storageUseAzuread?: boolean | cdktf.IResolvable;
    /**
    * The Subscription ID which should be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#subscription_id AzurermProvider#subscription_id}
    */
    readonly subscriptionId?: string;
    /**
    * The Tenant ID which should be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#tenant_id AzurermProvider#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Allow Azure AKS Workload Identity to be used for Authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#use_aks_workload_identity AzurermProvider#use_aks_workload_identity}
    */
    readonly useAksWorkloadIdentity?: boolean | cdktf.IResolvable;
    /**
    * Allow Azure CLI to be used for Authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#use_cli AzurermProvider#use_cli}
    */
    readonly useCli?: boolean | cdktf.IResolvable;
    /**
    * Allow Managed Service Identity to be used for Authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#use_msi AzurermProvider#use_msi}
    */
    readonly useMsi?: boolean | cdktf.IResolvable;
    /**
    * Allow OpenID Connect to be used for authentication
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#use_oidc AzurermProvider#use_oidc}
    */
    readonly useOidc?: boolean | cdktf.IResolvable;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#alias AzurermProvider#alias}
    */
    readonly alias?: string;
    /**
    * features block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#features AzurermProvider#features}
    */
    readonly features?: AzurermProviderFeatures[] | cdktf.IResolvable;
}
export interface AzurermProviderFeaturesApiManagement {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#purge_soft_delete_on_destroy AzurermProvider#purge_soft_delete_on_destroy}
    */
    readonly purgeSoftDeleteOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#recover_soft_deleted AzurermProvider#recover_soft_deleted}
    */
    readonly recoverSoftDeleted?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesApiManagementToTerraform(struct?: AzurermProviderFeaturesApiManagement | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesApiManagementToHclTerraform(struct?: AzurermProviderFeaturesApiManagement | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesAppConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#purge_soft_delete_on_destroy AzurermProvider#purge_soft_delete_on_destroy}
    */
    readonly purgeSoftDeleteOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#recover_soft_deleted AzurermProvider#recover_soft_deleted}
    */
    readonly recoverSoftDeleted?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesAppConfigurationToTerraform(struct?: AzurermProviderFeaturesAppConfiguration | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesAppConfigurationToHclTerraform(struct?: AzurermProviderFeaturesAppConfiguration | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesApplicationInsights {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#disable_generated_rule AzurermProvider#disable_generated_rule}
    */
    readonly disableGeneratedRule?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesApplicationInsightsToTerraform(struct?: AzurermProviderFeaturesApplicationInsights | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesApplicationInsightsToHclTerraform(struct?: AzurermProviderFeaturesApplicationInsights | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesCognitiveAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#purge_soft_delete_on_destroy AzurermProvider#purge_soft_delete_on_destroy}
    */
    readonly purgeSoftDeleteOnDestroy?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesCognitiveAccountToTerraform(struct?: AzurermProviderFeaturesCognitiveAccount | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesCognitiveAccountToHclTerraform(struct?: AzurermProviderFeaturesCognitiveAccount | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesDatabricksWorkspace {
    /**
    * When enabled, the managed resource group that contains the Unity Catalog data will be forcibly deleted when the workspace is destroyed, regardless of contents.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#force_delete AzurermProvider#force_delete}
    */
    readonly forceDelete?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesDatabricksWorkspaceToTerraform(struct?: AzurermProviderFeaturesDatabricksWorkspace | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesDatabricksWorkspaceToHclTerraform(struct?: AzurermProviderFeaturesDatabricksWorkspace | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesKeyVault {
    /**
    * When enabled soft-deleted `azurerm_key_vault` resources will be permanently deleted (e.g purged), when destroyed
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#purge_soft_delete_on_destroy AzurermProvider#purge_soft_delete_on_destroy}
    */
    readonly purgeSoftDeleteOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_certificate` resources will be permanently deleted (e.g purged), when destroyed
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#purge_soft_deleted_certificates_on_destroy AzurermProvider#purge_soft_deleted_certificates_on_destroy}
    */
    readonly purgeSoftDeletedCertificatesOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_managed_hardware_security_module_key` resources will be permanently deleted (e.g purged), when destroyed
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#purge_soft_deleted_hardware_security_module_keys_on_destroy AzurermProvider#purge_soft_deleted_hardware_security_module_keys_on_destroy}
    */
    readonly purgeSoftDeletedHardwareSecurityModuleKeysOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_managed_hardware_security_module` resources will be permanently deleted (e.g purged), when destroyed
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#purge_soft_deleted_hardware_security_modules_on_destroy AzurermProvider#purge_soft_deleted_hardware_security_modules_on_destroy}
    */
    readonly purgeSoftDeletedHardwareSecurityModulesOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_key` resources will be permanently deleted (e.g purged), when destroyed
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#purge_soft_deleted_keys_on_destroy AzurermProvider#purge_soft_deleted_keys_on_destroy}
    */
    readonly purgeSoftDeletedKeysOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_secret` resources will be permanently deleted (e.g purged), when destroyed
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#purge_soft_deleted_secrets_on_destroy AzurermProvider#purge_soft_deleted_secrets_on_destroy}
    */
    readonly purgeSoftDeletedSecretsOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_certificate` resources will be restored, instead of creating new ones
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#recover_soft_deleted_certificates AzurermProvider#recover_soft_deleted_certificates}
    */
    readonly recoverSoftDeletedCertificates?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_managed_hardware_security_module_key` resources will be restored, instead of creating new ones
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#recover_soft_deleted_hardware_security_module_keys AzurermProvider#recover_soft_deleted_hardware_security_module_keys}
    */
    readonly recoverSoftDeletedHardwareSecurityModuleKeys?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault` resources will be restored, instead of creating new ones
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#recover_soft_deleted_key_vaults AzurermProvider#recover_soft_deleted_key_vaults}
    */
    readonly recoverSoftDeletedKeyVaults?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_key` resources will be restored, instead of creating new ones
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#recover_soft_deleted_keys AzurermProvider#recover_soft_deleted_keys}
    */
    readonly recoverSoftDeletedKeys?: boolean | cdktf.IResolvable;
    /**
    * When enabled soft-deleted `azurerm_key_vault_secret` resources will be restored, instead of creating new ones
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#recover_soft_deleted_secrets AzurermProvider#recover_soft_deleted_secrets}
    */
    readonly recoverSoftDeletedSecrets?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesKeyVaultToTerraform(struct?: AzurermProviderFeaturesKeyVault | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesKeyVaultToHclTerraform(struct?: AzurermProviderFeaturesKeyVault | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesLogAnalyticsWorkspace {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#permanently_delete_on_destroy AzurermProvider#permanently_delete_on_destroy}
    */
    readonly permanentlyDeleteOnDestroy?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform(struct?: AzurermProviderFeaturesLogAnalyticsWorkspace | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesLogAnalyticsWorkspaceToHclTerraform(struct?: AzurermProviderFeaturesLogAnalyticsWorkspace | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesMachineLearning {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#purge_soft_deleted_workspace_on_destroy AzurermProvider#purge_soft_deleted_workspace_on_destroy}
    */
    readonly purgeSoftDeletedWorkspaceOnDestroy?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesMachineLearningToTerraform(struct?: AzurermProviderFeaturesMachineLearning | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesMachineLearningToHclTerraform(struct?: AzurermProviderFeaturesMachineLearning | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesManagedDisk {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#expand_without_downtime AzurermProvider#expand_without_downtime}
    */
    readonly expandWithoutDowntime?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesManagedDiskToTerraform(struct?: AzurermProviderFeaturesManagedDisk | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesManagedDiskToHclTerraform(struct?: AzurermProviderFeaturesManagedDisk | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesNetapp {
    /**
    * When enabled, backups will be deleted when the `azurerm_netapp_backup_vault` resource is destroyed
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#delete_backups_on_backup_vault_destroy AzurermProvider#delete_backups_on_backup_vault_destroy}
    */
    readonly deleteBackupsOnBackupVaultDestroy?: boolean | cdktf.IResolvable;
    /**
    * When enabled, the volume will not be destroyed, safeguarding from severe data loss
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#prevent_volume_destruction AzurermProvider#prevent_volume_destruction}
    */
    readonly preventVolumeDestruction?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesNetappToTerraform(struct?: AzurermProviderFeaturesNetapp | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesNetappToHclTerraform(struct?: AzurermProviderFeaturesNetapp | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesPostgresqlFlexibleServer {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#restart_server_on_configuration_value_change AzurermProvider#restart_server_on_configuration_value_change}
    */
    readonly restartServerOnConfigurationValueChange?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesPostgresqlFlexibleServerToTerraform(struct?: AzurermProviderFeaturesPostgresqlFlexibleServer | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesPostgresqlFlexibleServerToHclTerraform(struct?: AzurermProviderFeaturesPostgresqlFlexibleServer | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesRecoveryService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#purge_protected_items_from_vault_on_destroy AzurermProvider#purge_protected_items_from_vault_on_destroy}
    */
    readonly purgeProtectedItemsFromVaultOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#vm_backup_stop_protection_and_retain_data_on_destroy AzurermProvider#vm_backup_stop_protection_and_retain_data_on_destroy}
    */
    readonly vmBackupStopProtectionAndRetainDataOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#vm_backup_suspend_protection_and_retain_data_on_destroy AzurermProvider#vm_backup_suspend_protection_and_retain_data_on_destroy}
    */
    readonly vmBackupSuspendProtectionAndRetainDataOnDestroy?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesRecoveryServiceToTerraform(struct?: AzurermProviderFeaturesRecoveryService | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesRecoveryServiceToHclTerraform(struct?: AzurermProviderFeaturesRecoveryService | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesRecoveryServicesVaults {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#recover_soft_deleted_backup_protected_vm AzurermProvider#recover_soft_deleted_backup_protected_vm}
    */
    readonly recoverSoftDeletedBackupProtectedVm?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesRecoveryServicesVaultsToTerraform(struct?: AzurermProviderFeaturesRecoveryServicesVaults | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesRecoveryServicesVaultsToHclTerraform(struct?: AzurermProviderFeaturesRecoveryServicesVaults | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesResourceGroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#prevent_deletion_if_contains_resources AzurermProvider#prevent_deletion_if_contains_resources}
    */
    readonly preventDeletionIfContainsResources?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesResourceGroupToTerraform(struct?: AzurermProviderFeaturesResourceGroup | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesResourceGroupToHclTerraform(struct?: AzurermProviderFeaturesResourceGroup | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#data_plane_available AzurermProvider#data_plane_available}
    */
    readonly dataPlaneAvailable?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesStorageToTerraform(struct?: AzurermProviderFeaturesStorage | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesStorageToHclTerraform(struct?: AzurermProviderFeaturesStorage | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesSubscription {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#prevent_cancellation_on_destroy AzurermProvider#prevent_cancellation_on_destroy}
    */
    readonly preventCancellationOnDestroy?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesSubscriptionToTerraform(struct?: AzurermProviderFeaturesSubscription | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesSubscriptionToHclTerraform(struct?: AzurermProviderFeaturesSubscription | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesTemplateDeployment {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#delete_nested_items_during_deletion AzurermProvider#delete_nested_items_during_deletion}
    */
    readonly deleteNestedItemsDuringDeletion: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesTemplateDeploymentToTerraform(struct?: AzurermProviderFeaturesTemplateDeployment | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesTemplateDeploymentToHclTerraform(struct?: AzurermProviderFeaturesTemplateDeployment | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesVirtualMachine {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#delete_os_disk_on_deletion AzurermProvider#delete_os_disk_on_deletion}
    */
    readonly deleteOsDiskOnDeletion?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#detach_implicit_data_disk_on_deletion AzurermProvider#detach_implicit_data_disk_on_deletion}
    */
    readonly detachImplicitDataDiskOnDeletion?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#graceful_shutdown AzurermProvider#graceful_shutdown}
    */
    readonly gracefulShutdown?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#skip_shutdown_and_force_delete AzurermProvider#skip_shutdown_and_force_delete}
    */
    readonly skipShutdownAndForceDelete?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesVirtualMachineToTerraform(struct?: AzurermProviderFeaturesVirtualMachine | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesVirtualMachineToHclTerraform(struct?: AzurermProviderFeaturesVirtualMachine | cdktf.IResolvable): any;
export interface AzurermProviderFeaturesVirtualMachineScaleSet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#force_delete AzurermProvider#force_delete}
    */
    readonly forceDelete?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#reimage_on_manual_upgrade AzurermProvider#reimage_on_manual_upgrade}
    */
    readonly reimageOnManualUpgrade?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#roll_instances_when_required AzurermProvider#roll_instances_when_required}
    */
    readonly rollInstancesWhenRequired?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#scale_to_zero_before_deletion AzurermProvider#scale_to_zero_before_deletion}
    */
    readonly scaleToZeroBeforeDeletion?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesVirtualMachineScaleSetToTerraform(struct?: AzurermProviderFeaturesVirtualMachineScaleSet | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesVirtualMachineScaleSetToHclTerraform(struct?: AzurermProviderFeaturesVirtualMachineScaleSet | cdktf.IResolvable): any;
export interface AzurermProviderFeatures {
    /**
    * api_management block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#api_management AzurermProvider#api_management}
    */
    readonly apiManagement?: AzurermProviderFeaturesApiManagement[] | cdktf.IResolvable;
    /**
    * app_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#app_configuration AzurermProvider#app_configuration}
    */
    readonly appConfiguration?: AzurermProviderFeaturesAppConfiguration[] | cdktf.IResolvable;
    /**
    * application_insights block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#application_insights AzurermProvider#application_insights}
    */
    readonly applicationInsights?: AzurermProviderFeaturesApplicationInsights[] | cdktf.IResolvable;
    /**
    * cognitive_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#cognitive_account AzurermProvider#cognitive_account}
    */
    readonly cognitiveAccount?: AzurermProviderFeaturesCognitiveAccount[] | cdktf.IResolvable;
    /**
    * databricks_workspace block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#databricks_workspace AzurermProvider#databricks_workspace}
    */
    readonly databricksWorkspace?: AzurermProviderFeaturesDatabricksWorkspace[] | cdktf.IResolvable;
    /**
    * key_vault block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#key_vault AzurermProvider#key_vault}
    */
    readonly keyVault?: AzurermProviderFeaturesKeyVault[] | cdktf.IResolvable;
    /**
    * log_analytics_workspace block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#log_analytics_workspace AzurermProvider#log_analytics_workspace}
    */
    readonly logAnalyticsWorkspace?: AzurermProviderFeaturesLogAnalyticsWorkspace[] | cdktf.IResolvable;
    /**
    * machine_learning block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#machine_learning AzurermProvider#machine_learning}
    */
    readonly machineLearning?: AzurermProviderFeaturesMachineLearning[] | cdktf.IResolvable;
    /**
    * managed_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#managed_disk AzurermProvider#managed_disk}
    */
    readonly managedDisk?: AzurermProviderFeaturesManagedDisk[] | cdktf.IResolvable;
    /**
    * netapp block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#netapp AzurermProvider#netapp}
    */
    readonly netapp?: AzurermProviderFeaturesNetapp[] | cdktf.IResolvable;
    /**
    * postgresql_flexible_server block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#postgresql_flexible_server AzurermProvider#postgresql_flexible_server}
    */
    readonly postgresqlFlexibleServer?: AzurermProviderFeaturesPostgresqlFlexibleServer[] | cdktf.IResolvable;
    /**
    * recovery_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#recovery_service AzurermProvider#recovery_service}
    */
    readonly recoveryService?: AzurermProviderFeaturesRecoveryService[] | cdktf.IResolvable;
    /**
    * recovery_services_vaults block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#recovery_services_vaults AzurermProvider#recovery_services_vaults}
    */
    readonly recoveryServicesVaults?: AzurermProviderFeaturesRecoveryServicesVaults[] | cdktf.IResolvable;
    /**
    * resource_group block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#resource_group AzurermProvider#resource_group}
    */
    readonly resourceGroup?: AzurermProviderFeaturesResourceGroup[] | cdktf.IResolvable;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#storage AzurermProvider#storage}
    */
    readonly storage?: AzurermProviderFeaturesStorage[] | cdktf.IResolvable;
    /**
    * subscription block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#subscription AzurermProvider#subscription}
    */
    readonly subscription?: AzurermProviderFeaturesSubscription[] | cdktf.IResolvable;
    /**
    * template_deployment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#template_deployment AzurermProvider#template_deployment}
    */
    readonly templateDeployment?: AzurermProviderFeaturesTemplateDeployment[] | cdktf.IResolvable;
    /**
    * virtual_machine block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#virtual_machine AzurermProvider#virtual_machine}
    */
    readonly virtualMachine?: AzurermProviderFeaturesVirtualMachine[] | cdktf.IResolvable;
    /**
    * virtual_machine_scale_set block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#virtual_machine_scale_set AzurermProvider#virtual_machine_scale_set}
    */
    readonly virtualMachineScaleSet?: AzurermProviderFeaturesVirtualMachineScaleSet[] | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesToTerraform(struct?: AzurermProviderFeatures | cdktf.IResolvable): any;
export declare function azurermProviderFeaturesToHclTerraform(struct?: AzurermProviderFeatures | cdktf.IResolvable): any;
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs azurerm}
*/
export declare class AzurermProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "azurerm";
    /**
    * Generates CDKTF code for importing a AzurermProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AzurermProvider to import
    * @param importFromId The id of the existing AzurermProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AzurermProvider to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs azurerm} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AzurermProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: AzurermProviderConfig);
    private _adoPipelineServiceConnectionId?;
    get adoPipelineServiceConnectionId(): string | undefined;
    set adoPipelineServiceConnectionId(value: string | undefined);
    resetAdoPipelineServiceConnectionId(): void;
    get adoPipelineServiceConnectionIdInput(): string | undefined;
    private _auxiliaryTenantIds?;
    get auxiliaryTenantIds(): string[] | undefined;
    set auxiliaryTenantIds(value: string[] | undefined);
    resetAuxiliaryTenantIds(): void;
    get auxiliaryTenantIdsInput(): string[] | undefined;
    private _clientCertificate?;
    get clientCertificate(): string | undefined;
    set clientCertificate(value: string | undefined);
    resetClientCertificate(): void;
    get clientCertificateInput(): string | undefined;
    private _clientCertificatePassword?;
    get clientCertificatePassword(): string | undefined;
    set clientCertificatePassword(value: string | undefined);
    resetClientCertificatePassword(): void;
    get clientCertificatePasswordInput(): string | undefined;
    private _clientCertificatePath?;
    get clientCertificatePath(): string | undefined;
    set clientCertificatePath(value: string | undefined);
    resetClientCertificatePath(): void;
    get clientCertificatePathInput(): string | undefined;
    private _clientId?;
    get clientId(): string | undefined;
    set clientId(value: string | undefined);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _clientIdFilePath?;
    get clientIdFilePath(): string | undefined;
    set clientIdFilePath(value: string | undefined);
    resetClientIdFilePath(): void;
    get clientIdFilePathInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string | undefined;
    set clientSecret(value: string | undefined);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretFilePath?;
    get clientSecretFilePath(): string | undefined;
    set clientSecretFilePath(value: string | undefined);
    resetClientSecretFilePath(): void;
    get clientSecretFilePathInput(): string | undefined;
    private _disableCorrelationRequestId?;
    get disableCorrelationRequestId(): boolean | cdktf.IResolvable | undefined;
    set disableCorrelationRequestId(value: boolean | cdktf.IResolvable | undefined);
    resetDisableCorrelationRequestId(): void;
    get disableCorrelationRequestIdInput(): boolean | cdktf.IResolvable | undefined;
    private _disableTerraformPartnerId?;
    get disableTerraformPartnerId(): boolean | cdktf.IResolvable | undefined;
    set disableTerraformPartnerId(value: boolean | cdktf.IResolvable | undefined);
    resetDisableTerraformPartnerId(): void;
    get disableTerraformPartnerIdInput(): boolean | cdktf.IResolvable | undefined;
    private _environment?;
    get environment(): string | undefined;
    set environment(value: string | undefined);
    resetEnvironment(): void;
    get environmentInput(): string | undefined;
    private _metadataHost?;
    get metadataHost(): string | undefined;
    set metadataHost(value: string | undefined);
    resetMetadataHost(): void;
    get metadataHostInput(): string | undefined;
    private _msiApiVersion?;
    get msiApiVersion(): string | undefined;
    set msiApiVersion(value: string | undefined);
    resetMsiApiVersion(): void;
    get msiApiVersionInput(): string | undefined;
    private _msiEndpoint?;
    get msiEndpoint(): string | undefined;
    set msiEndpoint(value: string | undefined);
    resetMsiEndpoint(): void;
    get msiEndpointInput(): string | undefined;
    private _oidcRequestToken?;
    get oidcRequestToken(): string | undefined;
    set oidcRequestToken(value: string | undefined);
    resetOidcRequestToken(): void;
    get oidcRequestTokenInput(): string | undefined;
    private _oidcRequestUrl?;
    get oidcRequestUrl(): string | undefined;
    set oidcRequestUrl(value: string | undefined);
    resetOidcRequestUrl(): void;
    get oidcRequestUrlInput(): string | undefined;
    private _oidcToken?;
    get oidcToken(): string | undefined;
    set oidcToken(value: string | undefined);
    resetOidcToken(): void;
    get oidcTokenInput(): string | undefined;
    private _oidcTokenFilePath?;
    get oidcTokenFilePath(): string | undefined;
    set oidcTokenFilePath(value: string | undefined);
    resetOidcTokenFilePath(): void;
    get oidcTokenFilePathInput(): string | undefined;
    private _partnerId?;
    get partnerId(): string | undefined;
    set partnerId(value: string | undefined);
    resetPartnerId(): void;
    get partnerIdInput(): string | undefined;
    private _resourceProviderRegistrations?;
    get resourceProviderRegistrations(): string | undefined;
    set resourceProviderRegistrations(value: string | undefined);
    resetResourceProviderRegistrations(): void;
    get resourceProviderRegistrationsInput(): string | undefined;
    private _resourceProvidersToRegister?;
    get resourceProvidersToRegister(): string[] | undefined;
    set resourceProvidersToRegister(value: string[] | undefined);
    resetResourceProvidersToRegister(): void;
    get resourceProvidersToRegisterInput(): string[] | undefined;
    private _skipProviderRegistration?;
    get skipProviderRegistration(): boolean | cdktf.IResolvable | undefined;
    set skipProviderRegistration(value: boolean | cdktf.IResolvable | undefined);
    resetSkipProviderRegistration(): void;
    get skipProviderRegistrationInput(): boolean | cdktf.IResolvable | undefined;
    private _storageUseAzuread?;
    get storageUseAzuread(): boolean | cdktf.IResolvable | undefined;
    set storageUseAzuread(value: boolean | cdktf.IResolvable | undefined);
    resetStorageUseAzuread(): void;
    get storageUseAzureadInput(): boolean | cdktf.IResolvable | undefined;
    private _subscriptionId?;
    get subscriptionId(): string | undefined;
    set subscriptionId(value: string | undefined);
    resetSubscriptionId(): void;
    get subscriptionIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string | undefined;
    set tenantId(value: string | undefined);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _useAksWorkloadIdentity?;
    get useAksWorkloadIdentity(): boolean | cdktf.IResolvable | undefined;
    set useAksWorkloadIdentity(value: boolean | cdktf.IResolvable | undefined);
    resetUseAksWorkloadIdentity(): void;
    get useAksWorkloadIdentityInput(): boolean | cdktf.IResolvable | undefined;
    private _useCli?;
    get useCli(): boolean | cdktf.IResolvable | undefined;
    set useCli(value: boolean | cdktf.IResolvable | undefined);
    resetUseCli(): void;
    get useCliInput(): boolean | cdktf.IResolvable | undefined;
    private _useMsi?;
    get useMsi(): boolean | cdktf.IResolvable | undefined;
    set useMsi(value: boolean | cdktf.IResolvable | undefined);
    resetUseMsi(): void;
    get useMsiInput(): boolean | cdktf.IResolvable | undefined;
    private _useOidc?;
    get useOidc(): boolean | cdktf.IResolvable | undefined;
    set useOidc(value: boolean | cdktf.IResolvable | undefined);
    resetUseOidc(): void;
    get useOidcInput(): boolean | cdktf.IResolvable | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _features?;
    get features(): AzurermProviderFeatures[] | cdktf.IResolvable | undefined;
    set features(value: AzurermProviderFeatures[] | cdktf.IResolvable | undefined);
    resetFeatures(): void;
    get featuresInput(): cdktf.IResolvable | AzurermProviderFeatures[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
