/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RouteMapConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#id RouteMap#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#name RouteMap#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#virtual_hub_id RouteMap#virtual_hub_id}
    */
    readonly virtualHubId: string;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#rule RouteMap#rule}
    */
    readonly rule?: RouteMapRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#timeouts RouteMap#timeouts}
    */
    readonly timeouts?: RouteMapTimeouts;
}
export interface RouteMapRuleActionParameter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#as_path RouteMap#as_path}
    */
    readonly asPath?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#community RouteMap#community}
    */
    readonly community?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#route_prefix RouteMap#route_prefix}
    */
    readonly routePrefix?: string[];
}
export declare function routeMapRuleActionParameterToTerraform(struct?: RouteMapRuleActionParameter | cdktf.IResolvable): any;
export declare function routeMapRuleActionParameterToHclTerraform(struct?: RouteMapRuleActionParameter | cdktf.IResolvable): any;
export declare class RouteMapRuleActionParameterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RouteMapRuleActionParameter | cdktf.IResolvable | undefined;
    set internalValue(value: RouteMapRuleActionParameter | cdktf.IResolvable | undefined);
    private _asPath?;
    get asPath(): string[];
    set asPath(value: string[]);
    resetAsPath(): void;
    get asPathInput(): string[] | undefined;
    private _community?;
    get community(): string[];
    set community(value: string[]);
    resetCommunity(): void;
    get communityInput(): string[] | undefined;
    private _routePrefix?;
    get routePrefix(): string[];
    set routePrefix(value: string[]);
    resetRoutePrefix(): void;
    get routePrefixInput(): string[] | undefined;
}
export declare class RouteMapRuleActionParameterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RouteMapRuleActionParameter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RouteMapRuleActionParameterOutputReference;
}
export interface RouteMapRuleAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#type RouteMap#type}
    */
    readonly type: string;
    /**
    * parameter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#parameter RouteMap#parameter}
    */
    readonly parameter?: RouteMapRuleActionParameter[] | cdktf.IResolvable;
}
export declare function routeMapRuleActionToTerraform(struct?: RouteMapRuleAction | cdktf.IResolvable): any;
export declare function routeMapRuleActionToHclTerraform(struct?: RouteMapRuleAction | cdktf.IResolvable): any;
export declare class RouteMapRuleActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RouteMapRuleAction | cdktf.IResolvable | undefined;
    set internalValue(value: RouteMapRuleAction | cdktf.IResolvable | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _parameter;
    get parameter(): RouteMapRuleActionParameterList;
    putParameter(value: RouteMapRuleActionParameter[] | cdktf.IResolvable): void;
    resetParameter(): void;
    get parameterInput(): cdktf.IResolvable | RouteMapRuleActionParameter[] | undefined;
}
export declare class RouteMapRuleActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RouteMapRuleAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RouteMapRuleActionOutputReference;
}
export interface RouteMapRuleMatchCriterion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#as_path RouteMap#as_path}
    */
    readonly asPath?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#community RouteMap#community}
    */
    readonly community?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#match_condition RouteMap#match_condition}
    */
    readonly matchCondition: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#route_prefix RouteMap#route_prefix}
    */
    readonly routePrefix?: string[];
}
export declare function routeMapRuleMatchCriterionToTerraform(struct?: RouteMapRuleMatchCriterion | cdktf.IResolvable): any;
export declare function routeMapRuleMatchCriterionToHclTerraform(struct?: RouteMapRuleMatchCriterion | cdktf.IResolvable): any;
export declare class RouteMapRuleMatchCriterionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RouteMapRuleMatchCriterion | cdktf.IResolvable | undefined;
    set internalValue(value: RouteMapRuleMatchCriterion | cdktf.IResolvable | undefined);
    private _asPath?;
    get asPath(): string[];
    set asPath(value: string[]);
    resetAsPath(): void;
    get asPathInput(): string[] | undefined;
    private _community?;
    get community(): string[];
    set community(value: string[]);
    resetCommunity(): void;
    get communityInput(): string[] | undefined;
    private _matchCondition?;
    get matchCondition(): string;
    set matchCondition(value: string);
    get matchConditionInput(): string | undefined;
    private _routePrefix?;
    get routePrefix(): string[];
    set routePrefix(value: string[]);
    resetRoutePrefix(): void;
    get routePrefixInput(): string[] | undefined;
}
export declare class RouteMapRuleMatchCriterionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RouteMapRuleMatchCriterion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RouteMapRuleMatchCriterionOutputReference;
}
export interface RouteMapRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#name RouteMap#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#next_step_if_matched RouteMap#next_step_if_matched}
    */
    readonly nextStepIfMatched?: string;
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#action RouteMap#action}
    */
    readonly action?: RouteMapRuleAction[] | cdktf.IResolvable;
    /**
    * match_criterion block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#match_criterion RouteMap#match_criterion}
    */
    readonly matchCriterion?: RouteMapRuleMatchCriterion[] | cdktf.IResolvable;
}
export declare function routeMapRuleToTerraform(struct?: RouteMapRule | cdktf.IResolvable): any;
export declare function routeMapRuleToHclTerraform(struct?: RouteMapRule | cdktf.IResolvable): any;
export declare class RouteMapRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RouteMapRule | cdktf.IResolvable | undefined;
    set internalValue(value: RouteMapRule | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nextStepIfMatched?;
    get nextStepIfMatched(): string;
    set nextStepIfMatched(value: string);
    resetNextStepIfMatched(): void;
    get nextStepIfMatchedInput(): string | undefined;
    private _action;
    get action(): RouteMapRuleActionList;
    putAction(value: RouteMapRuleAction[] | cdktf.IResolvable): void;
    resetAction(): void;
    get actionInput(): cdktf.IResolvable | RouteMapRuleAction[] | undefined;
    private _matchCriterion;
    get matchCriterion(): RouteMapRuleMatchCriterionList;
    putMatchCriterion(value: RouteMapRuleMatchCriterion[] | cdktf.IResolvable): void;
    resetMatchCriterion(): void;
    get matchCriterionInput(): cdktf.IResolvable | RouteMapRuleMatchCriterion[] | undefined;
}
export declare class RouteMapRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RouteMapRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RouteMapRuleOutputReference;
}
export interface RouteMapTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#create RouteMap#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#delete RouteMap#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#read RouteMap#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#update RouteMap#update}
    */
    readonly update?: string;
}
export declare function routeMapTimeoutsToTerraform(struct?: RouteMapTimeouts | cdktf.IResolvable): any;
export declare function routeMapTimeoutsToHclTerraform(struct?: RouteMapTimeouts | cdktf.IResolvable): any;
export declare class RouteMapTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RouteMapTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: RouteMapTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map azurerm_route_map}
*/
export declare class RouteMap extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_route_map";
    /**
    * Generates CDKTF code for importing a RouteMap resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the RouteMap to import
    * @param importFromId The id of the existing RouteMap that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the RouteMap to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/route_map azurerm_route_map} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RouteMapConfig
    */
    constructor(scope: Construct, id: string, config: RouteMapConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _virtualHubId?;
    get virtualHubId(): string;
    set virtualHubId(value: string);
    get virtualHubIdInput(): string | undefined;
    private _rule;
    get rule(): RouteMapRuleList;
    putRule(value: RouteMapRule[] | cdktf.IResolvable): void;
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | RouteMapRule[] | undefined;
    private _timeouts;
    get timeouts(): RouteMapTimeoutsOutputReference;
    putTimeouts(value: RouteMapTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | RouteMapTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
