/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SentinelAlertRuleScheduledConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#alert_rule_template_guid SentinelAlertRuleScheduled#alert_rule_template_guid}
    */
    readonly alertRuleTemplateGuid?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#alert_rule_template_version SentinelAlertRuleScheduled#alert_rule_template_version}
    */
    readonly alertRuleTemplateVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#custom_details SentinelAlertRuleScheduled#custom_details}
    */
    readonly customDetails?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#description SentinelAlertRuleScheduled#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#display_name SentinelAlertRuleScheduled#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#enabled SentinelAlertRuleScheduled#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#id SentinelAlertRuleScheduled#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#log_analytics_workspace_id SentinelAlertRuleScheduled#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#name SentinelAlertRuleScheduled#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#query SentinelAlertRuleScheduled#query}
    */
    readonly query: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#query_frequency SentinelAlertRuleScheduled#query_frequency}
    */
    readonly queryFrequency?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#query_period SentinelAlertRuleScheduled#query_period}
    */
    readonly queryPeriod?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#severity SentinelAlertRuleScheduled#severity}
    */
    readonly severity: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#suppression_duration SentinelAlertRuleScheduled#suppression_duration}
    */
    readonly suppressionDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#suppression_enabled SentinelAlertRuleScheduled#suppression_enabled}
    */
    readonly suppressionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#tactics SentinelAlertRuleScheduled#tactics}
    */
    readonly tactics?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#techniques SentinelAlertRuleScheduled#techniques}
    */
    readonly techniques?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#trigger_operator SentinelAlertRuleScheduled#trigger_operator}
    */
    readonly triggerOperator?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#trigger_threshold SentinelAlertRuleScheduled#trigger_threshold}
    */
    readonly triggerThreshold?: number;
    /**
    * alert_details_override block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#alert_details_override SentinelAlertRuleScheduled#alert_details_override}
    */
    readonly alertDetailsOverride?: SentinelAlertRuleScheduledAlertDetailsOverride[] | cdktf.IResolvable;
    /**
    * entity_mapping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#entity_mapping SentinelAlertRuleScheduled#entity_mapping}
    */
    readonly entityMapping?: SentinelAlertRuleScheduledEntityMapping[] | cdktf.IResolvable;
    /**
    * event_grouping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#event_grouping SentinelAlertRuleScheduled#event_grouping}
    */
    readonly eventGrouping?: SentinelAlertRuleScheduledEventGrouping;
    /**
    * incident block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#incident SentinelAlertRuleScheduled#incident}
    */
    readonly incident?: SentinelAlertRuleScheduledIncident;
    /**
    * sentinel_entity_mapping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#sentinel_entity_mapping SentinelAlertRuleScheduled#sentinel_entity_mapping}
    */
    readonly sentinelEntityMapping?: SentinelAlertRuleScheduledSentinelEntityMapping[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#timeouts SentinelAlertRuleScheduled#timeouts}
    */
    readonly timeouts?: SentinelAlertRuleScheduledTimeouts;
}
export interface SentinelAlertRuleScheduledAlertDetailsOverrideDynamicProperty {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#name SentinelAlertRuleScheduled#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#value SentinelAlertRuleScheduled#value}
    */
    readonly value: string;
}
export declare function sentinelAlertRuleScheduledAlertDetailsOverrideDynamicPropertyToTerraform(struct?: SentinelAlertRuleScheduledAlertDetailsOverrideDynamicProperty | cdktf.IResolvable): any;
export declare function sentinelAlertRuleScheduledAlertDetailsOverrideDynamicPropertyToHclTerraform(struct?: SentinelAlertRuleScheduledAlertDetailsOverrideDynamicProperty | cdktf.IResolvable): any;
export declare class SentinelAlertRuleScheduledAlertDetailsOverrideDynamicPropertyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleScheduledAlertDetailsOverrideDynamicProperty | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleScheduledAlertDetailsOverrideDynamicProperty | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class SentinelAlertRuleScheduledAlertDetailsOverrideDynamicPropertyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAlertRuleScheduledAlertDetailsOverrideDynamicProperty[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleScheduledAlertDetailsOverrideDynamicPropertyOutputReference;
}
export interface SentinelAlertRuleScheduledAlertDetailsOverride {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#description_format SentinelAlertRuleScheduled#description_format}
    */
    readonly descriptionFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#display_name_format SentinelAlertRuleScheduled#display_name_format}
    */
    readonly displayNameFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#severity_column_name SentinelAlertRuleScheduled#severity_column_name}
    */
    readonly severityColumnName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#tactics_column_name SentinelAlertRuleScheduled#tactics_column_name}
    */
    readonly tacticsColumnName?: string;
    /**
    * dynamic_property block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#dynamic_property SentinelAlertRuleScheduled#dynamic_property}
    */
    readonly dynamicProperty?: SentinelAlertRuleScheduledAlertDetailsOverrideDynamicProperty[] | cdktf.IResolvable;
}
export declare function sentinelAlertRuleScheduledAlertDetailsOverrideToTerraform(struct?: SentinelAlertRuleScheduledAlertDetailsOverride | cdktf.IResolvable): any;
export declare function sentinelAlertRuleScheduledAlertDetailsOverrideToHclTerraform(struct?: SentinelAlertRuleScheduledAlertDetailsOverride | cdktf.IResolvable): any;
export declare class SentinelAlertRuleScheduledAlertDetailsOverrideOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleScheduledAlertDetailsOverride | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleScheduledAlertDetailsOverride | cdktf.IResolvable | undefined);
    private _descriptionFormat?;
    get descriptionFormat(): string;
    set descriptionFormat(value: string);
    resetDescriptionFormat(): void;
    get descriptionFormatInput(): string | undefined;
    private _displayNameFormat?;
    get displayNameFormat(): string;
    set displayNameFormat(value: string);
    resetDisplayNameFormat(): void;
    get displayNameFormatInput(): string | undefined;
    private _severityColumnName?;
    get severityColumnName(): string;
    set severityColumnName(value: string);
    resetSeverityColumnName(): void;
    get severityColumnNameInput(): string | undefined;
    private _tacticsColumnName?;
    get tacticsColumnName(): string;
    set tacticsColumnName(value: string);
    resetTacticsColumnName(): void;
    get tacticsColumnNameInput(): string | undefined;
    private _dynamicProperty;
    get dynamicProperty(): SentinelAlertRuleScheduledAlertDetailsOverrideDynamicPropertyList;
    putDynamicProperty(value: SentinelAlertRuleScheduledAlertDetailsOverrideDynamicProperty[] | cdktf.IResolvable): void;
    resetDynamicProperty(): void;
    get dynamicPropertyInput(): cdktf.IResolvable | SentinelAlertRuleScheduledAlertDetailsOverrideDynamicProperty[] | undefined;
}
export declare class SentinelAlertRuleScheduledAlertDetailsOverrideList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAlertRuleScheduledAlertDetailsOverride[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleScheduledAlertDetailsOverrideOutputReference;
}
export interface SentinelAlertRuleScheduledEntityMappingFieldMapping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#column_name SentinelAlertRuleScheduled#column_name}
    */
    readonly columnName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#identifier SentinelAlertRuleScheduled#identifier}
    */
    readonly identifier: string;
}
export declare function sentinelAlertRuleScheduledEntityMappingFieldMappingToTerraform(struct?: SentinelAlertRuleScheduledEntityMappingFieldMapping | cdktf.IResolvable): any;
export declare function sentinelAlertRuleScheduledEntityMappingFieldMappingToHclTerraform(struct?: SentinelAlertRuleScheduledEntityMappingFieldMapping | cdktf.IResolvable): any;
export declare class SentinelAlertRuleScheduledEntityMappingFieldMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleScheduledEntityMappingFieldMapping | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleScheduledEntityMappingFieldMapping | cdktf.IResolvable | undefined);
    private _columnName?;
    get columnName(): string;
    set columnName(value: string);
    get columnNameInput(): string | undefined;
    private _identifier?;
    get identifier(): string;
    set identifier(value: string);
    get identifierInput(): string | undefined;
}
export declare class SentinelAlertRuleScheduledEntityMappingFieldMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAlertRuleScheduledEntityMappingFieldMapping[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleScheduledEntityMappingFieldMappingOutputReference;
}
export interface SentinelAlertRuleScheduledEntityMapping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#entity_type SentinelAlertRuleScheduled#entity_type}
    */
    readonly entityType: string;
    /**
    * field_mapping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#field_mapping SentinelAlertRuleScheduled#field_mapping}
    */
    readonly fieldMapping: SentinelAlertRuleScheduledEntityMappingFieldMapping[] | cdktf.IResolvable;
}
export declare function sentinelAlertRuleScheduledEntityMappingToTerraform(struct?: SentinelAlertRuleScheduledEntityMapping | cdktf.IResolvable): any;
export declare function sentinelAlertRuleScheduledEntityMappingToHclTerraform(struct?: SentinelAlertRuleScheduledEntityMapping | cdktf.IResolvable): any;
export declare class SentinelAlertRuleScheduledEntityMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleScheduledEntityMapping | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleScheduledEntityMapping | cdktf.IResolvable | undefined);
    private _entityType?;
    get entityType(): string;
    set entityType(value: string);
    get entityTypeInput(): string | undefined;
    private _fieldMapping;
    get fieldMapping(): SentinelAlertRuleScheduledEntityMappingFieldMappingList;
    putFieldMapping(value: SentinelAlertRuleScheduledEntityMappingFieldMapping[] | cdktf.IResolvable): void;
    get fieldMappingInput(): cdktf.IResolvable | SentinelAlertRuleScheduledEntityMappingFieldMapping[] | undefined;
}
export declare class SentinelAlertRuleScheduledEntityMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAlertRuleScheduledEntityMapping[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleScheduledEntityMappingOutputReference;
}
export interface SentinelAlertRuleScheduledEventGrouping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#aggregation_method SentinelAlertRuleScheduled#aggregation_method}
    */
    readonly aggregationMethod: string;
}
export declare function sentinelAlertRuleScheduledEventGroupingToTerraform(struct?: SentinelAlertRuleScheduledEventGroupingOutputReference | SentinelAlertRuleScheduledEventGrouping): any;
export declare function sentinelAlertRuleScheduledEventGroupingToHclTerraform(struct?: SentinelAlertRuleScheduledEventGroupingOutputReference | SentinelAlertRuleScheduledEventGrouping): any;
export declare class SentinelAlertRuleScheduledEventGroupingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelAlertRuleScheduledEventGrouping | undefined;
    set internalValue(value: SentinelAlertRuleScheduledEventGrouping | undefined);
    private _aggregationMethod?;
    get aggregationMethod(): string;
    set aggregationMethod(value: string);
    get aggregationMethodInput(): string | undefined;
}
export interface SentinelAlertRuleScheduledIncidentGrouping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#by_alert_details SentinelAlertRuleScheduled#by_alert_details}
    */
    readonly byAlertDetails?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#by_custom_details SentinelAlertRuleScheduled#by_custom_details}
    */
    readonly byCustomDetails?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#by_entities SentinelAlertRuleScheduled#by_entities}
    */
    readonly byEntities?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#enabled SentinelAlertRuleScheduled#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#entity_matching_method SentinelAlertRuleScheduled#entity_matching_method}
    */
    readonly entityMatchingMethod?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#lookback_duration SentinelAlertRuleScheduled#lookback_duration}
    */
    readonly lookbackDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#reopen_closed_incidents SentinelAlertRuleScheduled#reopen_closed_incidents}
    */
    readonly reopenClosedIncidents?: boolean | cdktf.IResolvable;
}
export declare function sentinelAlertRuleScheduledIncidentGroupingToTerraform(struct?: SentinelAlertRuleScheduledIncidentGroupingOutputReference | SentinelAlertRuleScheduledIncidentGrouping): any;
export declare function sentinelAlertRuleScheduledIncidentGroupingToHclTerraform(struct?: SentinelAlertRuleScheduledIncidentGroupingOutputReference | SentinelAlertRuleScheduledIncidentGrouping): any;
export declare class SentinelAlertRuleScheduledIncidentGroupingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelAlertRuleScheduledIncidentGrouping | undefined;
    set internalValue(value: SentinelAlertRuleScheduledIncidentGrouping | undefined);
    private _byAlertDetails?;
    get byAlertDetails(): string[];
    set byAlertDetails(value: string[]);
    resetByAlertDetails(): void;
    get byAlertDetailsInput(): string[] | undefined;
    private _byCustomDetails?;
    get byCustomDetails(): string[];
    set byCustomDetails(value: string[]);
    resetByCustomDetails(): void;
    get byCustomDetailsInput(): string[] | undefined;
    private _byEntities?;
    get byEntities(): string[];
    set byEntities(value: string[]);
    resetByEntities(): void;
    get byEntitiesInput(): string[] | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _entityMatchingMethod?;
    get entityMatchingMethod(): string;
    set entityMatchingMethod(value: string);
    resetEntityMatchingMethod(): void;
    get entityMatchingMethodInput(): string | undefined;
    private _lookbackDuration?;
    get lookbackDuration(): string;
    set lookbackDuration(value: string);
    resetLookbackDuration(): void;
    get lookbackDurationInput(): string | undefined;
    private _reopenClosedIncidents?;
    get reopenClosedIncidents(): boolean | cdktf.IResolvable;
    set reopenClosedIncidents(value: boolean | cdktf.IResolvable);
    resetReopenClosedIncidents(): void;
    get reopenClosedIncidentsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SentinelAlertRuleScheduledIncident {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#create_incident_enabled SentinelAlertRuleScheduled#create_incident_enabled}
    */
    readonly createIncidentEnabled: boolean | cdktf.IResolvable;
    /**
    * grouping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#grouping SentinelAlertRuleScheduled#grouping}
    */
    readonly grouping: SentinelAlertRuleScheduledIncidentGrouping;
}
export declare function sentinelAlertRuleScheduledIncidentToTerraform(struct?: SentinelAlertRuleScheduledIncidentOutputReference | SentinelAlertRuleScheduledIncident): any;
export declare function sentinelAlertRuleScheduledIncidentToHclTerraform(struct?: SentinelAlertRuleScheduledIncidentOutputReference | SentinelAlertRuleScheduledIncident): any;
export declare class SentinelAlertRuleScheduledIncidentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelAlertRuleScheduledIncident | undefined;
    set internalValue(value: SentinelAlertRuleScheduledIncident | undefined);
    private _createIncidentEnabled?;
    get createIncidentEnabled(): boolean | cdktf.IResolvable;
    set createIncidentEnabled(value: boolean | cdktf.IResolvable);
    get createIncidentEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _grouping;
    get grouping(): SentinelAlertRuleScheduledIncidentGroupingOutputReference;
    putGrouping(value: SentinelAlertRuleScheduledIncidentGrouping): void;
    get groupingInput(): SentinelAlertRuleScheduledIncidentGrouping | undefined;
}
export interface SentinelAlertRuleScheduledSentinelEntityMapping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#column_name SentinelAlertRuleScheduled#column_name}
    */
    readonly columnName: string;
}
export declare function sentinelAlertRuleScheduledSentinelEntityMappingToTerraform(struct?: SentinelAlertRuleScheduledSentinelEntityMapping | cdktf.IResolvable): any;
export declare function sentinelAlertRuleScheduledSentinelEntityMappingToHclTerraform(struct?: SentinelAlertRuleScheduledSentinelEntityMapping | cdktf.IResolvable): any;
export declare class SentinelAlertRuleScheduledSentinelEntityMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SentinelAlertRuleScheduledSentinelEntityMapping | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleScheduledSentinelEntityMapping | cdktf.IResolvable | undefined);
    private _columnName?;
    get columnName(): string;
    set columnName(value: string);
    get columnNameInput(): string | undefined;
}
export declare class SentinelAlertRuleScheduledSentinelEntityMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SentinelAlertRuleScheduledSentinelEntityMapping[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SentinelAlertRuleScheduledSentinelEntityMappingOutputReference;
}
export interface SentinelAlertRuleScheduledTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#create SentinelAlertRuleScheduled#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#delete SentinelAlertRuleScheduled#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#read SentinelAlertRuleScheduled#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#update SentinelAlertRuleScheduled#update}
    */
    readonly update?: string;
}
export declare function sentinelAlertRuleScheduledTimeoutsToTerraform(struct?: SentinelAlertRuleScheduledTimeouts | cdktf.IResolvable): any;
export declare function sentinelAlertRuleScheduledTimeoutsToHclTerraform(struct?: SentinelAlertRuleScheduledTimeouts | cdktf.IResolvable): any;
export declare class SentinelAlertRuleScheduledTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelAlertRuleScheduledTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelAlertRuleScheduledTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled azurerm_sentinel_alert_rule_scheduled}
*/
export declare class SentinelAlertRuleScheduled extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_sentinel_alert_rule_scheduled";
    /**
    * Generates CDKTF code for importing a SentinelAlertRuleScheduled resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SentinelAlertRuleScheduled to import
    * @param importFromId The id of the existing SentinelAlertRuleScheduled that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SentinelAlertRuleScheduled to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/sentinel_alert_rule_scheduled azurerm_sentinel_alert_rule_scheduled} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SentinelAlertRuleScheduledConfig
    */
    constructor(scope: Construct, id: string, config: SentinelAlertRuleScheduledConfig);
    private _alertRuleTemplateGuid?;
    get alertRuleTemplateGuid(): string;
    set alertRuleTemplateGuid(value: string);
    resetAlertRuleTemplateGuid(): void;
    get alertRuleTemplateGuidInput(): string | undefined;
    private _alertRuleTemplateVersion?;
    get alertRuleTemplateVersion(): string;
    set alertRuleTemplateVersion(value: string);
    resetAlertRuleTemplateVersion(): void;
    get alertRuleTemplateVersionInput(): string | undefined;
    private _customDetails?;
    get customDetails(): {
        [key: string]: string;
    };
    set customDetails(value: {
        [key: string]: string;
    });
    resetCustomDetails(): void;
    get customDetailsInput(): {
        [key: string]: string;
    } | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _queryFrequency?;
    get queryFrequency(): string;
    set queryFrequency(value: string);
    resetQueryFrequency(): void;
    get queryFrequencyInput(): string | undefined;
    private _queryPeriod?;
    get queryPeriod(): string;
    set queryPeriod(value: string);
    resetQueryPeriod(): void;
    get queryPeriodInput(): string | undefined;
    private _severity?;
    get severity(): string;
    set severity(value: string);
    get severityInput(): string | undefined;
    private _suppressionDuration?;
    get suppressionDuration(): string;
    set suppressionDuration(value: string);
    resetSuppressionDuration(): void;
    get suppressionDurationInput(): string | undefined;
    private _suppressionEnabled?;
    get suppressionEnabled(): boolean | cdktf.IResolvable;
    set suppressionEnabled(value: boolean | cdktf.IResolvable);
    resetSuppressionEnabled(): void;
    get suppressionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tactics?;
    get tactics(): string[];
    set tactics(value: string[]);
    resetTactics(): void;
    get tacticsInput(): string[] | undefined;
    private _techniques?;
    get techniques(): string[];
    set techniques(value: string[]);
    resetTechniques(): void;
    get techniquesInput(): string[] | undefined;
    private _triggerOperator?;
    get triggerOperator(): string;
    set triggerOperator(value: string);
    resetTriggerOperator(): void;
    get triggerOperatorInput(): string | undefined;
    private _triggerThreshold?;
    get triggerThreshold(): number;
    set triggerThreshold(value: number);
    resetTriggerThreshold(): void;
    get triggerThresholdInput(): number | undefined;
    private _alertDetailsOverride;
    get alertDetailsOverride(): SentinelAlertRuleScheduledAlertDetailsOverrideList;
    putAlertDetailsOverride(value: SentinelAlertRuleScheduledAlertDetailsOverride[] | cdktf.IResolvable): void;
    resetAlertDetailsOverride(): void;
    get alertDetailsOverrideInput(): cdktf.IResolvable | SentinelAlertRuleScheduledAlertDetailsOverride[] | undefined;
    private _entityMapping;
    get entityMapping(): SentinelAlertRuleScheduledEntityMappingList;
    putEntityMapping(value: SentinelAlertRuleScheduledEntityMapping[] | cdktf.IResolvable): void;
    resetEntityMapping(): void;
    get entityMappingInput(): cdktf.IResolvable | SentinelAlertRuleScheduledEntityMapping[] | undefined;
    private _eventGrouping;
    get eventGrouping(): SentinelAlertRuleScheduledEventGroupingOutputReference;
    putEventGrouping(value: SentinelAlertRuleScheduledEventGrouping): void;
    resetEventGrouping(): void;
    get eventGroupingInput(): SentinelAlertRuleScheduledEventGrouping | undefined;
    private _incident;
    get incident(): SentinelAlertRuleScheduledIncidentOutputReference;
    putIncident(value: SentinelAlertRuleScheduledIncident): void;
    resetIncident(): void;
    get incidentInput(): SentinelAlertRuleScheduledIncident | undefined;
    private _sentinelEntityMapping;
    get sentinelEntityMapping(): SentinelAlertRuleScheduledSentinelEntityMappingList;
    putSentinelEntityMapping(value: SentinelAlertRuleScheduledSentinelEntityMapping[] | cdktf.IResolvable): void;
    resetSentinelEntityMapping(): void;
    get sentinelEntityMappingInput(): cdktf.IResolvable | SentinelAlertRuleScheduledSentinelEntityMapping[] | undefined;
    private _timeouts;
    get timeouts(): SentinelAlertRuleScheduledTimeoutsOutputReference;
    putTimeouts(value: SentinelAlertRuleScheduledTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SentinelAlertRuleScheduledTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
