/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageObjectReplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication#destination_storage_account_id StorageObjectReplication#destination_storage_account_id}
    */
    readonly destinationStorageAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication#id StorageObjectReplication#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication#source_storage_account_id StorageObjectReplication#source_storage_account_id}
    */
    readonly sourceStorageAccountId: string;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication#rules StorageObjectReplication#rules}
    */
    readonly rules: StorageObjectReplicationRules[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication#timeouts StorageObjectReplication#timeouts}
    */
    readonly timeouts?: StorageObjectReplicationTimeouts;
}
export interface StorageObjectReplicationRules {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication#copy_blobs_created_after StorageObjectReplication#copy_blobs_created_after}
    */
    readonly copyBlobsCreatedAfter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication#destination_container_name StorageObjectReplication#destination_container_name}
    */
    readonly destinationContainerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication#filter_out_blobs_with_prefix StorageObjectReplication#filter_out_blobs_with_prefix}
    */
    readonly filterOutBlobsWithPrefix?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication#source_container_name StorageObjectReplication#source_container_name}
    */
    readonly sourceContainerName: string;
}
export declare function storageObjectReplicationRulesToTerraform(struct?: StorageObjectReplicationRules | cdktf.IResolvable): any;
export declare function storageObjectReplicationRulesToHclTerraform(struct?: StorageObjectReplicationRules | cdktf.IResolvable): any;
export declare class StorageObjectReplicationRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageObjectReplicationRules | cdktf.IResolvable | undefined;
    set internalValue(value: StorageObjectReplicationRules | cdktf.IResolvable | undefined);
    private _copyBlobsCreatedAfter?;
    get copyBlobsCreatedAfter(): string;
    set copyBlobsCreatedAfter(value: string);
    resetCopyBlobsCreatedAfter(): void;
    get copyBlobsCreatedAfterInput(): string | undefined;
    private _destinationContainerName?;
    get destinationContainerName(): string;
    set destinationContainerName(value: string);
    get destinationContainerNameInput(): string | undefined;
    private _filterOutBlobsWithPrefix?;
    get filterOutBlobsWithPrefix(): string[];
    set filterOutBlobsWithPrefix(value: string[]);
    resetFilterOutBlobsWithPrefix(): void;
    get filterOutBlobsWithPrefixInput(): string[] | undefined;
    get name(): string;
    private _sourceContainerName?;
    get sourceContainerName(): string;
    set sourceContainerName(value: string);
    get sourceContainerNameInput(): string | undefined;
}
export declare class StorageObjectReplicationRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageObjectReplicationRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageObjectReplicationRulesOutputReference;
}
export interface StorageObjectReplicationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication#create StorageObjectReplication#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication#delete StorageObjectReplication#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication#read StorageObjectReplication#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication#update StorageObjectReplication#update}
    */
    readonly update?: string;
}
export declare function storageObjectReplicationTimeoutsToTerraform(struct?: StorageObjectReplicationTimeouts | cdktf.IResolvable): any;
export declare function storageObjectReplicationTimeoutsToHclTerraform(struct?: StorageObjectReplicationTimeouts | cdktf.IResolvable): any;
export declare class StorageObjectReplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageObjectReplicationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageObjectReplicationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication azurerm_storage_object_replication}
*/
export declare class StorageObjectReplication extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_object_replication";
    /**
    * Generates CDKTF code for importing a StorageObjectReplication resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageObjectReplication to import
    * @param importFromId The id of the existing StorageObjectReplication that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageObjectReplication to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/storage_object_replication azurerm_storage_object_replication} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageObjectReplicationConfig
    */
    constructor(scope: Construct, id: string, config: StorageObjectReplicationConfig);
    get destinationObjectReplicationId(): string;
    private _destinationStorageAccountId?;
    get destinationStorageAccountId(): string;
    set destinationStorageAccountId(value: string);
    get destinationStorageAccountIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get sourceObjectReplicationId(): string;
    private _sourceStorageAccountId?;
    get sourceStorageAccountId(): string;
    set sourceStorageAccountId(value: string);
    get sourceStorageAccountIdInput(): string | undefined;
    private _rules;
    get rules(): StorageObjectReplicationRulesList;
    putRules(value: StorageObjectReplicationRules[] | cdktf.IResolvable): void;
    get rulesInput(): cdktf.IResolvable | StorageObjectReplicationRules[] | undefined;
    private _timeouts;
    get timeouts(): StorageObjectReplicationTimeoutsOutputReference;
    putTimeouts(value: StorageObjectReplicationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageObjectReplicationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
