/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VideoIndexerAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#id VideoIndexerAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#location VideoIndexerAccount#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#name VideoIndexerAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#resource_group_name VideoIndexerAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#tags VideoIndexerAccount#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#identity VideoIndexerAccount#identity}
    */
    readonly identity: VideoIndexerAccountIdentity;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#storage VideoIndexerAccount#storage}
    */
    readonly storage: VideoIndexerAccountStorage;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#timeouts VideoIndexerAccount#timeouts}
    */
    readonly timeouts?: VideoIndexerAccountTimeouts;
}
export interface VideoIndexerAccountIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#identity_ids VideoIndexerAccount#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#type VideoIndexerAccount#type}
    */
    readonly type: string;
}
export declare function videoIndexerAccountIdentityToTerraform(struct?: VideoIndexerAccountIdentityOutputReference | VideoIndexerAccountIdentity): any;
export declare function videoIndexerAccountIdentityToHclTerraform(struct?: VideoIndexerAccountIdentityOutputReference | VideoIndexerAccountIdentity): any;
export declare class VideoIndexerAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VideoIndexerAccountIdentity | undefined;
    set internalValue(value: VideoIndexerAccountIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface VideoIndexerAccountStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#storage_account_id VideoIndexerAccount#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#user_assigned_identity_id VideoIndexerAccount#user_assigned_identity_id}
    */
    readonly userAssignedIdentityId?: string;
}
export declare function videoIndexerAccountStorageToTerraform(struct?: VideoIndexerAccountStorageOutputReference | VideoIndexerAccountStorage): any;
export declare function videoIndexerAccountStorageToHclTerraform(struct?: VideoIndexerAccountStorageOutputReference | VideoIndexerAccountStorage): any;
export declare class VideoIndexerAccountStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VideoIndexerAccountStorage | undefined;
    set internalValue(value: VideoIndexerAccountStorage | undefined);
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _userAssignedIdentityId?;
    get userAssignedIdentityId(): string;
    set userAssignedIdentityId(value: string);
    resetUserAssignedIdentityId(): void;
    get userAssignedIdentityIdInput(): string | undefined;
}
export interface VideoIndexerAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#create VideoIndexerAccount#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#delete VideoIndexerAccount#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#read VideoIndexerAccount#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#update VideoIndexerAccount#update}
    */
    readonly update?: string;
}
export declare function videoIndexerAccountTimeoutsToTerraform(struct?: VideoIndexerAccountTimeouts | cdktf.IResolvable): any;
export declare function videoIndexerAccountTimeoutsToHclTerraform(struct?: VideoIndexerAccountTimeouts | cdktf.IResolvable): any;
export declare class VideoIndexerAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VideoIndexerAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VideoIndexerAccountTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account azurerm_video_indexer_account}
*/
export declare class VideoIndexerAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_video_indexer_account";
    /**
    * Generates CDKTF code for importing a VideoIndexerAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VideoIndexerAccount to import
    * @param importFromId The id of the existing VideoIndexerAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VideoIndexerAccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.34.0/docs/resources/video_indexer_account azurerm_video_indexer_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VideoIndexerAccountConfig
    */
    constructor(scope: Construct, id: string, config: VideoIndexerAccountConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): VideoIndexerAccountIdentityOutputReference;
    putIdentity(value: VideoIndexerAccountIdentity): void;
    get identityInput(): VideoIndexerAccountIdentity | undefined;
    private _storage;
    get storage(): VideoIndexerAccountStorageOutputReference;
    putStorage(value: VideoIndexerAccountStorage): void;
    get storageInput(): VideoIndexerAccountStorage | undefined;
    private _timeouts;
    get timeouts(): VideoIndexerAccountTimeoutsOutputReference;
    putTimeouts(value: VideoIndexerAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VideoIndexerAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
