from robodyno.components.brands.uuid import DeviceType

ROBODYNO_MOTOR_SPECS = {
    DeviceType.ROBODYNO_PRO_44: {
        'reduction': -44,
        'available_velocity': 27,
        'available_torque': 13,
        'available_current': 15,
        'torque_constant': 0.7742,
        'with_brake': False,
    },
    DeviceType.ROBODYNO_PRO_12: {
        'reduction': -12.45,
        'available_velocity': 95,
        'available_torque': 4,
        'available_current': 15,
        'torque_constant': 0.2191,
        'with_brake': False,
    },
    DeviceType.ROBODYNO_PRO_50: {
        'reduction': 50,
        'available_velocity': 23.6,
        'available_torque': 15,
        'available_current': 15,
        'torque_constant': 0.88,
        'with_brake': False,
    },
    DeviceType.ROBODYNO_PRO_100: {
        'reduction': 100,
        'available_velocity': 11.8,
        'available_torque': 30,
        'available_current': 15,
        'torque_constant': 1.76,
        'with_brake': False,
    },
    DeviceType.ROBODYNO_PRO_DIRECT: {
        'reduction': 1,
        'available_velocity': 1180,
        'available_torque': 0.3,
        'available_current': 15,
        'torque_constant': 0.0176,
        'with_brake': False,
    },
    DeviceType.ROBODYNO_PLUS_50: {
        'reduction': 50,
        'available_velocity': 24,
        'available_torque': 48,
        'available_current': 25,
        'torque_constant': 1.7229,
        'with_brake': True,
    },
    DeviceType.ROBODYNO_PLUS_100: {
        'reduction': 100,
        'available_velocity': 12,
        'available_torque': 96,
        'available_current': 25,
        'torque_constant': 3.4458,
        'with_brake': True,
    },
    DeviceType.ROBODYNO_PLUS_12: {
        'reduction': -12.45,
        'available_velocity': 96,
        'available_torque': 12,
        'available_current': 25,
        'torque_constant': 0.429,
        'with_brake': True,
    },
    DeviceType.ROBODYNO_PLUS_DIRECT: {
        'reduction': 1,
        'available_velocity': 1200,
        'available_torque': 0.96,
        'available_current': 25,
        'torque_constant': 0.034458,
        'with_brake': True,
    },
    DeviceType.ROBODYNO_NANO_100: {
        'reduction': 100,
        'available_velocity': 16.23,
        'available_torque': 0.15,
        'available_current': 0.6,
        'torque_constant': 0.25,
        'with_brake': False,
    }
}