# # -*- coding: utf-8 -*-
# #"""Gestão de Imóveis.ipynb

# #Automatically generated by Colab.

# Original file is located at
#     https://colab.research.google.com/drive/1-LO95GUkHmOezaPkXX41vqcfKUJ0lQzv

# # Gestão de dados de imóveis

# ---
# Gonçalo José Madureira Tavares,Guilherme Costa e Silva,João Miguel Sernadas Maia,Vasco Nogueira Azevedo

# # 12.03.25
# - **Dados dos clientes (NIF,Nome, email,telefone)**
# - **Dados dos Imóveis (nome, localizacao, Rua, tipo, certificacao_energetica, mobilidade_reduzida, data_construcao, tipo_construcao, despesas_construcao, latitude e longitude)**
# - **Ligação entre os dados dos clientes e os dados do imóveis**

# # 24.04.25 - Fim

# Método para adicionar os clientes e todos os seus campos que foram pedidos por parte do cliente.
# E também criação da estrutura da tabela para representar todos os dados recolhidos
# """

class Cliente:
    def __init__(self, nome, email, telefone, nif):
        self.nome = nome
        self.email = email
        self.telefone = telefone
        self.nif = nif  # Número de Identificação Fiscal
        # Lista de casas atribuídas a este cliente
        self.casas = []

    def __repr__(self):
        return (
            f"Cliente(nome={self.nome}, email={self.email}, telefone={self.telefone}, "
            f"nif={self.nif}, casas={[casa['nome'] for casa in self.casas]})"
        )


class SistemaClientes:
    def __init__(self):
        self.clientes = []

    def adicionar_cliente(self, nome, email, telefone, nif):
        # Verifica se o cliente já existe na lista (nome, email, telefone ou nif)
        for cliente in self.clientes:
            if (cliente.nome == nome or cliente.email == email
                    or cliente.telefone == telefone or cliente.nif == nif):
                print("Erro: Cliente com o mesmo nome, e-mail, telefone ou NIF já existe.")
                return

        novo_cliente = Cliente(nome, email, telefone, nif)
        self.clientes.append(novo_cliente)
        print(f"Cliente '{nome}' (NIF: {nif}) adicionado com sucesso!")

    def remover_cliente(self, nome):
        for cliente in self.clientes:
            if cliente.nome.lower() == nome.lower():
                self.clientes.remove(cliente)
                print(f"Cliente '{nome}' removido com sucesso!")
                return
        print(f"Erro: Cliente '{nome}' não encontrado.")

    def atribuir_casa(self, nome_cliente, nome_casa, imobiliaria):
        # Procura o cliente
        cliente = next((c for c in self.clientes if c.nome.lower() == nome_cliente.lower()), None)
        if not cliente:
            print(f"Erro: Cliente '{nome_cliente}' não encontrado.")
            return

        # Procura casa no sistema imobiliário
        casa = next((c for c in imobiliaria.casas if c['nome'].lower() == nome_casa.lower()), None)
        if not casa:
            print(f"Erro: Casa '{nome_casa}' não encontrada no sistema imobiliário.")
            return

        # Verifica se já foi atribuída
        if casa in cliente.casas:
            print(f"Atenção: Cliente '{nome_cliente}' já tem a casa '{nome_casa}' atribuída.")
            return

        cliente.casas.append(casa)
        print(f"Casa '{nome_casa}' atribuída ao cliente '{nome_cliente}' com sucesso!")

    def listar_clientes(self):
        if not self.clientes:
            print("Nenhum cliente registado.")
            return

        print("\nLista de Clientes:")
        print("+----------------------+----------------------+----------------------+-----------------+----------------------+ ")
        print("| Nome                 | E-mail               | Telefone             | NIF             | Casas Atribuídas     | ")
        print("+----------------------+----------------------+----------------------+-----------------+----------------------+ ")
        for cliente in self.clientes:
            casas_str = ", ".join([c['nome'] for c in cliente.casas]) or "-"
            print(
                f"| {cliente.nome.ljust(20)} | {cliente.email.ljust(20)} | "
                f"{cliente.telefone.ljust(20)} | {cliente.nif.ljust(15)} | {casas_str.ljust(20)} |")
        print("+----------------------+----------------------+----------------------+-----------------+----------------------+ ")

# """Método para adicionar casas e todas as suas características e também eliminar as mesmas"""

class Imobiliaria:
    def __init__(self):
        self.casas = []

    def adicionar_casa(self, nome, localizacao, Rua, tipo,
                       certificacao_energetica, mobilidade_reduzida,
                       data_construcao, tipo_construcao,
                       despesas_construcao, latitude, longitude):
        for casa_existente in self.casas:
            if casa_existente["nome"] == nome:
                print("Erro: Essa casa já existe.")
                return

        casa = {
            "nome": nome,
            "localizacao": localizacao,
            "Rua": Rua,
            "tipo": tipo,
            "certificacao_energetica": certificacao_energetica,
            "mobilidade_reduzida": mobilidade_reduzida,
            "data_construcao": data_construcao,
            "tipo_construcao": tipo_construcao,
            "despesas_construcao": despesas_construcao,
            "latitude": latitude,
            "longitude": longitude
        }
        self.casas.append(casa)
        print(f"Casa '{nome}' adicionada com sucesso!")

    def remover_casa(self, nome):
        for casa in self.casas:
            if casa["nome"].lower() == nome.lower():
                self.casas.remove(casa)
                print(f"Casa '{nome}' removida com sucesso!")
                return
        print(f"Erro: Casa '{nome}' não encontrada.")

    def listar_casas(self):
        if not self.casas:
            print("Nenhuma casa registada.")
            return
        print("\nLista de Casas:")
        print("=" * 200)
        print(
            f"{'Nome':<20}{'Localização':<20}{'Rua':<20}{'Tipo':<10}"
            f"{'Cert. Energética':<20}{'Mobilidade Reduzida':<22}"
            f"{'Data Construção':<18}{'Tipo Construção':<20}"
            f"{'Despesas Construção':<22}{'Latitude':<12}{'Longitude':<12}"
        )
        print("-" * 200)
        for casa in self.casas:
            print(
                f"{casa['nome']:<20}{casa['localizacao']:<20}{casa['Rua']:<20}{casa['tipo']:<10}"
                f"{casa['certificacao_energetica']:<20}{str(casa['mobilidade_reduzida']):<22}"
                f"{casa['data_construcao']:<18}{casa['tipo_construcao']:<20}"
                f"{str(casa['despesas_construcao']):<22}{str(casa['latitude']):<12}{str(casa['longitude']):<12}"
            )
        print("=" * 200)

# """O bloca de código seguinte são os exemplos de uso com adicionar clientes, adicionar imoveis todos com teste de erros e atribuicao de clientes aos imovies."""

# # Exemplo de uso
# sistema = SistemaClientes()
# imobiliaria = Imobiliaria()

# # sistema.adicionar_cliente(nome, email, telefone)

# sistema.adicionar_cliente("João Silva", "joao@email.com", "999999999", "123456789")
# sistema.adicionar_cliente("Maria Sousa", "maria@email.com", "888888888", "987654321")
# sistema.adicionar_cliente("Pedro Santos", "pedro@email.com", "777777777", "111222333")
# sistema.adicionar_cliente("Rui Silva", "rui@email.com", "666666666", "444555666")
# sistema.adicionar_cliente("Sofia Costa", "Sofi@email.com", "555555555", "257337457")





#teste para aparecer o erro
# sistema.adicionar_cliente("João Silva", "joao@email.com", "999999999", "123456789")
# sistema.adicionar_cliente("Maria Sousa", "maria@email.com", "888888888", "987654321")


# imobiliaria.adicionar_casa("Casa do Lago", "Lisboa","Rua do Sobreiro", "T3", "A+", True, "2005-06-15","Madeira","85000", 38.7169, -9.1399)
# imobiliaria.adicionar_casa("Casa da Lagoa", "Porto","Rua do Pinheiro", "T1", "B-", False, "2001-07-5","Estrutura Metálica","180000", 38.7169, -9.1399)
# imobiliaria.adicionar_casa("Casa dos Gatos", "coimbra","Rua das Arvores", "T2", "C+", True, "2020-12-1","Container","65300", 38.7169, -9.1399)
# imobiliaria.adicionar_casa("Casa Azul", "coimbra","Rua das Arvores", "T2", "C+", True, "2020-12-1","Container","65300", 38.7169, -9.1399)


#teste para aparecer o erro
# imobiliaria.adicionar_casa("Casa Azul", "coimbra","Rua das Arvores", "T2", "C+", True, "2020-12-1","Container","65300", 38.7169, -9.1399)
# imobiliaria.adicionar_casa("Casa do Lago", "Lisboa", "Rua do Sobreiro", "T3","A+", True, "2005-06-15", "Madeira", 85000, 38.7169, -9.1399)


# sistema.atribuir_casa("João Silva", "Casa do Lago", imobiliaria)
# sistema.atribuir_casa("Maria Sousa", "Casa da Lagoa", imobiliaria)
# sistema.atribuir_casa("Pedro Santos", "Casa dos Gatos", imobiliaria)
# sistema.atribuir_casa("Rui Silva", "Casa Azul", imobiliaria)

#"""Tabela dos clientes, onde estão presentes todos os resultados pedidos"""

#sistema.listar_clientes()

#"""Remover Casa"""

#Correr apenas se quiser apagar a casa
#imobiliaria.remover_casa("Casa Azul")
#imobiliaria.remover_casa("Casa Amarela")

# #"""#Listar as Casas
# Com esta lista é possível ver todos os dados disponibilizados de cada casa
# """

#imobiliaria.listar_casas()