# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### ToolsLayer <a name="ToolsLayer" id="vaughntech-nodejs-powertools-lambdalayer.ToolsLayer"></a>

Create a Lambda layer with the PowerTools and other required modules.

#### Initializers <a name="Initializers" id="vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.Initializer"></a>

```typescript
import { ToolsLayer } from 'vaughntech-nodejs-powertools-lambdalayer'

new ToolsLayer(scope: Construct, id: string, props?: IExampleConstructProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.Initializer.parameter.props">props</a></code> | <code><a href="#vaughntech-nodejs-powertools-lambdalayer.IExampleConstructProps">IExampleConstructProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Optional</sup> <a name="props" id="vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.Initializer.parameter.props"></a>

- *Type:* <a href="#vaughntech-nodejs-powertools-lambdalayer.IExampleConstructProps">IExampleConstructProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.isConstruct"></a>

```typescript
import { ToolsLayer } from 'vaughntech-nodejs-powertools-lambdalayer'

ToolsLayer.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.property.layerVersion">layerVersion</a></code> | <code>aws-cdk-lib.aws_lambda.LayerVersion</code> | Lambda Layer. |

---

##### `node`<sup>Required</sup> <a name="node" id="vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `layerVersion`<sup>Required</sup> <a name="layerVersion" id="vaughntech-nodejs-powertools-lambdalayer.ToolsLayer.property.layerVersion"></a>

```typescript
public readonly layerVersion: LayerVersion;
```

- *Type:* aws-cdk-lib.aws_lambda.LayerVersion

Lambda Layer.

---




## Protocols <a name="Protocols" id="Protocols"></a>

### IExampleConstructProps <a name="IExampleConstructProps" id="vaughntech-nodejs-powertools-lambdalayer.IExampleConstructProps"></a>

- *Implemented By:* <a href="#vaughntech-nodejs-powertools-lambdalayer.IExampleConstructProps">IExampleConstructProps</a>


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#vaughntech-nodejs-powertools-lambdalayer.IExampleConstructProps.property.layerVersionName">layerVersionName</a></code> | <code>string</code> | Debug log sampling rate. |

---

##### `layerVersionName`<sup>Required</sup> <a name="layerVersionName" id="vaughntech-nodejs-powertools-lambdalayer.IExampleConstructProps.property.layerVersionName"></a>

```typescript
public readonly layerVersionName: string;
```

- *Type:* string
- *Default:* 'test'

Debug log sampling rate.

Zero means all events.

---

