"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogFormatter = void 0;
/**
 * This class defines and implements common methods for the formatting of log attributes.
 *
 * @class
 * @abstract
 * @implements {LogFormatterInterface}
 */
class LogFormatter {
    /**
     * It formats a given Error parameter.
     *
     * @param {Error} error
     * @returns {LogAttributes}
     */
    formatError(error) {
        return {
            name: error.name,
            location: this.getCodeLocation(error.stack),
            message: error.message,
            stack: error.stack,
        };
    }
    /**
     * It formats a date into a string in simplified extended ISO format (ISO 8601).
     *
     * @param {Date} now
     * @returns {string}
     */
    formatTimestamp(now) {
        return now.toISOString();
    }
    /**
     * It returns a string containing the location of an error, given a particular stack trace.
     *
     * @param stack
     * @returns {string}
     */
    getCodeLocation(stack) {
        if (!stack) {
            return '';
        }
        const stackLines = stack.split('\n');
        const regex = /\((.*):(\d+):(\d+)\)\\?$/;
        let i;
        for (i = 0; i < stackLines.length; i++) {
            const match = regex.exec(stackLines[i]);
            if (Array.isArray(match)) {
                return `${match[1]}:${Number(match[2])}`;
            }
        }
        return '';
    }
}
exports.LogFormatter = LogFormatter;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTG9nRm9ybWF0dGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2Zvcm1hdHRlci9Mb2dGb3JtYXR0ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBR0E7Ozs7OztHQU1HO0FBQ0gsTUFBZSxZQUFZO0lBVXpCOzs7OztPQUtHO0lBQ0ksV0FBVyxDQUFDLEtBQVk7UUFDN0IsT0FBTztZQUNMLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTtZQUNoQixRQUFRLEVBQUUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDO1lBQzNDLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztZQUN0QixLQUFLLEVBQUUsS0FBSyxDQUFDLEtBQUs7U0FDbkIsQ0FBQztJQUNKLENBQUM7SUFFRDs7Ozs7T0FLRztJQUNJLGVBQWUsQ0FBQyxHQUFTO1FBQzlCLE9BQU8sR0FBRyxDQUFDLFdBQVcsRUFBRSxDQUFDO0lBQzNCLENBQUM7SUFFRDs7Ozs7T0FLRztJQUNJLGVBQWUsQ0FBQyxLQUFjO1FBQ25DLElBQUksQ0FBQyxLQUFLLEVBQUU7WUFDVixPQUFPLEVBQUUsQ0FBQztTQUNYO1FBRUQsTUFBTSxVQUFVLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNyQyxNQUFNLEtBQUssR0FBRywwQkFBMEIsQ0FBQztRQUV6QyxJQUFJLENBQUMsQ0FBQztRQUNOLEtBQUssQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsVUFBVSxDQUFDLE1BQU0sRUFBRSxDQUFDLEVBQUUsRUFBRTtZQUN0QyxNQUFNLEtBQUssR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBRXhDLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsRUFBRTtnQkFDeEIsT0FBTyxHQUFHLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQzthQUMxQztTQUVGO1FBRUQsT0FBTyxFQUFFLENBQUM7SUFDWixDQUFDO0NBQ0Y7QUFHQyxvQ0FBWSJ9