# AUTOGENERATED! DO NOT EDIT! File to edit: 00_search.ipynb (unless otherwise specified).

__all__ = ['hubspot_search']

# Cell
# export

import os
import json
import requests
from dotenv import load_dotenv
load_dotenv()

# Cell


def hubspot_search(value, property='email', operator='EQ', hapikey=None):
    """
    Search hubspot based on one filter condition.
    """
    if hapikey is None:
        hapikey = os.environ.get('HUBSPOT_API_KEY','demo')
    endpoint = 'https://api.hubapi.com/crm/v3/objects/contacts/search'
    url = f'{endpoint}?hapikey={hapikey}'
    headers = {
        "Content-Type": "application/json"
    }
    data = json.dumps({
        "filterGroups": [
            {
                "filters": [
                    {
                        "propertyName": property,
                        "operator": operator,
                        "value": value
                    }
                ]
            }
        ]
    })
    r = requests.post(url=url, data=data, headers=headers)
    return r.json()

