// Legendre-Gauss Quadrature Points and Weights

#if defined(_WIN32) || defined(__WIN32__)
  #define EXPORTIT __declspec(dllexport)
#else
  #define EXPORTIT
#endif

EXPORTIT void leggauss_quad(int n, double *points, double *weights) {
    switch(n) {
    case 2:
        points[0] = -0.577350269189625764509148780501957455647601751270126876;
        points[1] = 0.577350269189625764509148780501957455647601751270126876;
        weights[0] = 1.;
        weights[1] = 1.;
        return;
    case 3:
        points[0] = -0.774596669241483377035853079956479922166584341058318165;
        points[1] = 0;
        points[2] = 0.774596669241483377035853079956479922166584341058318165;
        weights[0] = 0.555555555555555555555555555555555555555555555555555556;
        weights[1] = 0.888888888888888888888888888888888888888888888888888889;
        weights[2] = 0.555555555555555555555555555555555555555555555555555556;
        return;
    case 4:
        points[0] = -0.861136311594052575223946488892809505095725379629717638;
        points[1] = -0.339981043584856264802665759103244687200575869770914353;
        points[2] = 0.339981043584856264802665759103244687200575869770914353;
        points[3] = 0.861136311594052575223946488892809505095725379629717638;
        weights[0] = 0.34785484513745385737306394922199940723534869583389354;
        weights[1] = 0.65214515486254614262693605077800059276465130416610646;
        weights[2] = 0.65214515486254614262693605077800059276465130416610646;
        weights[3] = 0.34785484513745385737306394922199940723534869583389354;
        return;
    case 5:
        points[0] = -0.906179845938663992797626878299392965125651910762530863;
        points[1] = -0.538469310105683091036314420700208804967286606905559956;
        points[2] = 0;
        points[3] = 0.538469310105683091036314420700208804967286606905559956;
        points[4] = 0.906179845938663992797626878299392965125651910762530863;
        weights[0] = 0.236926885056189087514264040719917362643260002212414016;
        weights[1] = 0.47862867049936646804129151483563819291229555334314154;
        weights[2] = 0.568888888888888888888888888888888888888888888888888889;
        weights[3] = 0.47862867049936646804129151483563819291229555334314154;
        weights[4] = 0.236926885056189087514264040719917362643260002212414016;
        return;
    case 6:
        points[0] = -0.932469514203152027812301554493994609134765737712289825;
        points[1] = -0.661209386466264513661399595019905347006448564395170071;
        points[2] = -0.23861918608319690863050172168071193541861063014002135;
        points[3] = 0.23861918608319690863050172168071193541861063014002135;
        points[4] = 0.661209386466264513661399595019905347006448564395170071;
        points[5] = 0.932469514203152027812301554493994609134765737712289825;
        weights[0] = 0.171324492379170345040296142172732893526822501484043982;
        weights[1] = 0.360761573048138607569833513837716111661521892746745482;
        weights[2] = 0.467913934572691047389870343989550994811655605769210535;
        weights[3] = 0.467913934572691047389870343989550994811655605769210535;
        weights[4] = 0.360761573048138607569833513837716111661521892746745482;
        weights[5] = 0.171324492379170345040296142172732893526822501484043982;
        return;
    case 7:
        points[0] = -0.949107912342758524526189684047851262400770937670617784;
        points[1] = -0.74153118559939443986386477328078840707414764714139026;
        points[2] = -0.405845151377397166906606412076961463347382014099370126;
        points[3] = 0;
        points[4] = 0.405845151377397166906606412076961463347382014099370126;
        points[5] = 0.74153118559939443986386477328078840707414764714139026;
        points[6] = 0.949107912342758524526189684047851262400770937670617784;
        weights[0] = 0.129484966168869693270611432679082018328587402259946664;
        weights[1] = 0.279705391489276667901467771423779582486925065226598765;
        weights[2] = 0.381830050505118944950369775488975133878365083533862735;
        weights[3] = 0.417959183673469387755102040816326530612244897959183673;
        weights[4] = 0.381830050505118944950369775488975133878365083533862735;
        weights[5] = 0.279705391489276667901467771423779582486925065226598765;
        weights[6] = 0.129484966168869693270611432679082018328587402259946664;
        return;
    case 8:
        points[0] = -0.960289856497536231683560868569472990428235234301452038;
        points[1] = -0.796666477413626739591553936475830436837171731615964832;
        points[2] = -0.525532409916328985817739049189246349041964243120392858;
        points[3] = -0.183434642495649804939476142360183980666757812912973782;
        points[4] = 0.183434642495649804939476142360183980666757812912973782;
        points[5] = 0.525532409916328985817739049189246349041964243120392858;
        points[6] = 0.796666477413626739591553936475830436837171731615964832;
        points[7] = 0.960289856497536231683560868569472990428235234301452038;
        weights[0] = 0.101228536290376259152531354309962190115394091051684957;
        weights[1] = 0.222381034453374470544355994426240884430130870051249565;
        weights[2] = 0.313706645877887287337962201986601313260328999002734938;
        weights[3] = 0.362683783378361982965150449277195612194146039894330541;
        weights[4] = 0.362683783378361982965150449277195612194146039894330541;
        weights[5] = 0.313706645877887287337962201986601313260328999002734938;
        weights[6] = 0.222381034453374470544355994426240884430130870051249565;
        weights[7] = 0.101228536290376259152531354309962190115394091051684957;
        return;
    case 9:
        points[0] = -0.96816023950762608983557620290367287004940480049192533;
        points[1] = -0.836031107326635794299429788069734876544106718124675996;
        points[2] = -0.613371432700590397308702039341474184785720604940564693;
        points[3] = -0.324253423403808929038538014643336608571956260736973089;
        points[4] = 0;
        points[5] = 0.324253423403808929038538014643336608571956260736973089;
        points[6] = 0.613371432700590397308702039341474184785720604940564693;
        points[7] = 0.836031107326635794299429788069734876544106718124675996;
        points[8] = 0.96816023950762608983557620290367287004940480049192533;
        weights[0] = 0.0812743883615744119718921581105236506756617207824107507;
        weights[1] = 0.180648160694857404058472031242912809514337821732040484;
        weights[2] = 0.260610696402935462318742869418632849771840204437299952;
        weights[3] = 0.312347077040002840068630406584443665598754861261904646;
        weights[4] = 0.330239355001259763164525069286974048878810783572688335;
        weights[5] = 0.312347077040002840068630406584443665598754861261904646;
        weights[6] = 0.260610696402935462318742869418632849771840204437299952;
        weights[7] = 0.180648160694857404058472031242912809514337821732040484;
        weights[8] = 0.0812743883615744119718921581105236506756617207824107507;
        return;
    case 10:
        points[0] = -0.973906528517171720077964012084452053428269946692382119;
        points[1] = -0.865063366688984510732096688423493048527543014965330453;
        points[2] = -0.679409568299024406234327365114873575769294711834809468;
        points[3] = -0.433395394129247190799265943165784162200071837656246497;
        points[4] = -0.148874338981631210884826001129719984617564859420691696;
        points[5] = 0.148874338981631210884826001129719984617564859420691696;
        points[6] = 0.433395394129247190799265943165784162200071837656246497;
        points[7] = 0.679409568299024406234327365114873575769294711834809468;
        points[8] = 0.865063366688984510732096688423493048527543014965330453;
        points[9] = 0.973906528517171720077964012084452053428269946692382119;
        weights[0] = 0.0666713443086881375935688098933317928578648343201581451;
        weights[1] = 0.149451349150580593145776339657697332402556639669427368;
        weights[2] = 0.21908636251598204399553493422816319245877187052267709;
        weights[3] = 0.269266719309996355091226921569469352859759938460883796;
        weights[4] = 0.295524224714752870173892994651338329421046717026853601;
        weights[5] = 0.295524224714752870173892994651338329421046717026853601;
        weights[6] = 0.269266719309996355091226921569469352859759938460883796;
        weights[7] = 0.21908636251598204399553493422816319245877187052267709;
        weights[8] = 0.149451349150580593145776339657697332402556639669427368;
        weights[9] = 0.0666713443086881375935688098933317928578648343201581451;
        return;
    case 11:
        points[0] = -0.978228658146056992803938001122857390771422408919784415;
        points[1] = -0.887062599768095299075157769303927266631675751225314385;
        points[2] = -0.730152005574049324093416252031153458049643062026130312;
        points[3] = -0.519096129206811815925725669458609554480227115119928489;
        points[4] = -0.269543155952344972331531985400861524679621862439052282;
        points[5] = 0;
        points[6] = 0.269543155952344972331531985400861524679621862439052282;
        points[7] = 0.519096129206811815925725669458609554480227115119928489;
        points[8] = 0.730152005574049324093416252031153458049643062026130312;
        points[9] = 0.887062599768095299075157769303927266631675751225314385;
        points[10] = 0.978228658146056992803938001122857390771422408919784415;
        weights[0] = 0.0556685671161736664827537204425485787285156256968981483;
        weights[1] = 0.125580369464904624634694299223940100197615791395403501;
        weights[2] = 0.186290210927734251426097641431655891691284748040203412;
        weights[3] = 0.233193764591990479918523704843175139431798172316958509;
        weights[4] = 0.262804544510246662180688869890509195372764677603144556;
        weights[5] = 0.272925086777900630714483528336342189156041969894783748;
        weights[6] = 0.262804544510246662180688869890509195372764677603144556;
        weights[7] = 0.233193764591990479918523704843175139431798172316958509;
        weights[8] = 0.186290210927734251426097641431655891691284748040203412;
        weights[9] = 0.125580369464904624634694299223940100197615791395403501;
        weights[10] = 0.0556685671161736664827537204425485787285156256968981483;
        return;
    case 12:
        points[0] = -0.98156063424671925069054909014928082296015519981373151;
        points[1] = -0.904117256370474856678465866119096192537596709213297547;
        points[2] = -0.769902674194304687036893833212818075984925750018931638;
        points[3] = -0.587317954286617447296702418940534280369098514048052482;
        points[4] = -0.367831498998180193752691536643717561256360141335409621;
        points[5] = -0.125233408511468915472441369463853129983396916305444273;
        points[6] = 0.125233408511468915472441369463853129983396916305444273;
        points[7] = 0.367831498998180193752691536643717561256360141335409621;
        points[8] = 0.587317954286617447296702418940534280369098514048052482;
        points[9] = 0.769902674194304687036893833212818075984925750018931638;
        points[10] = 0.904117256370474856678465866119096192537596709213297547;
        points[11] = 0.98156063424671925069054909014928082296015519981373151;
        weights[0] = 0.0471753363865118271946159614850170603170290739948470896;
        weights[1] = 0.10693932599531843096025471819399622421457017347032488;
        weights[2] = 0.160078328543346226334652529543359071872011730490864178;
        weights[3] = 0.203167426723065921749064455809798376506518147274590146;
        weights[4] = 0.233492536538354808760849898924878056259409972199754875;
        weights[5] = 0.249147045813402785000562436042951210830460902569618831;
        weights[6] = 0.249147045813402785000562436042951210830460902569618831;
        weights[7] = 0.233492536538354808760849898924878056259409972199754875;
        weights[8] = 0.203167426723065921749064455809798376506518147274590146;
        weights[9] = 0.160078328543346226334652529543359071872011730490864178;
        weights[10] = 0.10693932599531843096025471819399622421457017347032488;
        weights[11] = 0.0471753363865118271946159614850170603170290739948470896;
        return;
    case 13:
        points[0] = -0.984183054718588149472829448807109611064990561925874909;
        points[1] = -0.917598399222977965206547836500719512390474790111683296;
        points[2] = -0.80157809073330991279420648958285989030561572479050003;
        points[3] = -0.642349339440340220643984606995515650071697398261576857;
        points[4] = -0.448492751036446852877912852127639867801921667441757879;
        points[5] = -0.230458315955134794065528121097988835211542375883531163;
        points[6] = 0;
        points[7] = 0.230458315955134794065528121097988835211542375883531163;
        points[8] = 0.448492751036446852877912852127639867801921667441757879;
        points[9] = 0.642349339440340220643984606995515650071697398261576857;
        points[10] = 0.80157809073330991279420648958285989030561572479050003;
        points[11] = 0.917598399222977965206547836500719512390474790111683296;
        points[12] = 0.984183054718588149472829448807109611064990561925874909;
        weights[0] = 0.0404840047653158795200215922009860600419865457449888681;
        weights[1] = 0.0921214998377284479144217759537971209236839998622368391;
        weights[2] = 0.138873510219787238463601776868871467621862718263298228;
        weights[3] = 0.178145980761945738280046691996097995512812650661016503;
        weights[4] = 0.207816047536888502312523219306052763386582609199503549;
        weights[5] = 0.22628318026289723841209018603977661843475773761555702;
        weights[6] = 0.232551553230873910194589515268835948156627477306797986;
        weights[7] = 0.22628318026289723841209018603977661843475773761555702;
        weights[8] = 0.207816047536888502312523219306052763386582609199503549;
        weights[9] = 0.178145980761945738280046691996097995512812650661016503;
        weights[10] = 0.138873510219787238463601776868871467621862718263298228;
        weights[11] = 0.0921214998377284479144217759537971209236839998622368391;
        weights[12] = 0.0404840047653158795200215922009860600419865457449888681;
        return;
    case 14:
        points[0] = -0.986283808696812338841597266704052801676091407239225882;
        points[1] = -0.928434883663573517336391139377874264477039210409837619;
        points[2] = -0.827201315069764993189794742650394961039701101475081182;
        points[3] = -0.687292904811685470148019803019334137538401212747170676;
        points[4] = -0.515248636358154091965290718551188662308885282569306037;
        points[5] = -0.319112368927889760435671824168475466834261203533843957;
        points[6] = -0.108054948707343662066244650219834747611951605474237557;
        points[7] = 0.108054948707343662066244650219834747611951605474237557;
        points[8] = 0.319112368927889760435671824168475466834261203533843957;
        points[9] = 0.515248636358154091965290718551188662308885282569306037;
        points[10] = 0.687292904811685470148019803019334137538401212747170676;
        points[11] = 0.827201315069764993189794742650394961039701101475081182;
        points[12] = 0.928434883663573517336391139377874264477039210409837619;
        points[13] = 0.986283808696812338841597266704052801676091407239225882;
        weights[0] = 0.0351194603317518630318328761381917806197056092771272766;
        weights[1] = 0.0801580871597602098056332770628543095836977853945947652;
        weights[2] = 0.121518570687903184689414809072476625956669345690074672;
        weights[3] = 0.157203167158193534569601938623842156605668037337323375;
        weights[4] = 0.185538397477937813741716590125157036248922602937331659;
        weights[5] = 0.205198463721295603965924065661218055710339061309419452;
        weights[6] = 0.2152638534631577901958764433162600352749975580541288;
        weights[7] = 0.2152638534631577901958764433162600352749975580541288;
        weights[8] = 0.205198463721295603965924065661218055710339061309419452;
        weights[9] = 0.185538397477937813741716590125157036248922602937331659;
        weights[10] = 0.157203167158193534569601938623842156605668037337323375;
        weights[11] = 0.121518570687903184689414809072476625956669345690074672;
        weights[12] = 0.0801580871597602098056332770628543095836977853945947652;
        weights[13] = 0.0351194603317518630318328761381917806197056092771272766;
        return;
    case 15:
        points[0] = -0.98799251802048542848956571858661258114697281712376149;
        points[1] = -0.937273392400705904307758947710209471243996273515304458;
        points[2] = -0.848206583410427216200648320774216851366256174736992634;
        points[3] = -0.724417731360170047416186054613938009630899294584102564;
        points[4] = -0.570972172608538847537226737253910641238386396282749605;
        points[5] = -0.394151347077563369897207370981045468362752776158698255;
        points[6] = -0.20119409399743452230062830339459620781283645446263768;
        points[7] = 0;
        points[8] = 0.20119409399743452230062830339459620781283645446263768;
        points[9] = 0.394151347077563369897207370981045468362752776158698255;
        points[10] = 0.570972172608538847537226737253910641238386396282749605;
        points[11] = 0.724417731360170047416186054613938009630899294584102564;
        points[12] = 0.848206583410427216200648320774216851366256174736992634;
        points[13] = 0.937273392400705904307758947710209471243996273515304458;
        points[14] = 0.98799251802048542848956571858661258114697281712376149;
        weights[0] = 0.0307532419961172683546283935772044177217481448334340743;
        weights[1] = 0.0703660474881081247092674164506673384667080327543307198;
        weights[2] = 0.107159220467171935011869546685869303415543715758101981;
        weights[3] = 0.139570677926154314447804794511028322520850275315511243;
        weights[4] = 0.166269205816993933553200860481208811130900180098412907;
        weights[5] = 0.186161000015562211026800561866422824506226012277928403;
        weights[6] = 0.198431485327111576456118326443839324818692559957541993;
        weights[7] = 0.202578241925561272880620199967519314838662158009477357;
        weights[8] = 0.198431485327111576456118326443839324818692559957541993;
        weights[9] = 0.186161000015562211026800561866422824506226012277928403;
        weights[10] = 0.166269205816993933553200860481208811130900180098412907;
        weights[11] = 0.139570677926154314447804794511028322520850275315511243;
        weights[12] = 0.107159220467171935011869546685869303415543715758101981;
        weights[13] = 0.0703660474881081247092674164506673384667080327543307198;
        weights[14] = 0.0307532419961172683546283935772044177217481448334340743;
        return;
    case 16:
        points[0] = -0.98940093499164993259615417345033262742627407165764513;
        points[1] = -0.944575023073232576077988415534608345091139272591072601;
        points[2] = -0.865631202387831743880467897712393132387335384847526708;
        points[3] = -0.75540440835500303389510119484744226835381365645750301;
        points[4] = -0.617876244402643748446671764048791018991882217765657794;
        points[5] = -0.458016777657227386342419442983577573540031613035523491;
        points[6] = -0.281603550779258913230460501460496106486069490770599801;
        points[7] = -0.0950125098376374401853193354249580631303530556890654567;
        points[8] = 0.0950125098376374401853193354249580631303530556890654567;
        points[9] = 0.281603550779258913230460501460496106486069490770599801;
        points[10] = 0.458016777657227386342419442983577573540031613035523491;
        points[11] = 0.617876244402643748446671764048791018991882217765657794;
        points[12] = 0.75540440835500303389510119484744226835381365645750301;
        points[13] = 0.865631202387831743880467897712393132387335384847526708;
        points[14] = 0.944575023073232576077988415534608345091139272591072601;
        points[15] = 0.98940093499164993259615417345033262742627407165764513;
        weights[0] = 0.027152459411754094851780572456018103512267375566760798;
        weights[1] = 0.0622535239386478928628438369943776942749865083529068579;
        weights[2] = 0.0951585116824927848099251076022462263552635031837126582;
        weights[3] = 0.12462897125553387205247628219201642014488685922220268;
        weights[4] = 0.149595988816576732081501730547478548970491068207836467;
        weights[5] = 0.169156519395002538189312079030359962211639473416028282;
        weights[6] = 0.182603415044923588866763667969219939383556223654649282;
        weights[7] = 0.189450610455068496285396723208283105146908988395902975;
        weights[8] = 0.189450610455068496285396723208283105146908988395902975;
        weights[9] = 0.182603415044923588866763667969219939383556223654649282;
        weights[10] = 0.169156519395002538189312079030359962211639473416028282;
        weights[11] = 0.149595988816576732081501730547478548970491068207836467;
        weights[12] = 0.12462897125553387205247628219201642014488685922220268;
        weights[13] = 0.0951585116824927848099251076022462263552635031837126582;
        weights[14] = 0.0622535239386478928628438369943776942749865083529068579;
        weights[15] = 0.027152459411754094851780572456018103512267375566760798;
        return;
    case 17:
        points[0] = -0.990575475314417335675434019940665276507789850459564303;
        points[1] = -0.950675521768767761222716957895803021443385046559108708;
        points[2] = -0.8802391537269859021229556944881556926234168179344279;
        points[3] = -0.781514003896801406925230055520476050223972472740568513;
        points[4] = -0.657671159216690765850302216643002335147805891475973244;
        points[5] = -0.512690537086476967886246568629551874582923722411172906;
        points[6] = -0.351231763453876315297185517095346005040539751575675023;
        points[7] = -0.178484181495847855850677493654065557475419332691525644;
        points[8] = 0;
        points[9] = 0.178484181495847855850677493654065557475419332691525644;
        points[10] = 0.351231763453876315297185517095346005040539751575675023;
        points[11] = 0.512690537086476967886246568629551874582923722411172906;
        points[12] = 0.657671159216690765850302216643002335147805891475973244;
        points[13] = 0.781514003896801406925230055520476050223972472740568513;
        points[14] = 0.8802391537269859021229556944881556926234168179344279;
        points[15] = 0.950675521768767761222716957895803021443385046559108708;
        points[16] = 0.990575475314417335675434019940665276507789850459564303;
        weights[0] = 0.0241483028685479319601100262875653246916973159450252783;
        weights[1] = 0.055459529373987201129440165358244660512846251953228847;
        weights[2] = 0.0850361483171791808835353701910620738504913892185054758;
        weights[3] = 0.11188384719340397109478838562635592673584342426307705;
        weights[4] = 0.13513636846852547328631998170235019737212585323448902;
        weights[5] = 0.154045761076810288081431594801958611940483058471017934;
        weights[6] = 0.168004102156450044509970663788323155021198128965074014;
        weights[7] = 0.176562705366992646325270990113197239150924418000748118;
        weights[8] = 0.179446470356206525458265644261885621448780319897668524;
        weights[9] = 0.176562705366992646325270990113197239150924418000748118;
        weights[10] = 0.168004102156450044509970663788323155021198128965074014;
        weights[11] = 0.154045761076810288081431594801958611940483058471017934;
        weights[12] = 0.13513636846852547328631998170235019737212585323448902;
        weights[13] = 0.11188384719340397109478838562635592673584342426307705;
        weights[14] = 0.0850361483171791808835353701910620738504913892185054758;
        weights[15] = 0.055459529373987201129440165358244660512846251953228847;
        weights[16] = 0.0241483028685479319601100262875653246916973159450252783;
        return;
    case 18:
        points[0] = -0.991565168420930946730016004706150770252578936845439693;
        points[1] = -0.955823949571397755181195892929776309972844134811306479;
        points[2] = -0.892602466497555739206060591127145515407895271352298214;
        points[3] = -0.803704958972523115682417455014590797103298921611922482;
        points[4] = -0.691687043060353207874891081288848389452270572817507759;
        points[5] = -0.559770831073947534607871548525329136927626485770709417;
        points[6] = -0.411751161462842646035931793833051637078989682120025511;
        points[7] = -0.251886225691505509588972854877911230162861765659640458;
        points[8] = -0.08477501304173530124226185293578381173331738690608992;
        points[9] = 0.08477501304173530124226185293578381173331738690608992;
        points[10] = 0.251886225691505509588972854877911230162861765659640458;
        points[11] = 0.411751161462842646035931793833051637078989682120025511;
        points[12] = 0.559770831073947534607871548525329136927626485770709417;
        points[13] = 0.691687043060353207874891081288848389452270572817507759;
        points[14] = 0.803704958972523115682417455014590797103298921611922482;
        points[15] = 0.892602466497555739206060591127145515407895271352298214;
        points[16] = 0.955823949571397755181195892929776309972844134811306479;
        points[17] = 0.991565168420930946730016004706150770252578936845439693;
        weights[0] = 0.0216160135264833103133427102664524693876852314755899455;
        weights[1] = 0.0497145488949697964533349462026386416808662461289102022;
        weights[2] = 0.0764257302548890565291296776166365256053179062083582874;
        weights[3] = 0.100942044106287165562813984924834607062801138887678902;
        weights[4] = 0.122555206711478460184519126800201555228163897333439097;
        weights[5] = 0.14064291467065065120473130375194722809550241033097256;
        weights[6] = 0.154684675126265244925418003836374772193218396267354173;
        weights[7] = 0.164276483745832722986053776465927590412338953997352953;
        weights[8] = 0.16914238296314359184065647013498661033410581937034388;
        weights[9] = 0.16914238296314359184065647013498661033410581937034388;
        weights[10] = 0.164276483745832722986053776465927590412338953997352953;
        weights[11] = 0.154684675126265244925418003836374772193218396267354173;
        weights[12] = 0.14064291467065065120473130375194722809550241033097256;
        weights[13] = 0.122555206711478460184519126800201555228163897333439097;
        weights[14] = 0.100942044106287165562813984924834607062801138887678902;
        weights[15] = 0.0764257302548890565291296776166365256053179062083582874;
        weights[16] = 0.0497145488949697964533349462026386416808662461289102022;
        weights[17] = 0.0216160135264833103133427102664524693876852314755899455;
        return;
    case 19:
        points[0] = -0.992406843843584403189017670253260493589316401403210787;
        points[1] = -0.960208152134830030852778840687651526615091503274138106;
        points[2] = -0.903155903614817901642660928532312487809393934057355818;
        points[3] = -0.822714656537142824978922486712713901774538486206830041;
        points[4] = -0.720966177335229378617095860823781629657141832908666775;
        points[5] = -0.600545304661681023469638164946239279868322082732292568;
        points[6] = -0.464570741375960945717267148104102367976285714624136597;
        points[7] = -0.316564099963629831990117328849844917892285219132887245;
        points[8] = -0.160358645640225375868096115740743549504873500470875379;
        points[9] = 0;
        points[10] = 0.160358645640225375868096115740743549504873500470875379;
        points[11] = 0.316564099963629831990117328849844917892285219132887245;
        points[12] = 0.464570741375960945717267148104102367976285714624136597;
        points[13] = 0.600545304661681023469638164946239279868322082732292568;
        points[14] = 0.720966177335229378617095860823781629657141832908666775;
        points[15] = 0.822714656537142824978922486712713901774538486206830041;
        points[16] = 0.903155903614817901642660928532312487809393934057355818;
        points[17] = 0.960208152134830030852778840687651526615091503274138106;
        points[18] = 0.992406843843584403189017670253260493589316401403210787;
        weights[0] = 0.0194617882297264770363120414644384357529066090692866408;
        weights[1] = 0.0448142267656996003328381574019942119517542274678576021;
        weights[2] = 0.0690445427376412265807082580060130449618480316876131311;
        weights[3] = 0.0914900216224499994644620941238396526609116512965987847;
        weights[4] = 0.111566645547333994716023901681765997481331853839893776;
        weights[5] = 0.128753962539336227675515784856877117055839577093463035;
        weights[6] = 0.142606702173606611775746109441902972475668344824473861;
        weights[7] = 0.152766042065859666778855400897662998461008267236428624;
        weights[8] = 0.158968843393954347649956439465047201678780158195126096;
        weights[9] = 0.161054449848783695979163625320916735039902558578516902;
        weights[10] = 0.158968843393954347649956439465047201678780158195126096;
        weights[11] = 0.152766042065859666778855400897662998461008267236428624;
        weights[12] = 0.142606702173606611775746109441902972475668344824473861;
        weights[13] = 0.128753962539336227675515784856877117055839577093463035;
        weights[14] = 0.111566645547333994716023901681765997481331853839893776;
        weights[15] = 0.0914900216224499994644620941238396526609116512965987847;
        weights[16] = 0.0690445427376412265807082580060130449618480316876131311;
        weights[17] = 0.0448142267656996003328381574019942119517542274678576021;
        weights[18] = 0.0194617882297264770363120414644384357529066090692866408;
        return;
    case 20:
        points[0] = -0.993128599185094924786122388471320278222647130901655896;
        points[1] = -0.963971927277913791267666131197277221912060327806188856;
        points[2] = -0.912234428251325905867752441203298113049184797423691775;
        points[3] = -0.839116971822218823394529061701520685329629365065637373;
        points[4] = -0.746331906460150792614305070355641590310730679569176444;
        points[5] = -0.636053680726515025452836696226285936743389116799368464;
        points[6] = -0.510867001950827098004364050955250998425491329202426833;
        points[7] = -0.373706088715419560672548177024927237395746321705682712;
        points[8] = -0.227785851141645078080496195368574624743088937682927472;
        points[9] = -0.0765265211334973337546404093988382110047962668134975008;
        points[10] = 0.0765265211334973337546404093988382110047962668134975008;
        points[11] = 0.227785851141645078080496195368574624743088937682927472;
        points[12] = 0.373706088715419560672548177024927237395746321705682712;
        points[13] = 0.510867001950827098004364050955250998425491329202426833;
        points[14] = 0.636053680726515025452836696226285936743389116799368464;
        points[15] = 0.746331906460150792614305070355641590310730679569176444;
        points[16] = 0.839116971822218823394529061701520685329629365065637373;
        points[17] = 0.912234428251325905867752441203298113049184797423691775;
        points[18] = 0.963971927277913791267666131197277221912060327806188856;
        points[19] = 0.993128599185094924786122388471320278222647130901655896;
        weights[0] = 0.0176140071391521183118619623518528163621431055433367325;
        weights[1] = 0.0406014298003869413310399522749321098790906399899515368;
        weights[2] = 0.0626720483341090635695065351870416063516010765784363641;
        weights[3] = 0.0832767415767047487247581432220462061001778285831632907;
        weights[4] = 0.101930119817240435036750135480349876166691656023392556;
        weights[5] = 0.118194531961518417312377377711382287005041219548968775;
        weights[6] = 0.131688638449176626898494499748163134916110511146983527;
        weights[7] = 0.142096109318382051329298325067164933034515413392020303;
        weights[8] = 0.149172986472603746787828737001969436692679904081368316;
        weights[9] = 0.152753387130725850698084331955097593491948645112378597;
        weights[10] = 0.152753387130725850698084331955097593491948645112378597;
        weights[11] = 0.149172986472603746787828737001969436692679904081368316;
        weights[12] = 0.142096109318382051329298325067164933034515413392020303;
        weights[13] = 0.131688638449176626898494499748163134916110511146983527;
        weights[14] = 0.118194531961518417312377377711382287005041219548968775;
        weights[15] = 0.101930119817240435036750135480349876166691656023392556;
        weights[16] = 0.0832767415767047487247581432220462061001778285831632907;
        weights[17] = 0.0626720483341090635695065351870416063516010765784363641;
        weights[18] = 0.0406014298003869413310399522749321098790906399899515368;
        weights[19] = 0.0176140071391521183118619623518528163621431055433367325;
        return;
    case 21:
        points[0] = -0.993752170620389500260242035937940929193338454782329186;
        points[1] = -0.96722683856630629431662221490769516142469368732984685;
        points[2] = -0.920099334150400828790187133714968894159147609648221697;
        points[3] = -0.853363364583317283647250638587567670276105803179343971;
        points[4] = -0.768439963475677908615877851306228034820976705771369551;
        points[5] = -0.667138804197412319305966669990339162597029343311402842;
        points[6] = -0.551618835887219807059018796724313286622060224230679665;
        points[7] = -0.424342120207438783573668888543788052096445231839634584;
        points[8] = -0.288021316802401096600792516064600319909018263646033229;
        points[9] = -0.145561854160895090937030982338686330116326024437937757;
        points[10] = 0;
        points[11] = 0.145561854160895090937030982338686330116326024437937757;
        points[12] = 0.288021316802401096600792516064600319909018263646033229;
        points[13] = 0.424342120207438783573668888543788052096445231839634584;
        points[14] = 0.551618835887219807059018796724313286622060224230679665;
        points[15] = 0.667138804197412319305966669990339162597029343311402842;
        points[16] = 0.768439963475677908615877851306228034820976705771369551;
        points[17] = 0.853363364583317283647250638587567670276105803179343971;
        points[18] = 0.920099334150400828790187133714968894159147609648221697;
        points[19] = 0.96722683856630629431662221490769516142469368732984685;
        points[20] = 0.993752170620389500260242035937940929193338454782329186;
        weights[0] = 0.0160172282577743333242246168584710152658904221179024825;
        weights[1] = 0.0369537897708524937999506682993296661889443081487298374;
        weights[2] = 0.0571344254268572082836358264724479574912875968262560414;
        weights[3] = 0.0761001136283793020170516533001831792261543524239660285;
        weights[4] = 0.0934444234560338615532897411139320884835266473615928449;
        weights[5] = 0.108797299167148377663474578070105642033699595793856331;
        weights[6] = 0.12183141605372853419536717712573359835633762556153745;
        weights[7] = 0.132268938633337461781052574496775604329011540143156823;
        weights[8] = 0.139887394791073154722133423867583110892793160954919604;
        weights[9] = 0.144524403989970059063827166553752543609949962197099835;
        weights[10] = 0.146081133649690427191985147683371188244809576941965444;
        weights[11] = 0.144524403989970059063827166553752543609949962197099835;
        weights[12] = 0.139887394791073154722133423867583110892793160954919604;
        weights[13] = 0.132268938633337461781052574496775604329011540143156823;
        weights[14] = 0.12183141605372853419536717712573359835633762556153745;
        weights[15] = 0.108797299167148377663474578070105642033699595793856331;
        weights[16] = 0.0934444234560338615532897411139320884835266473615928449;
        weights[17] = 0.0761001136283793020170516533001831792261543524239660285;
        weights[18] = 0.0571344254268572082836358264724479574912875968262560414;
        weights[19] = 0.0369537897708524937999506682993296661889443081487298374;
        weights[20] = 0.0160172282577743333242246168584710152658904221179024825;
        return;
    case 22:
        points[0] = -0.994294585482399292073031421161298980393054198396031535;
        points[1] = -0.97006049783542872712395098676526871080596892313780297;
        points[2] = -0.926956772187174000520692939259053196635329653372051982;
        points[3] = -0.865812577720300136536425637019378729084796755588446156;
        points[4] = -0.787816805979208162004277955408351521388178671331563158;
        points[5] = -0.694487263186682780050689835762256771267342289977435161;
        points[6] = -0.58764040350691159295887692763864734887761560357371784;
        points[7] = -0.469355837986757026406330710966406346095343791130736548;
        points[8] = -0.341935820892084225158147420427379619559173299170687344;
        points[9] = -0.20786042668822128547884653391954573421567510909793365;
        points[10] = -0.0697392733197222212138417961186280818222962994802314747;
        points[11] = 0.0697392733197222212138417961186280818222962994802314747;
        points[12] = 0.20786042668822128547884653391954573421567510909793365;
        points[13] = 0.341935820892084225158147420427379619559173299170687344;
        points[14] = 0.469355837986757026406330710966406346095343791130736548;
        points[15] = 0.58764040350691159295887692763864734887761560357371784;
        points[16] = 0.694487263186682780050689835762256771267342289977435161;
        points[17] = 0.787816805979208162004277955408351521388178671331563158;
        points[18] = 0.865812577720300136536425637019378729084796755588446156;
        points[19] = 0.926956772187174000520692939259053196635329653372051982;
        points[20] = 0.97006049783542872712395098676526871080596892313780297;
        points[21] = 0.994294585482399292073031421161298980393054198396031535;
        weights[0] = 0.0146279952982722006849910980471854451902119491243237309;
        weights[1] = 0.0337749015848141547933022468659129013491693144744746604;
        weights[2] = 0.0522933351526832859403120512732112561121500935692363161;
        weights[3] = 0.0697964684245204880949614189302176573987750529550805274;
        weights[4] = 0.0859416062170677274144436813727028661891444053490797833;
        weights[5] = 0.100414144442880964932078837830536282350811088767699626;
        weights[6] = 0.112932296080539218393400607421784319114263332120994704;
        weights[7] = 0.123252376810512424285560986154814471959444999004967972;
        weights[8] = 0.131173504787062370732964992530307445875741894188030653;
        weights[9] = 0.136541498346015171352573831231517396586367652988686168;
        weights[10] = 0.139251872855631993375410248341809957873920217457425858;
        weights[11] = 0.139251872855631993375410248341809957873920217457425858;
        weights[12] = 0.136541498346015171352573831231517396586367652988686168;
        weights[13] = 0.131173504787062370732964992530307445875741894188030653;
        weights[14] = 0.123252376810512424285560986154814471959444999004967972;
        weights[15] = 0.112932296080539218393400607421784319114263332120994704;
        weights[16] = 0.100414144442880964932078837830536282350811088767699626;
        weights[17] = 0.0859416062170677274144436813727028661891444053490797833;
        weights[18] = 0.0697964684245204880949614189302176573987750529550805274;
        weights[19] = 0.0522933351526832859403120512732112561121500935692363161;
        weights[20] = 0.0337749015848141547933022468659129013491693144744746604;
        weights[21] = 0.0146279952982722006849910980471854451902119491243237309;
        return;
    case 23:
        points[0] = -0.994769334997552123523925715445574360573627372458870421;
        points[1] = -0.972542471218115231956024076820777375181613795353973942;
        points[2] = -0.932971086826016102349196989038422978235701820151390771;
        points[3] = -0.876752358270441667378156885934145671638929029960650635;
        points[4] = -0.804888401618839892151118406996778557941430139730308023;
        points[5] = -0.718661363131950194461624483748618848329929745131292796;
        points[6] = -0.619609875763646156385097311649595653387180658807092296;
        points[7] = -0.509501477846007549689793047866846430544842769184857623;
        points[8] = -0.390301038030290831421488872880605458578050850692503481;
        points[9] = -0.264135680970344930533869538283309602979013250194139605;
        points[10] = -0.133256824298466110931742682241766137010405276253382157;
        points[11] = 0;
        points[12] = 0.133256824298466110931742682241766137010405276253382157;
        points[13] = 0.264135680970344930533869538283309602979013250194139605;
        points[14] = 0.390301038030290831421488872880605458578050850692503481;
        points[15] = 0.509501477846007549689793047866846430544842769184857623;
        points[16] = 0.619609875763646156385097311649595653387180658807092296;
        points[17] = 0.718661363131950194461624483748618848329929745131292796;
        points[18] = 0.804888401618839892151118406996778557941430139730308023;
        points[19] = 0.876752358270441667378156885934145671638929029960650635;
        points[20] = 0.932971086826016102349196989038422978235701820151390771;
        points[21] = 0.972542471218115231956024076820777375181613795353973942;
        points[22] = 0.994769334997552123523925715445574360573627372458870421;
        weights[0] = 0.0134118594871417720813094934586150649766183341057372334;
        weights[1] = 0.0309880058569794443106942196418845053837725289999280664;
        weights[2] = 0.0480376717310846685716410716320339965612163083035116113;
        weights[3] = 0.0642324214085258521271696151589109980391582757548068305;
        weights[4] = 0.0792814117767189549228925247420432269137119919384065026;
        weights[5] = 0.0929157660600351474770186173697646486034600717431298937;
        weights[6] = 0.104892091464541410074086185014743854858471583193975006;
        weights[7] = 0.114996640222411364941643512933961301491410522929585607;
        weights[8] = 0.123049084306729530467578400672009654815852812546470574;
        weights[9] = 0.128905722188082149978595339399793653259715497191783492;
        weights[10] = 0.132462039404696617371642464703316925805035669474223524;
        weights[11] = 0.133654572186106175351457110545844338583152807636883317;
        weights[12] = 0.132462039404696617371642464703316925805035669474223524;
        weights[13] = 0.128905722188082149978595339399793653259715497191783492;
        weights[14] = 0.123049084306729530467578400672009654815852812546470574;
        weights[15] = 0.114996640222411364941643512933961301491410522929585607;
        weights[16] = 0.104892091464541410074086185014743854858471583193975006;
        weights[17] = 0.0929157660600351474770186173697646486034600717431298937;
        weights[18] = 0.0792814117767189549228925247420432269137119919384065026;
        weights[19] = 0.0642324214085258521271696151589109980391582757548068305;
        weights[20] = 0.0480376717310846685716410716320339965612163083035116113;
        weights[21] = 0.0309880058569794443106942196418845053837725289999280664;
        weights[22] = 0.0134118594871417720813094934586150649766183341057372334;
        return;
    case 24:
        points[0] = -0.995187219997021360179997409700736811874597692596002877;
        points[1] = -0.97472855597130949819839199300816906174118305304017872;
        points[2] = -0.938274552002732758523649001708721449654819658077451347;
        points[3] = -0.88641552700440103421315434198219675508733304330892004;
        points[4] = -0.820001985973902921953949872669745208076126477667855587;
        points[5] = -0.740124191578554364243828103099978425523292487014185457;
        points[6] = -0.64809365193697556925249578691074762666965829861895678;
        points[7] = -0.545421471388839535658375617218372370010783992587618175;
        points[8] = -0.433793507626045138487084231913349712452421510927968808;
        points[9] = -0.315042679696163374386793291319810240786478260824817269;
        points[10] = -0.191118867473616309158639820757069631840405103314753356;
        points[11] = -0.0640568928626056260850430826247450385909991954207473934;
        points[12] = 0.0640568928626056260850430826247450385909991954207473934;
        points[13] = 0.191118867473616309158639820757069631840405103314753356;
        points[14] = 0.315042679696163374386793291319810240786478260824817269;
        points[15] = 0.433793507626045138487084231913349712452421510927968808;
        points[16] = 0.545421471388839535658375617218372370010783992587618175;
        points[17] = 0.64809365193697556925249578691074762666965829861895678;
        points[18] = 0.740124191578554364243828103099978425523292487014185457;
        points[19] = 0.820001985973902921953949872669745208076126477667855587;
        points[20] = 0.88641552700440103421315434198219675508733304330892004;
        points[21] = 0.938274552002732758523649001708721449654819658077451347;
        points[22] = 0.97472855597130949819839199300816906174118305304017872;
        points[23] = 0.995187219997021360179997409700736811874597692596002877;
        weights[0] = 0.0123412297999871995468056670700372915759100408913665168;
        weights[1] = 0.0285313886289336631813078159518782864491977979319081166;
        weights[2] = 0.0442774388174198061686027482113382288593128418338578967;
        weights[3] = 0.059298584915436780746367758500108584541200126565213491;
        weights[4] = 0.0733464814110803057340336152531165181193365098484994714;
        weights[5] = 0.0861901615319532759171852029837426671850805882379330056;
        weights[6] = 0.0976186521041138882698806644642471544279189688536859441;
        weights[7] = 0.107444270115965634782577342446606222794628690134220022;
        weights[8] = 0.115505668053725601353344483906783559862270311376496471;
        weights[9] = 0.121670472927803391204463153476262425607029559203805779;
        weights[10] = 0.125837456346828296121375382511183688726403325581345404;
        weights[11] = 0.127938195346752156974056165224695371851711239541667882;
        weights[12] = 0.127938195346752156974056165224695371851711239541667882;
        weights[13] = 0.125837456346828296121375382511183688726403325581345404;
        weights[14] = 0.121670472927803391204463153476262425607029559203805779;
        weights[15] = 0.115505668053725601353344483906783559862270311376496471;
        weights[16] = 0.107444270115965634782577342446606222794628690134220022;
        weights[17] = 0.0976186521041138882698806644642471544279189688536859441;
        weights[18] = 0.0861901615319532759171852029837426671850805882379330056;
        weights[19] = 0.0733464814110803057340336152531165181193365098484994714;
        weights[20] = 0.059298584915436780746367758500108584541200126565213491;
        weights[21] = 0.0442774388174198061686027482113382288593128418338578967;
        weights[22] = 0.0285313886289336631813078159518782864491977979319081166;
        weights[23] = 0.0123412297999871995468056670700372915759100408913665168;
        return;
    case 25:
        points[0] = -0.995556969790498097908784946893901617257562649404808171;
        points[1] = -0.976663921459517511498315386479594067745370555314406745;
        points[2] = -0.942974571228974339414011169658470531905201570608990142;
        points[3] = -0.894991997878275368851042006782804954174554849753583903;
        points[4] = -0.833442628760834001421021108693569569460964113823520786;
        points[5] = -0.759259263037357630577282865204360976387522018898334121;
        points[6] = -0.673566368473468364485120633247622175883416728072749317;
        points[7] = -0.577662930241222967723689841612654067395735039291518257;
        points[8] = -0.473002731445714960522182115009192041331817738461627291;
        points[9] = -0.36117230580938783773582173012764066742207834704337507;
        points[10] = -0.243866883720988432045190362797451586405633156325984476;
        points[11] = -0.122864692610710396387359818808036805532205346049783738;
        points[12] = 0;
        points[13] = 0.122864692610710396387359818808036805532205346049783738;
        points[14] = 0.243866883720988432045190362797451586405633156325984476;
        points[15] = 0.36117230580938783773582173012764066742207834704337507;
        points[16] = 0.473002731445714960522182115009192041331817738461627291;
        points[17] = 0.577662930241222967723689841612654067395735039291518257;
        points[18] = 0.673566368473468364485120633247622175883416728072749317;
        points[19] = 0.759259263037357630577282865204360976387522018898334121;
        points[20] = 0.833442628760834001421021108693569569460964113823520786;
        points[21] = 0.894991997878275368851042006782804954174554849753583903;
        points[22] = 0.942974571228974339414011169658470531905201570608990142;
        points[23] = 0.976663921459517511498315386479594067745370555314406745;
        points[24] = 0.995556969790498097908784946893901617257562649404808171;
        weights[0] = 0.0113937985010262879479029641132347736033205262929096964;
        weights[1] = 0.0263549866150321372619018152952991449359632817033224688;
        weights[2] = 0.0409391567013063126556234877116459536608457833641043465;
        weights[3] = 0.054904695975835191925936891540473324160109985553111349;
        weights[4] = 0.0680383338123569172071871856567079685547094943546365626;
        weights[5] = 0.0801407003350010180132349596691113022902257328536758937;
        weights[6] = 0.091028261982963649811497220702891653380992558959334311;
        weights[7] = 0.100535949067050644202206890392685826988466094528141907;
        weights[8] = 0.108519624474263653116093957050116619340077587986722016;
        weights[9] = 0.11485825914571164833932554586955580864093619166818015;
        weights[10] = 0.119455763535784772228178126512901047390176701413726426;
        weights[11] = 0.122242442990310041688959518945851505835059247563059041;
        weights[12] = 0.123176053726715451203902873079050142438233627518151665;
        weights[13] = 0.122242442990310041688959518945851505835059247563059041;
        weights[14] = 0.119455763535784772228178126512901047390176701413726426;
        weights[15] = 0.11485825914571164833932554586955580864093619166818015;
        weights[16] = 0.108519624474263653116093957050116619340077587986722016;
        weights[17] = 0.100535949067050644202206890392685826988466094528141907;
        weights[18] = 0.091028261982963649811497220702891653380992558959334311;
        weights[19] = 0.0801407003350010180132349596691113022902257328536758937;
        weights[20] = 0.0680383338123569172071871856567079685547094943546365626;
        weights[21] = 0.054904695975835191925936891540473324160109985553111349;
        weights[22] = 0.0409391567013063126556234877116459536608457833641043465;
        weights[23] = 0.0263549866150321372619018152952991449359632817033224688;
        weights[24] = 0.0113937985010262879479029641132347736033205262929096964;
        return;
    case 26:
        points[0] = -0.995885701145616929003216959322906025956857855119559667;
        points[1] = -0.978385445956470991100580354311926305446916563747318502;
        points[2] = -0.94715906666171425013591528351803675452071033768431527;
        points[3] = -0.902637861984307074217665599231210251341124005372905373;
        points[4] = -0.845445942788498018797507061467838161572075102091329569;
        points[5] = -0.776385948820678856192967247242283866976218256255194872;
        points[6] = -0.696427260419957264863813913729424697860753317790819152;
        points[7] = -0.60669229301761806323197874691688705443526457226590989;
        points[8] = -0.508440714824505717695703064725569175376306754185750814;
        points[9] = -0.403051755123486306481077377098883103659937409699316183;
        points[10] = -0.292004839485956895142835382077830296884719386962990378;
        points[11] = -0.176858820356890183969057748418344749977383763801264261;
        points[12] = -0.0592300934293132070937185751984033607902347353890355822;
        points[13] = 0.0592300934293132070937185751984033607902347353890355822;
        points[14] = 0.176858820356890183969057748418344749977383763801264261;
        points[15] = 0.292004839485956895142835382077830296884719386962990378;
        points[16] = 0.403051755123486306481077377098883103659937409699316183;
        points[17] = 0.508440714824505717695703064725569175376306754185750814;
        points[18] = 0.60669229301761806323197874691688705443526457226590989;
        points[19] = 0.696427260419957264863813913729424697860753317790819152;
        points[20] = 0.776385948820678856192967247242283866976218256255194872;
        points[21] = 0.845445942788498018797507061467838161572075102091329569;
        points[22] = 0.902637861984307074217665599231210251341124005372905373;
        points[23] = 0.94715906666171425013591528351803675452071033768431527;
        points[24] = 0.978385445956470991100580354311926305446916563747318502;
        points[25] = 0.995885701145616929003216959322906025956857855119559667;
        weights[0] = 0.0105513726173430071556511876852519779043457371796946146;
        weights[1] = 0.0244178510926319087896158275197884002404959261972703421;
        weights[2] = 0.0379623832943627639503031412488504946907704217440489577;
        weights[3] = 0.0509758252971478119983199007240733795258793185429719348;
        weights[4] = 0.0632740463295748355394536899070450957222228420126945107;
        weights[5] = 0.0746841497656597458870757961028483386387471618810406808;
        weights[6] = 0.0850458943134852392104477650799816965839203167766782762;
        weights[7] = 0.0942138003559141484636648830673031985491657459142072799;
        weights[8] = 0.10205916109442542323841407025343079232720881135424201;
        weights[9] = 0.108471840528576590656579426727997582289438203421306645;
        weights[10] = 0.113361816546319666549440718442598145245950362925015214;
        weights[11] = 0.116660443485296582044662507540362213631964881221924216;
        weights[12] = 0.118321415279262276516371085700468684649890270828905318;
        weights[13] = 0.118321415279262276516371085700468684649890270828905318;
        weights[14] = 0.116660443485296582044662507540362213631964881221924216;
        weights[15] = 0.113361816546319666549440718442598145245950362925015214;
        weights[16] = 0.108471840528576590656579426727997582289438203421306645;
        weights[17] = 0.10205916109442542323841407025343079232720881135424201;
        weights[18] = 0.0942138003559141484636648830673031985491657459142072799;
        weights[19] = 0.0850458943134852392104477650799816965839203167766782762;
        weights[20] = 0.0746841497656597458870757961028483386387471618810406808;
        weights[21] = 0.0632740463295748355394536899070450957222228420126945107;
        weights[22] = 0.0509758252971478119983199007240733795258793185429719348;
        weights[23] = 0.0379623832943627639503031412488504946907704217440489577;
        weights[24] = 0.0244178510926319087896158275197884002404959261972703421;
        weights[25] = 0.0105513726173430071556511876852519779043457371796946146;
        return;
    case 27:
        points[0] = -0.996179262888988566938887208381229990260688055565871188;
        points[1] = -0.979923475961501222855873355661047184567642221389950763;
        points[2] = -0.950900557814705006851908030643882893092589933484417651;
        points[3] = -0.909482320677491104300645018209689254948044335594960959;
        points[4] = -0.856207908018294490302737222706842797764286998603505827;
        points[5] = -0.791771639070508227144397344107270732919401065747863512;
        points[6] = -0.717013473739423699294816211642339549750672052098563143;
        points[7] = -0.632907971946495140927734637634488612103076017569336697;
        points[8] = -0.54055156457945689490030094155998282095918044898718169;
        points[9] = -0.441148251750026880585974155689281452447684595163099388;
        points[10] = -0.335993903638508899730319034207284541790020018907594191;
        points[11] = -0.226459365439536858857239107360230171179446732928203677;
        points[12] = -0.113972585609529966932894983869976627173280533978140995;
        points[13] = 0;
        points[14] = 0.113972585609529966932894983869976627173280533978140995;
        points[15] = 0.226459365439536858857239107360230171179446732928203677;
        points[16] = 0.335993903638508899730319034207284541790020018907594191;
        points[17] = 0.441148251750026880585974155689281452447684595163099388;
        points[18] = 0.54055156457945689490030094155998282095918044898718169;
        points[19] = 0.632907971946495140927734637634488612103076017569336697;
        points[20] = 0.717013473739423699294816211642339549750672052098563143;
        points[21] = 0.791771639070508227144397344107270732919401065747863512;
        points[22] = 0.856207908018294490302737222706842797764286998603505827;
        points[23] = 0.909482320677491104300645018209689254948044335594960959;
        points[24] = 0.950900557814705006851908030643882893092589933484417651;
        points[25] = 0.979923475961501222855873355661047184567642221389950763;
        points[26] = 0.996179262888988566938887208381229990260688055565871188;
        weights[0] = 0.00979899605129436026115005509125909809822581893509159217;
        weights[1] = 0.0226862315961806231960342064467614888127677202881663556;
        weights[2] = 0.0352970537574197110225782893047116411361388895229418116;
        weights[3] = 0.0474494125206150627040967101141847182247256201661847285;
        weights[4] = 0.0589835368598335991103008337195316331652405907064121625;
        weights[5] = 0.0697488237662455929843228883566672761328246932569520004;
        weights[6] = 0.0796048677730577712630749590098424029761466729870029514;
        weights[7] = 0.0884231585437569501943228028537491110565367500510991098;
        weights[8] = 0.0960887273700285075656526465581058591602116295370293344;
        weights[9] = 0.10250163781774579867124771153266380932440989491471733;
        weights[10] = 0.107578285788533187212162984426657404818966099063764666;
        weights[11] = 0.111252488356845192672163096042848674832920380085083267;
        weights[12] = 0.113476346108965148620369948092099257920524518810472026;
        weights[13] = 0.11422086737895698904504573690183524868072144335016533;
        weights[14] = 0.113476346108965148620369948092099257920524518810472026;
        weights[15] = 0.111252488356845192672163096042848674832920380085083267;
        weights[16] = 0.107578285788533187212162984426657404818966099063764666;
        weights[17] = 0.10250163781774579867124771153266380932440989491471733;
        weights[18] = 0.0960887273700285075656526465581058591602116295370293344;
        weights[19] = 0.0884231585437569501943228028537491110565367500510991098;
        weights[20] = 0.0796048677730577712630749590098424029761466729870029514;
        weights[21] = 0.0697488237662455929843228883566672761328246932569520004;
        weights[22] = 0.0589835368598335991103008337195316331652405907064121625;
        weights[23] = 0.0474494125206150627040967101141847182247256201661847285;
        weights[24] = 0.0352970537574197110225782893047116411361388895229418116;
        weights[25] = 0.0226862315961806231960342064467614888127677202881663556;
        weights[26] = 0.00979899605129436026115005509125909809822581893509159217;
        return;
    case 28:
        points[0] = -0.996442497573954449950436390483310991750130432096425905;
        points[1] = -0.98130316537087275369455994580783027644415495325313831;
        points[2] = -0.954259280628938197254101839705215589003403874087951675;
        points[3] = -0.915633026392132073869689423329927146352496795209121509;
        points[4] = -0.865892522574395048942254567379686804341862830784226337;
        points[5] = -0.805641370917179171447885955425277658671701414808311668;
        points[6] = -0.735610878013631772028144510292534368016061019993041893;
        points[7] = -0.656651094038864961219898176506742821569601690249929962;
        points[8] = -0.569720471811401719308003283356430933124712685656647228;
        points[9] = -0.475874224955118261034411847667434042627216145378655951;
        points[10] = -0.37625151608907871022135720955608698287169397704322291;
        points[11] = -0.272061627635178077676826356125769734824761296693522952;
        points[12] = -0.164569282133380771281471777891165457145725415601168176;
        points[13] = -0.0550792898840342704265165273418799778507959910608336837;
        points[14] = 0.0550792898840342704265165273418799778507959910608336837;
        points[15] = 0.164569282133380771281471777891165457145725415601168176;
        points[16] = 0.272061627635178077676826356125769734824761296693522952;
        points[17] = 0.37625151608907871022135720955608698287169397704322291;
        points[18] = 0.475874224955118261034411847667434042627216145378655951;
        points[19] = 0.569720471811401719308003283356430933124712685656647228;
        points[20] = 0.656651094038864961219898176506742821569601690249929962;
        points[21] = 0.735610878013631772028144510292534368016061019993041893;
        points[22] = 0.805641370917179171447885955425277658671701414808311668;
        points[23] = 0.865892522574395048942254567379686804341862830784226337;
        points[24] = 0.915633026392132073869689423329927146352496795209121509;
        points[25] = 0.954259280628938197254101839705215589003403874087951675;
        points[26] = 0.98130316537087275369455994580783027644415495325313831;
        points[27] = 0.996442497573954449950436390483310991750130432096425905;
        weights[0] = 0.00912428259309451773881615392295170624034449109829099942;
        weights[1] = 0.0211321125927712597515003809932654344513693507232856378;
        weights[2] = 0.0329014277823043799776308191705320459815308174200971879;
        weights[3] = 0.0442729347590042278395878776532073906149941127085668437;
        weights[4] = 0.0551073456757167454314829182269455912190579642256653884;
        weights[5] = 0.0652729239669995957933975667755046363536354311626070263;
        weights[6] = 0.0746462142345687790239318871730220380216358612063334474;
        weights[7] = 0.083113417228901218390396498244332479861134413443851333;
        weights[8] = 0.0905717443930328409421860313367841298228574854544848724;
        weights[9] = 0.096930657997929915850489006095440601765033123356461605;
        weights[10] = 0.102112967578060769814216638505712135046580002357920541;
        weights[11] = 0.106055765922846417910416436996810828789922962685159517;
        weights[12] = 0.108711192258294135253571519303673367875278454666043968;
        weights[13] = 0.110047013016475196282376265601817613956625529491231633;
        weights[14] = 0.110047013016475196282376265601817613956625529491231633;
        weights[15] = 0.108711192258294135253571519303673367875278454666043968;
        weights[16] = 0.106055765922846417910416436996810828789922962685159517;
        weights[17] = 0.102112967578060769814216638505712135046580002357920541;
        weights[18] = 0.096930657997929915850489006095440601765033123356461605;
        weights[19] = 0.0905717443930328409421860313367841298228574854544848724;
        weights[20] = 0.083113417228901218390396498244332479861134413443851333;
        weights[21] = 0.0746462142345687790239318871730220380216358612063334474;
        weights[22] = 0.0652729239669995957933975667755046363536354311626070263;
        weights[23] = 0.0551073456757167454314829182269455912190579642256653884;
        weights[24] = 0.0442729347590042278395878776532073906149941127085668437;
        weights[25] = 0.0329014277823043799776308191705320459815308174200971879;
        weights[26] = 0.0211321125927712597515003809932654344513693507232856378;
        weights[27] = 0.00912428259309451773881615392295170624034449109829099942;
        return;
    case 29:
        points[0] = -0.996679442260596586163191532549353885651773453250880002;
        points[1] = -0.982545505261413174870926015786376956106781948906431559;
        points[2] = -0.957285595778087725798208036980823563737559553954097071;
        points[3] = -0.921180232953058785093753436083106425408839343312293598;
        points[4] = -0.874637804920102790417793421256578546910616863119041371;
        points[5] = -0.818185487615252444989572214578784975630021561882293771;
        points[6] = -0.752462851734477133912610077212138190212591968228986608;
        points[7] = -0.678214537602686515156185005391985926388262930014645163;
        points[8] = -0.596281797138227820379586211188989780078186810385577638;
        points[9] = -0.507592955124227642102627919627520153351223840384584164;
        points[10] = -0.41315288817400866389070658603161682332343851873631392;
        points[11] = -0.314031637867639934948195923191047448258448819090827481;
        points[12] = -0.211352286166001074506375728902937499056650817712095148;
        points[13] = -0.106278230132679230170982392430376980917195439295607136;
        points[14] = 0;
        points[15] = 0.106278230132679230170982392430376980917195439295607136;
        points[16] = 0.211352286166001074506375728902937499056650817712095148;
        points[17] = 0.314031637867639934948195923191047448258448819090827481;
        points[18] = 0.41315288817400866389070658603161682332343851873631392;
        points[19] = 0.507592955124227642102627919627520153351223840384584164;
        points[20] = 0.596281797138227820379586211188989780078186810385577638;
        points[21] = 0.678214537602686515156185005391985926388262930014645163;
        points[22] = 0.752462851734477133912610077212138190212591968228986608;
        points[23] = 0.818185487615252444989572214578784975630021561882293771;
        points[24] = 0.874637804920102790417793421256578546910616863119041371;
        points[25] = 0.921180232953058785093753436083106425408839343312293598;
        points[26] = 0.957285595778087725798208036980823563737559553954097071;
        points[27] = 0.982545505261413174870926015786376956106781948906431559;
        points[28] = 0.996679442260596586163191532549353885651773453250880002;
        weights[0] = 0.00851690387874640965426381330224980300239888979851848605;
        weights[1] = 0.0197320850561227059838598016403956311496065681903615877;
        weights[2] = 0.0307404922020936226444085253746167497471162609687095103;
        weights[3] = 0.0414020625186828361048300101140769215334907803885743973;
        weights[4] = 0.0515948269024979239125943811795425979196221106461420677;
        weights[5] = 0.0612030906570791385421098480239070449240645397791302083;
        weights[6] = 0.0701179332550512785695814869488791731023948886747735819;
        weights[7] = 0.0782383271357637838281448886596803313668790769596697095;
        weights[8] = 0.0854722573661725275453448492972080713816982566135933953;
        weights[9] = 0.0917377571392587633479664110771108068982290209819545713;
        weights[10] = 0.0969638340944086063019000748826887591763562779218035643;
        weights[11] = 0.101091273759914966121820546907497363647567278852525199;
        weights[12] = 0.104073310077729373913328471285120068910652220675467692;
        weights[13] = 0.10587615509732094140659132785218789307483131374227804;
        weights[14] = 0.10647938171831424424651112690967756833018503161299598;
        weights[15] = 0.10587615509732094140659132785218789307483131374227804;
        weights[16] = 0.104073310077729373913328471285120068910652220675467692;
        weights[17] = 0.101091273759914966121820546907497363647567278852525199;
        weights[18] = 0.0969638340944086063019000748826887591763562779218035643;
        weights[19] = 0.0917377571392587633479664110771108068982290209819545713;
        weights[20] = 0.0854722573661725275453448492972080713816982566135933953;
        weights[21] = 0.0782383271357637838281448886596803313668790769596697095;
        weights[22] = 0.0701179332550512785695814869488791731023948886747735819;
        weights[23] = 0.0612030906570791385421098480239070449240645397791302083;
        weights[24] = 0.0515948269024979239125943811795425979196221106461420677;
        weights[25] = 0.0414020625186828361048300101140769215334907803885743973;
        weights[26] = 0.0307404922020936226444085253746167497471162609687095103;
        weights[27] = 0.0197320850561227059838598016403956311496065681903615877;
        weights[28] = 0.00851690387874640965426381330224980300239888979851848605;
        return;
    case 30:
        points[0] = -0.99689348407464954027163005091869528334088203811775079;
        points[1] = -0.983668123279747209970032581605662801940317854709711364;
        points[2] = -0.960021864968307512216871025581797662930359217403923399;
        points[3] = -0.926200047429274325879324277080474004086474536825329061;
        points[4] = -0.882560535792052681543116462530225590056689147146484232;
        points[5] = -0.829565762382768397442898119732501916439068696170341679;
        points[6] = -0.767777432104826194917977340974503131694883617232908453;
        points[7] = -0.697850494793315796932292388026640068382353800653954656;
        points[8] = -0.620526182989242861140477556431189299207364692829528133;
        points[9] = -0.536624148142019899264169793311072794164178006930297105;
        points[10] = -0.44703376953808917678060990032285400016240759386142441;
        points[11] = -0.352704725530878113471037207089373860653631008021425627;
        points[12] = -0.254636926167889846439805129817805107882789303302518426;
        points[13] = -0.153869913608583546963794672743255920418551971244338462;
        points[14] = -0.0514718425553176958330252131667225737491414536665695643;
        points[15] = 0.0514718425553176958330252131667225737491414536665695643;
        points[16] = 0.153869913608583546963794672743255920418551971244338462;
        points[17] = 0.254636926167889846439805129817805107882789303302518426;
        points[18] = 0.352704725530878113471037207089373860653631008021425627;
        points[19] = 0.44703376953808917678060990032285400016240759386142441;
        points[20] = 0.536624148142019899264169793311072794164178006930297105;
        points[21] = 0.620526182989242861140477556431189299207364692829528133;
        points[22] = 0.697850494793315796932292388026640068382353800653954656;
        points[23] = 0.767777432104826194917977340974503131694883617232908453;
        points[24] = 0.829565762382768397442898119732501916439068696170341679;
        points[25] = 0.882560535792052681543116462530225590056689147146484232;
        points[26] = 0.926200047429274325879324277080474004086474536825329061;
        points[27] = 0.960021864968307512216871025581797662930359217403923399;
        points[28] = 0.983668123279747209970032581605662801940317854709711364;
        points[29] = 0.99689348407464954027163005091869528334088203811775079;
        weights[0] = 0.00796819249616660561546588347467362245048069658715172123;
        weights[1] = 0.0184664683110909591423021319120472690962065339681814034;
        weights[2] = 0.0287847078833233693497191796112920436395888945462874965;
        weights[3] = 0.0387991925696270495968019364463476920332009767663953521;
        weights[4] = 0.0484026728305940529029381404228075178152718091973727363;
        weights[5] = 0.0574931562176190664817216894020561287971206707217631345;
        weights[6] = 0.065974229882180495128128515115962361237442953656660379;
        weights[7] = 0.0737559747377052062682438500221907341537705260370494389;
        weights[8] = 0.0807558952294202153546949384605297308758928037084392999;
        weights[9] = 0.086899787201082979802387530715125702576753328743545344;
        weights[10] = 0.0921225222377861287176327070876187671969132344182341075;
        weights[11] = 0.0963687371746442596394686263518098650964064614301602459;
        weights[12] = 0.0995934205867952670627802821035694765298692636667042772;
        weights[13] = 0.101762389748405504596428952168554044632706289487126841;
        weights[14] = 0.102852652893558840341285636705415043868375557064928223;
        weights[15] = 0.102852652893558840341285636705415043868375557064928223;
        weights[16] = 0.101762389748405504596428952168554044632706289487126841;
        weights[17] = 0.0995934205867952670627802821035694765298692636667042772;
        weights[18] = 0.0963687371746442596394686263518098650964064614301602459;
        weights[19] = 0.0921225222377861287176327070876187671969132344182341075;
        weights[20] = 0.086899787201082979802387530715125702576753328743545344;
        weights[21] = 0.0807558952294202153546949384605297308758928037084392999;
        weights[22] = 0.0737559747377052062682438500221907341537705260370494389;
        weights[23] = 0.065974229882180495128128515115962361237442953656660379;
        weights[24] = 0.0574931562176190664817216894020561287971206707217631345;
        weights[25] = 0.0484026728305940529029381404228075178152718091973727363;
        weights[26] = 0.0387991925696270495968019364463476920332009767663953521;
        weights[27] = 0.0287847078833233693497191796112920436395888945462874965;
        weights[28] = 0.0184664683110909591423021319120472690962065339681814034;
        weights[29] = 0.00796819249616660561546588347467362245048069658715172123;
        return;
    }
}
