import { RemovalPolicy } from "aws-cdk-lib";
import { IKey } from "aws-cdk-lib/aws-kms";
import { ILogGroup, RetentionDays } from "aws-cdk-lib/aws-logs";
import { Construct } from "constructs";
/**
 * A log group encrypted by a KMS customer managed key.
 */
export interface IEncryptedLogGroup {
    /**
     * The KMS encryption key.
     */
    readonly key: IKey;
    /**
     * The log group.
     */
    readonly logGroup: ILogGroup;
}
/**
 * Constructor properties for EncryptedLogGroup.
 */
export interface EncryptedLogGroupProps {
    /**
     * Name of the log group.
     *
     * We need a log group name ahead of time because otherwise the key policy
     * would create a cyclical dependency.
     */
    readonly logGroupName: string;
    /**
     * How long, in days, the log contents will be retained.
     *
     * @default RetentionDays.TWO_YEARS
     */
    readonly retention?: RetentionDays;
    /**
     * The KMS Key to encrypt the log group with.
     *
     * @default A new KMS key will be created
     */
    readonly encryptionKey?: IKey;
    /**
     * Whether the key and group should be retained when they are removed from the Stack.
     *
     * @default RemovalPolicy.RETAIN
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * A log group encrypted by a KMS customer managed key.
 */
export declare class EncryptedLogGroup extends Construct implements IEncryptedLogGroup {
    readonly key: IKey;
    readonly logGroup: ILogGroup;
    /**
     * Creates a new EncryptedLogGroup.
     */
    constructor(scope: Construct, id: string, props: EncryptedLogGroupProps);
}
//# sourceMappingURL=encrypted-log-group.d.ts.map