import type { IVpc, SubnetSelection, SelectedSubnets } from "aws-cdk-lib/aws-ec2";
import { Construct } from "constructs";
/**
 * Properties for creating a new {@link AssignOnLaunch}.
 */
export interface AssignOnLaunchProps {
    /**
     * The VPC whose subnets will be configured.
     */
    readonly vpc: IVpc;
    /**
     * Which subnets to assign IPv6 addresses upon ENI creation.
     */
    readonly vpcSubnets?: SubnetSelection;
}
/**
 * Interface for the AssignOnLaunch class.
 */
export interface IAssignOnLaunch {
    /**
     * The IPv6-enabled VPC.
     */
    readonly vpc: IVpc;
    /**
     * The chosen subnets for address assignment on ENI launch.
     */
    readonly vpcPlacement: SelectedSubnets;
}
/**
 * Enables the "assignIpv6AddressOnCreation" attribute on selected subnets.
 *
 * @see {@link https://github.com/aws/aws-cdk/issues/894}
 * @see {@link https://github.com/aws/aws-cdk/issues/5927}
 */
export declare class AssignOnLaunch extends Construct implements IAssignOnLaunch {
    readonly vpc: IVpc;
    readonly vpcPlacement: SelectedSubnets;
    /**
     * Creates a new BetterVpc.
     *
     * @param scope - The construct scope.
     * @param id - The construct ID.
     * @param options - The constructor options.
     */
    constructor(scope: Construct, id: string, options: AssignOnLaunchProps);
}
//# sourceMappingURL=assign-on-launch.d.ts.map