/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import py4j.Argument;
import py4j.ConnectionProperty;
import py4j.Py4JException;
import py4j.ReturnObject;
import py4j.model.Py4JMember;
import py4j.reflection.LRUCache;
import py4j.reflection.MethodInvoker;
import py4j.reflection.ReflectionEngine;

public class Gateway {
    private final Map<String, Object> bindings = new ConcurrentHashMap<String, Object>();
    private final AtomicInteger objCounter = new AtomicInteger();
    private final AtomicInteger argCounter = new AtomicInteger();
    private static final String OBJECT_NAME_PREFIX = "o";
    private final Object entryPoint;
    private final ReflectionEngine rEngine = new ReflectionEngine();
    private final Logger logger = Logger.getLogger(Gateway.class.getName());
    private boolean isStarted = false;
    private boolean cleanUpConnection = false;
    private static ThreadLocal<LRUCache<String, Py4JMember>> helpPages = new ThreadLocal<LRUCache<String, Py4JMember>>(){

        @Override
        protected LRUCache<String, Py4JMember> initialValue() {
            return new LRUCache<String, Py4JMember>();
        }
    };
    private static ThreadLocal<ConnectionProperty> connectionProperty = new ThreadLocal<ConnectionProperty>(){

        @Override
        protected ConnectionProperty initialValue() {
            return new ConnectionProperty();
        }
    };
    private static ThreadLocal<Set<String>> connectionObjects = new ThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return new HashSet<String>();
        }
    };

    public Gateway(Object entryPoint) {
        this(entryPoint, false);
    }

    public Gateway(Object entryPoint, boolean cleanUpConnection) {
        this.entryPoint = entryPoint;
        this.cleanUpConnection = cleanUpConnection;
    }

    public ReturnObject attachObject(String objectId) {
        Object object = this.getObjectFromId(objectId);
        if (object == null) {
            throw new Py4JException("Cannot attach " + objectId + ": it does not exist.");
        }
        return this.getReturnObject(object);
    }

    private void buildArgs(List<Argument> args, List<Object> parametersList) {
        for (Argument arg : args) {
            if (!arg.isReference()) {
                parametersList.add(arg.getValue());
                continue;
            }
            parametersList.add(this.bindings.get(arg.getValue().toString()));
        }
    }

    public void closeConnection() {
        if (connectionProperty.get().isCleanConnection()) {
            this.logger.info("Cleaning Connection");
            for (String objectId : connectionObjects.get()) {
                this.bindings.remove(objectId);
            }
        }
    }

    public void deleteObject(String objectId) {
        this.bindings.remove(objectId);
        connectionObjects.get().remove(objectId);
    }

    protected AtomicInteger getArgCounter() {
        return this.argCounter;
    }

    protected Map<String, Object> getBindings() {
        return this.bindings;
    }

    public Object getEntryPoint() {
        return this.entryPoint;
    }

    public LRUCache<String, Py4JMember> getHelpPages() {
        return helpPages.get();
    }

    public List<String> getMethodNames(Object obj) {
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        HashSet<String> methodNames = new HashSet<String>();
        for (Method method : methods) {
            methodNames.add(method.getName());
        }
        return new ArrayList<String>(methodNames);
    }

    public String getMethodNamesAsString(Object obj) {
        List<String> methodNames = this.getMethodNames(obj);
        StringBuilder buffer = new StringBuilder();
        for (String methodName : methodNames) {
            buffer.append(methodName);
            buffer.append(",");
        }
        return buffer.toString();
    }

    protected String getNextObjectId() {
        return OBJECT_NAME_PREFIX + this.objCounter.getAndIncrement();
    }

    protected AtomicInteger getObjCounter() {
        return this.objCounter;
    }

    public Object getObject(String objectId) {
        if (objectId.equals("c")) {
            return connectionProperty.get();
        }
        return this.bindings.get(objectId);
    }

    protected Object getObjectFromId(String targetObjectId) {
        if (targetObjectId.startsWith("z:")) {
            return null;
        }
        return this.getObject(targetObjectId);
    }

    public ReflectionEngine getReflectionEngine() {
        return this.rEngine;
    }

    public ReturnObject getReturnObject(Object object) {
        ReturnObject returnObject;
        if (object != null) {
            if (this.isPrimitiveObject(object)) {
                returnObject = ReturnObject.getPrimitiveReturnObject(object);
            } else if (object == ReflectionEngine.RETURN_VOID) {
                returnObject = ReturnObject.getVoidReturnObject();
            } else if (this.isList(object)) {
                String objectId = this.putNewObject(object);
                returnObject = ReturnObject.getListReturnObject(objectId, ((List)object).size());
            } else if (this.isMap(object)) {
                String objectId = this.putNewObject(object);
                returnObject = ReturnObject.getMapReturnObject(objectId, ((Map)object).size());
            } else {
                String objectId = this.putNewObject(object);
                returnObject = ReturnObject.getReferenceReturnObject(objectId);
                this.trackConnectionObject(returnObject);
            }
        } else {
            returnObject = ReturnObject.getNullReturnObject();
        }
        return returnObject;
    }

    public ReturnObject invoke(String fqn, List<Argument> args) {
        if (args == null) {
            args = new ArrayList<Argument>();
        }
        ReturnObject returnObject = null;
        ArrayList<Object> parametersList = new ArrayList<Object>();
        try {
            this.buildArgs(args, parametersList);
            this.logger.info("Calling constructor: " + fqn);
            Object[] parameters = parametersList.toArray();
            MethodInvoker method = this.rEngine.getConstructor(fqn, parameters);
            Object object = this.rEngine.invoke(null, method, parameters);
            returnObject = this.getReturnObject(object);
        }
        catch (Exception e) {
            throw new Py4JException(e);
        }
        return returnObject;
    }

    public ReturnObject invoke(String methodName, String targetObjectId, List<Argument> args) {
        if (args == null) {
            args = new ArrayList<Argument>();
        }
        ReturnObject returnObject = null;
        ArrayList<Object> parametersList = new ArrayList<Object>();
        try {
            Object targetObject = this.getObjectFromId(targetObjectId);
            this.buildArgs(args, parametersList);
            this.logger.info("Calling: " + methodName);
            Object[] parameters = parametersList.toArray();
            MethodInvoker method = null;
            method = targetObject != null ? this.rEngine.getMethod(targetObject, methodName, parameters) : this.rEngine.getMethod(targetObjectId.substring("z:".length()), methodName, parameters);
            Object object = this.rEngine.invoke(targetObject, method, parameters);
            returnObject = this.getReturnObject(object);
        }
        catch (Exception e) {
            throw new Py4JException(e);
        }
        return returnObject;
    }

    protected boolean isList(Object object) {
        return object instanceof List;
    }

    protected boolean isMap(Object object) {
        return object instanceof Map;
    }

    protected boolean isPrimitiveObject(Object object) {
        return object instanceof Boolean || object instanceof String || object instanceof Number || object instanceof Character;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    protected String putNewObject(Object object) {
        String id = this.getNextObjectId();
        this.bindings.put(id, object);
        return id;
    }

    public void setStarted(boolean isStarted) {
        this.isStarted = isStarted;
    }

    public void shutdown() {
        this.isStarted = false;
        this.bindings.clear();
    }

    public void startup() {
        this.isStarted = true;
        if (this.entryPoint != null) {
            this.bindings.put("t", this.entryPoint);
        }
    }

    private void trackConnectionObject(ReturnObject returnObject) {
        String name = returnObject.getName();
        if (name != null) {
            connectionObjects.get().add(returnObject.getName());
        }
    }
}

