# mypy-boto3-codestar

[![PyPI - mypy-boto3-codestar](https://img.shields.io/pypi/v/mypy-boto3-codestar.svg?color=blue)](https://pypi.org/project/mypy-boto3-codestar)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-codestar.svg?color=blue)](https://pypi.org/project/mypy-boto3-codestar)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CodeStar 1.14.7](https://boto3.amazonaws.com/v1/documentation/api/1.14.7/reference/services/codestar.html#CodeStar) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `CodeStar` service.

```bash
python -m pip install boto3-stubs[codestar]
```

## How to use

### Client annotations

`CodeStarClient` provides annotations for `boto3.client("codestar")`.

```python
import boto3

from mypy_boto3_codestar import CodeStarClient
from mypy_boto3_codestar.paginator import (
    ListProjectsPaginator,
    ListResourcesPaginator,
    ListTeamMembersPaginator,
    ListUserProfilesPaginator,
)
from mypy_boto3_codestar.type_defs import CodeCommitCodeDestinationTypeDef, ...

client: CodeStarClient = boto3.client("codestar")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CodeStarClient = session.client("codestar")
```

### Paginators annotations

`mypy_boto3_codestar.paginator` module contains type annotations for all paginators.

```python

client: CodeStarClient = boto3.client("codestar")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_projects_paginator: ListProjectsPaginator = client.get_paginator("list_projects")
list_resources_paginator: ListResourcesPaginator = client.get_paginator("list_resources")
list_team_members_paginator: ListTeamMembersPaginator = client.get_paginator("list_team_members")
list_user_profiles_paginator: ListUserProfilesPaginator = client.get_paginator("list_user_profiles")
```







### Typed dictionations

`mypy_boto3_codestar.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> CodeCommitCodeDestinationTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_codestar` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("codestar")

session_client = boto3.Session().client("codestar")
```
