

# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

from __future__ import annotations
import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime
import threading
import itertools
import traceback
import typing
import platform

# Used for default argument values
_DEFAULT = object() # type: typing.Any


class _UniffiRustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_uint64),
        ("len", ctypes.c_uint64),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def default():
        return _UniffiRustBuffer(0, 0, None)

    @staticmethod
    def alloc(size):
        return _uniffi_rust_call(_UniffiLib.ffi_breez_sdk_liquid_bindings_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return _uniffi_rust_call(_UniffiLib.ffi_breez_sdk_liquid_bindings_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return _uniffi_rust_call(_UniffiLib.ffi_breez_sdk_liquid_bindings_rustbuffer_free, self)

    def __str__(self):
        return "_UniffiRustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def alloc_with_builder(*args):
        """Context-manger to allocate a buffer using a _UniffiRustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = _UniffiRustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consume_with_stream(self):
        """Context-manager to consume a buffer using a _UniffiRustBufferStream.

        The _UniffiRustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = _UniffiRustBufferStream.from_rust_buffer(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer at end of consume_with_stream")
        finally:
            self.free()

    @contextlib.contextmanager
    def read_with_stream(self):
        """Context-manager to read a buffer using a _UniffiRustBufferStream.

        This is like consume_with_stream, but doesn't free the buffer afterwards.
        It should only be used with borrowed `_UniffiRustBuffer` data.
        """
        s = _UniffiRustBufferStream.from_rust_buffer(self)
        yield s
        if s.remaining() != 0:
            raise RuntimeError("junk data left in buffer at end of read_with_stream")

class _UniffiForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "_UniffiForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class _UniffiRustBufferStream:
    """
    Helper for structured reading of bytes from a _UniffiRustBuffer
    """

    def __init__(self, data, len):
        self.data = data
        self.len = len
        self.offset = 0

    @classmethod
    def from_rust_buffer(cls, buf):
        return cls(buf.data, buf.len)

    def remaining(self):
        return self.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        data = self.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def read_i8(self):
        return self._unpack_from(1, ">b")

    def read_u8(self):
        return self._unpack_from(1, ">B")

    def read_i16(self):
        return self._unpack_from(2, ">h")

    def read_u16(self):
        return self._unpack_from(2, ">H")

    def read_i32(self):
        return self._unpack_from(4, ">i")

    def read_u32(self):
        return self._unpack_from(4, ">I")

    def read_i64(self):
        return self._unpack_from(8, ">q")

    def read_u64(self):
        return self._unpack_from(8, ">Q")

    def read_float(self):
        v = self._unpack_from(4, ">f")
        return v

    def read_double(self):
        return self._unpack_from(8, ">d")

class _UniffiRustBufferBuilder:
    """
    Helper for structured writing of bytes into a _UniffiRustBuffer.
    """

    def __init__(self):
        self.rbuf = _UniffiRustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, num_bytes):
        if self.rbuf.len + num_bytes > self.rbuf.capacity:
            self.rbuf = _UniffiRustBuffer.reserve(self.rbuf, num_bytes)
        yield None
        self.rbuf.len += num_bytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write_i8(self, v):
        self._pack_into(1, ">b", v)

    def write_u8(self, v):
        self._pack_into(1, ">B", v)

    def write_i16(self, v):
        self._pack_into(2, ">h", v)

    def write_u16(self, v):
        self._pack_into(2, ">H", v)

    def write_i32(self, v):
        self._pack_into(4, ">i", v)

    def write_u32(self, v):
        self._pack_into(4, ">I", v)

    def write_i64(self, v):
        self._pack_into(8, ">q", v)

    def write_u64(self, v):
        self._pack_into(8, ">Q", v)

    def write_float(self, v):
        self._pack_into(4, ">f", v)

    def write_double(self, v):
        self._pack_into(8, ">d", v)

    def write_c_size_t(self, v):
        self._pack_into(ctypes.sizeof(ctypes.c_size_t) , "@N", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class _UniffiRustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", _UniffiRustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_UNEXPECTED_ERROR = 2

    @staticmethod
    def default():
        return _UniffiRustCallStatus(code=_UniffiRustCallStatus.CALL_SUCCESS, error_buf=_UniffiRustBuffer.default())

    def __str__(self):
        if self.code == _UniffiRustCallStatus.CALL_SUCCESS:
            return "_UniffiRustCallStatus(CALL_SUCCESS)"
        elif self.code == _UniffiRustCallStatus.CALL_ERROR:
            return "_UniffiRustCallStatus(CALL_ERROR)"
        elif self.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
            return "_UniffiRustCallStatus(CALL_UNEXPECTED_ERROR)"
        else:
            return "_UniffiRustCallStatus(<invalid code>)"

def _uniffi_rust_call(fn, *args):
    # Call a rust function
    return _uniffi_rust_call_with_error(None, fn, *args)

def _uniffi_rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the _UniffiConverter for the error class that corresponds to the result.
    call_status = _UniffiRustCallStatus.default()

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    _uniffi_check_call_status(error_ffi_converter, call_status)
    return result

def _uniffi_check_call_status(error_ffi_converter, call_status):
    if call_status.code == _UniffiRustCallStatus.CALL_SUCCESS:
        pass
    elif call_status.code == _UniffiRustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.error_buf.free()
            raise InternalError("_uniffi_rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
        # When the rust code sees a panic, it tries to construct a _UniffiRustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = _UniffiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid _UniffiRustCallStatus code: {}".format(
            call_status.code))

def _uniffi_trait_interface_call(call_status, make_call, write_return_value):
    try:
        return write_return_value(make_call())
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))

def _uniffi_trait_interface_call_with_error(call_status, make_call, write_return_value, error_type, lower_error):
    try:
        try:
            return write_return_value(make_call())
        except error_type as e:
            call_status.code = _UniffiRustCallStatus.CALL_ERROR
            call_status.error_buf = lower_error(e)
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))
class _UniffiHandleMap:
    """
    A map where inserting, getting and removing data is synchronized with a lock.
    """

    def __init__(self):
        # type Handle = int
        self._map = {}  # type: Dict[Handle, Any]
        self._lock = threading.Lock()
        self._counter = itertools.count()

    def insert(self, obj):
        with self._lock:
            handle = next(self._counter)
            self._map[handle] = obj
            return handle

    def get(self, handle):
        try:
            with self._lock:
                return self._map[handle]
        except KeyError:
            raise InternalError("_UniffiHandleMap.get: Invalid handle")

    def remove(self, handle):
        try:
            with self._lock:
                return self._map.pop(handle)
        except KeyError:
            raise InternalError("_UniffiHandleMap.remove: Invalid handle")

    def __len__(self):
        return len(self._map)
# Types conforming to `_UniffiConverterPrimitive` pass themselves directly over the FFI.
class _UniffiConverterPrimitive:
    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return value

class _UniffiConverterPrimitiveInt(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__index__()
        except Exception:
            raise TypeError("'{}' object cannot be interpreted as an integer".format(type(value).__name__))
        if not isinstance(value, int):
            raise TypeError("__index__ returned non-int (type {})".format(type(value).__name__))
        if not cls.VALUE_MIN <= value < cls.VALUE_MAX:
            raise ValueError("{} requires {} <= value < {}".format(cls.CLASS_NAME, cls.VALUE_MIN, cls.VALUE_MAX))

class _UniffiConverterPrimitiveFloat(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__float__()
        except Exception:
            raise TypeError("must be real number, not {}".format(type(value).__name__))
        if not isinstance(value, float):
            raise TypeError("__float__ returned non-float (type {})".format(type(value).__name__))

# Helper class for wrapper types that will always go through a _UniffiRustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class _UniffiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consume_with_stream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code, and the FFI Function declarations.
# Define some ctypes FFI types that we use in the library

"""
Function pointer for a Rust task, which a callback function that takes a opaque pointer
"""
_UNIFFI_RUST_TASK = ctypes.CFUNCTYPE(None, ctypes.c_void_p, ctypes.c_int8)

def _uniffi_future_callback_t(return_type):
    """
    Factory function to create callback function types for async functions
    """
    return ctypes.CFUNCTYPE(None, ctypes.c_uint64, return_type, _UniffiRustCallStatus)

def _uniffi_load_indirect():
    """
    This is how we find and load the dynamic library provided by the component.
    For now we just look it up by name.
    """
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    libname = libname.format("breez_sdk_liquid_bindings")
    path = os.path.join(os.path.dirname(__file__), libname)
    lib = ctypes.cdll.LoadLibrary(path)
    return lib

def _uniffi_check_contract_api_version(lib):
    # Get the bindings contract version from our ComponentInterface
    bindings_contract_version = 26
    # Get the scaffolding contract version by calling the into the dylib
    scaffolding_contract_version = lib.ffi_breez_sdk_liquid_bindings_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version:
        raise InternalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")

def _uniffi_check_api_checksums(lib):
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_func_connect() != 39960:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_func_connect_with_signer() != 48633:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_func_default_config() != 20931:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_func_parse_invoice() != 15921:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_func_set_logger() != 32375:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_accept_payment_proposed_fees() != 57291:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_add_event_listener() != 65289:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_backup() != 3592:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_buy_bitcoin() != 53022:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_check_message() != 64029:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_disconnect() != 37717:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_fetch_fiat_rates() != 61824:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_fetch_lightning_limits() != 61822:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_fetch_onchain_limits() != 51575:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_fetch_payment_proposed_fees() != 45806:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_get_info() != 4290:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_get_payment() != 25832:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_list_fiat_currencies() != 38203:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_list_payments() != 39611:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_list_refundables() != 22886:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_lnurl_auth() != 58655:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_lnurl_pay() != 46650:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_lnurl_withdraw() != 60533:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_parse() != 40166:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_pay_onchain() != 46079:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_buy_bitcoin() != 26608:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_lnurl_pay() != 14727:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_pay_onchain() != 1876:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_receive_payment() != 28769:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_refund() != 53467:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_send_payment() != 1183:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_receive_payment() != 63548:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_recommended_fees() != 23255:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_refund() != 31475:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_register_webhook() != 3912:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_remove_event_listener() != 16569:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_rescan_onchain_swaps() != 14305:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_restore() != 63590:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_send_payment() != 63087:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_sign_message() != 33731:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_sync() != 31783:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_unregister_webhook() != 34970:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_eventlistener_on_event() != 22441:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_logger_log() != 36218:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_xpub() != 36847:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_derive_xpub() != 8680:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_sign_ecdsa() != 48623:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_sign_ecdsa_recoverable() != 263:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_slip77_master_blinding_key() != 9707:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_hmac_sha256() != 40934:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_ecies_encrypt() != 43772:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_ecies_decrypt() != 45851:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniffiLib = _uniffi_load_indirect()
_UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.c_int8,
)
_UNIFFI_FOREIGN_FUTURE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
_UNIFFI_CALLBACK_INTERFACE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
class _UniffiForeignFuture(ctypes.Structure):
    _fields_ = [
        ("handle", ctypes.c_uint64),
        ("free", _UNIFFI_FOREIGN_FUTURE_FREE),
    ]
class _UniffiForeignFutureStructU8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU8,
)
class _UniffiForeignFutureStructI8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI8,
)
class _UniffiForeignFutureStructU16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU16,
)
class _UniffiForeignFutureStructI16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI16,
)
class _UniffiForeignFutureStructU32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU32,
)
class _UniffiForeignFutureStructI32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI32,
)
class _UniffiForeignFutureStructU64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU64,
)
class _UniffiForeignFutureStructI64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI64,
)
class _UniffiForeignFutureStructF32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_float),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF32,
)
class _UniffiForeignFutureStructF64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_double),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF64,
)
class _UniffiForeignFutureStructPointer(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_void_p),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_POINTER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructPointer,
)
class _UniffiForeignFutureStructRustBuffer(ctypes.Structure):
    _fields_ = [
        ("return_value", _UniffiRustBuffer),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructRustBuffer,
)
class _UniffiForeignFutureStructVoid(ctypes.Structure):
    _fields_ = [
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructVoid,
)
_UNIFFI_CALLBACK_INTERFACE_EVENT_LISTENER_METHOD0 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UNIFFI_CALLBACK_INTERFACE_LOGGER_METHOD0 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD0 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.POINTER(_UniffiRustBuffer),
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD1 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,ctypes.POINTER(_UniffiRustBuffer),
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD2 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,_UniffiRustBuffer,ctypes.POINTER(_UniffiRustBuffer),
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD3 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,ctypes.POINTER(_UniffiRustBuffer),
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD4 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.POINTER(_UniffiRustBuffer),
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD5 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,_UniffiRustBuffer,ctypes.POINTER(_UniffiRustBuffer),
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD6 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,ctypes.POINTER(_UniffiRustBuffer),
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD7 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiRustBuffer,ctypes.POINTER(_UniffiRustBuffer),
    ctypes.POINTER(_UniffiRustCallStatus),
)
class _UniffiVTableCallbackInterfaceEventListener(ctypes.Structure):
    _fields_ = [
        ("on_event", _UNIFFI_CALLBACK_INTERFACE_EVENT_LISTENER_METHOD0),
        ("uniffi_free", _UNIFFI_CALLBACK_INTERFACE_FREE),
    ]
class _UniffiVTableCallbackInterfaceLogger(ctypes.Structure):
    _fields_ = [
        ("log", _UNIFFI_CALLBACK_INTERFACE_LOGGER_METHOD0),
        ("uniffi_free", _UNIFFI_CALLBACK_INTERFACE_FREE),
    ]
class _UniffiVTableCallbackInterfaceSigner(ctypes.Structure):
    _fields_ = [
        ("xpub", _UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD0),
        ("derive_xpub", _UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD1),
        ("sign_ecdsa", _UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD2),
        ("sign_ecdsa_recoverable", _UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD3),
        ("slip77_master_blinding_key", _UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD4),
        ("hmac_sha256", _UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD5),
        ("ecies_encrypt", _UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD6),
        ("ecies_decrypt", _UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD7),
        ("uniffi_free", _UNIFFI_CALLBACK_INTERFACE_FREE),
    ]
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_clone_bindingliquidsdk.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_clone_bindingliquidsdk.restype = ctypes.c_void_p
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_free_bindingliquidsdk.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_free_bindingliquidsdk.restype = None
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_accept_payment_proposed_fees.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_accept_payment_proposed_fees.restype = None
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_add_event_listener.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_add_event_listener.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_backup.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_backup.restype = None
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_buy_bitcoin.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_buy_bitcoin.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_check_message.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_check_message.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_disconnect.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_disconnect.restype = None
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_fetch_fiat_rates.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_fetch_fiat_rates.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_fetch_lightning_limits.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_fetch_lightning_limits.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_fetch_onchain_limits.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_fetch_onchain_limits.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_fetch_payment_proposed_fees.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_fetch_payment_proposed_fees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_get_info.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_get_info.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_get_payment.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_get_payment.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_list_fiat_currencies.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_list_fiat_currencies.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_list_payments.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_list_payments.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_list_refundables.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_list_refundables.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_lnurl_auth.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_lnurl_auth.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_lnurl_pay.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_lnurl_pay.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_lnurl_withdraw.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_lnurl_withdraw.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_parse.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_parse.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_pay_onchain.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_pay_onchain.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_buy_bitcoin.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_buy_bitcoin.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_lnurl_pay.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_lnurl_pay.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_pay_onchain.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_pay_onchain.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_receive_payment.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_receive_payment.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_refund.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_refund.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_send_payment.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_send_payment.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_receive_payment.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_receive_payment.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_recommended_fees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_recommended_fees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_refund.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_refund.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_register_webhook.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_register_webhook.restype = None
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_remove_event_listener.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_remove_event_listener.restype = None
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_rescan_onchain_swaps.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_rescan_onchain_swaps.restype = None
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_restore.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_restore.restype = None
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_send_payment.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_send_payment.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_sign_message.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_sign_message.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_sync.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_sync.restype = None
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_unregister_webhook.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_unregister_webhook.restype = None
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_init_callback_vtable_eventlistener.argtypes = (
    ctypes.POINTER(_UniffiVTableCallbackInterfaceEventListener),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_init_callback_vtable_eventlistener.restype = None
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_init_callback_vtable_logger.argtypes = (
    ctypes.POINTER(_UniffiVTableCallbackInterfaceLogger),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_init_callback_vtable_logger.restype = None
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_init_callback_vtable_signer.argtypes = (
    ctypes.POINTER(_UniffiVTableCallbackInterfaceSigner),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_init_callback_vtable_signer.restype = None
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_func_connect.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_func_connect.restype = ctypes.c_void_p
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_func_connect_with_signer.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_func_connect_with_signer.restype = ctypes.c_void_p
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_func_default_config.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_func_default_config.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_func_parse_invoice.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_func_parse_invoice.restype = _UniffiRustBuffer
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_func_set_logger.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_func_set_logger.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rustbuffer_alloc.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rustbuffer_alloc.restype = _UniffiRustBuffer
_UniffiLib.ffi_breez_sdk_liquid_bindings_rustbuffer_from_bytes.argtypes = (
    _UniffiForeignBytes,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rustbuffer_from_bytes.restype = _UniffiRustBuffer
_UniffiLib.ffi_breez_sdk_liquid_bindings_rustbuffer_free.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rustbuffer_free.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rustbuffer_reserve.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rustbuffer_reserve.restype = _UniffiRustBuffer
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_u8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_u8.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_u8.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_u8.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_u8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_u8.restype = ctypes.c_uint8
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_i8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_i8.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_i8.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_i8.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_i8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_i8.restype = ctypes.c_int8
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_u16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_u16.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_u16.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_u16.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_u16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_u16.restype = ctypes.c_uint16
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_i16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_i16.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_i16.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_i16.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_i16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_i16.restype = ctypes.c_int16
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_u32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_u32.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_u32.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_u32.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_u32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_u32.restype = ctypes.c_uint32
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_i32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_i32.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_i32.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_i32.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_i32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_i32.restype = ctypes.c_int32
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_u64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_u64.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_u64.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_u64.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_u64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_u64.restype = ctypes.c_uint64
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_i64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_i64.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_i64.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_i64.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_i64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_i64.restype = ctypes.c_int64
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_f32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_f32.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_f32.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_f32.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_f32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_f32.restype = ctypes.c_float
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_f64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_f64.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_f64.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_f64.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_f64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_f64.restype = ctypes.c_double
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_pointer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_pointer.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_pointer.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_pointer.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_pointer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_pointer.restype = ctypes.c_void_p
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_rust_buffer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_rust_buffer.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_rust_buffer.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_rust_buffer.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_rust_buffer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_rust_buffer.restype = _UniffiRustBuffer
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_void.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_poll_void.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_cancel_void.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_free_void.restype = None
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_void.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_rust_future_complete_void.restype = None
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_func_connect.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_func_connect.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_func_connect_with_signer.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_func_connect_with_signer.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_func_default_config.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_func_default_config.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_func_parse_invoice.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_func_parse_invoice.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_func_set_logger.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_func_set_logger.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_accept_payment_proposed_fees.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_accept_payment_proposed_fees.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_add_event_listener.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_add_event_listener.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_backup.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_backup.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_buy_bitcoin.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_buy_bitcoin.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_check_message.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_check_message.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_disconnect.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_disconnect.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_fetch_fiat_rates.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_fetch_fiat_rates.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_fetch_lightning_limits.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_fetch_lightning_limits.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_fetch_onchain_limits.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_fetch_onchain_limits.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_fetch_payment_proposed_fees.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_fetch_payment_proposed_fees.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_get_info.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_get_info.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_get_payment.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_get_payment.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_list_fiat_currencies.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_list_fiat_currencies.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_list_payments.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_list_payments.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_list_refundables.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_list_refundables.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_lnurl_auth.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_lnurl_auth.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_lnurl_pay.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_lnurl_pay.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_lnurl_withdraw.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_lnurl_withdraw.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_parse.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_parse.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_pay_onchain.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_pay_onchain.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_buy_bitcoin.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_buy_bitcoin.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_lnurl_pay.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_lnurl_pay.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_pay_onchain.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_pay_onchain.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_receive_payment.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_receive_payment.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_refund.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_refund.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_send_payment.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_prepare_send_payment.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_receive_payment.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_receive_payment.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_recommended_fees.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_recommended_fees.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_refund.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_refund.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_register_webhook.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_register_webhook.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_remove_event_listener.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_remove_event_listener.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_rescan_onchain_swaps.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_rescan_onchain_swaps.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_restore.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_restore.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_send_payment.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_send_payment.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_sign_message.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_sign_message.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_sync.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_sync.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_unregister_webhook.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_bindingliquidsdk_unregister_webhook.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_eventlistener_on_event.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_eventlistener_on_event.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_logger_log.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_logger_log.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_xpub.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_xpub.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_derive_xpub.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_derive_xpub.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_sign_ecdsa.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_sign_ecdsa.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_sign_ecdsa_recoverable.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_sign_ecdsa_recoverable.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_slip77_master_blinding_key.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_slip77_master_blinding_key.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_hmac_sha256.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_hmac_sha256.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_ecies_encrypt.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_ecies_encrypt.restype = ctypes.c_uint16
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_ecies_decrypt.argtypes = (
)
_UniffiLib.uniffi_breez_sdk_liquid_bindings_checksum_method_signer_ecies_decrypt.restype = ctypes.c_uint16
_UniffiLib.ffi_breez_sdk_liquid_bindings_uniffi_contract_version.argtypes = (
)
_UniffiLib.ffi_breez_sdk_liquid_bindings_uniffi_contract_version.restype = ctypes.c_uint32

_uniffi_check_contract_api_version(_UniffiLib)
# _uniffi_check_api_checksums(_UniffiLib)

# Public interface members begin here.


class _UniffiConverterUInt8(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u8"
    VALUE_MIN = 0
    VALUE_MAX = 2**8

    @staticmethod
    def read(buf):
        return buf.read_u8()

    @staticmethod
    def write(value, buf):
        buf.write_u8(value)

class _UniffiConverterUInt16(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u16"
    VALUE_MIN = 0
    VALUE_MAX = 2**16

    @staticmethod
    def read(buf):
        return buf.read_u16()

    @staticmethod
    def write(value, buf):
        buf.write_u16(value)

class _UniffiConverterUInt32(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u32"
    VALUE_MIN = 0
    VALUE_MAX = 2**32

    @staticmethod
    def read(buf):
        return buf.read_u32()

    @staticmethod
    def write(value, buf):
        buf.write_u32(value)

class _UniffiConverterUInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u64"
    VALUE_MIN = 0
    VALUE_MAX = 2**64

    @staticmethod
    def read(buf):
        return buf.read_u64()

    @staticmethod
    def write(value, buf):
        buf.write_u64(value)

class _UniffiConverterInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "i64"
    VALUE_MIN = -2**63
    VALUE_MAX = 2**63

    @staticmethod
    def read(buf):
        return buf.read_i64()

    @staticmethod
    def write(value, buf):
        buf.write_i64(value)

class _UniffiConverterDouble(_UniffiConverterPrimitiveFloat):
    @staticmethod
    def read(buf):
        return buf.read_double()

    @staticmethod
    def write(value, buf):
        buf.write_double(value)

class _UniffiConverterBool:
    @classmethod
    def check_lower(cls, value):
        return not not value

    @classmethod
    def lower(cls, value):
        return 1 if value else 0

    @staticmethod
    def lift(value):
        return value != 0

    @classmethod
    def read(cls, buf):
        return cls.lift(buf.read_u8())

    @classmethod
    def write(cls, value, buf):
        buf.write_u8(value)

class _UniffiConverterString:
    @staticmethod
    def check_lower(value):
        if not isinstance(value, str):
            raise TypeError("argument must be str, not {}".format(type(value).__name__))
        return value

    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8_bytes = buf.read(size)
        return utf8_bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        utf8_bytes = value.encode("utf-8")
        buf.write_i32(len(utf8_bytes))
        buf.write(utf8_bytes)

    @staticmethod
    def lift(buf):
        with buf.consume_with_stream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()



class BindingLiquidSdkProtocol(typing.Protocol):
    def accept_payment_proposed_fees(self, req: "AcceptPaymentProposedFeesRequest"):
        raise NotImplementedError
    def add_event_listener(self, listener: "EventListener"):
        raise NotImplementedError
    def backup(self, req: "BackupRequest"):
        raise NotImplementedError
    def buy_bitcoin(self, req: "BuyBitcoinRequest"):
        raise NotImplementedError
    def check_message(self, req: "CheckMessageRequest"):
        raise NotImplementedError
    def disconnect(self, ):
        raise NotImplementedError
    def fetch_fiat_rates(self, ):
        raise NotImplementedError
    def fetch_lightning_limits(self, ):
        raise NotImplementedError
    def fetch_onchain_limits(self, ):
        raise NotImplementedError
    def fetch_payment_proposed_fees(self, req: "FetchPaymentProposedFeesRequest"):
        raise NotImplementedError
    def get_info(self, ):
        raise NotImplementedError
    def get_payment(self, req: "GetPaymentRequest"):
        raise NotImplementedError
    def list_fiat_currencies(self, ):
        raise NotImplementedError
    def list_payments(self, req: "ListPaymentsRequest"):
        raise NotImplementedError
    def list_refundables(self, ):
        raise NotImplementedError
    def lnurl_auth(self, req_data: "LnUrlAuthRequestData"):
        raise NotImplementedError
    def lnurl_pay(self, req: "LnUrlPayRequest"):
        raise NotImplementedError
    def lnurl_withdraw(self, req: "LnUrlWithdrawRequest"):
        raise NotImplementedError
    def parse(self, input: "str"):
        raise NotImplementedError
    def pay_onchain(self, req: "PayOnchainRequest"):
        raise NotImplementedError
    def prepare_buy_bitcoin(self, req: "PrepareBuyBitcoinRequest"):
        raise NotImplementedError
    def prepare_lnurl_pay(self, req: "PrepareLnUrlPayRequest"):
        raise NotImplementedError
    def prepare_pay_onchain(self, req: "PreparePayOnchainRequest"):
        raise NotImplementedError
    def prepare_receive_payment(self, req: "PrepareReceiveRequest"):
        raise NotImplementedError
    def prepare_refund(self, req: "PrepareRefundRequest"):
        raise NotImplementedError
    def prepare_send_payment(self, req: "PrepareSendRequest"):
        raise NotImplementedError
    def receive_payment(self, req: "ReceivePaymentRequest"):
        raise NotImplementedError
    def recommended_fees(self, ):
        raise NotImplementedError
    def refund(self, req: "RefundRequest"):
        raise NotImplementedError
    def register_webhook(self, webhook_url: "str"):
        raise NotImplementedError
    def remove_event_listener(self, id: "str"):
        raise NotImplementedError
    def rescan_onchain_swaps(self, ):
        raise NotImplementedError
    def restore(self, req: "RestoreRequest"):
        raise NotImplementedError
    def send_payment(self, req: "SendPaymentRequest"):
        raise NotImplementedError
    def sign_message(self, req: "SignMessageRequest"):
        raise NotImplementedError
    def sync(self, ):
        raise NotImplementedError
    def unregister_webhook(self, ):
        raise NotImplementedError


class BindingLiquidSdk:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_free_bindingliquidsdk, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_clone_bindingliquidsdk, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def accept_payment_proposed_fees(self, req: "AcceptPaymentProposedFeesRequest") -> None:
        _UniffiConverterTypeAcceptPaymentProposedFeesRequest.check_lower(req)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_accept_payment_proposed_fees,self._uniffi_clone_pointer(),
        _UniffiConverterTypeAcceptPaymentProposedFeesRequest.lower(req))






    def add_event_listener(self, listener: "EventListener") -> "str":
        _UniffiConverterTypeEventListener.check_lower(listener)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_add_event_listener,self._uniffi_clone_pointer(),
        _UniffiConverterTypeEventListener.lower(listener))
        )





    def backup(self, req: "BackupRequest") -> None:
        _UniffiConverterTypeBackupRequest.check_lower(req)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_backup,self._uniffi_clone_pointer(),
        _UniffiConverterTypeBackupRequest.lower(req))






    def buy_bitcoin(self, req: "BuyBitcoinRequest") -> "str":
        _UniffiConverterTypeBuyBitcoinRequest.check_lower(req)
        
        return _UniffiConverterString.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_buy_bitcoin,self._uniffi_clone_pointer(),
        _UniffiConverterTypeBuyBitcoinRequest.lower(req))
        )





    def check_message(self, req: "CheckMessageRequest") -> "CheckMessageResponse":
        _UniffiConverterTypeCheckMessageRequest.check_lower(req)
        
        return _UniffiConverterTypeCheckMessageResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_check_message,self._uniffi_clone_pointer(),
        _UniffiConverterTypeCheckMessageRequest.lower(req))
        )





    def disconnect(self, ) -> None:
        _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_disconnect,self._uniffi_clone_pointer(),)






    def fetch_fiat_rates(self, ) -> "typing.List[Rate]":
        return _UniffiConverterSequenceTypeRate.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_fetch_fiat_rates,self._uniffi_clone_pointer(),)
        )





    def fetch_lightning_limits(self, ) -> "LightningPaymentLimitsResponse":
        return _UniffiConverterTypeLightningPaymentLimitsResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_fetch_lightning_limits,self._uniffi_clone_pointer(),)
        )





    def fetch_onchain_limits(self, ) -> "OnchainPaymentLimitsResponse":
        return _UniffiConverterTypeOnchainPaymentLimitsResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_fetch_onchain_limits,self._uniffi_clone_pointer(),)
        )





    def fetch_payment_proposed_fees(self, req: "FetchPaymentProposedFeesRequest") -> "FetchPaymentProposedFeesResponse":
        _UniffiConverterTypeFetchPaymentProposedFeesRequest.check_lower(req)
        
        return _UniffiConverterTypeFetchPaymentProposedFeesResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_fetch_payment_proposed_fees,self._uniffi_clone_pointer(),
        _UniffiConverterTypeFetchPaymentProposedFeesRequest.lower(req))
        )





    def get_info(self, ) -> "GetInfoResponse":
        return _UniffiConverterTypeGetInfoResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_get_info,self._uniffi_clone_pointer(),)
        )





    def get_payment(self, req: "GetPaymentRequest") -> "typing.Optional[Payment]":
        _UniffiConverterTypeGetPaymentRequest.check_lower(req)
        
        return _UniffiConverterOptionalTypePayment.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_get_payment,self._uniffi_clone_pointer(),
        _UniffiConverterTypeGetPaymentRequest.lower(req))
        )





    def list_fiat_currencies(self, ) -> "typing.List[FiatCurrency]":
        return _UniffiConverterSequenceTypeFiatCurrency.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_list_fiat_currencies,self._uniffi_clone_pointer(),)
        )





    def list_payments(self, req: "ListPaymentsRequest") -> "typing.List[Payment]":
        _UniffiConverterTypeListPaymentsRequest.check_lower(req)
        
        return _UniffiConverterSequenceTypePayment.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_list_payments,self._uniffi_clone_pointer(),
        _UniffiConverterTypeListPaymentsRequest.lower(req))
        )





    def list_refundables(self, ) -> "typing.List[RefundableSwap]":
        return _UniffiConverterSequenceTypeRefundableSwap.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_list_refundables,self._uniffi_clone_pointer(),)
        )





    def lnurl_auth(self, req_data: "LnUrlAuthRequestData") -> "LnUrlCallbackStatus":
        _UniffiConverterTypeLnUrlAuthRequestData.check_lower(req_data)
        
        return _UniffiConverterTypeLnUrlCallbackStatus.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLnUrlAuthError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_lnurl_auth,self._uniffi_clone_pointer(),
        _UniffiConverterTypeLnUrlAuthRequestData.lower(req_data))
        )





    def lnurl_pay(self, req: "LnUrlPayRequest") -> "LnUrlPayResult":
        _UniffiConverterTypeLnUrlPayRequest.check_lower(req)
        
        return _UniffiConverterTypeLnUrlPayResult.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLnUrlPayError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_lnurl_pay,self._uniffi_clone_pointer(),
        _UniffiConverterTypeLnUrlPayRequest.lower(req))
        )





    def lnurl_withdraw(self, req: "LnUrlWithdrawRequest") -> "LnUrlWithdrawResult":
        _UniffiConverterTypeLnUrlWithdrawRequest.check_lower(req)
        
        return _UniffiConverterTypeLnUrlWithdrawResult.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLnUrlWithdrawError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_lnurl_withdraw,self._uniffi_clone_pointer(),
        _UniffiConverterTypeLnUrlWithdrawRequest.lower(req))
        )





    def parse(self, input: "str") -> "InputType":
        _UniffiConverterString.check_lower(input)
        
        return _UniffiConverterTypeInputType.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_parse,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(input))
        )





    def pay_onchain(self, req: "PayOnchainRequest") -> "SendPaymentResponse":
        _UniffiConverterTypePayOnchainRequest.check_lower(req)
        
        return _UniffiConverterTypeSendPaymentResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_pay_onchain,self._uniffi_clone_pointer(),
        _UniffiConverterTypePayOnchainRequest.lower(req))
        )





    def prepare_buy_bitcoin(self, req: "PrepareBuyBitcoinRequest") -> "PrepareBuyBitcoinResponse":
        _UniffiConverterTypePrepareBuyBitcoinRequest.check_lower(req)
        
        return _UniffiConverterTypePrepareBuyBitcoinResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_buy_bitcoin,self._uniffi_clone_pointer(),
        _UniffiConverterTypePrepareBuyBitcoinRequest.lower(req))
        )





    def prepare_lnurl_pay(self, req: "PrepareLnUrlPayRequest") -> "PrepareLnUrlPayResponse":
        _UniffiConverterTypePrepareLnUrlPayRequest.check_lower(req)
        
        return _UniffiConverterTypePrepareLnUrlPayResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeLnUrlPayError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_lnurl_pay,self._uniffi_clone_pointer(),
        _UniffiConverterTypePrepareLnUrlPayRequest.lower(req))
        )





    def prepare_pay_onchain(self, req: "PreparePayOnchainRequest") -> "PreparePayOnchainResponse":
        _UniffiConverterTypePreparePayOnchainRequest.check_lower(req)
        
        return _UniffiConverterTypePreparePayOnchainResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_pay_onchain,self._uniffi_clone_pointer(),
        _UniffiConverterTypePreparePayOnchainRequest.lower(req))
        )





    def prepare_receive_payment(self, req: "PrepareReceiveRequest") -> "PrepareReceiveResponse":
        _UniffiConverterTypePrepareReceiveRequest.check_lower(req)
        
        return _UniffiConverterTypePrepareReceiveResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_receive_payment,self._uniffi_clone_pointer(),
        _UniffiConverterTypePrepareReceiveRequest.lower(req))
        )





    def prepare_refund(self, req: "PrepareRefundRequest") -> "PrepareRefundResponse":
        _UniffiConverterTypePrepareRefundRequest.check_lower(req)
        
        return _UniffiConverterTypePrepareRefundResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_refund,self._uniffi_clone_pointer(),
        _UniffiConverterTypePrepareRefundRequest.lower(req))
        )





    def prepare_send_payment(self, req: "PrepareSendRequest") -> "PrepareSendResponse":
        _UniffiConverterTypePrepareSendRequest.check_lower(req)
        
        return _UniffiConverterTypePrepareSendResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_prepare_send_payment,self._uniffi_clone_pointer(),
        _UniffiConverterTypePrepareSendRequest.lower(req))
        )





    def receive_payment(self, req: "ReceivePaymentRequest") -> "ReceivePaymentResponse":
        _UniffiConverterTypeReceivePaymentRequest.check_lower(req)
        
        return _UniffiConverterTypeReceivePaymentResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_receive_payment,self._uniffi_clone_pointer(),
        _UniffiConverterTypeReceivePaymentRequest.lower(req))
        )





    def recommended_fees(self, ) -> "RecommendedFees":
        return _UniffiConverterTypeRecommendedFees.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_recommended_fees,self._uniffi_clone_pointer(),)
        )





    def refund(self, req: "RefundRequest") -> "RefundResponse":
        _UniffiConverterTypeRefundRequest.check_lower(req)
        
        return _UniffiConverterTypeRefundResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_refund,self._uniffi_clone_pointer(),
        _UniffiConverterTypeRefundRequest.lower(req))
        )





    def register_webhook(self, webhook_url: "str") -> None:
        _UniffiConverterString.check_lower(webhook_url)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_register_webhook,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(webhook_url))






    def remove_event_listener(self, id: "str") -> None:
        _UniffiConverterString.check_lower(id)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_remove_event_listener,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(id))






    def rescan_onchain_swaps(self, ) -> None:
        _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_rescan_onchain_swaps,self._uniffi_clone_pointer(),)






    def restore(self, req: "RestoreRequest") -> None:
        _UniffiConverterTypeRestoreRequest.check_lower(req)
        
        _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_restore,self._uniffi_clone_pointer(),
        _UniffiConverterTypeRestoreRequest.lower(req))






    def send_payment(self, req: "SendPaymentRequest") -> "SendPaymentResponse":
        _UniffiConverterTypeSendPaymentRequest.check_lower(req)
        
        return _UniffiConverterTypeSendPaymentResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_send_payment,self._uniffi_clone_pointer(),
        _UniffiConverterTypeSendPaymentRequest.lower(req))
        )





    def sign_message(self, req: "SignMessageRequest") -> "SignMessageResponse":
        _UniffiConverterTypeSignMessageRequest.check_lower(req)
        
        return _UniffiConverterTypeSignMessageResponse.lift(
            _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_sign_message,self._uniffi_clone_pointer(),
        _UniffiConverterTypeSignMessageRequest.lower(req))
        )





    def sync(self, ) -> None:
        _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_sync,self._uniffi_clone_pointer(),)






    def unregister_webhook(self, ) -> None:
        _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_method_bindingliquidsdk_unregister_webhook,self._uniffi_clone_pointer(),)







class _UniffiConverterTypeBindingLiquidSdk:

    @staticmethod
    def lift(value: int):
        return BindingLiquidSdk._make_instance_(value)

    @staticmethod
    def check_lower(value: BindingLiquidSdk):
        if not isinstance(value, BindingLiquidSdk):
            raise TypeError("Expected BindingLiquidSdk instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: BindingLiquidSdkProtocol):
        if not isinstance(value, BindingLiquidSdk):
            raise TypeError("Expected BindingLiquidSdk instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: BindingLiquidSdkProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))


class AcceptPaymentProposedFeesRequest:
    response: "FetchPaymentProposedFeesResponse"
    def __init__(self, *, response: "FetchPaymentProposedFeesResponse"):
        self.response = response

    def __str__(self):
        return "AcceptPaymentProposedFeesRequest(response={})".format(self.response)

    def __eq__(self, other):
        if self.response != other.response:
            return False
        return True

class _UniffiConverterTypeAcceptPaymentProposedFeesRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AcceptPaymentProposedFeesRequest(
            response=_UniffiConverterTypeFetchPaymentProposedFeesResponse.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeFetchPaymentProposedFeesResponse.check_lower(value.response)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeFetchPaymentProposedFeesResponse.write(value.response, buf)


class AesSuccessActionData:
    description: "str"
    ciphertext: "str"
    iv: "str"
    def __init__(self, *, description: "str", ciphertext: "str", iv: "str"):
        self.description = description
        self.ciphertext = ciphertext
        self.iv = iv

    def __str__(self):
        return "AesSuccessActionData(description={}, ciphertext={}, iv={})".format(self.description, self.ciphertext, self.iv)

    def __eq__(self, other):
        if self.description != other.description:
            return False
        if self.ciphertext != other.ciphertext:
            return False
        if self.iv != other.iv:
            return False
        return True

class _UniffiConverterTypeAesSuccessActionData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AesSuccessActionData(
            description=_UniffiConverterString.read(buf),
            ciphertext=_UniffiConverterString.read(buf),
            iv=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.description)
        _UniffiConverterString.check_lower(value.ciphertext)
        _UniffiConverterString.check_lower(value.iv)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.description, buf)
        _UniffiConverterString.write(value.ciphertext, buf)
        _UniffiConverterString.write(value.iv, buf)


class AesSuccessActionDataDecrypted:
    description: "str"
    plaintext: "str"
    def __init__(self, *, description: "str", plaintext: "str"):
        self.description = description
        self.plaintext = plaintext

    def __str__(self):
        return "AesSuccessActionDataDecrypted(description={}, plaintext={})".format(self.description, self.plaintext)

    def __eq__(self, other):
        if self.description != other.description:
            return False
        if self.plaintext != other.plaintext:
            return False
        return True

class _UniffiConverterTypeAesSuccessActionDataDecrypted(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AesSuccessActionDataDecrypted(
            description=_UniffiConverterString.read(buf),
            plaintext=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.description)
        _UniffiConverterString.check_lower(value.plaintext)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.description, buf)
        _UniffiConverterString.write(value.plaintext, buf)


class AssetBalance:
    asset_id: "str"
    balance_sat: "int"
    name: "typing.Optional[str]"
    ticker: "typing.Optional[str]"
    balance: "typing.Optional[float]"
    def __init__(self, *, asset_id: "str", balance_sat: "int", name: "typing.Optional[str]", ticker: "typing.Optional[str]", balance: "typing.Optional[float]"):
        self.asset_id = asset_id
        self.balance_sat = balance_sat
        self.name = name
        self.ticker = ticker
        self.balance = balance

    def __str__(self):
        return "AssetBalance(asset_id={}, balance_sat={}, name={}, ticker={}, balance={})".format(self.asset_id, self.balance_sat, self.name, self.ticker, self.balance)

    def __eq__(self, other):
        if self.asset_id != other.asset_id:
            return False
        if self.balance_sat != other.balance_sat:
            return False
        if self.name != other.name:
            return False
        if self.ticker != other.ticker:
            return False
        if self.balance != other.balance:
            return False
        return True

class _UniffiConverterTypeAssetBalance(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AssetBalance(
            asset_id=_UniffiConverterString.read(buf),
            balance_sat=_UniffiConverterUInt64.read(buf),
            name=_UniffiConverterOptionalString.read(buf),
            ticker=_UniffiConverterOptionalString.read(buf),
            balance=_UniffiConverterOptionalDouble.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.asset_id)
        _UniffiConverterUInt64.check_lower(value.balance_sat)
        _UniffiConverterOptionalString.check_lower(value.name)
        _UniffiConverterOptionalString.check_lower(value.ticker)
        _UniffiConverterOptionalDouble.check_lower(value.balance)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.asset_id, buf)
        _UniffiConverterUInt64.write(value.balance_sat, buf)
        _UniffiConverterOptionalString.write(value.name, buf)
        _UniffiConverterOptionalString.write(value.ticker, buf)
        _UniffiConverterOptionalDouble.write(value.balance, buf)


class AssetInfo:
    name: "str"
    ticker: "str"
    amount: "float"
    def __init__(self, *, name: "str", ticker: "str", amount: "float"):
        self.name = name
        self.ticker = ticker
        self.amount = amount

    def __str__(self):
        return "AssetInfo(name={}, ticker={}, amount={})".format(self.name, self.ticker, self.amount)

    def __eq__(self, other):
        if self.name != other.name:
            return False
        if self.ticker != other.ticker:
            return False
        if self.amount != other.amount:
            return False
        return True

class _UniffiConverterTypeAssetInfo(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AssetInfo(
            name=_UniffiConverterString.read(buf),
            ticker=_UniffiConverterString.read(buf),
            amount=_UniffiConverterDouble.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.name)
        _UniffiConverterString.check_lower(value.ticker)
        _UniffiConverterDouble.check_lower(value.amount)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.name, buf)
        _UniffiConverterString.write(value.ticker, buf)
        _UniffiConverterDouble.write(value.amount, buf)


class AssetMetadata:
    asset_id: "str"
    name: "str"
    ticker: "str"
    precision: "int"
    def __init__(self, *, asset_id: "str", name: "str", ticker: "str", precision: "int"):
        self.asset_id = asset_id
        self.name = name
        self.ticker = ticker
        self.precision = precision

    def __str__(self):
        return "AssetMetadata(asset_id={}, name={}, ticker={}, precision={})".format(self.asset_id, self.name, self.ticker, self.precision)

    def __eq__(self, other):
        if self.asset_id != other.asset_id:
            return False
        if self.name != other.name:
            return False
        if self.ticker != other.ticker:
            return False
        if self.precision != other.precision:
            return False
        return True

class _UniffiConverterTypeAssetMetadata(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return AssetMetadata(
            asset_id=_UniffiConverterString.read(buf),
            name=_UniffiConverterString.read(buf),
            ticker=_UniffiConverterString.read(buf),
            precision=_UniffiConverterUInt8.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.asset_id)
        _UniffiConverterString.check_lower(value.name)
        _UniffiConverterString.check_lower(value.ticker)
        _UniffiConverterUInt8.check_lower(value.precision)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.asset_id, buf)
        _UniffiConverterString.write(value.name, buf)
        _UniffiConverterString.write(value.ticker, buf)
        _UniffiConverterUInt8.write(value.precision, buf)


class BackupRequest:
    backup_path: "typing.Optional[str]"
    def __init__(self, *, backup_path: "typing.Optional[str]" = _DEFAULT):
        if backup_path is _DEFAULT:
            self.backup_path = None
        else:
            self.backup_path = backup_path

    def __str__(self):
        return "BackupRequest(backup_path={})".format(self.backup_path)

    def __eq__(self, other):
        if self.backup_path != other.backup_path:
            return False
        return True

class _UniffiConverterTypeBackupRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return BackupRequest(
            backup_path=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.backup_path)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.backup_path, buf)


class BitcoinAddressData:
    address: "str"
    network: "Network"
    amount_sat: "typing.Optional[int]"
    label: "typing.Optional[str]"
    message: "typing.Optional[str]"
    def __init__(self, *, address: "str", network: "Network", amount_sat: "typing.Optional[int]", label: "typing.Optional[str]", message: "typing.Optional[str]"):
        self.address = address
        self.network = network
        self.amount_sat = amount_sat
        self.label = label
        self.message = message

    def __str__(self):
        return "BitcoinAddressData(address={}, network={}, amount_sat={}, label={}, message={})".format(self.address, self.network, self.amount_sat, self.label, self.message)

    def __eq__(self, other):
        if self.address != other.address:
            return False
        if self.network != other.network:
            return False
        if self.amount_sat != other.amount_sat:
            return False
        if self.label != other.label:
            return False
        if self.message != other.message:
            return False
        return True

class _UniffiConverterTypeBitcoinAddressData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return BitcoinAddressData(
            address=_UniffiConverterString.read(buf),
            network=_UniffiConverterTypeNetwork.read(buf),
            amount_sat=_UniffiConverterOptionalUInt64.read(buf),
            label=_UniffiConverterOptionalString.read(buf),
            message=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.address)
        _UniffiConverterTypeNetwork.check_lower(value.network)
        _UniffiConverterOptionalUInt64.check_lower(value.amount_sat)
        _UniffiConverterOptionalString.check_lower(value.label)
        _UniffiConverterOptionalString.check_lower(value.message)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.address, buf)
        _UniffiConverterTypeNetwork.write(value.network, buf)
        _UniffiConverterOptionalUInt64.write(value.amount_sat, buf)
        _UniffiConverterOptionalString.write(value.label, buf)
        _UniffiConverterOptionalString.write(value.message, buf)


class BlockchainInfo:
    liquid_tip: "int"
    bitcoin_tip: "int"
    def __init__(self, *, liquid_tip: "int", bitcoin_tip: "int"):
        self.liquid_tip = liquid_tip
        self.bitcoin_tip = bitcoin_tip

    def __str__(self):
        return "BlockchainInfo(liquid_tip={}, bitcoin_tip={})".format(self.liquid_tip, self.bitcoin_tip)

    def __eq__(self, other):
        if self.liquid_tip != other.liquid_tip:
            return False
        if self.bitcoin_tip != other.bitcoin_tip:
            return False
        return True

class _UniffiConverterTypeBlockchainInfo(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return BlockchainInfo(
            liquid_tip=_UniffiConverterUInt32.read(buf),
            bitcoin_tip=_UniffiConverterUInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.liquid_tip)
        _UniffiConverterUInt32.check_lower(value.bitcoin_tip)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.liquid_tip, buf)
        _UniffiConverterUInt32.write(value.bitcoin_tip, buf)


class BuyBitcoinRequest:
    prepare_response: "PrepareBuyBitcoinResponse"
    redirect_url: "typing.Optional[str]"
    def __init__(self, *, prepare_response: "PrepareBuyBitcoinResponse", redirect_url: "typing.Optional[str]" = _DEFAULT):
        self.prepare_response = prepare_response
        if redirect_url is _DEFAULT:
            self.redirect_url = None
        else:
            self.redirect_url = redirect_url

    def __str__(self):
        return "BuyBitcoinRequest(prepare_response={}, redirect_url={})".format(self.prepare_response, self.redirect_url)

    def __eq__(self, other):
        if self.prepare_response != other.prepare_response:
            return False
        if self.redirect_url != other.redirect_url:
            return False
        return True

class _UniffiConverterTypeBuyBitcoinRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return BuyBitcoinRequest(
            prepare_response=_UniffiConverterTypePrepareBuyBitcoinResponse.read(buf),
            redirect_url=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePrepareBuyBitcoinResponse.check_lower(value.prepare_response)
        _UniffiConverterOptionalString.check_lower(value.redirect_url)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePrepareBuyBitcoinResponse.write(value.prepare_response, buf)
        _UniffiConverterOptionalString.write(value.redirect_url, buf)


class CheckMessageRequest:
    message: "str"
    pubkey: "str"
    signature: "str"
    def __init__(self, *, message: "str", pubkey: "str", signature: "str"):
        self.message = message
        self.pubkey = pubkey
        self.signature = signature

    def __str__(self):
        return "CheckMessageRequest(message={}, pubkey={}, signature={})".format(self.message, self.pubkey, self.signature)

    def __eq__(self, other):
        if self.message != other.message:
            return False
        if self.pubkey != other.pubkey:
            return False
        if self.signature != other.signature:
            return False
        return True

class _UniffiConverterTypeCheckMessageRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return CheckMessageRequest(
            message=_UniffiConverterString.read(buf),
            pubkey=_UniffiConverterString.read(buf),
            signature=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.message)
        _UniffiConverterString.check_lower(value.pubkey)
        _UniffiConverterString.check_lower(value.signature)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.message, buf)
        _UniffiConverterString.write(value.pubkey, buf)
        _UniffiConverterString.write(value.signature, buf)


class CheckMessageResponse:
    is_valid: "bool"
    def __init__(self, *, is_valid: "bool"):
        self.is_valid = is_valid

    def __str__(self):
        return "CheckMessageResponse(is_valid={})".format(self.is_valid)

    def __eq__(self, other):
        if self.is_valid != other.is_valid:
            return False
        return True

class _UniffiConverterTypeCheckMessageResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return CheckMessageResponse(
            is_valid=_UniffiConverterBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterBool.check_lower(value.is_valid)

    @staticmethod
    def write(value, buf):
        _UniffiConverterBool.write(value.is_valid, buf)


class Config:
    liquid_electrum_url: "str"
    bitcoin_electrum_url: "str"
    mempoolspace_url: "str"
    working_dir: "str"
    network: "LiquidNetwork"
    payment_timeout_sec: "int"
    sync_service_url: "typing.Optional[str]"
    breez_api_key: "typing.Optional[str]"
    cache_dir: "typing.Optional[str]"
    zero_conf_max_amount_sat: "typing.Optional[int]"
    use_default_external_input_parsers: "bool"
    external_input_parsers: "typing.Optional[typing.List[ExternalInputParser]]"
    onchain_fee_rate_leeway_sat_per_vbyte: "typing.Optional[int]"
    asset_metadata: "typing.Optional[typing.List[AssetMetadata]]"
    def __init__(self, *, liquid_electrum_url: "str", bitcoin_electrum_url: "str", mempoolspace_url: "str", working_dir: "str", network: "LiquidNetwork", payment_timeout_sec: "int", sync_service_url: "typing.Optional[str]", breez_api_key: "typing.Optional[str]", cache_dir: "typing.Optional[str]", zero_conf_max_amount_sat: "typing.Optional[int]", use_default_external_input_parsers: "bool" = _DEFAULT, external_input_parsers: "typing.Optional[typing.List[ExternalInputParser]]" = _DEFAULT, onchain_fee_rate_leeway_sat_per_vbyte: "typing.Optional[int]" = _DEFAULT, asset_metadata: "typing.Optional[typing.List[AssetMetadata]]" = _DEFAULT):
        self.liquid_electrum_url = liquid_electrum_url
        self.bitcoin_electrum_url = bitcoin_electrum_url
        self.mempoolspace_url = mempoolspace_url
        self.working_dir = working_dir
        self.network = network
        self.payment_timeout_sec = payment_timeout_sec
        self.sync_service_url = sync_service_url
        self.breez_api_key = breez_api_key
        self.cache_dir = cache_dir
        self.zero_conf_max_amount_sat = zero_conf_max_amount_sat
        if use_default_external_input_parsers is _DEFAULT:
            self.use_default_external_input_parsers = True
        else:
            self.use_default_external_input_parsers = use_default_external_input_parsers
        if external_input_parsers is _DEFAULT:
            self.external_input_parsers = None
        else:
            self.external_input_parsers = external_input_parsers
        if onchain_fee_rate_leeway_sat_per_vbyte is _DEFAULT:
            self.onchain_fee_rate_leeway_sat_per_vbyte = None
        else:
            self.onchain_fee_rate_leeway_sat_per_vbyte = onchain_fee_rate_leeway_sat_per_vbyte
        if asset_metadata is _DEFAULT:
            self.asset_metadata = None
        else:
            self.asset_metadata = asset_metadata

    def __str__(self):
        return "Config(liquid_electrum_url={}, bitcoin_electrum_url={}, mempoolspace_url={}, working_dir={}, network={}, payment_timeout_sec={}, sync_service_url={}, breez_api_key={}, cache_dir={}, zero_conf_max_amount_sat={}, use_default_external_input_parsers={}, external_input_parsers={}, onchain_fee_rate_leeway_sat_per_vbyte={}, asset_metadata={})".format(self.liquid_electrum_url, self.bitcoin_electrum_url, self.mempoolspace_url, self.working_dir, self.network, self.payment_timeout_sec, self.sync_service_url, self.breez_api_key, self.cache_dir, self.zero_conf_max_amount_sat, self.use_default_external_input_parsers, self.external_input_parsers, self.onchain_fee_rate_leeway_sat_per_vbyte, self.asset_metadata)

    def __eq__(self, other):
        if self.liquid_electrum_url != other.liquid_electrum_url:
            return False
        if self.bitcoin_electrum_url != other.bitcoin_electrum_url:
            return False
        if self.mempoolspace_url != other.mempoolspace_url:
            return False
        if self.working_dir != other.working_dir:
            return False
        if self.network != other.network:
            return False
        if self.payment_timeout_sec != other.payment_timeout_sec:
            return False
        if self.sync_service_url != other.sync_service_url:
            return False
        if self.breez_api_key != other.breez_api_key:
            return False
        if self.cache_dir != other.cache_dir:
            return False
        if self.zero_conf_max_amount_sat != other.zero_conf_max_amount_sat:
            return False
        if self.use_default_external_input_parsers != other.use_default_external_input_parsers:
            return False
        if self.external_input_parsers != other.external_input_parsers:
            return False
        if self.onchain_fee_rate_leeway_sat_per_vbyte != other.onchain_fee_rate_leeway_sat_per_vbyte:
            return False
        if self.asset_metadata != other.asset_metadata:
            return False
        return True

class _UniffiConverterTypeConfig(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Config(
            liquid_electrum_url=_UniffiConverterString.read(buf),
            bitcoin_electrum_url=_UniffiConverterString.read(buf),
            mempoolspace_url=_UniffiConverterString.read(buf),
            working_dir=_UniffiConverterString.read(buf),
            network=_UniffiConverterTypeLiquidNetwork.read(buf),
            payment_timeout_sec=_UniffiConverterUInt64.read(buf),
            sync_service_url=_UniffiConverterOptionalString.read(buf),
            breez_api_key=_UniffiConverterOptionalString.read(buf),
            cache_dir=_UniffiConverterOptionalString.read(buf),
            zero_conf_max_amount_sat=_UniffiConverterOptionalUInt64.read(buf),
            use_default_external_input_parsers=_UniffiConverterBool.read(buf),
            external_input_parsers=_UniffiConverterOptionalSequenceTypeExternalInputParser.read(buf),
            onchain_fee_rate_leeway_sat_per_vbyte=_UniffiConverterOptionalUInt32.read(buf),
            asset_metadata=_UniffiConverterOptionalSequenceTypeAssetMetadata.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.liquid_electrum_url)
        _UniffiConverterString.check_lower(value.bitcoin_electrum_url)
        _UniffiConverterString.check_lower(value.mempoolspace_url)
        _UniffiConverterString.check_lower(value.working_dir)
        _UniffiConverterTypeLiquidNetwork.check_lower(value.network)
        _UniffiConverterUInt64.check_lower(value.payment_timeout_sec)
        _UniffiConverterOptionalString.check_lower(value.sync_service_url)
        _UniffiConverterOptionalString.check_lower(value.breez_api_key)
        _UniffiConverterOptionalString.check_lower(value.cache_dir)
        _UniffiConverterOptionalUInt64.check_lower(value.zero_conf_max_amount_sat)
        _UniffiConverterBool.check_lower(value.use_default_external_input_parsers)
        _UniffiConverterOptionalSequenceTypeExternalInputParser.check_lower(value.external_input_parsers)
        _UniffiConverterOptionalUInt32.check_lower(value.onchain_fee_rate_leeway_sat_per_vbyte)
        _UniffiConverterOptionalSequenceTypeAssetMetadata.check_lower(value.asset_metadata)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.liquid_electrum_url, buf)
        _UniffiConverterString.write(value.bitcoin_electrum_url, buf)
        _UniffiConverterString.write(value.mempoolspace_url, buf)
        _UniffiConverterString.write(value.working_dir, buf)
        _UniffiConverterTypeLiquidNetwork.write(value.network, buf)
        _UniffiConverterUInt64.write(value.payment_timeout_sec, buf)
        _UniffiConverterOptionalString.write(value.sync_service_url, buf)
        _UniffiConverterOptionalString.write(value.breez_api_key, buf)
        _UniffiConverterOptionalString.write(value.cache_dir, buf)
        _UniffiConverterOptionalUInt64.write(value.zero_conf_max_amount_sat, buf)
        _UniffiConverterBool.write(value.use_default_external_input_parsers, buf)
        _UniffiConverterOptionalSequenceTypeExternalInputParser.write(value.external_input_parsers, buf)
        _UniffiConverterOptionalUInt32.write(value.onchain_fee_rate_leeway_sat_per_vbyte, buf)
        _UniffiConverterOptionalSequenceTypeAssetMetadata.write(value.asset_metadata, buf)


class ConnectRequest:
    config: "Config"
    mnemonic: "typing.Optional[str]"
    passphrase: "typing.Optional[str]"
    seed: "typing.Optional[typing.List[int]]"
    def __init__(self, *, config: "Config", mnemonic: "typing.Optional[str]" = _DEFAULT, passphrase: "typing.Optional[str]" = _DEFAULT, seed: "typing.Optional[typing.List[int]]" = _DEFAULT):
        self.config = config
        if mnemonic is _DEFAULT:
            self.mnemonic = None
        else:
            self.mnemonic = mnemonic
        if passphrase is _DEFAULT:
            self.passphrase = None
        else:
            self.passphrase = passphrase
        if seed is _DEFAULT:
            self.seed = None
        else:
            self.seed = seed

    def __str__(self):
        return "ConnectRequest(config={}, mnemonic={}, passphrase={}, seed={})".format(self.config, self.mnemonic, self.passphrase, self.seed)

    def __eq__(self, other):
        if self.config != other.config:
            return False
        if self.mnemonic != other.mnemonic:
            return False
        if self.passphrase != other.passphrase:
            return False
        if self.seed != other.seed:
            return False
        return True

class _UniffiConverterTypeConnectRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ConnectRequest(
            config=_UniffiConverterTypeConfig.read(buf),
            mnemonic=_UniffiConverterOptionalString.read(buf),
            passphrase=_UniffiConverterOptionalString.read(buf),
            seed=_UniffiConverterOptionalSequenceUInt8.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeConfig.check_lower(value.config)
        _UniffiConverterOptionalString.check_lower(value.mnemonic)
        _UniffiConverterOptionalString.check_lower(value.passphrase)
        _UniffiConverterOptionalSequenceUInt8.check_lower(value.seed)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeConfig.write(value.config, buf)
        _UniffiConverterOptionalString.write(value.mnemonic, buf)
        _UniffiConverterOptionalString.write(value.passphrase, buf)
        _UniffiConverterOptionalSequenceUInt8.write(value.seed, buf)


class ConnectWithSignerRequest:
    config: "Config"
    def __init__(self, *, config: "Config"):
        self.config = config

    def __str__(self):
        return "ConnectWithSignerRequest(config={})".format(self.config)

    def __eq__(self, other):
        if self.config != other.config:
            return False
        return True

class _UniffiConverterTypeConnectWithSignerRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ConnectWithSignerRequest(
            config=_UniffiConverterTypeConfig.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeConfig.check_lower(value.config)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeConfig.write(value.config, buf)


class CurrencyInfo:
    name: "str"
    fraction_size: "int"
    spacing: "typing.Optional[int]"
    symbol: "typing.Optional[Symbol]"
    uniq_symbol: "typing.Optional[Symbol]"
    localized_name: "typing.List[LocalizedName]"
    locale_overrides: "typing.List[LocaleOverrides]"
    def __init__(self, *, name: "str", fraction_size: "int", spacing: "typing.Optional[int]", symbol: "typing.Optional[Symbol]", uniq_symbol: "typing.Optional[Symbol]", localized_name: "typing.List[LocalizedName]", locale_overrides: "typing.List[LocaleOverrides]"):
        self.name = name
        self.fraction_size = fraction_size
        self.spacing = spacing
        self.symbol = symbol
        self.uniq_symbol = uniq_symbol
        self.localized_name = localized_name
        self.locale_overrides = locale_overrides

    def __str__(self):
        return "CurrencyInfo(name={}, fraction_size={}, spacing={}, symbol={}, uniq_symbol={}, localized_name={}, locale_overrides={})".format(self.name, self.fraction_size, self.spacing, self.symbol, self.uniq_symbol, self.localized_name, self.locale_overrides)

    def __eq__(self, other):
        if self.name != other.name:
            return False
        if self.fraction_size != other.fraction_size:
            return False
        if self.spacing != other.spacing:
            return False
        if self.symbol != other.symbol:
            return False
        if self.uniq_symbol != other.uniq_symbol:
            return False
        if self.localized_name != other.localized_name:
            return False
        if self.locale_overrides != other.locale_overrides:
            return False
        return True

class _UniffiConverterTypeCurrencyInfo(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return CurrencyInfo(
            name=_UniffiConverterString.read(buf),
            fraction_size=_UniffiConverterUInt32.read(buf),
            spacing=_UniffiConverterOptionalUInt32.read(buf),
            symbol=_UniffiConverterOptionalTypeSymbol.read(buf),
            uniq_symbol=_UniffiConverterOptionalTypeSymbol.read(buf),
            localized_name=_UniffiConverterSequenceTypeLocalizedName.read(buf),
            locale_overrides=_UniffiConverterSequenceTypeLocaleOverrides.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.name)
        _UniffiConverterUInt32.check_lower(value.fraction_size)
        _UniffiConverterOptionalUInt32.check_lower(value.spacing)
        _UniffiConverterOptionalTypeSymbol.check_lower(value.symbol)
        _UniffiConverterOptionalTypeSymbol.check_lower(value.uniq_symbol)
        _UniffiConverterSequenceTypeLocalizedName.check_lower(value.localized_name)
        _UniffiConverterSequenceTypeLocaleOverrides.check_lower(value.locale_overrides)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.name, buf)
        _UniffiConverterUInt32.write(value.fraction_size, buf)
        _UniffiConverterOptionalUInt32.write(value.spacing, buf)
        _UniffiConverterOptionalTypeSymbol.write(value.symbol, buf)
        _UniffiConverterOptionalTypeSymbol.write(value.uniq_symbol, buf)
        _UniffiConverterSequenceTypeLocalizedName.write(value.localized_name, buf)
        _UniffiConverterSequenceTypeLocaleOverrides.write(value.locale_overrides, buf)


class ExternalInputParser:
    provider_id: "str"
    input_regex: "str"
    parser_url: "str"
    def __init__(self, *, provider_id: "str", input_regex: "str", parser_url: "str"):
        self.provider_id = provider_id
        self.input_regex = input_regex
        self.parser_url = parser_url

    def __str__(self):
        return "ExternalInputParser(provider_id={}, input_regex={}, parser_url={})".format(self.provider_id, self.input_regex, self.parser_url)

    def __eq__(self, other):
        if self.provider_id != other.provider_id:
            return False
        if self.input_regex != other.input_regex:
            return False
        if self.parser_url != other.parser_url:
            return False
        return True

class _UniffiConverterTypeExternalInputParser(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ExternalInputParser(
            provider_id=_UniffiConverterString.read(buf),
            input_regex=_UniffiConverterString.read(buf),
            parser_url=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.provider_id)
        _UniffiConverterString.check_lower(value.input_regex)
        _UniffiConverterString.check_lower(value.parser_url)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.provider_id, buf)
        _UniffiConverterString.write(value.input_regex, buf)
        _UniffiConverterString.write(value.parser_url, buf)


class FetchPaymentProposedFeesRequest:
    swap_id: "str"
    def __init__(self, *, swap_id: "str"):
        self.swap_id = swap_id

    def __str__(self):
        return "FetchPaymentProposedFeesRequest(swap_id={})".format(self.swap_id)

    def __eq__(self, other):
        if self.swap_id != other.swap_id:
            return False
        return True

class _UniffiConverterTypeFetchPaymentProposedFeesRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return FetchPaymentProposedFeesRequest(
            swap_id=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.swap_id)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.swap_id, buf)


class FetchPaymentProposedFeesResponse:
    swap_id: "str"
    fees_sat: "int"
    payer_amount_sat: "int"
    receiver_amount_sat: "int"
    def __init__(self, *, swap_id: "str", fees_sat: "int", payer_amount_sat: "int", receiver_amount_sat: "int"):
        self.swap_id = swap_id
        self.fees_sat = fees_sat
        self.payer_amount_sat = payer_amount_sat
        self.receiver_amount_sat = receiver_amount_sat

    def __str__(self):
        return "FetchPaymentProposedFeesResponse(swap_id={}, fees_sat={}, payer_amount_sat={}, receiver_amount_sat={})".format(self.swap_id, self.fees_sat, self.payer_amount_sat, self.receiver_amount_sat)

    def __eq__(self, other):
        if self.swap_id != other.swap_id:
            return False
        if self.fees_sat != other.fees_sat:
            return False
        if self.payer_amount_sat != other.payer_amount_sat:
            return False
        if self.receiver_amount_sat != other.receiver_amount_sat:
            return False
        return True

class _UniffiConverterTypeFetchPaymentProposedFeesResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return FetchPaymentProposedFeesResponse(
            swap_id=_UniffiConverterString.read(buf),
            fees_sat=_UniffiConverterUInt64.read(buf),
            payer_amount_sat=_UniffiConverterUInt64.read(buf),
            receiver_amount_sat=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.swap_id)
        _UniffiConverterUInt64.check_lower(value.fees_sat)
        _UniffiConverterUInt64.check_lower(value.payer_amount_sat)
        _UniffiConverterUInt64.check_lower(value.receiver_amount_sat)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.swap_id, buf)
        _UniffiConverterUInt64.write(value.fees_sat, buf)
        _UniffiConverterUInt64.write(value.payer_amount_sat, buf)
        _UniffiConverterUInt64.write(value.receiver_amount_sat, buf)


class FiatCurrency:
    id: "str"
    info: "CurrencyInfo"
    def __init__(self, *, id: "str", info: "CurrencyInfo"):
        self.id = id
        self.info = info

    def __str__(self):
        return "FiatCurrency(id={}, info={})".format(self.id, self.info)

    def __eq__(self, other):
        if self.id != other.id:
            return False
        if self.info != other.info:
            return False
        return True

class _UniffiConverterTypeFiatCurrency(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return FiatCurrency(
            id=_UniffiConverterString.read(buf),
            info=_UniffiConverterTypeCurrencyInfo.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.id)
        _UniffiConverterTypeCurrencyInfo.check_lower(value.info)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.id, buf)
        _UniffiConverterTypeCurrencyInfo.write(value.info, buf)


class GetInfoResponse:
    wallet_info: "WalletInfo"
    blockchain_info: "BlockchainInfo"
    def __init__(self, *, wallet_info: "WalletInfo", blockchain_info: "BlockchainInfo"):
        self.wallet_info = wallet_info
        self.blockchain_info = blockchain_info

    def __str__(self):
        return "GetInfoResponse(wallet_info={}, blockchain_info={})".format(self.wallet_info, self.blockchain_info)

    def __eq__(self, other):
        if self.wallet_info != other.wallet_info:
            return False
        if self.blockchain_info != other.blockchain_info:
            return False
        return True

class _UniffiConverterTypeGetInfoResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return GetInfoResponse(
            wallet_info=_UniffiConverterTypeWalletInfo.read(buf),
            blockchain_info=_UniffiConverterTypeBlockchainInfo.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeWalletInfo.check_lower(value.wallet_info)
        _UniffiConverterTypeBlockchainInfo.check_lower(value.blockchain_info)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeWalletInfo.write(value.wallet_info, buf)
        _UniffiConverterTypeBlockchainInfo.write(value.blockchain_info, buf)


class LightningPaymentLimitsResponse:
    send: "Limits"
    receive: "Limits"
    def __init__(self, *, send: "Limits", receive: "Limits"):
        self.send = send
        self.receive = receive

    def __str__(self):
        return "LightningPaymentLimitsResponse(send={}, receive={})".format(self.send, self.receive)

    def __eq__(self, other):
        if self.send != other.send:
            return False
        if self.receive != other.receive:
            return False
        return True

class _UniffiConverterTypeLightningPaymentLimitsResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LightningPaymentLimitsResponse(
            send=_UniffiConverterTypeLimits.read(buf),
            receive=_UniffiConverterTypeLimits.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeLimits.check_lower(value.send)
        _UniffiConverterTypeLimits.check_lower(value.receive)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeLimits.write(value.send, buf)
        _UniffiConverterTypeLimits.write(value.receive, buf)


class Limits:
    min_sat: "int"
    max_sat: "int"
    max_zero_conf_sat: "int"
    def __init__(self, *, min_sat: "int", max_sat: "int", max_zero_conf_sat: "int"):
        self.min_sat = min_sat
        self.max_sat = max_sat
        self.max_zero_conf_sat = max_zero_conf_sat

    def __str__(self):
        return "Limits(min_sat={}, max_sat={}, max_zero_conf_sat={})".format(self.min_sat, self.max_sat, self.max_zero_conf_sat)

    def __eq__(self, other):
        if self.min_sat != other.min_sat:
            return False
        if self.max_sat != other.max_sat:
            return False
        if self.max_zero_conf_sat != other.max_zero_conf_sat:
            return False
        return True

class _UniffiConverterTypeLimits(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Limits(
            min_sat=_UniffiConverterUInt64.read(buf),
            max_sat=_UniffiConverterUInt64.read(buf),
            max_zero_conf_sat=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt64.check_lower(value.min_sat)
        _UniffiConverterUInt64.check_lower(value.max_sat)
        _UniffiConverterUInt64.check_lower(value.max_zero_conf_sat)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt64.write(value.min_sat, buf)
        _UniffiConverterUInt64.write(value.max_sat, buf)
        _UniffiConverterUInt64.write(value.max_zero_conf_sat, buf)


class LiquidAddressData:
    address: "str"
    network: "Network"
    asset_id: "typing.Optional[str]"
    amount: "typing.Optional[float]"
    amount_sat: "typing.Optional[int]"
    label: "typing.Optional[str]"
    message: "typing.Optional[str]"
    def __init__(self, *, address: "str", network: "Network", asset_id: "typing.Optional[str]", amount: "typing.Optional[float]", amount_sat: "typing.Optional[int]", label: "typing.Optional[str]", message: "typing.Optional[str]"):
        self.address = address
        self.network = network
        self.asset_id = asset_id
        self.amount = amount
        self.amount_sat = amount_sat
        self.label = label
        self.message = message

    def __str__(self):
        return "LiquidAddressData(address={}, network={}, asset_id={}, amount={}, amount_sat={}, label={}, message={})".format(self.address, self.network, self.asset_id, self.amount, self.amount_sat, self.label, self.message)

    def __eq__(self, other):
        if self.address != other.address:
            return False
        if self.network != other.network:
            return False
        if self.asset_id != other.asset_id:
            return False
        if self.amount != other.amount:
            return False
        if self.amount_sat != other.amount_sat:
            return False
        if self.label != other.label:
            return False
        if self.message != other.message:
            return False
        return True

class _UniffiConverterTypeLiquidAddressData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LiquidAddressData(
            address=_UniffiConverterString.read(buf),
            network=_UniffiConverterTypeNetwork.read(buf),
            asset_id=_UniffiConverterOptionalString.read(buf),
            amount=_UniffiConverterOptionalDouble.read(buf),
            amount_sat=_UniffiConverterOptionalUInt64.read(buf),
            label=_UniffiConverterOptionalString.read(buf),
            message=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.address)
        _UniffiConverterTypeNetwork.check_lower(value.network)
        _UniffiConverterOptionalString.check_lower(value.asset_id)
        _UniffiConverterOptionalDouble.check_lower(value.amount)
        _UniffiConverterOptionalUInt64.check_lower(value.amount_sat)
        _UniffiConverterOptionalString.check_lower(value.label)
        _UniffiConverterOptionalString.check_lower(value.message)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.address, buf)
        _UniffiConverterTypeNetwork.write(value.network, buf)
        _UniffiConverterOptionalString.write(value.asset_id, buf)
        _UniffiConverterOptionalDouble.write(value.amount, buf)
        _UniffiConverterOptionalUInt64.write(value.amount_sat, buf)
        _UniffiConverterOptionalString.write(value.label, buf)
        _UniffiConverterOptionalString.write(value.message, buf)


class ListPaymentsRequest:
    filters: "typing.Optional[typing.List[PaymentType]]"
    states: "typing.Optional[typing.List[PaymentState]]"
    from_timestamp: "typing.Optional[int]"
    to_timestamp: "typing.Optional[int]"
    offset: "typing.Optional[int]"
    limit: "typing.Optional[int]"
    details: "typing.Optional[ListPaymentDetails]"
    sort_ascending: "typing.Optional[bool]"
    def __init__(self, *, filters: "typing.Optional[typing.List[PaymentType]]" = _DEFAULT, states: "typing.Optional[typing.List[PaymentState]]" = _DEFAULT, from_timestamp: "typing.Optional[int]" = _DEFAULT, to_timestamp: "typing.Optional[int]" = _DEFAULT, offset: "typing.Optional[int]" = _DEFAULT, limit: "typing.Optional[int]" = _DEFAULT, details: "typing.Optional[ListPaymentDetails]" = _DEFAULT, sort_ascending: "typing.Optional[bool]" = _DEFAULT):
        if filters is _DEFAULT:
            self.filters = None
        else:
            self.filters = filters
        if states is _DEFAULT:
            self.states = None
        else:
            self.states = states
        if from_timestamp is _DEFAULT:
            self.from_timestamp = None
        else:
            self.from_timestamp = from_timestamp
        if to_timestamp is _DEFAULT:
            self.to_timestamp = None
        else:
            self.to_timestamp = to_timestamp
        if offset is _DEFAULT:
            self.offset = None
        else:
            self.offset = offset
        if limit is _DEFAULT:
            self.limit = None
        else:
            self.limit = limit
        if details is _DEFAULT:
            self.details = None
        else:
            self.details = details
        if sort_ascending is _DEFAULT:
            self.sort_ascending = None
        else:
            self.sort_ascending = sort_ascending

    def __str__(self):
        return "ListPaymentsRequest(filters={}, states={}, from_timestamp={}, to_timestamp={}, offset={}, limit={}, details={}, sort_ascending={})".format(self.filters, self.states, self.from_timestamp, self.to_timestamp, self.offset, self.limit, self.details, self.sort_ascending)

    def __eq__(self, other):
        if self.filters != other.filters:
            return False
        if self.states != other.states:
            return False
        if self.from_timestamp != other.from_timestamp:
            return False
        if self.to_timestamp != other.to_timestamp:
            return False
        if self.offset != other.offset:
            return False
        if self.limit != other.limit:
            return False
        if self.details != other.details:
            return False
        if self.sort_ascending != other.sort_ascending:
            return False
        return True

class _UniffiConverterTypeListPaymentsRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ListPaymentsRequest(
            filters=_UniffiConverterOptionalSequenceTypePaymentType.read(buf),
            states=_UniffiConverterOptionalSequenceTypePaymentState.read(buf),
            from_timestamp=_UniffiConverterOptionalInt64.read(buf),
            to_timestamp=_UniffiConverterOptionalInt64.read(buf),
            offset=_UniffiConverterOptionalUInt32.read(buf),
            limit=_UniffiConverterOptionalUInt32.read(buf),
            details=_UniffiConverterOptionalTypeListPaymentDetails.read(buf),
            sort_ascending=_UniffiConverterOptionalBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalSequenceTypePaymentType.check_lower(value.filters)
        _UniffiConverterOptionalSequenceTypePaymentState.check_lower(value.states)
        _UniffiConverterOptionalInt64.check_lower(value.from_timestamp)
        _UniffiConverterOptionalInt64.check_lower(value.to_timestamp)
        _UniffiConverterOptionalUInt32.check_lower(value.offset)
        _UniffiConverterOptionalUInt32.check_lower(value.limit)
        _UniffiConverterOptionalTypeListPaymentDetails.check_lower(value.details)
        _UniffiConverterOptionalBool.check_lower(value.sort_ascending)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalSequenceTypePaymentType.write(value.filters, buf)
        _UniffiConverterOptionalSequenceTypePaymentState.write(value.states, buf)
        _UniffiConverterOptionalInt64.write(value.from_timestamp, buf)
        _UniffiConverterOptionalInt64.write(value.to_timestamp, buf)
        _UniffiConverterOptionalUInt32.write(value.offset, buf)
        _UniffiConverterOptionalUInt32.write(value.limit, buf)
        _UniffiConverterOptionalTypeListPaymentDetails.write(value.details, buf)
        _UniffiConverterOptionalBool.write(value.sort_ascending, buf)


class LnInvoice:
    """
    ///////////////////////////////
    """

    bolt11: "str"
    network: "Network"
    payee_pubkey: "str"
    payment_hash: "str"
    description: "typing.Optional[str]"
    description_hash: "typing.Optional[str]"
    amount_msat: "typing.Optional[int]"
    timestamp: "int"
    expiry: "int"
    routing_hints: "typing.List[RouteHint]"
    payment_secret: "typing.List[int]"
    min_final_cltv_expiry_delta: "int"
    def __init__(self, *, bolt11: "str", network: "Network", payee_pubkey: "str", payment_hash: "str", description: "typing.Optional[str]", description_hash: "typing.Optional[str]", amount_msat: "typing.Optional[int]", timestamp: "int", expiry: "int", routing_hints: "typing.List[RouteHint]", payment_secret: "typing.List[int]", min_final_cltv_expiry_delta: "int"):
        self.bolt11 = bolt11
        self.network = network
        self.payee_pubkey = payee_pubkey
        self.payment_hash = payment_hash
        self.description = description
        self.description_hash = description_hash
        self.amount_msat = amount_msat
        self.timestamp = timestamp
        self.expiry = expiry
        self.routing_hints = routing_hints
        self.payment_secret = payment_secret
        self.min_final_cltv_expiry_delta = min_final_cltv_expiry_delta

    def __str__(self):
        return "LnInvoice(bolt11={}, network={}, payee_pubkey={}, payment_hash={}, description={}, description_hash={}, amount_msat={}, timestamp={}, expiry={}, routing_hints={}, payment_secret={}, min_final_cltv_expiry_delta={})".format(self.bolt11, self.network, self.payee_pubkey, self.payment_hash, self.description, self.description_hash, self.amount_msat, self.timestamp, self.expiry, self.routing_hints, self.payment_secret, self.min_final_cltv_expiry_delta)

    def __eq__(self, other):
        if self.bolt11 != other.bolt11:
            return False
        if self.network != other.network:
            return False
        if self.payee_pubkey != other.payee_pubkey:
            return False
        if self.payment_hash != other.payment_hash:
            return False
        if self.description != other.description:
            return False
        if self.description_hash != other.description_hash:
            return False
        if self.amount_msat != other.amount_msat:
            return False
        if self.timestamp != other.timestamp:
            return False
        if self.expiry != other.expiry:
            return False
        if self.routing_hints != other.routing_hints:
            return False
        if self.payment_secret != other.payment_secret:
            return False
        if self.min_final_cltv_expiry_delta != other.min_final_cltv_expiry_delta:
            return False
        return True

class _UniffiConverterTypeLnInvoice(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnInvoice(
            bolt11=_UniffiConverterString.read(buf),
            network=_UniffiConverterTypeNetwork.read(buf),
            payee_pubkey=_UniffiConverterString.read(buf),
            payment_hash=_UniffiConverterString.read(buf),
            description=_UniffiConverterOptionalString.read(buf),
            description_hash=_UniffiConverterOptionalString.read(buf),
            amount_msat=_UniffiConverterOptionalUInt64.read(buf),
            timestamp=_UniffiConverterUInt64.read(buf),
            expiry=_UniffiConverterUInt64.read(buf),
            routing_hints=_UniffiConverterSequenceTypeRouteHint.read(buf),
            payment_secret=_UniffiConverterSequenceUInt8.read(buf),
            min_final_cltv_expiry_delta=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.bolt11)
        _UniffiConverterTypeNetwork.check_lower(value.network)
        _UniffiConverterString.check_lower(value.payee_pubkey)
        _UniffiConverterString.check_lower(value.payment_hash)
        _UniffiConverterOptionalString.check_lower(value.description)
        _UniffiConverterOptionalString.check_lower(value.description_hash)
        _UniffiConverterOptionalUInt64.check_lower(value.amount_msat)
        _UniffiConverterUInt64.check_lower(value.timestamp)
        _UniffiConverterUInt64.check_lower(value.expiry)
        _UniffiConverterSequenceTypeRouteHint.check_lower(value.routing_hints)
        _UniffiConverterSequenceUInt8.check_lower(value.payment_secret)
        _UniffiConverterUInt64.check_lower(value.min_final_cltv_expiry_delta)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.bolt11, buf)
        _UniffiConverterTypeNetwork.write(value.network, buf)
        _UniffiConverterString.write(value.payee_pubkey, buf)
        _UniffiConverterString.write(value.payment_hash, buf)
        _UniffiConverterOptionalString.write(value.description, buf)
        _UniffiConverterOptionalString.write(value.description_hash, buf)
        _UniffiConverterOptionalUInt64.write(value.amount_msat, buf)
        _UniffiConverterUInt64.write(value.timestamp, buf)
        _UniffiConverterUInt64.write(value.expiry, buf)
        _UniffiConverterSequenceTypeRouteHint.write(value.routing_hints, buf)
        _UniffiConverterSequenceUInt8.write(value.payment_secret, buf)
        _UniffiConverterUInt64.write(value.min_final_cltv_expiry_delta, buf)


class LnOffer:
    offer: "str"
    chains: "typing.List[str]"
    paths: "typing.List[LnOfferBlindedPath]"
    description: "typing.Optional[str]"
    signing_pubkey: "typing.Optional[str]"
    min_amount: "typing.Optional[Amount]"
    absolute_expiry: "typing.Optional[int]"
    issuer: "typing.Optional[str]"
    def __init__(self, *, offer: "str", chains: "typing.List[str]", paths: "typing.List[LnOfferBlindedPath]", description: "typing.Optional[str]", signing_pubkey: "typing.Optional[str]", min_amount: "typing.Optional[Amount]", absolute_expiry: "typing.Optional[int]", issuer: "typing.Optional[str]"):
        self.offer = offer
        self.chains = chains
        self.paths = paths
        self.description = description
        self.signing_pubkey = signing_pubkey
        self.min_amount = min_amount
        self.absolute_expiry = absolute_expiry
        self.issuer = issuer

    def __str__(self):
        return "LnOffer(offer={}, chains={}, paths={}, description={}, signing_pubkey={}, min_amount={}, absolute_expiry={}, issuer={})".format(self.offer, self.chains, self.paths, self.description, self.signing_pubkey, self.min_amount, self.absolute_expiry, self.issuer)

    def __eq__(self, other):
        if self.offer != other.offer:
            return False
        if self.chains != other.chains:
            return False
        if self.paths != other.paths:
            return False
        if self.description != other.description:
            return False
        if self.signing_pubkey != other.signing_pubkey:
            return False
        if self.min_amount != other.min_amount:
            return False
        if self.absolute_expiry != other.absolute_expiry:
            return False
        if self.issuer != other.issuer:
            return False
        return True

class _UniffiConverterTypeLnOffer(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnOffer(
            offer=_UniffiConverterString.read(buf),
            chains=_UniffiConverterSequenceString.read(buf),
            paths=_UniffiConverterSequenceTypeLnOfferBlindedPath.read(buf),
            description=_UniffiConverterOptionalString.read(buf),
            signing_pubkey=_UniffiConverterOptionalString.read(buf),
            min_amount=_UniffiConverterOptionalTypeAmount.read(buf),
            absolute_expiry=_UniffiConverterOptionalUInt64.read(buf),
            issuer=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.offer)
        _UniffiConverterSequenceString.check_lower(value.chains)
        _UniffiConverterSequenceTypeLnOfferBlindedPath.check_lower(value.paths)
        _UniffiConverterOptionalString.check_lower(value.description)
        _UniffiConverterOptionalString.check_lower(value.signing_pubkey)
        _UniffiConverterOptionalTypeAmount.check_lower(value.min_amount)
        _UniffiConverterOptionalUInt64.check_lower(value.absolute_expiry)
        _UniffiConverterOptionalString.check_lower(value.issuer)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.offer, buf)
        _UniffiConverterSequenceString.write(value.chains, buf)
        _UniffiConverterSequenceTypeLnOfferBlindedPath.write(value.paths, buf)
        _UniffiConverterOptionalString.write(value.description, buf)
        _UniffiConverterOptionalString.write(value.signing_pubkey, buf)
        _UniffiConverterOptionalTypeAmount.write(value.min_amount, buf)
        _UniffiConverterOptionalUInt64.write(value.absolute_expiry, buf)
        _UniffiConverterOptionalString.write(value.issuer, buf)


class LnOfferBlindedPath:
    blinded_hops: "typing.List[str]"
    def __init__(self, *, blinded_hops: "typing.List[str]"):
        self.blinded_hops = blinded_hops

    def __str__(self):
        return "LnOfferBlindedPath(blinded_hops={})".format(self.blinded_hops)

    def __eq__(self, other):
        if self.blinded_hops != other.blinded_hops:
            return False
        return True

class _UniffiConverterTypeLnOfferBlindedPath(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnOfferBlindedPath(
            blinded_hops=_UniffiConverterSequenceString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterSequenceString.check_lower(value.blinded_hops)

    @staticmethod
    def write(value, buf):
        _UniffiConverterSequenceString.write(value.blinded_hops, buf)


class LnUrlAuthRequestData:
    k1: "str"
    domain: "str"
    url: "str"
    action: "typing.Optional[str]"
    def __init__(self, *, k1: "str", domain: "str", url: "str", action: "typing.Optional[str]" = _DEFAULT):
        self.k1 = k1
        self.domain = domain
        self.url = url
        if action is _DEFAULT:
            self.action = None
        else:
            self.action = action

    def __str__(self):
        return "LnUrlAuthRequestData(k1={}, domain={}, url={}, action={})".format(self.k1, self.domain, self.url, self.action)

    def __eq__(self, other):
        if self.k1 != other.k1:
            return False
        if self.domain != other.domain:
            return False
        if self.url != other.url:
            return False
        if self.action != other.action:
            return False
        return True

class _UniffiConverterTypeLnUrlAuthRequestData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnUrlAuthRequestData(
            k1=_UniffiConverterString.read(buf),
            domain=_UniffiConverterString.read(buf),
            url=_UniffiConverterString.read(buf),
            action=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.k1)
        _UniffiConverterString.check_lower(value.domain)
        _UniffiConverterString.check_lower(value.url)
        _UniffiConverterOptionalString.check_lower(value.action)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.k1, buf)
        _UniffiConverterString.write(value.domain, buf)
        _UniffiConverterString.write(value.url, buf)
        _UniffiConverterOptionalString.write(value.action, buf)


class LnUrlErrorData:
    reason: "str"
    def __init__(self, *, reason: "str"):
        self.reason = reason

    def __str__(self):
        return "LnUrlErrorData(reason={})".format(self.reason)

    def __eq__(self, other):
        if self.reason != other.reason:
            return False
        return True

class _UniffiConverterTypeLnUrlErrorData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnUrlErrorData(
            reason=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.reason)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.reason, buf)


class LnUrlInfo:
    ln_address: "typing.Optional[str]"
    lnurl_pay_comment: "typing.Optional[str]"
    lnurl_pay_domain: "typing.Optional[str]"
    lnurl_pay_metadata: "typing.Optional[str]"
    lnurl_pay_success_action: "typing.Optional[SuccessActionProcessed]"
    lnurl_pay_unprocessed_success_action: "typing.Optional[SuccessAction]"
    lnurl_withdraw_endpoint: "typing.Optional[str]"
    def __init__(self, *, ln_address: "typing.Optional[str]", lnurl_pay_comment: "typing.Optional[str]", lnurl_pay_domain: "typing.Optional[str]", lnurl_pay_metadata: "typing.Optional[str]", lnurl_pay_success_action: "typing.Optional[SuccessActionProcessed]", lnurl_pay_unprocessed_success_action: "typing.Optional[SuccessAction]", lnurl_withdraw_endpoint: "typing.Optional[str]"):
        self.ln_address = ln_address
        self.lnurl_pay_comment = lnurl_pay_comment
        self.lnurl_pay_domain = lnurl_pay_domain
        self.lnurl_pay_metadata = lnurl_pay_metadata
        self.lnurl_pay_success_action = lnurl_pay_success_action
        self.lnurl_pay_unprocessed_success_action = lnurl_pay_unprocessed_success_action
        self.lnurl_withdraw_endpoint = lnurl_withdraw_endpoint

    def __str__(self):
        return "LnUrlInfo(ln_address={}, lnurl_pay_comment={}, lnurl_pay_domain={}, lnurl_pay_metadata={}, lnurl_pay_success_action={}, lnurl_pay_unprocessed_success_action={}, lnurl_withdraw_endpoint={})".format(self.ln_address, self.lnurl_pay_comment, self.lnurl_pay_domain, self.lnurl_pay_metadata, self.lnurl_pay_success_action, self.lnurl_pay_unprocessed_success_action, self.lnurl_withdraw_endpoint)

    def __eq__(self, other):
        if self.ln_address != other.ln_address:
            return False
        if self.lnurl_pay_comment != other.lnurl_pay_comment:
            return False
        if self.lnurl_pay_domain != other.lnurl_pay_domain:
            return False
        if self.lnurl_pay_metadata != other.lnurl_pay_metadata:
            return False
        if self.lnurl_pay_success_action != other.lnurl_pay_success_action:
            return False
        if self.lnurl_pay_unprocessed_success_action != other.lnurl_pay_unprocessed_success_action:
            return False
        if self.lnurl_withdraw_endpoint != other.lnurl_withdraw_endpoint:
            return False
        return True

class _UniffiConverterTypeLnUrlInfo(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnUrlInfo(
            ln_address=_UniffiConverterOptionalString.read(buf),
            lnurl_pay_comment=_UniffiConverterOptionalString.read(buf),
            lnurl_pay_domain=_UniffiConverterOptionalString.read(buf),
            lnurl_pay_metadata=_UniffiConverterOptionalString.read(buf),
            lnurl_pay_success_action=_UniffiConverterOptionalTypeSuccessActionProcessed.read(buf),
            lnurl_pay_unprocessed_success_action=_UniffiConverterOptionalTypeSuccessAction.read(buf),
            lnurl_withdraw_endpoint=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.ln_address)
        _UniffiConverterOptionalString.check_lower(value.lnurl_pay_comment)
        _UniffiConverterOptionalString.check_lower(value.lnurl_pay_domain)
        _UniffiConverterOptionalString.check_lower(value.lnurl_pay_metadata)
        _UniffiConverterOptionalTypeSuccessActionProcessed.check_lower(value.lnurl_pay_success_action)
        _UniffiConverterOptionalTypeSuccessAction.check_lower(value.lnurl_pay_unprocessed_success_action)
        _UniffiConverterOptionalString.check_lower(value.lnurl_withdraw_endpoint)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.ln_address, buf)
        _UniffiConverterOptionalString.write(value.lnurl_pay_comment, buf)
        _UniffiConverterOptionalString.write(value.lnurl_pay_domain, buf)
        _UniffiConverterOptionalString.write(value.lnurl_pay_metadata, buf)
        _UniffiConverterOptionalTypeSuccessActionProcessed.write(value.lnurl_pay_success_action, buf)
        _UniffiConverterOptionalTypeSuccessAction.write(value.lnurl_pay_unprocessed_success_action, buf)
        _UniffiConverterOptionalString.write(value.lnurl_withdraw_endpoint, buf)


class LnUrlPayErrorData:
    payment_hash: "str"
    reason: "str"
    def __init__(self, *, payment_hash: "str", reason: "str"):
        self.payment_hash = payment_hash
        self.reason = reason

    def __str__(self):
        return "LnUrlPayErrorData(payment_hash={}, reason={})".format(self.payment_hash, self.reason)

    def __eq__(self, other):
        if self.payment_hash != other.payment_hash:
            return False
        if self.reason != other.reason:
            return False
        return True

class _UniffiConverterTypeLnUrlPayErrorData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnUrlPayErrorData(
            payment_hash=_UniffiConverterString.read(buf),
            reason=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.payment_hash)
        _UniffiConverterString.check_lower(value.reason)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.payment_hash, buf)
        _UniffiConverterString.write(value.reason, buf)


class LnUrlPayRequest:
    prepare_response: "PrepareLnUrlPayResponse"
    def __init__(self, *, prepare_response: "PrepareLnUrlPayResponse"):
        self.prepare_response = prepare_response

    def __str__(self):
        return "LnUrlPayRequest(prepare_response={})".format(self.prepare_response)

    def __eq__(self, other):
        if self.prepare_response != other.prepare_response:
            return False
        return True

class _UniffiConverterTypeLnUrlPayRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnUrlPayRequest(
            prepare_response=_UniffiConverterTypePrepareLnUrlPayResponse.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePrepareLnUrlPayResponse.check_lower(value.prepare_response)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePrepareLnUrlPayResponse.write(value.prepare_response, buf)


class LnUrlPayRequestData:
    callback: "str"
    min_sendable: "int"
    max_sendable: "int"
    metadata_str: "str"
    comment_allowed: "int"
    domain: "str"
    allows_nostr: "bool"
    nostr_pubkey: "typing.Optional[str]"
    ln_address: "typing.Optional[str]"
    def __init__(self, *, callback: "str", min_sendable: "int", max_sendable: "int", metadata_str: "str", comment_allowed: "int", domain: "str", allows_nostr: "bool", nostr_pubkey: "typing.Optional[str]", ln_address: "typing.Optional[str]"):
        self.callback = callback
        self.min_sendable = min_sendable
        self.max_sendable = max_sendable
        self.metadata_str = metadata_str
        self.comment_allowed = comment_allowed
        self.domain = domain
        self.allows_nostr = allows_nostr
        self.nostr_pubkey = nostr_pubkey
        self.ln_address = ln_address

    def __str__(self):
        return "LnUrlPayRequestData(callback={}, min_sendable={}, max_sendable={}, metadata_str={}, comment_allowed={}, domain={}, allows_nostr={}, nostr_pubkey={}, ln_address={})".format(self.callback, self.min_sendable, self.max_sendable, self.metadata_str, self.comment_allowed, self.domain, self.allows_nostr, self.nostr_pubkey, self.ln_address)

    def __eq__(self, other):
        if self.callback != other.callback:
            return False
        if self.min_sendable != other.min_sendable:
            return False
        if self.max_sendable != other.max_sendable:
            return False
        if self.metadata_str != other.metadata_str:
            return False
        if self.comment_allowed != other.comment_allowed:
            return False
        if self.domain != other.domain:
            return False
        if self.allows_nostr != other.allows_nostr:
            return False
        if self.nostr_pubkey != other.nostr_pubkey:
            return False
        if self.ln_address != other.ln_address:
            return False
        return True

class _UniffiConverterTypeLnUrlPayRequestData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnUrlPayRequestData(
            callback=_UniffiConverterString.read(buf),
            min_sendable=_UniffiConverterUInt64.read(buf),
            max_sendable=_UniffiConverterUInt64.read(buf),
            metadata_str=_UniffiConverterString.read(buf),
            comment_allowed=_UniffiConverterUInt16.read(buf),
            domain=_UniffiConverterString.read(buf),
            allows_nostr=_UniffiConverterBool.read(buf),
            nostr_pubkey=_UniffiConverterOptionalString.read(buf),
            ln_address=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.callback)
        _UniffiConverterUInt64.check_lower(value.min_sendable)
        _UniffiConverterUInt64.check_lower(value.max_sendable)
        _UniffiConverterString.check_lower(value.metadata_str)
        _UniffiConverterUInt16.check_lower(value.comment_allowed)
        _UniffiConverterString.check_lower(value.domain)
        _UniffiConverterBool.check_lower(value.allows_nostr)
        _UniffiConverterOptionalString.check_lower(value.nostr_pubkey)
        _UniffiConverterOptionalString.check_lower(value.ln_address)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.callback, buf)
        _UniffiConverterUInt64.write(value.min_sendable, buf)
        _UniffiConverterUInt64.write(value.max_sendable, buf)
        _UniffiConverterString.write(value.metadata_str, buf)
        _UniffiConverterUInt16.write(value.comment_allowed, buf)
        _UniffiConverterString.write(value.domain, buf)
        _UniffiConverterBool.write(value.allows_nostr, buf)
        _UniffiConverterOptionalString.write(value.nostr_pubkey, buf)
        _UniffiConverterOptionalString.write(value.ln_address, buf)


class LnUrlPaySuccessData:
    success_action: "typing.Optional[SuccessActionProcessed]"
    payment: "Payment"
    def __init__(self, *, success_action: "typing.Optional[SuccessActionProcessed]", payment: "Payment"):
        self.success_action = success_action
        self.payment = payment

    def __str__(self):
        return "LnUrlPaySuccessData(success_action={}, payment={})".format(self.success_action, self.payment)

    def __eq__(self, other):
        if self.success_action != other.success_action:
            return False
        if self.payment != other.payment:
            return False
        return True

class _UniffiConverterTypeLnUrlPaySuccessData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnUrlPaySuccessData(
            success_action=_UniffiConverterOptionalTypeSuccessActionProcessed.read(buf),
            payment=_UniffiConverterTypePayment.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalTypeSuccessActionProcessed.check_lower(value.success_action)
        _UniffiConverterTypePayment.check_lower(value.payment)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalTypeSuccessActionProcessed.write(value.success_action, buf)
        _UniffiConverterTypePayment.write(value.payment, buf)


class LnUrlWithdrawRequest:
    data: "LnUrlWithdrawRequestData"
    amount_msat: "int"
    description: "typing.Optional[str]"
    def __init__(self, *, data: "LnUrlWithdrawRequestData", amount_msat: "int", description: "typing.Optional[str]" = _DEFAULT):
        self.data = data
        self.amount_msat = amount_msat
        if description is _DEFAULT:
            self.description = None
        else:
            self.description = description

    def __str__(self):
        return "LnUrlWithdrawRequest(data={}, amount_msat={}, description={})".format(self.data, self.amount_msat, self.description)

    def __eq__(self, other):
        if self.data != other.data:
            return False
        if self.amount_msat != other.amount_msat:
            return False
        if self.description != other.description:
            return False
        return True

class _UniffiConverterTypeLnUrlWithdrawRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnUrlWithdrawRequest(
            data=_UniffiConverterTypeLnUrlWithdrawRequestData.read(buf),
            amount_msat=_UniffiConverterUInt64.read(buf),
            description=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeLnUrlWithdrawRequestData.check_lower(value.data)
        _UniffiConverterUInt64.check_lower(value.amount_msat)
        _UniffiConverterOptionalString.check_lower(value.description)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeLnUrlWithdrawRequestData.write(value.data, buf)
        _UniffiConverterUInt64.write(value.amount_msat, buf)
        _UniffiConverterOptionalString.write(value.description, buf)


class LnUrlWithdrawRequestData:
    callback: "str"
    k1: "str"
    default_description: "str"
    min_withdrawable: "int"
    max_withdrawable: "int"
    def __init__(self, *, callback: "str", k1: "str", default_description: "str", min_withdrawable: "int", max_withdrawable: "int"):
        self.callback = callback
        self.k1 = k1
        self.default_description = default_description
        self.min_withdrawable = min_withdrawable
        self.max_withdrawable = max_withdrawable

    def __str__(self):
        return "LnUrlWithdrawRequestData(callback={}, k1={}, default_description={}, min_withdrawable={}, max_withdrawable={})".format(self.callback, self.k1, self.default_description, self.min_withdrawable, self.max_withdrawable)

    def __eq__(self, other):
        if self.callback != other.callback:
            return False
        if self.k1 != other.k1:
            return False
        if self.default_description != other.default_description:
            return False
        if self.min_withdrawable != other.min_withdrawable:
            return False
        if self.max_withdrawable != other.max_withdrawable:
            return False
        return True

class _UniffiConverterTypeLnUrlWithdrawRequestData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnUrlWithdrawRequestData(
            callback=_UniffiConverterString.read(buf),
            k1=_UniffiConverterString.read(buf),
            default_description=_UniffiConverterString.read(buf),
            min_withdrawable=_UniffiConverterUInt64.read(buf),
            max_withdrawable=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.callback)
        _UniffiConverterString.check_lower(value.k1)
        _UniffiConverterString.check_lower(value.default_description)
        _UniffiConverterUInt64.check_lower(value.min_withdrawable)
        _UniffiConverterUInt64.check_lower(value.max_withdrawable)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.callback, buf)
        _UniffiConverterString.write(value.k1, buf)
        _UniffiConverterString.write(value.default_description, buf)
        _UniffiConverterUInt64.write(value.min_withdrawable, buf)
        _UniffiConverterUInt64.write(value.max_withdrawable, buf)


class LnUrlWithdrawSuccessData:
    invoice: "LnInvoice"
    def __init__(self, *, invoice: "LnInvoice"):
        self.invoice = invoice

    def __str__(self):
        return "LnUrlWithdrawSuccessData(invoice={})".format(self.invoice)

    def __eq__(self, other):
        if self.invoice != other.invoice:
            return False
        return True

class _UniffiConverterTypeLnUrlWithdrawSuccessData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LnUrlWithdrawSuccessData(
            invoice=_UniffiConverterTypeLnInvoice.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeLnInvoice.check_lower(value.invoice)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeLnInvoice.write(value.invoice, buf)


class LocaleOverrides:
    locale: "str"
    spacing: "typing.Optional[int]"
    symbol: "Symbol"
    def __init__(self, *, locale: "str", spacing: "typing.Optional[int]", symbol: "Symbol"):
        self.locale = locale
        self.spacing = spacing
        self.symbol = symbol

    def __str__(self):
        return "LocaleOverrides(locale={}, spacing={}, symbol={})".format(self.locale, self.spacing, self.symbol)

    def __eq__(self, other):
        if self.locale != other.locale:
            return False
        if self.spacing != other.spacing:
            return False
        if self.symbol != other.symbol:
            return False
        return True

class _UniffiConverterTypeLocaleOverrides(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LocaleOverrides(
            locale=_UniffiConverterString.read(buf),
            spacing=_UniffiConverterOptionalUInt32.read(buf),
            symbol=_UniffiConverterTypeSymbol.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.locale)
        _UniffiConverterOptionalUInt32.check_lower(value.spacing)
        _UniffiConverterTypeSymbol.check_lower(value.symbol)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.locale, buf)
        _UniffiConverterOptionalUInt32.write(value.spacing, buf)
        _UniffiConverterTypeSymbol.write(value.symbol, buf)


class LocalizedName:
    locale: "str"
    name: "str"
    def __init__(self, *, locale: "str", name: "str"):
        self.locale = locale
        self.name = name

    def __str__(self):
        return "LocalizedName(locale={}, name={})".format(self.locale, self.name)

    def __eq__(self, other):
        if self.locale != other.locale:
            return False
        if self.name != other.name:
            return False
        return True

class _UniffiConverterTypeLocalizedName(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LocalizedName(
            locale=_UniffiConverterString.read(buf),
            name=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.locale)
        _UniffiConverterString.check_lower(value.name)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.locale, buf)
        _UniffiConverterString.write(value.name, buf)


class LogEntry:
    line: "str"
    level: "str"
    def __init__(self, *, line: "str", level: "str"):
        self.line = line
        self.level = level

    def __str__(self):
        return "LogEntry(line={}, level={})".format(self.line, self.level)

    def __eq__(self, other):
        if self.line != other.line:
            return False
        if self.level != other.level:
            return False
        return True

class _UniffiConverterTypeLogEntry(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LogEntry(
            line=_UniffiConverterString.read(buf),
            level=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.line)
        _UniffiConverterString.check_lower(value.level)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.line, buf)
        _UniffiConverterString.write(value.level, buf)


class MessageSuccessActionData:
    message: "str"
    def __init__(self, *, message: "str"):
        self.message = message

    def __str__(self):
        return "MessageSuccessActionData(message={})".format(self.message)

    def __eq__(self, other):
        if self.message != other.message:
            return False
        return True

class _UniffiConverterTypeMessageSuccessActionData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return MessageSuccessActionData(
            message=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.message)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.message, buf)


class OnchainPaymentLimitsResponse:
    send: "Limits"
    receive: "Limits"
    def __init__(self, *, send: "Limits", receive: "Limits"):
        self.send = send
        self.receive = receive

    def __str__(self):
        return "OnchainPaymentLimitsResponse(send={}, receive={})".format(self.send, self.receive)

    def __eq__(self, other):
        if self.send != other.send:
            return False
        if self.receive != other.receive:
            return False
        return True

class _UniffiConverterTypeOnchainPaymentLimitsResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return OnchainPaymentLimitsResponse(
            send=_UniffiConverterTypeLimits.read(buf),
            receive=_UniffiConverterTypeLimits.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeLimits.check_lower(value.send)
        _UniffiConverterTypeLimits.check_lower(value.receive)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeLimits.write(value.send, buf)
        _UniffiConverterTypeLimits.write(value.receive, buf)


class PayOnchainRequest:
    address: "str"
    prepare_response: "PreparePayOnchainResponse"
    def __init__(self, *, address: "str", prepare_response: "PreparePayOnchainResponse"):
        self.address = address
        self.prepare_response = prepare_response

    def __str__(self):
        return "PayOnchainRequest(address={}, prepare_response={})".format(self.address, self.prepare_response)

    def __eq__(self, other):
        if self.address != other.address:
            return False
        if self.prepare_response != other.prepare_response:
            return False
        return True

class _UniffiConverterTypePayOnchainRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PayOnchainRequest(
            address=_UniffiConverterString.read(buf),
            prepare_response=_UniffiConverterTypePreparePayOnchainResponse.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.address)
        _UniffiConverterTypePreparePayOnchainResponse.check_lower(value.prepare_response)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.address, buf)
        _UniffiConverterTypePreparePayOnchainResponse.write(value.prepare_response, buf)


class Payment:
    timestamp: "int"
    amount_sat: "int"
    fees_sat: "int"
    payment_type: "PaymentType"
    status: "PaymentState"
    details: "PaymentDetails"
    swapper_fees_sat: "typing.Optional[int]"
    destination: "typing.Optional[str]"
    tx_id: "typing.Optional[str]"
    unblinding_data: "typing.Optional[str]"
    def __init__(self, *, timestamp: "int", amount_sat: "int", fees_sat: "int", payment_type: "PaymentType", status: "PaymentState", details: "PaymentDetails", swapper_fees_sat: "typing.Optional[int]" = _DEFAULT, destination: "typing.Optional[str]" = _DEFAULT, tx_id: "typing.Optional[str]" = _DEFAULT, unblinding_data: "typing.Optional[str]" = _DEFAULT):
        self.timestamp = timestamp
        self.amount_sat = amount_sat
        self.fees_sat = fees_sat
        self.payment_type = payment_type
        self.status = status
        self.details = details
        if swapper_fees_sat is _DEFAULT:
            self.swapper_fees_sat = None
        else:
            self.swapper_fees_sat = swapper_fees_sat
        if destination is _DEFAULT:
            self.destination = None
        else:
            self.destination = destination
        if tx_id is _DEFAULT:
            self.tx_id = None
        else:
            self.tx_id = tx_id
        if unblinding_data is _DEFAULT:
            self.unblinding_data = None
        else:
            self.unblinding_data = unblinding_data

    def __str__(self):
        return "Payment(timestamp={}, amount_sat={}, fees_sat={}, payment_type={}, status={}, details={}, swapper_fees_sat={}, destination={}, tx_id={}, unblinding_data={})".format(self.timestamp, self.amount_sat, self.fees_sat, self.payment_type, self.status, self.details, self.swapper_fees_sat, self.destination, self.tx_id, self.unblinding_data)

    def __eq__(self, other):
        if self.timestamp != other.timestamp:
            return False
        if self.amount_sat != other.amount_sat:
            return False
        if self.fees_sat != other.fees_sat:
            return False
        if self.payment_type != other.payment_type:
            return False
        if self.status != other.status:
            return False
        if self.details != other.details:
            return False
        if self.swapper_fees_sat != other.swapper_fees_sat:
            return False
        if self.destination != other.destination:
            return False
        if self.tx_id != other.tx_id:
            return False
        if self.unblinding_data != other.unblinding_data:
            return False
        return True

class _UniffiConverterTypePayment(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Payment(
            timestamp=_UniffiConverterUInt32.read(buf),
            amount_sat=_UniffiConverterUInt64.read(buf),
            fees_sat=_UniffiConverterUInt64.read(buf),
            payment_type=_UniffiConverterTypePaymentType.read(buf),
            status=_UniffiConverterTypePaymentState.read(buf),
            details=_UniffiConverterTypePaymentDetails.read(buf),
            swapper_fees_sat=_UniffiConverterOptionalUInt64.read(buf),
            destination=_UniffiConverterOptionalString.read(buf),
            tx_id=_UniffiConverterOptionalString.read(buf),
            unblinding_data=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.timestamp)
        _UniffiConverterUInt64.check_lower(value.amount_sat)
        _UniffiConverterUInt64.check_lower(value.fees_sat)
        _UniffiConverterTypePaymentType.check_lower(value.payment_type)
        _UniffiConverterTypePaymentState.check_lower(value.status)
        _UniffiConverterTypePaymentDetails.check_lower(value.details)
        _UniffiConverterOptionalUInt64.check_lower(value.swapper_fees_sat)
        _UniffiConverterOptionalString.check_lower(value.destination)
        _UniffiConverterOptionalString.check_lower(value.tx_id)
        _UniffiConverterOptionalString.check_lower(value.unblinding_data)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.timestamp, buf)
        _UniffiConverterUInt64.write(value.amount_sat, buf)
        _UniffiConverterUInt64.write(value.fees_sat, buf)
        _UniffiConverterTypePaymentType.write(value.payment_type, buf)
        _UniffiConverterTypePaymentState.write(value.status, buf)
        _UniffiConverterTypePaymentDetails.write(value.details, buf)
        _UniffiConverterOptionalUInt64.write(value.swapper_fees_sat, buf)
        _UniffiConverterOptionalString.write(value.destination, buf)
        _UniffiConverterOptionalString.write(value.tx_id, buf)
        _UniffiConverterOptionalString.write(value.unblinding_data, buf)


class PrepareBuyBitcoinRequest:
    provider: "BuyBitcoinProvider"
    amount_sat: "int"
    def __init__(self, *, provider: "BuyBitcoinProvider", amount_sat: "int"):
        self.provider = provider
        self.amount_sat = amount_sat

    def __str__(self):
        return "PrepareBuyBitcoinRequest(provider={}, amount_sat={})".format(self.provider, self.amount_sat)

    def __eq__(self, other):
        if self.provider != other.provider:
            return False
        if self.amount_sat != other.amount_sat:
            return False
        return True

class _UniffiConverterTypePrepareBuyBitcoinRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareBuyBitcoinRequest(
            provider=_UniffiConverterTypeBuyBitcoinProvider.read(buf),
            amount_sat=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeBuyBitcoinProvider.check_lower(value.provider)
        _UniffiConverterUInt64.check_lower(value.amount_sat)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeBuyBitcoinProvider.write(value.provider, buf)
        _UniffiConverterUInt64.write(value.amount_sat, buf)


class PrepareBuyBitcoinResponse:
    provider: "BuyBitcoinProvider"
    amount_sat: "int"
    fees_sat: "int"
    def __init__(self, *, provider: "BuyBitcoinProvider", amount_sat: "int", fees_sat: "int"):
        self.provider = provider
        self.amount_sat = amount_sat
        self.fees_sat = fees_sat

    def __str__(self):
        return "PrepareBuyBitcoinResponse(provider={}, amount_sat={}, fees_sat={})".format(self.provider, self.amount_sat, self.fees_sat)

    def __eq__(self, other):
        if self.provider != other.provider:
            return False
        if self.amount_sat != other.amount_sat:
            return False
        if self.fees_sat != other.fees_sat:
            return False
        return True

class _UniffiConverterTypePrepareBuyBitcoinResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareBuyBitcoinResponse(
            provider=_UniffiConverterTypeBuyBitcoinProvider.read(buf),
            amount_sat=_UniffiConverterUInt64.read(buf),
            fees_sat=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeBuyBitcoinProvider.check_lower(value.provider)
        _UniffiConverterUInt64.check_lower(value.amount_sat)
        _UniffiConverterUInt64.check_lower(value.fees_sat)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeBuyBitcoinProvider.write(value.provider, buf)
        _UniffiConverterUInt64.write(value.amount_sat, buf)
        _UniffiConverterUInt64.write(value.fees_sat, buf)


class PrepareLnUrlPayRequest:
    data: "LnUrlPayRequestData"
    amount: "PayAmount"
    bip353_address: "typing.Optional[str]"
    comment: "typing.Optional[str]"
    validate_success_action_url: "typing.Optional[bool]"
    def __init__(self, *, data: "LnUrlPayRequestData", amount: "PayAmount", bip353_address: "typing.Optional[str]" = _DEFAULT, comment: "typing.Optional[str]" = _DEFAULT, validate_success_action_url: "typing.Optional[bool]" = _DEFAULT):
        self.data = data
        self.amount = amount
        if bip353_address is _DEFAULT:
            self.bip353_address = None
        else:
            self.bip353_address = bip353_address
        if comment is _DEFAULT:
            self.comment = None
        else:
            self.comment = comment
        if validate_success_action_url is _DEFAULT:
            self.validate_success_action_url = None
        else:
            self.validate_success_action_url = validate_success_action_url

    def __str__(self):
        return "PrepareLnUrlPayRequest(data={}, amount={}, bip353_address={}, comment={}, validate_success_action_url={})".format(self.data, self.amount, self.bip353_address, self.comment, self.validate_success_action_url)

    def __eq__(self, other):
        if self.data != other.data:
            return False
        if self.amount != other.amount:
            return False
        if self.bip353_address != other.bip353_address:
            return False
        if self.comment != other.comment:
            return False
        if self.validate_success_action_url != other.validate_success_action_url:
            return False
        return True

class _UniffiConverterTypePrepareLnUrlPayRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareLnUrlPayRequest(
            data=_UniffiConverterTypeLnUrlPayRequestData.read(buf),
            amount=_UniffiConverterTypePayAmount.read(buf),
            bip353_address=_UniffiConverterOptionalString.read(buf),
            comment=_UniffiConverterOptionalString.read(buf),
            validate_success_action_url=_UniffiConverterOptionalBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeLnUrlPayRequestData.check_lower(value.data)
        _UniffiConverterTypePayAmount.check_lower(value.amount)
        _UniffiConverterOptionalString.check_lower(value.bip353_address)
        _UniffiConverterOptionalString.check_lower(value.comment)
        _UniffiConverterOptionalBool.check_lower(value.validate_success_action_url)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeLnUrlPayRequestData.write(value.data, buf)
        _UniffiConverterTypePayAmount.write(value.amount, buf)
        _UniffiConverterOptionalString.write(value.bip353_address, buf)
        _UniffiConverterOptionalString.write(value.comment, buf)
        _UniffiConverterOptionalBool.write(value.validate_success_action_url, buf)


class PrepareLnUrlPayResponse:
    destination: "SendDestination"
    fees_sat: "int"
    data: "LnUrlPayRequestData"
    comment: "typing.Optional[str]"
    success_action: "typing.Optional[SuccessAction]"
    def __init__(self, *, destination: "SendDestination", fees_sat: "int", data: "LnUrlPayRequestData", comment: "typing.Optional[str]" = _DEFAULT, success_action: "typing.Optional[SuccessAction]" = _DEFAULT):
        self.destination = destination
        self.fees_sat = fees_sat
        self.data = data
        if comment is _DEFAULT:
            self.comment = None
        else:
            self.comment = comment
        if success_action is _DEFAULT:
            self.success_action = None
        else:
            self.success_action = success_action

    def __str__(self):
        return "PrepareLnUrlPayResponse(destination={}, fees_sat={}, data={}, comment={}, success_action={})".format(self.destination, self.fees_sat, self.data, self.comment, self.success_action)

    def __eq__(self, other):
        if self.destination != other.destination:
            return False
        if self.fees_sat != other.fees_sat:
            return False
        if self.data != other.data:
            return False
        if self.comment != other.comment:
            return False
        if self.success_action != other.success_action:
            return False
        return True

class _UniffiConverterTypePrepareLnUrlPayResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareLnUrlPayResponse(
            destination=_UniffiConverterTypeSendDestination.read(buf),
            fees_sat=_UniffiConverterUInt64.read(buf),
            data=_UniffiConverterTypeLnUrlPayRequestData.read(buf),
            comment=_UniffiConverterOptionalString.read(buf),
            success_action=_UniffiConverterOptionalTypeSuccessAction.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeSendDestination.check_lower(value.destination)
        _UniffiConverterUInt64.check_lower(value.fees_sat)
        _UniffiConverterTypeLnUrlPayRequestData.check_lower(value.data)
        _UniffiConverterOptionalString.check_lower(value.comment)
        _UniffiConverterOptionalTypeSuccessAction.check_lower(value.success_action)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeSendDestination.write(value.destination, buf)
        _UniffiConverterUInt64.write(value.fees_sat, buf)
        _UniffiConverterTypeLnUrlPayRequestData.write(value.data, buf)
        _UniffiConverterOptionalString.write(value.comment, buf)
        _UniffiConverterOptionalTypeSuccessAction.write(value.success_action, buf)


class PreparePayOnchainRequest:
    amount: "PayAmount"
    fee_rate_sat_per_vbyte: "typing.Optional[int]"
    def __init__(self, *, amount: "PayAmount", fee_rate_sat_per_vbyte: "typing.Optional[int]" = _DEFAULT):
        self.amount = amount
        if fee_rate_sat_per_vbyte is _DEFAULT:
            self.fee_rate_sat_per_vbyte = None
        else:
            self.fee_rate_sat_per_vbyte = fee_rate_sat_per_vbyte

    def __str__(self):
        return "PreparePayOnchainRequest(amount={}, fee_rate_sat_per_vbyte={})".format(self.amount, self.fee_rate_sat_per_vbyte)

    def __eq__(self, other):
        if self.amount != other.amount:
            return False
        if self.fee_rate_sat_per_vbyte != other.fee_rate_sat_per_vbyte:
            return False
        return True

class _UniffiConverterTypePreparePayOnchainRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PreparePayOnchainRequest(
            amount=_UniffiConverterTypePayAmount.read(buf),
            fee_rate_sat_per_vbyte=_UniffiConverterOptionalUInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePayAmount.check_lower(value.amount)
        _UniffiConverterOptionalUInt32.check_lower(value.fee_rate_sat_per_vbyte)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePayAmount.write(value.amount, buf)
        _UniffiConverterOptionalUInt32.write(value.fee_rate_sat_per_vbyte, buf)


class PreparePayOnchainResponse:
    receiver_amount_sat: "int"
    claim_fees_sat: "int"
    total_fees_sat: "int"
    def __init__(self, *, receiver_amount_sat: "int", claim_fees_sat: "int", total_fees_sat: "int"):
        self.receiver_amount_sat = receiver_amount_sat
        self.claim_fees_sat = claim_fees_sat
        self.total_fees_sat = total_fees_sat

    def __str__(self):
        return "PreparePayOnchainResponse(receiver_amount_sat={}, claim_fees_sat={}, total_fees_sat={})".format(self.receiver_amount_sat, self.claim_fees_sat, self.total_fees_sat)

    def __eq__(self, other):
        if self.receiver_amount_sat != other.receiver_amount_sat:
            return False
        if self.claim_fees_sat != other.claim_fees_sat:
            return False
        if self.total_fees_sat != other.total_fees_sat:
            return False
        return True

class _UniffiConverterTypePreparePayOnchainResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PreparePayOnchainResponse(
            receiver_amount_sat=_UniffiConverterUInt64.read(buf),
            claim_fees_sat=_UniffiConverterUInt64.read(buf),
            total_fees_sat=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt64.check_lower(value.receiver_amount_sat)
        _UniffiConverterUInt64.check_lower(value.claim_fees_sat)
        _UniffiConverterUInt64.check_lower(value.total_fees_sat)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt64.write(value.receiver_amount_sat, buf)
        _UniffiConverterUInt64.write(value.claim_fees_sat, buf)
        _UniffiConverterUInt64.write(value.total_fees_sat, buf)


class PrepareReceiveRequest:
    payment_method: "PaymentMethod"
    amount: "typing.Optional[ReceiveAmount]"
    def __init__(self, *, payment_method: "PaymentMethod", amount: "typing.Optional[ReceiveAmount]" = _DEFAULT):
        self.payment_method = payment_method
        if amount is _DEFAULT:
            self.amount = None
        else:
            self.amount = amount

    def __str__(self):
        return "PrepareReceiveRequest(payment_method={}, amount={})".format(self.payment_method, self.amount)

    def __eq__(self, other):
        if self.payment_method != other.payment_method:
            return False
        if self.amount != other.amount:
            return False
        return True

class _UniffiConverterTypePrepareReceiveRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareReceiveRequest(
            payment_method=_UniffiConverterTypePaymentMethod.read(buf),
            amount=_UniffiConverterOptionalTypeReceiveAmount.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePaymentMethod.check_lower(value.payment_method)
        _UniffiConverterOptionalTypeReceiveAmount.check_lower(value.amount)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePaymentMethod.write(value.payment_method, buf)
        _UniffiConverterOptionalTypeReceiveAmount.write(value.amount, buf)


class PrepareReceiveResponse:
    payment_method: "PaymentMethod"
    fees_sat: "int"
    amount: "typing.Optional[ReceiveAmount]"
    min_payer_amount_sat: "typing.Optional[int]"
    max_payer_amount_sat: "typing.Optional[int]"
    swapper_feerate: "typing.Optional[float]"
    def __init__(self, *, payment_method: "PaymentMethod", fees_sat: "int", amount: "typing.Optional[ReceiveAmount]", min_payer_amount_sat: "typing.Optional[int]", max_payer_amount_sat: "typing.Optional[int]", swapper_feerate: "typing.Optional[float]"):
        self.payment_method = payment_method
        self.fees_sat = fees_sat
        self.amount = amount
        self.min_payer_amount_sat = min_payer_amount_sat
        self.max_payer_amount_sat = max_payer_amount_sat
        self.swapper_feerate = swapper_feerate

    def __str__(self):
        return "PrepareReceiveResponse(payment_method={}, fees_sat={}, amount={}, min_payer_amount_sat={}, max_payer_amount_sat={}, swapper_feerate={})".format(self.payment_method, self.fees_sat, self.amount, self.min_payer_amount_sat, self.max_payer_amount_sat, self.swapper_feerate)

    def __eq__(self, other):
        if self.payment_method != other.payment_method:
            return False
        if self.fees_sat != other.fees_sat:
            return False
        if self.amount != other.amount:
            return False
        if self.min_payer_amount_sat != other.min_payer_amount_sat:
            return False
        if self.max_payer_amount_sat != other.max_payer_amount_sat:
            return False
        if self.swapper_feerate != other.swapper_feerate:
            return False
        return True

class _UniffiConverterTypePrepareReceiveResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareReceiveResponse(
            payment_method=_UniffiConverterTypePaymentMethod.read(buf),
            fees_sat=_UniffiConverterUInt64.read(buf),
            amount=_UniffiConverterOptionalTypeReceiveAmount.read(buf),
            min_payer_amount_sat=_UniffiConverterOptionalUInt64.read(buf),
            max_payer_amount_sat=_UniffiConverterOptionalUInt64.read(buf),
            swapper_feerate=_UniffiConverterOptionalDouble.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePaymentMethod.check_lower(value.payment_method)
        _UniffiConverterUInt64.check_lower(value.fees_sat)
        _UniffiConverterOptionalTypeReceiveAmount.check_lower(value.amount)
        _UniffiConverterOptionalUInt64.check_lower(value.min_payer_amount_sat)
        _UniffiConverterOptionalUInt64.check_lower(value.max_payer_amount_sat)
        _UniffiConverterOptionalDouble.check_lower(value.swapper_feerate)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePaymentMethod.write(value.payment_method, buf)
        _UniffiConverterUInt64.write(value.fees_sat, buf)
        _UniffiConverterOptionalTypeReceiveAmount.write(value.amount, buf)
        _UniffiConverterOptionalUInt64.write(value.min_payer_amount_sat, buf)
        _UniffiConverterOptionalUInt64.write(value.max_payer_amount_sat, buf)
        _UniffiConverterOptionalDouble.write(value.swapper_feerate, buf)


class PrepareRefundRequest:
    swap_address: "str"
    refund_address: "str"
    fee_rate_sat_per_vbyte: "int"
    def __init__(self, *, swap_address: "str", refund_address: "str", fee_rate_sat_per_vbyte: "int"):
        self.swap_address = swap_address
        self.refund_address = refund_address
        self.fee_rate_sat_per_vbyte = fee_rate_sat_per_vbyte

    def __str__(self):
        return "PrepareRefundRequest(swap_address={}, refund_address={}, fee_rate_sat_per_vbyte={})".format(self.swap_address, self.refund_address, self.fee_rate_sat_per_vbyte)

    def __eq__(self, other):
        if self.swap_address != other.swap_address:
            return False
        if self.refund_address != other.refund_address:
            return False
        if self.fee_rate_sat_per_vbyte != other.fee_rate_sat_per_vbyte:
            return False
        return True

class _UniffiConverterTypePrepareRefundRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareRefundRequest(
            swap_address=_UniffiConverterString.read(buf),
            refund_address=_UniffiConverterString.read(buf),
            fee_rate_sat_per_vbyte=_UniffiConverterUInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.swap_address)
        _UniffiConverterString.check_lower(value.refund_address)
        _UniffiConverterUInt32.check_lower(value.fee_rate_sat_per_vbyte)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.swap_address, buf)
        _UniffiConverterString.write(value.refund_address, buf)
        _UniffiConverterUInt32.write(value.fee_rate_sat_per_vbyte, buf)


class PrepareRefundResponse:
    tx_vsize: "int"
    tx_fee_sat: "int"
    last_refund_tx_id: "typing.Optional[str]"
    def __init__(self, *, tx_vsize: "int", tx_fee_sat: "int", last_refund_tx_id: "typing.Optional[str]" = _DEFAULT):
        self.tx_vsize = tx_vsize
        self.tx_fee_sat = tx_fee_sat
        if last_refund_tx_id is _DEFAULT:
            self.last_refund_tx_id = None
        else:
            self.last_refund_tx_id = last_refund_tx_id

    def __str__(self):
        return "PrepareRefundResponse(tx_vsize={}, tx_fee_sat={}, last_refund_tx_id={})".format(self.tx_vsize, self.tx_fee_sat, self.last_refund_tx_id)

    def __eq__(self, other):
        if self.tx_vsize != other.tx_vsize:
            return False
        if self.tx_fee_sat != other.tx_fee_sat:
            return False
        if self.last_refund_tx_id != other.last_refund_tx_id:
            return False
        return True

class _UniffiConverterTypePrepareRefundResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareRefundResponse(
            tx_vsize=_UniffiConverterUInt32.read(buf),
            tx_fee_sat=_UniffiConverterUInt64.read(buf),
            last_refund_tx_id=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.tx_vsize)
        _UniffiConverterUInt64.check_lower(value.tx_fee_sat)
        _UniffiConverterOptionalString.check_lower(value.last_refund_tx_id)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.tx_vsize, buf)
        _UniffiConverterUInt64.write(value.tx_fee_sat, buf)
        _UniffiConverterOptionalString.write(value.last_refund_tx_id, buf)


class PrepareSendRequest:
    destination: "str"
    amount: "typing.Optional[PayAmount]"
    def __init__(self, *, destination: "str", amount: "typing.Optional[PayAmount]" = _DEFAULT):
        self.destination = destination
        if amount is _DEFAULT:
            self.amount = None
        else:
            self.amount = amount

    def __str__(self):
        return "PrepareSendRequest(destination={}, amount={})".format(self.destination, self.amount)

    def __eq__(self, other):
        if self.destination != other.destination:
            return False
        if self.amount != other.amount:
            return False
        return True

class _UniffiConverterTypePrepareSendRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareSendRequest(
            destination=_UniffiConverterString.read(buf),
            amount=_UniffiConverterOptionalTypePayAmount.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.destination)
        _UniffiConverterOptionalTypePayAmount.check_lower(value.amount)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.destination, buf)
        _UniffiConverterOptionalTypePayAmount.write(value.amount, buf)


class PrepareSendResponse:
    destination: "SendDestination"
    fees_sat: "int"
    def __init__(self, *, destination: "SendDestination", fees_sat: "int"):
        self.destination = destination
        self.fees_sat = fees_sat

    def __str__(self):
        return "PrepareSendResponse(destination={}, fees_sat={})".format(self.destination, self.fees_sat)

    def __eq__(self, other):
        if self.destination != other.destination:
            return False
        if self.fees_sat != other.fees_sat:
            return False
        return True

class _UniffiConverterTypePrepareSendResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PrepareSendResponse(
            destination=_UniffiConverterTypeSendDestination.read(buf),
            fees_sat=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypeSendDestination.check_lower(value.destination)
        _UniffiConverterUInt64.check_lower(value.fees_sat)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeSendDestination.write(value.destination, buf)
        _UniffiConverterUInt64.write(value.fees_sat, buf)


class Rate:
    coin: "str"
    value: "float"
    def __init__(self, *, coin: "str", value: "float"):
        self.coin = coin
        self.value = value

    def __str__(self):
        return "Rate(coin={}, value={})".format(self.coin, self.value)

    def __eq__(self, other):
        if self.coin != other.coin:
            return False
        if self.value != other.value:
            return False
        return True

class _UniffiConverterTypeRate(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Rate(
            coin=_UniffiConverterString.read(buf),
            value=_UniffiConverterDouble.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.coin)
        _UniffiConverterDouble.check_lower(value.value)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.coin, buf)
        _UniffiConverterDouble.write(value.value, buf)


class ReceivePaymentRequest:
    prepare_response: "PrepareReceiveResponse"
    description: "typing.Optional[str]"
    use_description_hash: "typing.Optional[bool]"
    def __init__(self, *, prepare_response: "PrepareReceiveResponse", description: "typing.Optional[str]" = _DEFAULT, use_description_hash: "typing.Optional[bool]" = _DEFAULT):
        self.prepare_response = prepare_response
        if description is _DEFAULT:
            self.description = None
        else:
            self.description = description
        if use_description_hash is _DEFAULT:
            self.use_description_hash = None
        else:
            self.use_description_hash = use_description_hash

    def __str__(self):
        return "ReceivePaymentRequest(prepare_response={}, description={}, use_description_hash={})".format(self.prepare_response, self.description, self.use_description_hash)

    def __eq__(self, other):
        if self.prepare_response != other.prepare_response:
            return False
        if self.description != other.description:
            return False
        if self.use_description_hash != other.use_description_hash:
            return False
        return True

class _UniffiConverterTypeReceivePaymentRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ReceivePaymentRequest(
            prepare_response=_UniffiConverterTypePrepareReceiveResponse.read(buf),
            description=_UniffiConverterOptionalString.read(buf),
            use_description_hash=_UniffiConverterOptionalBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePrepareReceiveResponse.check_lower(value.prepare_response)
        _UniffiConverterOptionalString.check_lower(value.description)
        _UniffiConverterOptionalBool.check_lower(value.use_description_hash)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePrepareReceiveResponse.write(value.prepare_response, buf)
        _UniffiConverterOptionalString.write(value.description, buf)
        _UniffiConverterOptionalBool.write(value.use_description_hash, buf)


class ReceivePaymentResponse:
    destination: "str"
    def __init__(self, *, destination: "str"):
        self.destination = destination

    def __str__(self):
        return "ReceivePaymentResponse(destination={})".format(self.destination)

    def __eq__(self, other):
        if self.destination != other.destination:
            return False
        return True

class _UniffiConverterTypeReceivePaymentResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ReceivePaymentResponse(
            destination=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.destination)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.destination, buf)


class RecommendedFees:
    fastest_fee: "int"
    half_hour_fee: "int"
    hour_fee: "int"
    economy_fee: "int"
    minimum_fee: "int"
    def __init__(self, *, fastest_fee: "int", half_hour_fee: "int", hour_fee: "int", economy_fee: "int", minimum_fee: "int"):
        self.fastest_fee = fastest_fee
        self.half_hour_fee = half_hour_fee
        self.hour_fee = hour_fee
        self.economy_fee = economy_fee
        self.minimum_fee = minimum_fee

    def __str__(self):
        return "RecommendedFees(fastest_fee={}, half_hour_fee={}, hour_fee={}, economy_fee={}, minimum_fee={})".format(self.fastest_fee, self.half_hour_fee, self.hour_fee, self.economy_fee, self.minimum_fee)

    def __eq__(self, other):
        if self.fastest_fee != other.fastest_fee:
            return False
        if self.half_hour_fee != other.half_hour_fee:
            return False
        if self.hour_fee != other.hour_fee:
            return False
        if self.economy_fee != other.economy_fee:
            return False
        if self.minimum_fee != other.minimum_fee:
            return False
        return True

class _UniffiConverterTypeRecommendedFees(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RecommendedFees(
            fastest_fee=_UniffiConverterUInt64.read(buf),
            half_hour_fee=_UniffiConverterUInt64.read(buf),
            hour_fee=_UniffiConverterUInt64.read(buf),
            economy_fee=_UniffiConverterUInt64.read(buf),
            minimum_fee=_UniffiConverterUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt64.check_lower(value.fastest_fee)
        _UniffiConverterUInt64.check_lower(value.half_hour_fee)
        _UniffiConverterUInt64.check_lower(value.hour_fee)
        _UniffiConverterUInt64.check_lower(value.economy_fee)
        _UniffiConverterUInt64.check_lower(value.minimum_fee)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt64.write(value.fastest_fee, buf)
        _UniffiConverterUInt64.write(value.half_hour_fee, buf)
        _UniffiConverterUInt64.write(value.hour_fee, buf)
        _UniffiConverterUInt64.write(value.economy_fee, buf)
        _UniffiConverterUInt64.write(value.minimum_fee, buf)


class RefundRequest:
    swap_address: "str"
    refund_address: "str"
    fee_rate_sat_per_vbyte: "int"
    def __init__(self, *, swap_address: "str", refund_address: "str", fee_rate_sat_per_vbyte: "int"):
        self.swap_address = swap_address
        self.refund_address = refund_address
        self.fee_rate_sat_per_vbyte = fee_rate_sat_per_vbyte

    def __str__(self):
        return "RefundRequest(swap_address={}, refund_address={}, fee_rate_sat_per_vbyte={})".format(self.swap_address, self.refund_address, self.fee_rate_sat_per_vbyte)

    def __eq__(self, other):
        if self.swap_address != other.swap_address:
            return False
        if self.refund_address != other.refund_address:
            return False
        if self.fee_rate_sat_per_vbyte != other.fee_rate_sat_per_vbyte:
            return False
        return True

class _UniffiConverterTypeRefundRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RefundRequest(
            swap_address=_UniffiConverterString.read(buf),
            refund_address=_UniffiConverterString.read(buf),
            fee_rate_sat_per_vbyte=_UniffiConverterUInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.swap_address)
        _UniffiConverterString.check_lower(value.refund_address)
        _UniffiConverterUInt32.check_lower(value.fee_rate_sat_per_vbyte)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.swap_address, buf)
        _UniffiConverterString.write(value.refund_address, buf)
        _UniffiConverterUInt32.write(value.fee_rate_sat_per_vbyte, buf)


class RefundResponse:
    refund_tx_id: "str"
    def __init__(self, *, refund_tx_id: "str"):
        self.refund_tx_id = refund_tx_id

    def __str__(self):
        return "RefundResponse(refund_tx_id={})".format(self.refund_tx_id)

    def __eq__(self, other):
        if self.refund_tx_id != other.refund_tx_id:
            return False
        return True

class _UniffiConverterTypeRefundResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RefundResponse(
            refund_tx_id=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.refund_tx_id)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.refund_tx_id, buf)


class RefundableSwap:
    swap_address: "str"
    timestamp: "int"
    amount_sat: "int"
    last_refund_tx_id: "typing.Optional[str]"
    def __init__(self, *, swap_address: "str", timestamp: "int", amount_sat: "int", last_refund_tx_id: "typing.Optional[str]"):
        self.swap_address = swap_address
        self.timestamp = timestamp
        self.amount_sat = amount_sat
        self.last_refund_tx_id = last_refund_tx_id

    def __str__(self):
        return "RefundableSwap(swap_address={}, timestamp={}, amount_sat={}, last_refund_tx_id={})".format(self.swap_address, self.timestamp, self.amount_sat, self.last_refund_tx_id)

    def __eq__(self, other):
        if self.swap_address != other.swap_address:
            return False
        if self.timestamp != other.timestamp:
            return False
        if self.amount_sat != other.amount_sat:
            return False
        if self.last_refund_tx_id != other.last_refund_tx_id:
            return False
        return True

class _UniffiConverterTypeRefundableSwap(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RefundableSwap(
            swap_address=_UniffiConverterString.read(buf),
            timestamp=_UniffiConverterUInt32.read(buf),
            amount_sat=_UniffiConverterUInt64.read(buf),
            last_refund_tx_id=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.swap_address)
        _UniffiConverterUInt32.check_lower(value.timestamp)
        _UniffiConverterUInt64.check_lower(value.amount_sat)
        _UniffiConverterOptionalString.check_lower(value.last_refund_tx_id)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.swap_address, buf)
        _UniffiConverterUInt32.write(value.timestamp, buf)
        _UniffiConverterUInt64.write(value.amount_sat, buf)
        _UniffiConverterOptionalString.write(value.last_refund_tx_id, buf)


class RestoreRequest:
    backup_path: "typing.Optional[str]"
    def __init__(self, *, backup_path: "typing.Optional[str]" = _DEFAULT):
        if backup_path is _DEFAULT:
            self.backup_path = None
        else:
            self.backup_path = backup_path

    def __str__(self):
        return "RestoreRequest(backup_path={})".format(self.backup_path)

    def __eq__(self, other):
        if self.backup_path != other.backup_path:
            return False
        return True

class _UniffiConverterTypeRestoreRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RestoreRequest(
            backup_path=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.backup_path)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.backup_path, buf)


class RouteHint:
    hops: "typing.List[RouteHintHop]"
    def __init__(self, *, hops: "typing.List[RouteHintHop]"):
        self.hops = hops

    def __str__(self):
        return "RouteHint(hops={})".format(self.hops)

    def __eq__(self, other):
        if self.hops != other.hops:
            return False
        return True

class _UniffiConverterTypeRouteHint(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RouteHint(
            hops=_UniffiConverterSequenceTypeRouteHintHop.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterSequenceTypeRouteHintHop.check_lower(value.hops)

    @staticmethod
    def write(value, buf):
        _UniffiConverterSequenceTypeRouteHintHop.write(value.hops, buf)


class RouteHintHop:
    src_node_id: "str"
    short_channel_id: "str"
    fees_base_msat: "int"
    fees_proportional_millionths: "int"
    cltv_expiry_delta: "int"
    htlc_minimum_msat: "typing.Optional[int]"
    htlc_maximum_msat: "typing.Optional[int]"
    def __init__(self, *, src_node_id: "str", short_channel_id: "str", fees_base_msat: "int", fees_proportional_millionths: "int", cltv_expiry_delta: "int", htlc_minimum_msat: "typing.Optional[int]", htlc_maximum_msat: "typing.Optional[int]"):
        self.src_node_id = src_node_id
        self.short_channel_id = short_channel_id
        self.fees_base_msat = fees_base_msat
        self.fees_proportional_millionths = fees_proportional_millionths
        self.cltv_expiry_delta = cltv_expiry_delta
        self.htlc_minimum_msat = htlc_minimum_msat
        self.htlc_maximum_msat = htlc_maximum_msat

    def __str__(self):
        return "RouteHintHop(src_node_id={}, short_channel_id={}, fees_base_msat={}, fees_proportional_millionths={}, cltv_expiry_delta={}, htlc_minimum_msat={}, htlc_maximum_msat={})".format(self.src_node_id, self.short_channel_id, self.fees_base_msat, self.fees_proportional_millionths, self.cltv_expiry_delta, self.htlc_minimum_msat, self.htlc_maximum_msat)

    def __eq__(self, other):
        if self.src_node_id != other.src_node_id:
            return False
        if self.short_channel_id != other.short_channel_id:
            return False
        if self.fees_base_msat != other.fees_base_msat:
            return False
        if self.fees_proportional_millionths != other.fees_proportional_millionths:
            return False
        if self.cltv_expiry_delta != other.cltv_expiry_delta:
            return False
        if self.htlc_minimum_msat != other.htlc_minimum_msat:
            return False
        if self.htlc_maximum_msat != other.htlc_maximum_msat:
            return False
        return True

class _UniffiConverterTypeRouteHintHop(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return RouteHintHop(
            src_node_id=_UniffiConverterString.read(buf),
            short_channel_id=_UniffiConverterString.read(buf),
            fees_base_msat=_UniffiConverterUInt32.read(buf),
            fees_proportional_millionths=_UniffiConverterUInt32.read(buf),
            cltv_expiry_delta=_UniffiConverterUInt64.read(buf),
            htlc_minimum_msat=_UniffiConverterOptionalUInt64.read(buf),
            htlc_maximum_msat=_UniffiConverterOptionalUInt64.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.src_node_id)
        _UniffiConverterString.check_lower(value.short_channel_id)
        _UniffiConverterUInt32.check_lower(value.fees_base_msat)
        _UniffiConverterUInt32.check_lower(value.fees_proportional_millionths)
        _UniffiConverterUInt64.check_lower(value.cltv_expiry_delta)
        _UniffiConverterOptionalUInt64.check_lower(value.htlc_minimum_msat)
        _UniffiConverterOptionalUInt64.check_lower(value.htlc_maximum_msat)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.src_node_id, buf)
        _UniffiConverterString.write(value.short_channel_id, buf)
        _UniffiConverterUInt32.write(value.fees_base_msat, buf)
        _UniffiConverterUInt32.write(value.fees_proportional_millionths, buf)
        _UniffiConverterUInt64.write(value.cltv_expiry_delta, buf)
        _UniffiConverterOptionalUInt64.write(value.htlc_minimum_msat, buf)
        _UniffiConverterOptionalUInt64.write(value.htlc_maximum_msat, buf)


class SendPaymentRequest:
    prepare_response: "PrepareSendResponse"
    def __init__(self, *, prepare_response: "PrepareSendResponse"):
        self.prepare_response = prepare_response

    def __str__(self):
        return "SendPaymentRequest(prepare_response={})".format(self.prepare_response)

    def __eq__(self, other):
        if self.prepare_response != other.prepare_response:
            return False
        return True

class _UniffiConverterTypeSendPaymentRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SendPaymentRequest(
            prepare_response=_UniffiConverterTypePrepareSendResponse.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePrepareSendResponse.check_lower(value.prepare_response)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePrepareSendResponse.write(value.prepare_response, buf)


class SendPaymentResponse:
    payment: "Payment"
    def __init__(self, *, payment: "Payment"):
        self.payment = payment

    def __str__(self):
        return "SendPaymentResponse(payment={})".format(self.payment)

    def __eq__(self, other):
        if self.payment != other.payment:
            return False
        return True

class _UniffiConverterTypeSendPaymentResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SendPaymentResponse(
            payment=_UniffiConverterTypePayment.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterTypePayment.check_lower(value.payment)

    @staticmethod
    def write(value, buf):
        _UniffiConverterTypePayment.write(value.payment, buf)


class SignMessageRequest:
    message: "str"
    def __init__(self, *, message: "str"):
        self.message = message

    def __str__(self):
        return "SignMessageRequest(message={})".format(self.message)

    def __eq__(self, other):
        if self.message != other.message:
            return False
        return True

class _UniffiConverterTypeSignMessageRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SignMessageRequest(
            message=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.message)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.message, buf)


class SignMessageResponse:
    signature: "str"
    def __init__(self, *, signature: "str"):
        self.signature = signature

    def __str__(self):
        return "SignMessageResponse(signature={})".format(self.signature)

    def __eq__(self, other):
        if self.signature != other.signature:
            return False
        return True

class _UniffiConverterTypeSignMessageResponse(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SignMessageResponse(
            signature=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.signature)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.signature, buf)


class Symbol:
    grapheme: "typing.Optional[str]"
    template: "typing.Optional[str]"
    rtl: "typing.Optional[bool]"
    position: "typing.Optional[int]"
    def __init__(self, *, grapheme: "typing.Optional[str]", template: "typing.Optional[str]", rtl: "typing.Optional[bool]", position: "typing.Optional[int]"):
        self.grapheme = grapheme
        self.template = template
        self.rtl = rtl
        self.position = position

    def __str__(self):
        return "Symbol(grapheme={}, template={}, rtl={}, position={})".format(self.grapheme, self.template, self.rtl, self.position)

    def __eq__(self, other):
        if self.grapheme != other.grapheme:
            return False
        if self.template != other.template:
            return False
        if self.rtl != other.rtl:
            return False
        if self.position != other.position:
            return False
        return True

class _UniffiConverterTypeSymbol(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Symbol(
            grapheme=_UniffiConverterOptionalString.read(buf),
            template=_UniffiConverterOptionalString.read(buf),
            rtl=_UniffiConverterOptionalBool.read(buf),
            position=_UniffiConverterOptionalUInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.grapheme)
        _UniffiConverterOptionalString.check_lower(value.template)
        _UniffiConverterOptionalBool.check_lower(value.rtl)
        _UniffiConverterOptionalUInt32.check_lower(value.position)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.grapheme, buf)
        _UniffiConverterOptionalString.write(value.template, buf)
        _UniffiConverterOptionalBool.write(value.rtl, buf)
        _UniffiConverterOptionalUInt32.write(value.position, buf)


class UrlSuccessActionData:
    description: "str"
    url: "str"
    matches_callback_domain: "bool"
    def __init__(self, *, description: "str", url: "str", matches_callback_domain: "bool"):
        self.description = description
        self.url = url
        self.matches_callback_domain = matches_callback_domain

    def __str__(self):
        return "UrlSuccessActionData(description={}, url={}, matches_callback_domain={})".format(self.description, self.url, self.matches_callback_domain)

    def __eq__(self, other):
        if self.description != other.description:
            return False
        if self.url != other.url:
            return False
        if self.matches_callback_domain != other.matches_callback_domain:
            return False
        return True

class _UniffiConverterTypeUrlSuccessActionData(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return UrlSuccessActionData(
            description=_UniffiConverterString.read(buf),
            url=_UniffiConverterString.read(buf),
            matches_callback_domain=_UniffiConverterBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.description)
        _UniffiConverterString.check_lower(value.url)
        _UniffiConverterBool.check_lower(value.matches_callback_domain)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.description, buf)
        _UniffiConverterString.write(value.url, buf)
        _UniffiConverterBool.write(value.matches_callback_domain, buf)


class WalletInfo:
    balance_sat: "int"
    pending_send_sat: "int"
    pending_receive_sat: "int"
    fingerprint: "str"
    pubkey: "str"
    asset_balances: "typing.List[AssetBalance]"
    def __init__(self, *, balance_sat: "int", pending_send_sat: "int", pending_receive_sat: "int", fingerprint: "str", pubkey: "str", asset_balances: "typing.List[AssetBalance]"):
        self.balance_sat = balance_sat
        self.pending_send_sat = pending_send_sat
        self.pending_receive_sat = pending_receive_sat
        self.fingerprint = fingerprint
        self.pubkey = pubkey
        self.asset_balances = asset_balances

    def __str__(self):
        return "WalletInfo(balance_sat={}, pending_send_sat={}, pending_receive_sat={}, fingerprint={}, pubkey={}, asset_balances={})".format(self.balance_sat, self.pending_send_sat, self.pending_receive_sat, self.fingerprint, self.pubkey, self.asset_balances)

    def __eq__(self, other):
        if self.balance_sat != other.balance_sat:
            return False
        if self.pending_send_sat != other.pending_send_sat:
            return False
        if self.pending_receive_sat != other.pending_receive_sat:
            return False
        if self.fingerprint != other.fingerprint:
            return False
        if self.pubkey != other.pubkey:
            return False
        if self.asset_balances != other.asset_balances:
            return False
        return True

class _UniffiConverterTypeWalletInfo(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return WalletInfo(
            balance_sat=_UniffiConverterUInt64.read(buf),
            pending_send_sat=_UniffiConverterUInt64.read(buf),
            pending_receive_sat=_UniffiConverterUInt64.read(buf),
            fingerprint=_UniffiConverterString.read(buf),
            pubkey=_UniffiConverterString.read(buf),
            asset_balances=_UniffiConverterSequenceTypeAssetBalance.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt64.check_lower(value.balance_sat)
        _UniffiConverterUInt64.check_lower(value.pending_send_sat)
        _UniffiConverterUInt64.check_lower(value.pending_receive_sat)
        _UniffiConverterString.check_lower(value.fingerprint)
        _UniffiConverterString.check_lower(value.pubkey)
        _UniffiConverterSequenceTypeAssetBalance.check_lower(value.asset_balances)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt64.write(value.balance_sat, buf)
        _UniffiConverterUInt64.write(value.pending_send_sat, buf)
        _UniffiConverterUInt64.write(value.pending_receive_sat, buf)
        _UniffiConverterString.write(value.fingerprint, buf)
        _UniffiConverterString.write(value.pubkey, buf)
        _UniffiConverterSequenceTypeAssetBalance.write(value.asset_balances, buf)





class AesSuccessActionDataResult:
    def __init__(self):
        raise RuntimeError("AesSuccessActionDataResult cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class DECRYPTED:
        data: "AesSuccessActionDataDecrypted"

        def __init__(self,data: "AesSuccessActionDataDecrypted"):
            self.data = data

        def __str__(self):
            return "AesSuccessActionDataResult.DECRYPTED(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_decrypted():
                return False
            if self.data != other.data:
                return False
            return True
    
    class ERROR_STATUS:
        reason: "str"

        def __init__(self,reason: "str"):
            self.reason = reason

        def __str__(self):
            return "AesSuccessActionDataResult.ERROR_STATUS(reason={})".format(self.reason)

        def __eq__(self, other):
            if not other.is_error_status():
                return False
            if self.reason != other.reason:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_decrypted(self) -> bool:
        return isinstance(self, AesSuccessActionDataResult.DECRYPTED)
    def is_error_status(self) -> bool:
        return isinstance(self, AesSuccessActionDataResult.ERROR_STATUS)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
AesSuccessActionDataResult.DECRYPTED = type("AesSuccessActionDataResult.DECRYPTED", (AesSuccessActionDataResult.DECRYPTED, AesSuccessActionDataResult,), {})  # type: ignore
AesSuccessActionDataResult.ERROR_STATUS = type("AesSuccessActionDataResult.ERROR_STATUS", (AesSuccessActionDataResult.ERROR_STATUS, AesSuccessActionDataResult,), {})  # type: ignore




class _UniffiConverterTypeAesSuccessActionDataResult(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return AesSuccessActionDataResult.DECRYPTED(
                _UniffiConverterTypeAesSuccessActionDataDecrypted.read(buf),
            )
        if variant == 2:
            return AesSuccessActionDataResult.ERROR_STATUS(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_decrypted():
            _UniffiConverterTypeAesSuccessActionDataDecrypted.check_lower(value.data)
            return
        if value.is_error_status():
            _UniffiConverterString.check_lower(value.reason)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_decrypted():
            buf.write_i32(1)
            _UniffiConverterTypeAesSuccessActionDataDecrypted.write(value.data, buf)
        if value.is_error_status():
            buf.write_i32(2)
            _UniffiConverterString.write(value.reason, buf)







class Amount:
    def __init__(self):
        raise RuntimeError("Amount cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class BITCOIN:
        amount_msat: "int"

        def __init__(self,amount_msat: "int"):
            self.amount_msat = amount_msat

        def __str__(self):
            return "Amount.BITCOIN(amount_msat={})".format(self.amount_msat)

        def __eq__(self, other):
            if not other.is_bitcoin():
                return False
            if self.amount_msat != other.amount_msat:
                return False
            return True
    
    class CURRENCY:
        iso4217_code: "str"
        fractional_amount: "int"

        def __init__(self,iso4217_code: "str", fractional_amount: "int"):
            self.iso4217_code = iso4217_code
            self.fractional_amount = fractional_amount

        def __str__(self):
            return "Amount.CURRENCY(iso4217_code={}, fractional_amount={})".format(self.iso4217_code, self.fractional_amount)

        def __eq__(self, other):
            if not other.is_currency():
                return False
            if self.iso4217_code != other.iso4217_code:
                return False
            if self.fractional_amount != other.fractional_amount:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_bitcoin(self) -> bool:
        return isinstance(self, Amount.BITCOIN)
    def is_currency(self) -> bool:
        return isinstance(self, Amount.CURRENCY)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
Amount.BITCOIN = type("Amount.BITCOIN", (Amount.BITCOIN, Amount,), {})  # type: ignore
Amount.CURRENCY = type("Amount.CURRENCY", (Amount.CURRENCY, Amount,), {})  # type: ignore




class _UniffiConverterTypeAmount(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Amount.BITCOIN(
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 2:
            return Amount.CURRENCY(
                _UniffiConverterString.read(buf),
                _UniffiConverterUInt64.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_bitcoin():
            _UniffiConverterUInt64.check_lower(value.amount_msat)
            return
        if value.is_currency():
            _UniffiConverterString.check_lower(value.iso4217_code)
            _UniffiConverterUInt64.check_lower(value.fractional_amount)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_bitcoin():
            buf.write_i32(1)
            _UniffiConverterUInt64.write(value.amount_msat, buf)
        if value.is_currency():
            buf.write_i32(2)
            _UniffiConverterString.write(value.iso4217_code, buf)
            _UniffiConverterUInt64.write(value.fractional_amount, buf)







class BuyBitcoinProvider(enum.Enum):
    MOONPAY = 0
    


class _UniffiConverterTypeBuyBitcoinProvider(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return BuyBitcoinProvider.MOONPAY
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == BuyBitcoinProvider.MOONPAY:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == BuyBitcoinProvider.MOONPAY:
            buf.write_i32(1)







class GetPaymentRequest:
    def __init__(self):
        raise RuntimeError("GetPaymentRequest cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class PAYMENT_HASH:
        payment_hash: "str"

        def __init__(self,payment_hash: "str"):
            self.payment_hash = payment_hash

        def __str__(self):
            return "GetPaymentRequest.PAYMENT_HASH(payment_hash={})".format(self.payment_hash)

        def __eq__(self, other):
            if not other.is_payment_hash():
                return False
            if self.payment_hash != other.payment_hash:
                return False
            return True
    
    class SWAP_ID:
        swap_id: "str"

        def __init__(self,swap_id: "str"):
            self.swap_id = swap_id

        def __str__(self):
            return "GetPaymentRequest.SWAP_ID(swap_id={})".format(self.swap_id)

        def __eq__(self, other):
            if not other.is_swap_id():
                return False
            if self.swap_id != other.swap_id:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_payment_hash(self) -> bool:
        return isinstance(self, GetPaymentRequest.PAYMENT_HASH)
    def is_swap_id(self) -> bool:
        return isinstance(self, GetPaymentRequest.SWAP_ID)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
GetPaymentRequest.PAYMENT_HASH = type("GetPaymentRequest.PAYMENT_HASH", (GetPaymentRequest.PAYMENT_HASH, GetPaymentRequest,), {})  # type: ignore
GetPaymentRequest.SWAP_ID = type("GetPaymentRequest.SWAP_ID", (GetPaymentRequest.SWAP_ID, GetPaymentRequest,), {})  # type: ignore




class _UniffiConverterTypeGetPaymentRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return GetPaymentRequest.PAYMENT_HASH(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return GetPaymentRequest.SWAP_ID(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_payment_hash():
            _UniffiConverterString.check_lower(value.payment_hash)
            return
        if value.is_swap_id():
            _UniffiConverterString.check_lower(value.swap_id)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_payment_hash():
            buf.write_i32(1)
            _UniffiConverterString.write(value.payment_hash, buf)
        if value.is_swap_id():
            buf.write_i32(2)
            _UniffiConverterString.write(value.swap_id, buf)







class InputType:
    def __init__(self):
        raise RuntimeError("InputType cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class BITCOIN_ADDRESS:
        address: "BitcoinAddressData"

        def __init__(self,address: "BitcoinAddressData"):
            self.address = address

        def __str__(self):
            return "InputType.BITCOIN_ADDRESS(address={})".format(self.address)

        def __eq__(self, other):
            if not other.is_bitcoin_address():
                return False
            if self.address != other.address:
                return False
            return True
    
    class LIQUID_ADDRESS:
        address: "LiquidAddressData"

        def __init__(self,address: "LiquidAddressData"):
            self.address = address

        def __str__(self):
            return "InputType.LIQUID_ADDRESS(address={})".format(self.address)

        def __eq__(self, other):
            if not other.is_liquid_address():
                return False
            if self.address != other.address:
                return False
            return True
    
    class BOLT11:
        invoice: "LnInvoice"

        def __init__(self,invoice: "LnInvoice"):
            self.invoice = invoice

        def __str__(self):
            return "InputType.BOLT11(invoice={})".format(self.invoice)

        def __eq__(self, other):
            if not other.is_bolt11():
                return False
            if self.invoice != other.invoice:
                return False
            return True
    
    class BOLT12_OFFER:
        offer: "LnOffer"
        bip353_address: "typing.Optional[str]"

        def __init__(self,offer: "LnOffer", bip353_address: "typing.Optional[str]"):
            self.offer = offer
            self.bip353_address = bip353_address

        def __str__(self):
            return "InputType.BOLT12_OFFER(offer={}, bip353_address={})".format(self.offer, self.bip353_address)

        def __eq__(self, other):
            if not other.is_bolt12_offer():
                return False
            if self.offer != other.offer:
                return False
            if self.bip353_address != other.bip353_address:
                return False
            return True
    
    class NODE_ID:
        node_id: "str"

        def __init__(self,node_id: "str"):
            self.node_id = node_id

        def __str__(self):
            return "InputType.NODE_ID(node_id={})".format(self.node_id)

        def __eq__(self, other):
            if not other.is_node_id():
                return False
            if self.node_id != other.node_id:
                return False
            return True
    
    class URL:
        url: "str"

        def __init__(self,url: "str"):
            self.url = url

        def __str__(self):
            return "InputType.URL(url={})".format(self.url)

        def __eq__(self, other):
            if not other.is_url():
                return False
            if self.url != other.url:
                return False
            return True
    
    class LN_URL_PAY:
        data: "LnUrlPayRequestData"
        bip353_address: "typing.Optional[str]"

        def __init__(self,data: "LnUrlPayRequestData", bip353_address: "typing.Optional[str]"):
            self.data = data
            self.bip353_address = bip353_address

        def __str__(self):
            return "InputType.LN_URL_PAY(data={}, bip353_address={})".format(self.data, self.bip353_address)

        def __eq__(self, other):
            if not other.is_ln_url_pay():
                return False
            if self.data != other.data:
                return False
            if self.bip353_address != other.bip353_address:
                return False
            return True
    
    class LN_URL_WITHDRAW:
        data: "LnUrlWithdrawRequestData"

        def __init__(self,data: "LnUrlWithdrawRequestData"):
            self.data = data

        def __str__(self):
            return "InputType.LN_URL_WITHDRAW(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_ln_url_withdraw():
                return False
            if self.data != other.data:
                return False
            return True
    
    class LN_URL_AUTH:
        data: "LnUrlAuthRequestData"

        def __init__(self,data: "LnUrlAuthRequestData"):
            self.data = data

        def __str__(self):
            return "InputType.LN_URL_AUTH(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_ln_url_auth():
                return False
            if self.data != other.data:
                return False
            return True
    
    class LN_URL_ERROR:
        data: "LnUrlErrorData"

        def __init__(self,data: "LnUrlErrorData"):
            self.data = data

        def __str__(self):
            return "InputType.LN_URL_ERROR(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_ln_url_error():
                return False
            if self.data != other.data:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_bitcoin_address(self) -> bool:
        return isinstance(self, InputType.BITCOIN_ADDRESS)
    def is_liquid_address(self) -> bool:
        return isinstance(self, InputType.LIQUID_ADDRESS)
    def is_bolt11(self) -> bool:
        return isinstance(self, InputType.BOLT11)
    def is_bolt12_offer(self) -> bool:
        return isinstance(self, InputType.BOLT12_OFFER)
    def is_node_id(self) -> bool:
        return isinstance(self, InputType.NODE_ID)
    def is_url(self) -> bool:
        return isinstance(self, InputType.URL)
    def is_ln_url_pay(self) -> bool:
        return isinstance(self, InputType.LN_URL_PAY)
    def is_ln_url_withdraw(self) -> bool:
        return isinstance(self, InputType.LN_URL_WITHDRAW)
    def is_ln_url_auth(self) -> bool:
        return isinstance(self, InputType.LN_URL_AUTH)
    def is_ln_url_error(self) -> bool:
        return isinstance(self, InputType.LN_URL_ERROR)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
InputType.BITCOIN_ADDRESS = type("InputType.BITCOIN_ADDRESS", (InputType.BITCOIN_ADDRESS, InputType,), {})  # type: ignore
InputType.LIQUID_ADDRESS = type("InputType.LIQUID_ADDRESS", (InputType.LIQUID_ADDRESS, InputType,), {})  # type: ignore
InputType.BOLT11 = type("InputType.BOLT11", (InputType.BOLT11, InputType,), {})  # type: ignore
InputType.BOLT12_OFFER = type("InputType.BOLT12_OFFER", (InputType.BOLT12_OFFER, InputType,), {})  # type: ignore
InputType.NODE_ID = type("InputType.NODE_ID", (InputType.NODE_ID, InputType,), {})  # type: ignore
InputType.URL = type("InputType.URL", (InputType.URL, InputType,), {})  # type: ignore
InputType.LN_URL_PAY = type("InputType.LN_URL_PAY", (InputType.LN_URL_PAY, InputType,), {})  # type: ignore
InputType.LN_URL_WITHDRAW = type("InputType.LN_URL_WITHDRAW", (InputType.LN_URL_WITHDRAW, InputType,), {})  # type: ignore
InputType.LN_URL_AUTH = type("InputType.LN_URL_AUTH", (InputType.LN_URL_AUTH, InputType,), {})  # type: ignore
InputType.LN_URL_ERROR = type("InputType.LN_URL_ERROR", (InputType.LN_URL_ERROR, InputType,), {})  # type: ignore




class _UniffiConverterTypeInputType(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return InputType.BITCOIN_ADDRESS(
                _UniffiConverterTypeBitcoinAddressData.read(buf),
            )
        if variant == 2:
            return InputType.LIQUID_ADDRESS(
                _UniffiConverterTypeLiquidAddressData.read(buf),
            )
        if variant == 3:
            return InputType.BOLT11(
                _UniffiConverterTypeLnInvoice.read(buf),
            )
        if variant == 4:
            return InputType.BOLT12_OFFER(
                _UniffiConverterTypeLnOffer.read(buf),
                _UniffiConverterOptionalString.read(buf),
            )
        if variant == 5:
            return InputType.NODE_ID(
                _UniffiConverterString.read(buf),
            )
        if variant == 6:
            return InputType.URL(
                _UniffiConverterString.read(buf),
            )
        if variant == 7:
            return InputType.LN_URL_PAY(
                _UniffiConverterTypeLnUrlPayRequestData.read(buf),
                _UniffiConverterOptionalString.read(buf),
            )
        if variant == 8:
            return InputType.LN_URL_WITHDRAW(
                _UniffiConverterTypeLnUrlWithdrawRequestData.read(buf),
            )
        if variant == 9:
            return InputType.LN_URL_AUTH(
                _UniffiConverterTypeLnUrlAuthRequestData.read(buf),
            )
        if variant == 10:
            return InputType.LN_URL_ERROR(
                _UniffiConverterTypeLnUrlErrorData.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_bitcoin_address():
            _UniffiConverterTypeBitcoinAddressData.check_lower(value.address)
            return
        if value.is_liquid_address():
            _UniffiConverterTypeLiquidAddressData.check_lower(value.address)
            return
        if value.is_bolt11():
            _UniffiConverterTypeLnInvoice.check_lower(value.invoice)
            return
        if value.is_bolt12_offer():
            _UniffiConverterTypeLnOffer.check_lower(value.offer)
            _UniffiConverterOptionalString.check_lower(value.bip353_address)
            return
        if value.is_node_id():
            _UniffiConverterString.check_lower(value.node_id)
            return
        if value.is_url():
            _UniffiConverterString.check_lower(value.url)
            return
        if value.is_ln_url_pay():
            _UniffiConverterTypeLnUrlPayRequestData.check_lower(value.data)
            _UniffiConverterOptionalString.check_lower(value.bip353_address)
            return
        if value.is_ln_url_withdraw():
            _UniffiConverterTypeLnUrlWithdrawRequestData.check_lower(value.data)
            return
        if value.is_ln_url_auth():
            _UniffiConverterTypeLnUrlAuthRequestData.check_lower(value.data)
            return
        if value.is_ln_url_error():
            _UniffiConverterTypeLnUrlErrorData.check_lower(value.data)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_bitcoin_address():
            buf.write_i32(1)
            _UniffiConverterTypeBitcoinAddressData.write(value.address, buf)
        if value.is_liquid_address():
            buf.write_i32(2)
            _UniffiConverterTypeLiquidAddressData.write(value.address, buf)
        if value.is_bolt11():
            buf.write_i32(3)
            _UniffiConverterTypeLnInvoice.write(value.invoice, buf)
        if value.is_bolt12_offer():
            buf.write_i32(4)
            _UniffiConverterTypeLnOffer.write(value.offer, buf)
            _UniffiConverterOptionalString.write(value.bip353_address, buf)
        if value.is_node_id():
            buf.write_i32(5)
            _UniffiConverterString.write(value.node_id, buf)
        if value.is_url():
            buf.write_i32(6)
            _UniffiConverterString.write(value.url, buf)
        if value.is_ln_url_pay():
            buf.write_i32(7)
            _UniffiConverterTypeLnUrlPayRequestData.write(value.data, buf)
            _UniffiConverterOptionalString.write(value.bip353_address, buf)
        if value.is_ln_url_withdraw():
            buf.write_i32(8)
            _UniffiConverterTypeLnUrlWithdrawRequestData.write(value.data, buf)
        if value.is_ln_url_auth():
            buf.write_i32(9)
            _UniffiConverterTypeLnUrlAuthRequestData.write(value.data, buf)
        if value.is_ln_url_error():
            buf.write_i32(10)
            _UniffiConverterTypeLnUrlErrorData.write(value.data, buf)







class LiquidNetwork(enum.Enum):
    MAINNET = 0
    
    TESTNET = 1
    
    REGTEST = 2
    


class _UniffiConverterTypeLiquidNetwork(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return LiquidNetwork.MAINNET
        if variant == 2:
            return LiquidNetwork.TESTNET
        if variant == 3:
            return LiquidNetwork.REGTEST
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == LiquidNetwork.MAINNET:
            return
        if value == LiquidNetwork.TESTNET:
            return
        if value == LiquidNetwork.REGTEST:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == LiquidNetwork.MAINNET:
            buf.write_i32(1)
        if value == LiquidNetwork.TESTNET:
            buf.write_i32(2)
        if value == LiquidNetwork.REGTEST:
            buf.write_i32(3)







class ListPaymentDetails:
    def __init__(self):
        raise RuntimeError("ListPaymentDetails cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class LIQUID:
        asset_id: "typing.Optional[str]"
        destination: "typing.Optional[str]"

        def __init__(self,asset_id: "typing.Optional[str]", destination: "typing.Optional[str]"):
            self.asset_id = asset_id
            self.destination = destination

        def __str__(self):
            return "ListPaymentDetails.LIQUID(asset_id={}, destination={})".format(self.asset_id, self.destination)

        def __eq__(self, other):
            if not other.is_liquid():
                return False
            if self.asset_id != other.asset_id:
                return False
            if self.destination != other.destination:
                return False
            return True
    
    class BITCOIN:
        address: "typing.Optional[str]"

        def __init__(self,address: "typing.Optional[str]"):
            self.address = address

        def __str__(self):
            return "ListPaymentDetails.BITCOIN(address={})".format(self.address)

        def __eq__(self, other):
            if not other.is_bitcoin():
                return False
            if self.address != other.address:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_liquid(self) -> bool:
        return isinstance(self, ListPaymentDetails.LIQUID)
    def is_bitcoin(self) -> bool:
        return isinstance(self, ListPaymentDetails.BITCOIN)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
ListPaymentDetails.LIQUID = type("ListPaymentDetails.LIQUID", (ListPaymentDetails.LIQUID, ListPaymentDetails,), {})  # type: ignore
ListPaymentDetails.BITCOIN = type("ListPaymentDetails.BITCOIN", (ListPaymentDetails.BITCOIN, ListPaymentDetails,), {})  # type: ignore




class _UniffiConverterTypeListPaymentDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return ListPaymentDetails.LIQUID(
                _UniffiConverterOptionalString.read(buf),
                _UniffiConverterOptionalString.read(buf),
            )
        if variant == 2:
            return ListPaymentDetails.BITCOIN(
                _UniffiConverterOptionalString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_liquid():
            _UniffiConverterOptionalString.check_lower(value.asset_id)
            _UniffiConverterOptionalString.check_lower(value.destination)
            return
        if value.is_bitcoin():
            _UniffiConverterOptionalString.check_lower(value.address)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_liquid():
            buf.write_i32(1)
            _UniffiConverterOptionalString.write(value.asset_id, buf)
            _UniffiConverterOptionalString.write(value.destination, buf)
        if value.is_bitcoin():
            buf.write_i32(2)
            _UniffiConverterOptionalString.write(value.address, buf)




# LnUrlAuthError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class LnUrlAuthError(Exception):
    pass

_UniffiTempLnUrlAuthError = LnUrlAuthError

class LnUrlAuthError:  # type: ignore
    class Generic(_UniffiTempLnUrlAuthError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlAuthError.Generic({})".format(str(self))
    _UniffiTempLnUrlAuthError.Generic = Generic # type: ignore
    class InvalidUri(_UniffiTempLnUrlAuthError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlAuthError.InvalidUri({})".format(str(self))
    _UniffiTempLnUrlAuthError.InvalidUri = InvalidUri # type: ignore
    class ServiceConnectivity(_UniffiTempLnUrlAuthError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlAuthError.ServiceConnectivity({})".format(str(self))
    _UniffiTempLnUrlAuthError.ServiceConnectivity = ServiceConnectivity # type: ignore

LnUrlAuthError = _UniffiTempLnUrlAuthError # type: ignore
del _UniffiTempLnUrlAuthError


class _UniffiConverterTypeLnUrlAuthError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return LnUrlAuthError.Generic(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return LnUrlAuthError.InvalidUri(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return LnUrlAuthError.ServiceConnectivity(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, LnUrlAuthError.Generic):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlAuthError.InvalidUri):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlAuthError.ServiceConnectivity):
            _UniffiConverterString.check_lower(value.err)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, LnUrlAuthError.Generic):
            buf.write_i32(1)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlAuthError.InvalidUri):
            buf.write_i32(2)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlAuthError.ServiceConnectivity):
            buf.write_i32(3)
            _UniffiConverterString.write(value.err, buf)





class LnUrlCallbackStatus:
    def __init__(self):
        raise RuntimeError("LnUrlCallbackStatus cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class OK:

        def __init__(self,):
            pass

        def __str__(self):
            return "LnUrlCallbackStatus.OK()".format()

        def __eq__(self, other):
            if not other.is_ok():
                return False
            return True
    
    class ERROR_STATUS:
        data: "LnUrlErrorData"

        def __init__(self,data: "LnUrlErrorData"):
            self.data = data

        def __str__(self):
            return "LnUrlCallbackStatus.ERROR_STATUS(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_error_status():
                return False
            if self.data != other.data:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_ok(self) -> bool:
        return isinstance(self, LnUrlCallbackStatus.OK)
    def is_error_status(self) -> bool:
        return isinstance(self, LnUrlCallbackStatus.ERROR_STATUS)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
LnUrlCallbackStatus.OK = type("LnUrlCallbackStatus.OK", (LnUrlCallbackStatus.OK, LnUrlCallbackStatus,), {})  # type: ignore
LnUrlCallbackStatus.ERROR_STATUS = type("LnUrlCallbackStatus.ERROR_STATUS", (LnUrlCallbackStatus.ERROR_STATUS, LnUrlCallbackStatus,), {})  # type: ignore




class _UniffiConverterTypeLnUrlCallbackStatus(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return LnUrlCallbackStatus.OK(
            )
        if variant == 2:
            return LnUrlCallbackStatus.ERROR_STATUS(
                _UniffiConverterTypeLnUrlErrorData.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_ok():
            return
        if value.is_error_status():
            _UniffiConverterTypeLnUrlErrorData.check_lower(value.data)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_ok():
            buf.write_i32(1)
        if value.is_error_status():
            buf.write_i32(2)
            _UniffiConverterTypeLnUrlErrorData.write(value.data, buf)




# LnUrlPayError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class LnUrlPayError(Exception):
    pass

_UniffiTempLnUrlPayError = LnUrlPayError

class LnUrlPayError:  # type: ignore
    class AlreadyPaid(_UniffiTempLnUrlPayError):
        def __init__(self):
            pass

        def __repr__(self):
            return "LnUrlPayError.AlreadyPaid({})".format(str(self))
    _UniffiTempLnUrlPayError.AlreadyPaid = AlreadyPaid # type: ignore
    class Generic(_UniffiTempLnUrlPayError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlPayError.Generic({})".format(str(self))
    _UniffiTempLnUrlPayError.Generic = Generic # type: ignore
    class InvalidAmount(_UniffiTempLnUrlPayError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlPayError.InvalidAmount({})".format(str(self))
    _UniffiTempLnUrlPayError.InvalidAmount = InvalidAmount # type: ignore
    class InvalidInvoice(_UniffiTempLnUrlPayError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlPayError.InvalidInvoice({})".format(str(self))
    _UniffiTempLnUrlPayError.InvalidInvoice = InvalidInvoice # type: ignore
    class InvalidNetwork(_UniffiTempLnUrlPayError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlPayError.InvalidNetwork({})".format(str(self))
    _UniffiTempLnUrlPayError.InvalidNetwork = InvalidNetwork # type: ignore
    class InvalidUri(_UniffiTempLnUrlPayError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlPayError.InvalidUri({})".format(str(self))
    _UniffiTempLnUrlPayError.InvalidUri = InvalidUri # type: ignore
    class InvoiceExpired(_UniffiTempLnUrlPayError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlPayError.InvoiceExpired({})".format(str(self))
    _UniffiTempLnUrlPayError.InvoiceExpired = InvoiceExpired # type: ignore
    class PaymentFailed(_UniffiTempLnUrlPayError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlPayError.PaymentFailed({})".format(str(self))
    _UniffiTempLnUrlPayError.PaymentFailed = PaymentFailed # type: ignore
    class PaymentTimeout(_UniffiTempLnUrlPayError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlPayError.PaymentTimeout({})".format(str(self))
    _UniffiTempLnUrlPayError.PaymentTimeout = PaymentTimeout # type: ignore
    class RouteNotFound(_UniffiTempLnUrlPayError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlPayError.RouteNotFound({})".format(str(self))
    _UniffiTempLnUrlPayError.RouteNotFound = RouteNotFound # type: ignore
    class RouteTooExpensive(_UniffiTempLnUrlPayError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlPayError.RouteTooExpensive({})".format(str(self))
    _UniffiTempLnUrlPayError.RouteTooExpensive = RouteTooExpensive # type: ignore
    class ServiceConnectivity(_UniffiTempLnUrlPayError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlPayError.ServiceConnectivity({})".format(str(self))
    _UniffiTempLnUrlPayError.ServiceConnectivity = ServiceConnectivity # type: ignore

LnUrlPayError = _UniffiTempLnUrlPayError # type: ignore
del _UniffiTempLnUrlPayError


class _UniffiConverterTypeLnUrlPayError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return LnUrlPayError.AlreadyPaid(
            )
        if variant == 2:
            return LnUrlPayError.Generic(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return LnUrlPayError.InvalidAmount(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return LnUrlPayError.InvalidInvoice(
                _UniffiConverterString.read(buf),
            )
        if variant == 5:
            return LnUrlPayError.InvalidNetwork(
                _UniffiConverterString.read(buf),
            )
        if variant == 6:
            return LnUrlPayError.InvalidUri(
                _UniffiConverterString.read(buf),
            )
        if variant == 7:
            return LnUrlPayError.InvoiceExpired(
                _UniffiConverterString.read(buf),
            )
        if variant == 8:
            return LnUrlPayError.PaymentFailed(
                _UniffiConverterString.read(buf),
            )
        if variant == 9:
            return LnUrlPayError.PaymentTimeout(
                _UniffiConverterString.read(buf),
            )
        if variant == 10:
            return LnUrlPayError.RouteNotFound(
                _UniffiConverterString.read(buf),
            )
        if variant == 11:
            return LnUrlPayError.RouteTooExpensive(
                _UniffiConverterString.read(buf),
            )
        if variant == 12:
            return LnUrlPayError.ServiceConnectivity(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, LnUrlPayError.AlreadyPaid):
            return
        if isinstance(value, LnUrlPayError.Generic):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlPayError.InvalidAmount):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlPayError.InvalidInvoice):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlPayError.InvalidNetwork):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlPayError.InvalidUri):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlPayError.InvoiceExpired):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlPayError.PaymentFailed):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlPayError.PaymentTimeout):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlPayError.RouteNotFound):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlPayError.RouteTooExpensive):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlPayError.ServiceConnectivity):
            _UniffiConverterString.check_lower(value.err)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, LnUrlPayError.AlreadyPaid):
            buf.write_i32(1)
        if isinstance(value, LnUrlPayError.Generic):
            buf.write_i32(2)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlPayError.InvalidAmount):
            buf.write_i32(3)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlPayError.InvalidInvoice):
            buf.write_i32(4)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlPayError.InvalidNetwork):
            buf.write_i32(5)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlPayError.InvalidUri):
            buf.write_i32(6)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlPayError.InvoiceExpired):
            buf.write_i32(7)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlPayError.PaymentFailed):
            buf.write_i32(8)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlPayError.PaymentTimeout):
            buf.write_i32(9)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlPayError.RouteNotFound):
            buf.write_i32(10)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlPayError.RouteTooExpensive):
            buf.write_i32(11)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlPayError.ServiceConnectivity):
            buf.write_i32(12)
            _UniffiConverterString.write(value.err, buf)





class LnUrlPayResult:
    """
    /////////////////////////////
    ///////////////////////////////
    """

    def __init__(self):
        raise RuntimeError("LnUrlPayResult cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class ENDPOINT_SUCCESS:
        data: "LnUrlPaySuccessData"

        def __init__(self,data: "LnUrlPaySuccessData"):
            self.data = data

        def __str__(self):
            return "LnUrlPayResult.ENDPOINT_SUCCESS(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_endpoint_success():
                return False
            if self.data != other.data:
                return False
            return True
    
    class ENDPOINT_ERROR:
        data: "LnUrlErrorData"

        def __init__(self,data: "LnUrlErrorData"):
            self.data = data

        def __str__(self):
            return "LnUrlPayResult.ENDPOINT_ERROR(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_endpoint_error():
                return False
            if self.data != other.data:
                return False
            return True
    
    class PAY_ERROR:
        data: "LnUrlPayErrorData"

        def __init__(self,data: "LnUrlPayErrorData"):
            self.data = data

        def __str__(self):
            return "LnUrlPayResult.PAY_ERROR(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_pay_error():
                return False
            if self.data != other.data:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_endpoint_success(self) -> bool:
        return isinstance(self, LnUrlPayResult.ENDPOINT_SUCCESS)
    def is_endpoint_error(self) -> bool:
        return isinstance(self, LnUrlPayResult.ENDPOINT_ERROR)
    def is_pay_error(self) -> bool:
        return isinstance(self, LnUrlPayResult.PAY_ERROR)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
LnUrlPayResult.ENDPOINT_SUCCESS = type("LnUrlPayResult.ENDPOINT_SUCCESS", (LnUrlPayResult.ENDPOINT_SUCCESS, LnUrlPayResult,), {})  # type: ignore
LnUrlPayResult.ENDPOINT_ERROR = type("LnUrlPayResult.ENDPOINT_ERROR", (LnUrlPayResult.ENDPOINT_ERROR, LnUrlPayResult,), {})  # type: ignore
LnUrlPayResult.PAY_ERROR = type("LnUrlPayResult.PAY_ERROR", (LnUrlPayResult.PAY_ERROR, LnUrlPayResult,), {})  # type: ignore




class _UniffiConverterTypeLnUrlPayResult(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return LnUrlPayResult.ENDPOINT_SUCCESS(
                _UniffiConverterTypeLnUrlPaySuccessData.read(buf),
            )
        if variant == 2:
            return LnUrlPayResult.ENDPOINT_ERROR(
                _UniffiConverterTypeLnUrlErrorData.read(buf),
            )
        if variant == 3:
            return LnUrlPayResult.PAY_ERROR(
                _UniffiConverterTypeLnUrlPayErrorData.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_endpoint_success():
            _UniffiConverterTypeLnUrlPaySuccessData.check_lower(value.data)
            return
        if value.is_endpoint_error():
            _UniffiConverterTypeLnUrlErrorData.check_lower(value.data)
            return
        if value.is_pay_error():
            _UniffiConverterTypeLnUrlPayErrorData.check_lower(value.data)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_endpoint_success():
            buf.write_i32(1)
            _UniffiConverterTypeLnUrlPaySuccessData.write(value.data, buf)
        if value.is_endpoint_error():
            buf.write_i32(2)
            _UniffiConverterTypeLnUrlErrorData.write(value.data, buf)
        if value.is_pay_error():
            buf.write_i32(3)
            _UniffiConverterTypeLnUrlPayErrorData.write(value.data, buf)




# LnUrlWithdrawError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class LnUrlWithdrawError(Exception):
    pass

_UniffiTempLnUrlWithdrawError = LnUrlWithdrawError

class LnUrlWithdrawError:  # type: ignore
    class Generic(_UniffiTempLnUrlWithdrawError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlWithdrawError.Generic({})".format(str(self))
    _UniffiTempLnUrlWithdrawError.Generic = Generic # type: ignore
    class InvalidAmount(_UniffiTempLnUrlWithdrawError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlWithdrawError.InvalidAmount({})".format(str(self))
    _UniffiTempLnUrlWithdrawError.InvalidAmount = InvalidAmount # type: ignore
    class InvalidInvoice(_UniffiTempLnUrlWithdrawError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlWithdrawError.InvalidInvoice({})".format(str(self))
    _UniffiTempLnUrlWithdrawError.InvalidInvoice = InvalidInvoice # type: ignore
    class InvalidUri(_UniffiTempLnUrlWithdrawError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlWithdrawError.InvalidUri({})".format(str(self))
    _UniffiTempLnUrlWithdrawError.InvalidUri = InvalidUri # type: ignore
    class ServiceConnectivity(_UniffiTempLnUrlWithdrawError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlWithdrawError.ServiceConnectivity({})".format(str(self))
    _UniffiTempLnUrlWithdrawError.ServiceConnectivity = ServiceConnectivity # type: ignore
    class InvoiceNoRoutingHints(_UniffiTempLnUrlWithdrawError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "LnUrlWithdrawError.InvoiceNoRoutingHints({})".format(str(self))
    _UniffiTempLnUrlWithdrawError.InvoiceNoRoutingHints = InvoiceNoRoutingHints # type: ignore

LnUrlWithdrawError = _UniffiTempLnUrlWithdrawError # type: ignore
del _UniffiTempLnUrlWithdrawError


class _UniffiConverterTypeLnUrlWithdrawError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return LnUrlWithdrawError.Generic(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return LnUrlWithdrawError.InvalidAmount(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return LnUrlWithdrawError.InvalidInvoice(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return LnUrlWithdrawError.InvalidUri(
                _UniffiConverterString.read(buf),
            )
        if variant == 5:
            return LnUrlWithdrawError.ServiceConnectivity(
                _UniffiConverterString.read(buf),
            )
        if variant == 6:
            return LnUrlWithdrawError.InvoiceNoRoutingHints(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, LnUrlWithdrawError.Generic):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlWithdrawError.InvalidAmount):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlWithdrawError.InvalidInvoice):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlWithdrawError.InvalidUri):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlWithdrawError.ServiceConnectivity):
            _UniffiConverterString.check_lower(value.err)
            return
        if isinstance(value, LnUrlWithdrawError.InvoiceNoRoutingHints):
            _UniffiConverterString.check_lower(value.err)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, LnUrlWithdrawError.Generic):
            buf.write_i32(1)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlWithdrawError.InvalidAmount):
            buf.write_i32(2)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlWithdrawError.InvalidInvoice):
            buf.write_i32(3)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlWithdrawError.InvalidUri):
            buf.write_i32(4)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlWithdrawError.ServiceConnectivity):
            buf.write_i32(5)
            _UniffiConverterString.write(value.err, buf)
        if isinstance(value, LnUrlWithdrawError.InvoiceNoRoutingHints):
            buf.write_i32(6)
            _UniffiConverterString.write(value.err, buf)





class LnUrlWithdrawResult:
    def __init__(self):
        raise RuntimeError("LnUrlWithdrawResult cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class OK:
        data: "LnUrlWithdrawSuccessData"

        def __init__(self,data: "LnUrlWithdrawSuccessData"):
            self.data = data

        def __str__(self):
            return "LnUrlWithdrawResult.OK(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_ok():
                return False
            if self.data != other.data:
                return False
            return True
    
    class TIMEOUT:
        data: "LnUrlWithdrawSuccessData"

        def __init__(self,data: "LnUrlWithdrawSuccessData"):
            self.data = data

        def __str__(self):
            return "LnUrlWithdrawResult.TIMEOUT(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_timeout():
                return False
            if self.data != other.data:
                return False
            return True
    
    class ERROR_STATUS:
        data: "LnUrlErrorData"

        def __init__(self,data: "LnUrlErrorData"):
            self.data = data

        def __str__(self):
            return "LnUrlWithdrawResult.ERROR_STATUS(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_error_status():
                return False
            if self.data != other.data:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_ok(self) -> bool:
        return isinstance(self, LnUrlWithdrawResult.OK)
    def is_timeout(self) -> bool:
        return isinstance(self, LnUrlWithdrawResult.TIMEOUT)
    def is_error_status(self) -> bool:
        return isinstance(self, LnUrlWithdrawResult.ERROR_STATUS)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
LnUrlWithdrawResult.OK = type("LnUrlWithdrawResult.OK", (LnUrlWithdrawResult.OK, LnUrlWithdrawResult,), {})  # type: ignore
LnUrlWithdrawResult.TIMEOUT = type("LnUrlWithdrawResult.TIMEOUT", (LnUrlWithdrawResult.TIMEOUT, LnUrlWithdrawResult,), {})  # type: ignore
LnUrlWithdrawResult.ERROR_STATUS = type("LnUrlWithdrawResult.ERROR_STATUS", (LnUrlWithdrawResult.ERROR_STATUS, LnUrlWithdrawResult,), {})  # type: ignore




class _UniffiConverterTypeLnUrlWithdrawResult(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return LnUrlWithdrawResult.OK(
                _UniffiConverterTypeLnUrlWithdrawSuccessData.read(buf),
            )
        if variant == 2:
            return LnUrlWithdrawResult.TIMEOUT(
                _UniffiConverterTypeLnUrlWithdrawSuccessData.read(buf),
            )
        if variant == 3:
            return LnUrlWithdrawResult.ERROR_STATUS(
                _UniffiConverterTypeLnUrlErrorData.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_ok():
            _UniffiConverterTypeLnUrlWithdrawSuccessData.check_lower(value.data)
            return
        if value.is_timeout():
            _UniffiConverterTypeLnUrlWithdrawSuccessData.check_lower(value.data)
            return
        if value.is_error_status():
            _UniffiConverterTypeLnUrlErrorData.check_lower(value.data)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_ok():
            buf.write_i32(1)
            _UniffiConverterTypeLnUrlWithdrawSuccessData.write(value.data, buf)
        if value.is_timeout():
            buf.write_i32(2)
            _UniffiConverterTypeLnUrlWithdrawSuccessData.write(value.data, buf)
        if value.is_error_status():
            buf.write_i32(3)
            _UniffiConverterTypeLnUrlErrorData.write(value.data, buf)







class Network(enum.Enum):
    BITCOIN = 0
    
    TESTNET = 1
    
    SIGNET = 2
    
    REGTEST = 3
    


class _UniffiConverterTypeNetwork(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Network.BITCOIN
        if variant == 2:
            return Network.TESTNET
        if variant == 3:
            return Network.SIGNET
        if variant == 4:
            return Network.REGTEST
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == Network.BITCOIN:
            return
        if value == Network.TESTNET:
            return
        if value == Network.SIGNET:
            return
        if value == Network.REGTEST:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == Network.BITCOIN:
            buf.write_i32(1)
        if value == Network.TESTNET:
            buf.write_i32(2)
        if value == Network.SIGNET:
            buf.write_i32(3)
        if value == Network.REGTEST:
            buf.write_i32(4)







class PayAmount:
    def __init__(self):
        raise RuntimeError("PayAmount cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class BITCOIN:
        receiver_amount_sat: "int"

        def __init__(self,receiver_amount_sat: "int"):
            self.receiver_amount_sat = receiver_amount_sat

        def __str__(self):
            return "PayAmount.BITCOIN(receiver_amount_sat={})".format(self.receiver_amount_sat)

        def __eq__(self, other):
            if not other.is_bitcoin():
                return False
            if self.receiver_amount_sat != other.receiver_amount_sat:
                return False
            return True
    
    class ASSET:
        asset_id: "str"
        receiver_amount: "float"

        def __init__(self,asset_id: "str", receiver_amount: "float"):
            self.asset_id = asset_id
            self.receiver_amount = receiver_amount

        def __str__(self):
            return "PayAmount.ASSET(asset_id={}, receiver_amount={})".format(self.asset_id, self.receiver_amount)

        def __eq__(self, other):
            if not other.is_asset():
                return False
            if self.asset_id != other.asset_id:
                return False
            if self.receiver_amount != other.receiver_amount:
                return False
            return True
    
    class DRAIN:

        def __init__(self,):
            pass

        def __str__(self):
            return "PayAmount.DRAIN()".format()

        def __eq__(self, other):
            if not other.is_drain():
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_bitcoin(self) -> bool:
        return isinstance(self, PayAmount.BITCOIN)
    def is_asset(self) -> bool:
        return isinstance(self, PayAmount.ASSET)
    def is_drain(self) -> bool:
        return isinstance(self, PayAmount.DRAIN)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
PayAmount.BITCOIN = type("PayAmount.BITCOIN", (PayAmount.BITCOIN, PayAmount,), {})  # type: ignore
PayAmount.ASSET = type("PayAmount.ASSET", (PayAmount.ASSET, PayAmount,), {})  # type: ignore
PayAmount.DRAIN = type("PayAmount.DRAIN", (PayAmount.DRAIN, PayAmount,), {})  # type: ignore




class _UniffiConverterTypePayAmount(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return PayAmount.BITCOIN(
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 2:
            return PayAmount.ASSET(
                _UniffiConverterString.read(buf),
                _UniffiConverterDouble.read(buf),
            )
        if variant == 3:
            return PayAmount.DRAIN(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_bitcoin():
            _UniffiConverterUInt64.check_lower(value.receiver_amount_sat)
            return
        if value.is_asset():
            _UniffiConverterString.check_lower(value.asset_id)
            _UniffiConverterDouble.check_lower(value.receiver_amount)
            return
        if value.is_drain():
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_bitcoin():
            buf.write_i32(1)
            _UniffiConverterUInt64.write(value.receiver_amount_sat, buf)
        if value.is_asset():
            buf.write_i32(2)
            _UniffiConverterString.write(value.asset_id, buf)
            _UniffiConverterDouble.write(value.receiver_amount, buf)
        if value.is_drain():
            buf.write_i32(3)







class PaymentDetails:
    def __init__(self):
        raise RuntimeError("PaymentDetails cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class LIGHTNING:
        swap_id: "str"
        description: "str"
        liquid_expiration_blockheight: "int"
        preimage: "typing.Optional[str]"
        invoice: "typing.Optional[str]"
        bolt12_offer: "typing.Optional[str]"
        payment_hash: "typing.Optional[str]"
        destination_pubkey: "typing.Optional[str]"
        lnurl_info: "typing.Optional[LnUrlInfo]"
        bip353_address: "typing.Optional[str]"
        claim_tx_id: "typing.Optional[str]"
        refund_tx_id: "typing.Optional[str]"
        refund_tx_amount_sat: "typing.Optional[int]"

        def __init__(self,swap_id: "str", description: "str", liquid_expiration_blockheight: "int", preimage: "typing.Optional[str]", invoice: "typing.Optional[str]", bolt12_offer: "typing.Optional[str]", payment_hash: "typing.Optional[str]", destination_pubkey: "typing.Optional[str]", lnurl_info: "typing.Optional[LnUrlInfo]", bip353_address: "typing.Optional[str]", claim_tx_id: "typing.Optional[str]", refund_tx_id: "typing.Optional[str]", refund_tx_amount_sat: "typing.Optional[int]"):
            self.swap_id = swap_id
            self.description = description
            self.liquid_expiration_blockheight = liquid_expiration_blockheight
            self.preimage = preimage
            self.invoice = invoice
            self.bolt12_offer = bolt12_offer
            self.payment_hash = payment_hash
            self.destination_pubkey = destination_pubkey
            self.lnurl_info = lnurl_info
            self.bip353_address = bip353_address
            self.claim_tx_id = claim_tx_id
            self.refund_tx_id = refund_tx_id
            self.refund_tx_amount_sat = refund_tx_amount_sat

        def __str__(self):
            return "PaymentDetails.LIGHTNING(swap_id={}, description={}, liquid_expiration_blockheight={}, preimage={}, invoice={}, bolt12_offer={}, payment_hash={}, destination_pubkey={}, lnurl_info={}, bip353_address={}, claim_tx_id={}, refund_tx_id={}, refund_tx_amount_sat={})".format(self.swap_id, self.description, self.liquid_expiration_blockheight, self.preimage, self.invoice, self.bolt12_offer, self.payment_hash, self.destination_pubkey, self.lnurl_info, self.bip353_address, self.claim_tx_id, self.refund_tx_id, self.refund_tx_amount_sat)

        def __eq__(self, other):
            if not other.is_lightning():
                return False
            if self.swap_id != other.swap_id:
                return False
            if self.description != other.description:
                return False
            if self.liquid_expiration_blockheight != other.liquid_expiration_blockheight:
                return False
            if self.preimage != other.preimage:
                return False
            if self.invoice != other.invoice:
                return False
            if self.bolt12_offer != other.bolt12_offer:
                return False
            if self.payment_hash != other.payment_hash:
                return False
            if self.destination_pubkey != other.destination_pubkey:
                return False
            if self.lnurl_info != other.lnurl_info:
                return False
            if self.bip353_address != other.bip353_address:
                return False
            if self.claim_tx_id != other.claim_tx_id:
                return False
            if self.refund_tx_id != other.refund_tx_id:
                return False
            if self.refund_tx_amount_sat != other.refund_tx_amount_sat:
                return False
            return True
    
    class LIQUID:
        asset_id: "str"
        destination: "str"
        description: "str"
        asset_info: "typing.Optional[AssetInfo]"

        def __init__(self,asset_id: "str", destination: "str", description: "str", asset_info: "typing.Optional[AssetInfo]"):
            self.asset_id = asset_id
            self.destination = destination
            self.description = description
            self.asset_info = asset_info

        def __str__(self):
            return "PaymentDetails.LIQUID(asset_id={}, destination={}, description={}, asset_info={})".format(self.asset_id, self.destination, self.description, self.asset_info)

        def __eq__(self, other):
            if not other.is_liquid():
                return False
            if self.asset_id != other.asset_id:
                return False
            if self.destination != other.destination:
                return False
            if self.description != other.description:
                return False
            if self.asset_info != other.asset_info:
                return False
            return True
    
    class BITCOIN:
        swap_id: "str"
        description: "str"
        auto_accepted_fees: "bool"
        bitcoin_expiration_blockheight: "typing.Optional[int]"
        liquid_expiration_blockheight: "typing.Optional[int]"
        claim_tx_id: "typing.Optional[str]"
        refund_tx_id: "typing.Optional[str]"
        refund_tx_amount_sat: "typing.Optional[int]"

        def __init__(self,swap_id: "str", description: "str", auto_accepted_fees: "bool", bitcoin_expiration_blockheight: "typing.Optional[int]", liquid_expiration_blockheight: "typing.Optional[int]", claim_tx_id: "typing.Optional[str]", refund_tx_id: "typing.Optional[str]", refund_tx_amount_sat: "typing.Optional[int]"):
            self.swap_id = swap_id
            self.description = description
            self.auto_accepted_fees = auto_accepted_fees
            self.bitcoin_expiration_blockheight = bitcoin_expiration_blockheight
            self.liquid_expiration_blockheight = liquid_expiration_blockheight
            self.claim_tx_id = claim_tx_id
            self.refund_tx_id = refund_tx_id
            self.refund_tx_amount_sat = refund_tx_amount_sat

        def __str__(self):
            return "PaymentDetails.BITCOIN(swap_id={}, description={}, auto_accepted_fees={}, bitcoin_expiration_blockheight={}, liquid_expiration_blockheight={}, claim_tx_id={}, refund_tx_id={}, refund_tx_amount_sat={})".format(self.swap_id, self.description, self.auto_accepted_fees, self.bitcoin_expiration_blockheight, self.liquid_expiration_blockheight, self.claim_tx_id, self.refund_tx_id, self.refund_tx_amount_sat)

        def __eq__(self, other):
            if not other.is_bitcoin():
                return False
            if self.swap_id != other.swap_id:
                return False
            if self.description != other.description:
                return False
            if self.auto_accepted_fees != other.auto_accepted_fees:
                return False
            if self.bitcoin_expiration_blockheight != other.bitcoin_expiration_blockheight:
                return False
            if self.liquid_expiration_blockheight != other.liquid_expiration_blockheight:
                return False
            if self.claim_tx_id != other.claim_tx_id:
                return False
            if self.refund_tx_id != other.refund_tx_id:
                return False
            if self.refund_tx_amount_sat != other.refund_tx_amount_sat:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_lightning(self) -> bool:
        return isinstance(self, PaymentDetails.LIGHTNING)
    def is_liquid(self) -> bool:
        return isinstance(self, PaymentDetails.LIQUID)
    def is_bitcoin(self) -> bool:
        return isinstance(self, PaymentDetails.BITCOIN)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
PaymentDetails.LIGHTNING = type("PaymentDetails.LIGHTNING", (PaymentDetails.LIGHTNING, PaymentDetails,), {})  # type: ignore
PaymentDetails.LIQUID = type("PaymentDetails.LIQUID", (PaymentDetails.LIQUID, PaymentDetails,), {})  # type: ignore
PaymentDetails.BITCOIN = type("PaymentDetails.BITCOIN", (PaymentDetails.BITCOIN, PaymentDetails,), {})  # type: ignore




class _UniffiConverterTypePaymentDetails(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return PaymentDetails.LIGHTNING(
                _UniffiConverterString.read(buf),
                _UniffiConverterString.read(buf),
                _UniffiConverterUInt32.read(buf),
                _UniffiConverterOptionalString.read(buf),
                _UniffiConverterOptionalString.read(buf),
                _UniffiConverterOptionalString.read(buf),
                _UniffiConverterOptionalString.read(buf),
                _UniffiConverterOptionalString.read(buf),
                _UniffiConverterOptionalTypeLnUrlInfo.read(buf),
                _UniffiConverterOptionalString.read(buf),
                _UniffiConverterOptionalString.read(buf),
                _UniffiConverterOptionalString.read(buf),
                _UniffiConverterOptionalUInt64.read(buf),
            )
        if variant == 2:
            return PaymentDetails.LIQUID(
                _UniffiConverterString.read(buf),
                _UniffiConverterString.read(buf),
                _UniffiConverterString.read(buf),
                _UniffiConverterOptionalTypeAssetInfo.read(buf),
            )
        if variant == 3:
            return PaymentDetails.BITCOIN(
                _UniffiConverterString.read(buf),
                _UniffiConverterString.read(buf),
                _UniffiConverterBool.read(buf),
                _UniffiConverterOptionalUInt32.read(buf),
                _UniffiConverterOptionalUInt32.read(buf),
                _UniffiConverterOptionalString.read(buf),
                _UniffiConverterOptionalString.read(buf),
                _UniffiConverterOptionalUInt64.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_lightning():
            _UniffiConverterString.check_lower(value.swap_id)
            _UniffiConverterString.check_lower(value.description)
            _UniffiConverterUInt32.check_lower(value.liquid_expiration_blockheight)
            _UniffiConverterOptionalString.check_lower(value.preimage)
            _UniffiConverterOptionalString.check_lower(value.invoice)
            _UniffiConverterOptionalString.check_lower(value.bolt12_offer)
            _UniffiConverterOptionalString.check_lower(value.payment_hash)
            _UniffiConverterOptionalString.check_lower(value.destination_pubkey)
            _UniffiConverterOptionalTypeLnUrlInfo.check_lower(value.lnurl_info)
            _UniffiConverterOptionalString.check_lower(value.bip353_address)
            _UniffiConverterOptionalString.check_lower(value.claim_tx_id)
            _UniffiConverterOptionalString.check_lower(value.refund_tx_id)
            _UniffiConverterOptionalUInt64.check_lower(value.refund_tx_amount_sat)
            return
        if value.is_liquid():
            _UniffiConverterString.check_lower(value.asset_id)
            _UniffiConverterString.check_lower(value.destination)
            _UniffiConverterString.check_lower(value.description)
            _UniffiConverterOptionalTypeAssetInfo.check_lower(value.asset_info)
            return
        if value.is_bitcoin():
            _UniffiConverterString.check_lower(value.swap_id)
            _UniffiConverterString.check_lower(value.description)
            _UniffiConverterBool.check_lower(value.auto_accepted_fees)
            _UniffiConverterOptionalUInt32.check_lower(value.bitcoin_expiration_blockheight)
            _UniffiConverterOptionalUInt32.check_lower(value.liquid_expiration_blockheight)
            _UniffiConverterOptionalString.check_lower(value.claim_tx_id)
            _UniffiConverterOptionalString.check_lower(value.refund_tx_id)
            _UniffiConverterOptionalUInt64.check_lower(value.refund_tx_amount_sat)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_lightning():
            buf.write_i32(1)
            _UniffiConverterString.write(value.swap_id, buf)
            _UniffiConverterString.write(value.description, buf)
            _UniffiConverterUInt32.write(value.liquid_expiration_blockheight, buf)
            _UniffiConverterOptionalString.write(value.preimage, buf)
            _UniffiConverterOptionalString.write(value.invoice, buf)
            _UniffiConverterOptionalString.write(value.bolt12_offer, buf)
            _UniffiConverterOptionalString.write(value.payment_hash, buf)
            _UniffiConverterOptionalString.write(value.destination_pubkey, buf)
            _UniffiConverterOptionalTypeLnUrlInfo.write(value.lnurl_info, buf)
            _UniffiConverterOptionalString.write(value.bip353_address, buf)
            _UniffiConverterOptionalString.write(value.claim_tx_id, buf)
            _UniffiConverterOptionalString.write(value.refund_tx_id, buf)
            _UniffiConverterOptionalUInt64.write(value.refund_tx_amount_sat, buf)
        if value.is_liquid():
            buf.write_i32(2)
            _UniffiConverterString.write(value.asset_id, buf)
            _UniffiConverterString.write(value.destination, buf)
            _UniffiConverterString.write(value.description, buf)
            _UniffiConverterOptionalTypeAssetInfo.write(value.asset_info, buf)
        if value.is_bitcoin():
            buf.write_i32(3)
            _UniffiConverterString.write(value.swap_id, buf)
            _UniffiConverterString.write(value.description, buf)
            _UniffiConverterBool.write(value.auto_accepted_fees, buf)
            _UniffiConverterOptionalUInt32.write(value.bitcoin_expiration_blockheight, buf)
            _UniffiConverterOptionalUInt32.write(value.liquid_expiration_blockheight, buf)
            _UniffiConverterOptionalString.write(value.claim_tx_id, buf)
            _UniffiConverterOptionalString.write(value.refund_tx_id, buf)
            _UniffiConverterOptionalUInt64.write(value.refund_tx_amount_sat, buf)




# PaymentError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class PaymentError(Exception):
    pass

_UniffiTempPaymentError = PaymentError

class PaymentError:  # type: ignore
    class AlreadyClaimed(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.AlreadyClaimed({})".format(repr(str(self)))
    _UniffiTempPaymentError.AlreadyClaimed = AlreadyClaimed # type: ignore
    class AlreadyPaid(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.AlreadyPaid({})".format(repr(str(self)))
    _UniffiTempPaymentError.AlreadyPaid = AlreadyPaid # type: ignore
    class PaymentInProgress(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.PaymentInProgress({})".format(repr(str(self)))
    _UniffiTempPaymentError.PaymentInProgress = PaymentInProgress # type: ignore
    class AmountOutOfRange(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.AmountOutOfRange({})".format(repr(str(self)))
    _UniffiTempPaymentError.AmountOutOfRange = AmountOutOfRange # type: ignore
    class AmountMissing(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.AmountMissing({})".format(repr(str(self)))
    _UniffiTempPaymentError.AmountMissing = AmountMissing # type: ignore
    class AssetError(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.AssetError({})".format(repr(str(self)))
    _UniffiTempPaymentError.AssetError = AssetError # type: ignore
    class Generic(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.Generic({})".format(repr(str(self)))
    _UniffiTempPaymentError.Generic = Generic # type: ignore
    class InvalidOrExpiredFees(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.InvalidOrExpiredFees({})".format(repr(str(self)))
    _UniffiTempPaymentError.InvalidOrExpiredFees = InvalidOrExpiredFees # type: ignore
    class InsufficientFunds(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.InsufficientFunds({})".format(repr(str(self)))
    _UniffiTempPaymentError.InsufficientFunds = InsufficientFunds # type: ignore
    class InvalidDescription(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.InvalidDescription({})".format(repr(str(self)))
    _UniffiTempPaymentError.InvalidDescription = InvalidDescription # type: ignore
    class InvalidInvoice(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.InvalidInvoice({})".format(repr(str(self)))
    _UniffiTempPaymentError.InvalidInvoice = InvalidInvoice # type: ignore
    class InvalidNetwork(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.InvalidNetwork({})".format(repr(str(self)))
    _UniffiTempPaymentError.InvalidNetwork = InvalidNetwork # type: ignore
    class InvalidPreimage(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.InvalidPreimage({})".format(repr(str(self)))
    _UniffiTempPaymentError.InvalidPreimage = InvalidPreimage # type: ignore
    class PairsNotFound(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.PairsNotFound({})".format(repr(str(self)))
    _UniffiTempPaymentError.PairsNotFound = PairsNotFound # type: ignore
    class PaymentTimeout(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.PaymentTimeout({})".format(repr(str(self)))
    _UniffiTempPaymentError.PaymentTimeout = PaymentTimeout # type: ignore
    class PersistError(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.PersistError({})".format(repr(str(self)))
    _UniffiTempPaymentError.PersistError = PersistError # type: ignore
    class ReceiveError(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.ReceiveError({})".format(repr(str(self)))
    _UniffiTempPaymentError.ReceiveError = ReceiveError # type: ignore
    class Refunded(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.Refunded({})".format(repr(str(self)))
    _UniffiTempPaymentError.Refunded = Refunded # type: ignore
    class SelfTransferNotSupported(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.SelfTransferNotSupported({})".format(repr(str(self)))
    _UniffiTempPaymentError.SelfTransferNotSupported = SelfTransferNotSupported # type: ignore
    class SendError(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.SendError({})".format(repr(str(self)))
    _UniffiTempPaymentError.SendError = SendError # type: ignore
    class SignerError(_UniffiTempPaymentError):

        def __repr__(self):
            return "PaymentError.SignerError({})".format(repr(str(self)))
    _UniffiTempPaymentError.SignerError = SignerError # type: ignore

PaymentError = _UniffiTempPaymentError # type: ignore
del _UniffiTempPaymentError


class _UniffiConverterTypePaymentError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return PaymentError.AlreadyClaimed(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return PaymentError.AlreadyPaid(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return PaymentError.PaymentInProgress(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return PaymentError.AmountOutOfRange(
                _UniffiConverterString.read(buf),
            )
        if variant == 5:
            return PaymentError.AmountMissing(
                _UniffiConverterString.read(buf),
            )
        if variant == 6:
            return PaymentError.AssetError(
                _UniffiConverterString.read(buf),
            )
        if variant == 7:
            return PaymentError.Generic(
                _UniffiConverterString.read(buf),
            )
        if variant == 8:
            return PaymentError.InvalidOrExpiredFees(
                _UniffiConverterString.read(buf),
            )
        if variant == 9:
            return PaymentError.InsufficientFunds(
                _UniffiConverterString.read(buf),
            )
        if variant == 10:
            return PaymentError.InvalidDescription(
                _UniffiConverterString.read(buf),
            )
        if variant == 11:
            return PaymentError.InvalidInvoice(
                _UniffiConverterString.read(buf),
            )
        if variant == 12:
            return PaymentError.InvalidNetwork(
                _UniffiConverterString.read(buf),
            )
        if variant == 13:
            return PaymentError.InvalidPreimage(
                _UniffiConverterString.read(buf),
            )
        if variant == 14:
            return PaymentError.PairsNotFound(
                _UniffiConverterString.read(buf),
            )
        if variant == 15:
            return PaymentError.PaymentTimeout(
                _UniffiConverterString.read(buf),
            )
        if variant == 16:
            return PaymentError.PersistError(
                _UniffiConverterString.read(buf),
            )
        if variant == 17:
            return PaymentError.ReceiveError(
                _UniffiConverterString.read(buf),
            )
        if variant == 18:
            return PaymentError.Refunded(
                _UniffiConverterString.read(buf),
            )
        if variant == 19:
            return PaymentError.SelfTransferNotSupported(
                _UniffiConverterString.read(buf),
            )
        if variant == 20:
            return PaymentError.SendError(
                _UniffiConverterString.read(buf),
            )
        if variant == 21:
            return PaymentError.SignerError(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, PaymentError.AlreadyClaimed):
            return
        if isinstance(value, PaymentError.AlreadyPaid):
            return
        if isinstance(value, PaymentError.PaymentInProgress):
            return
        if isinstance(value, PaymentError.AmountOutOfRange):
            return
        if isinstance(value, PaymentError.AmountMissing):
            return
        if isinstance(value, PaymentError.AssetError):
            return
        if isinstance(value, PaymentError.Generic):
            return
        if isinstance(value, PaymentError.InvalidOrExpiredFees):
            return
        if isinstance(value, PaymentError.InsufficientFunds):
            return
        if isinstance(value, PaymentError.InvalidDescription):
            return
        if isinstance(value, PaymentError.InvalidInvoice):
            return
        if isinstance(value, PaymentError.InvalidNetwork):
            return
        if isinstance(value, PaymentError.InvalidPreimage):
            return
        if isinstance(value, PaymentError.PairsNotFound):
            return
        if isinstance(value, PaymentError.PaymentTimeout):
            return
        if isinstance(value, PaymentError.PersistError):
            return
        if isinstance(value, PaymentError.ReceiveError):
            return
        if isinstance(value, PaymentError.Refunded):
            return
        if isinstance(value, PaymentError.SelfTransferNotSupported):
            return
        if isinstance(value, PaymentError.SendError):
            return
        if isinstance(value, PaymentError.SignerError):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, PaymentError.AlreadyClaimed):
            buf.write_i32(1)
        if isinstance(value, PaymentError.AlreadyPaid):
            buf.write_i32(2)
        if isinstance(value, PaymentError.PaymentInProgress):
            buf.write_i32(3)
        if isinstance(value, PaymentError.AmountOutOfRange):
            buf.write_i32(4)
        if isinstance(value, PaymentError.AmountMissing):
            buf.write_i32(5)
        if isinstance(value, PaymentError.AssetError):
            buf.write_i32(6)
        if isinstance(value, PaymentError.Generic):
            buf.write_i32(7)
        if isinstance(value, PaymentError.InvalidOrExpiredFees):
            buf.write_i32(8)
        if isinstance(value, PaymentError.InsufficientFunds):
            buf.write_i32(9)
        if isinstance(value, PaymentError.InvalidDescription):
            buf.write_i32(10)
        if isinstance(value, PaymentError.InvalidInvoice):
            buf.write_i32(11)
        if isinstance(value, PaymentError.InvalidNetwork):
            buf.write_i32(12)
        if isinstance(value, PaymentError.InvalidPreimage):
            buf.write_i32(13)
        if isinstance(value, PaymentError.PairsNotFound):
            buf.write_i32(14)
        if isinstance(value, PaymentError.PaymentTimeout):
            buf.write_i32(15)
        if isinstance(value, PaymentError.PersistError):
            buf.write_i32(16)
        if isinstance(value, PaymentError.ReceiveError):
            buf.write_i32(17)
        if isinstance(value, PaymentError.Refunded):
            buf.write_i32(18)
        if isinstance(value, PaymentError.SelfTransferNotSupported):
            buf.write_i32(19)
        if isinstance(value, PaymentError.SendError):
            buf.write_i32(20)
        if isinstance(value, PaymentError.SignerError):
            buf.write_i32(21)





class PaymentMethod(enum.Enum):
    LIGHTNING = 0
    
    BITCOIN_ADDRESS = 1
    
    LIQUID_ADDRESS = 2
    


class _UniffiConverterTypePaymentMethod(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return PaymentMethod.LIGHTNING
        if variant == 2:
            return PaymentMethod.BITCOIN_ADDRESS
        if variant == 3:
            return PaymentMethod.LIQUID_ADDRESS
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == PaymentMethod.LIGHTNING:
            return
        if value == PaymentMethod.BITCOIN_ADDRESS:
            return
        if value == PaymentMethod.LIQUID_ADDRESS:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == PaymentMethod.LIGHTNING:
            buf.write_i32(1)
        if value == PaymentMethod.BITCOIN_ADDRESS:
            buf.write_i32(2)
        if value == PaymentMethod.LIQUID_ADDRESS:
            buf.write_i32(3)







class PaymentState(enum.Enum):
    CREATED = 0
    
    PENDING = 1
    
    COMPLETE = 2
    
    FAILED = 3
    
    TIMED_OUT = 4
    
    REFUNDABLE = 5
    
    REFUND_PENDING = 6
    
    WAITING_FEE_ACCEPTANCE = 7
    


class _UniffiConverterTypePaymentState(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return PaymentState.CREATED
        if variant == 2:
            return PaymentState.PENDING
        if variant == 3:
            return PaymentState.COMPLETE
        if variant == 4:
            return PaymentState.FAILED
        if variant == 5:
            return PaymentState.TIMED_OUT
        if variant == 6:
            return PaymentState.REFUNDABLE
        if variant == 7:
            return PaymentState.REFUND_PENDING
        if variant == 8:
            return PaymentState.WAITING_FEE_ACCEPTANCE
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == PaymentState.CREATED:
            return
        if value == PaymentState.PENDING:
            return
        if value == PaymentState.COMPLETE:
            return
        if value == PaymentState.FAILED:
            return
        if value == PaymentState.TIMED_OUT:
            return
        if value == PaymentState.REFUNDABLE:
            return
        if value == PaymentState.REFUND_PENDING:
            return
        if value == PaymentState.WAITING_FEE_ACCEPTANCE:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == PaymentState.CREATED:
            buf.write_i32(1)
        if value == PaymentState.PENDING:
            buf.write_i32(2)
        if value == PaymentState.COMPLETE:
            buf.write_i32(3)
        if value == PaymentState.FAILED:
            buf.write_i32(4)
        if value == PaymentState.TIMED_OUT:
            buf.write_i32(5)
        if value == PaymentState.REFUNDABLE:
            buf.write_i32(6)
        if value == PaymentState.REFUND_PENDING:
            buf.write_i32(7)
        if value == PaymentState.WAITING_FEE_ACCEPTANCE:
            buf.write_i32(8)







class PaymentType(enum.Enum):
    RECEIVE = 0
    
    SEND = 1
    


class _UniffiConverterTypePaymentType(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return PaymentType.RECEIVE
        if variant == 2:
            return PaymentType.SEND
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == PaymentType.RECEIVE:
            return
        if value == PaymentType.SEND:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == PaymentType.RECEIVE:
            buf.write_i32(1)
        if value == PaymentType.SEND:
            buf.write_i32(2)







class ReceiveAmount:
    def __init__(self):
        raise RuntimeError("ReceiveAmount cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class BITCOIN:
        payer_amount_sat: "int"

        def __init__(self,payer_amount_sat: "int"):
            self.payer_amount_sat = payer_amount_sat

        def __str__(self):
            return "ReceiveAmount.BITCOIN(payer_amount_sat={})".format(self.payer_amount_sat)

        def __eq__(self, other):
            if not other.is_bitcoin():
                return False
            if self.payer_amount_sat != other.payer_amount_sat:
                return False
            return True
    
    class ASSET:
        asset_id: "str"
        payer_amount: "typing.Optional[float]"

        def __init__(self,asset_id: "str", payer_amount: "typing.Optional[float]"):
            self.asset_id = asset_id
            self.payer_amount = payer_amount

        def __str__(self):
            return "ReceiveAmount.ASSET(asset_id={}, payer_amount={})".format(self.asset_id, self.payer_amount)

        def __eq__(self, other):
            if not other.is_asset():
                return False
            if self.asset_id != other.asset_id:
                return False
            if self.payer_amount != other.payer_amount:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_bitcoin(self) -> bool:
        return isinstance(self, ReceiveAmount.BITCOIN)
    def is_asset(self) -> bool:
        return isinstance(self, ReceiveAmount.ASSET)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
ReceiveAmount.BITCOIN = type("ReceiveAmount.BITCOIN", (ReceiveAmount.BITCOIN, ReceiveAmount,), {})  # type: ignore
ReceiveAmount.ASSET = type("ReceiveAmount.ASSET", (ReceiveAmount.ASSET, ReceiveAmount,), {})  # type: ignore




class _UniffiConverterTypeReceiveAmount(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return ReceiveAmount.BITCOIN(
                _UniffiConverterUInt64.read(buf),
            )
        if variant == 2:
            return ReceiveAmount.ASSET(
                _UniffiConverterString.read(buf),
                _UniffiConverterOptionalDouble.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_bitcoin():
            _UniffiConverterUInt64.check_lower(value.payer_amount_sat)
            return
        if value.is_asset():
            _UniffiConverterString.check_lower(value.asset_id)
            _UniffiConverterOptionalDouble.check_lower(value.payer_amount)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_bitcoin():
            buf.write_i32(1)
            _UniffiConverterUInt64.write(value.payer_amount_sat, buf)
        if value.is_asset():
            buf.write_i32(2)
            _UniffiConverterString.write(value.asset_id, buf)
            _UniffiConverterOptionalDouble.write(value.payer_amount, buf)




# SdkError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class SdkError(Exception):
    """
    /////////////////////////////
    """

    pass

_UniffiTempSdkError = SdkError

class SdkError:  # type: ignore
    """
    /////////////////////////////
    """

    class AlreadyStarted(_UniffiTempSdkError):

        def __repr__(self):
            return "SdkError.AlreadyStarted({})".format(repr(str(self)))
    _UniffiTempSdkError.AlreadyStarted = AlreadyStarted # type: ignore
    class Generic(_UniffiTempSdkError):

        def __repr__(self):
            return "SdkError.Generic({})".format(repr(str(self)))
    _UniffiTempSdkError.Generic = Generic # type: ignore
    class NotStarted(_UniffiTempSdkError):

        def __repr__(self):
            return "SdkError.NotStarted({})".format(repr(str(self)))
    _UniffiTempSdkError.NotStarted = NotStarted # type: ignore
    class ServiceConnectivity(_UniffiTempSdkError):

        def __repr__(self):
            return "SdkError.ServiceConnectivity({})".format(repr(str(self)))
    _UniffiTempSdkError.ServiceConnectivity = ServiceConnectivity # type: ignore

SdkError = _UniffiTempSdkError # type: ignore
del _UniffiTempSdkError


class _UniffiConverterTypeSdkError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SdkError.AlreadyStarted(
                _UniffiConverterString.read(buf),
            )
        if variant == 2:
            return SdkError.Generic(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return SdkError.NotStarted(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return SdkError.ServiceConnectivity(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, SdkError.AlreadyStarted):
            return
        if isinstance(value, SdkError.Generic):
            return
        if isinstance(value, SdkError.NotStarted):
            return
        if isinstance(value, SdkError.ServiceConnectivity):
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, SdkError.AlreadyStarted):
            buf.write_i32(1)
        if isinstance(value, SdkError.Generic):
            buf.write_i32(2)
        if isinstance(value, SdkError.NotStarted):
            buf.write_i32(3)
        if isinstance(value, SdkError.ServiceConnectivity):
            buf.write_i32(4)





class SdkEvent:
    def __init__(self):
        raise RuntimeError("SdkEvent cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class PAYMENT_FAILED:
        details: "Payment"

        def __init__(self,details: "Payment"):
            self.details = details

        def __str__(self):
            return "SdkEvent.PAYMENT_FAILED(details={})".format(self.details)

        def __eq__(self, other):
            if not other.is_payment_failed():
                return False
            if self.details != other.details:
                return False
            return True
    
    class PAYMENT_PENDING:
        details: "Payment"

        def __init__(self,details: "Payment"):
            self.details = details

        def __str__(self):
            return "SdkEvent.PAYMENT_PENDING(details={})".format(self.details)

        def __eq__(self, other):
            if not other.is_payment_pending():
                return False
            if self.details != other.details:
                return False
            return True
    
    class PAYMENT_REFUNDABLE:
        details: "Payment"

        def __init__(self,details: "Payment"):
            self.details = details

        def __str__(self):
            return "SdkEvent.PAYMENT_REFUNDABLE(details={})".format(self.details)

        def __eq__(self, other):
            if not other.is_payment_refundable():
                return False
            if self.details != other.details:
                return False
            return True
    
    class PAYMENT_REFUNDED:
        details: "Payment"

        def __init__(self,details: "Payment"):
            self.details = details

        def __str__(self):
            return "SdkEvent.PAYMENT_REFUNDED(details={})".format(self.details)

        def __eq__(self, other):
            if not other.is_payment_refunded():
                return False
            if self.details != other.details:
                return False
            return True
    
    class PAYMENT_REFUND_PENDING:
        details: "Payment"

        def __init__(self,details: "Payment"):
            self.details = details

        def __str__(self):
            return "SdkEvent.PAYMENT_REFUND_PENDING(details={})".format(self.details)

        def __eq__(self, other):
            if not other.is_payment_refund_pending():
                return False
            if self.details != other.details:
                return False
            return True
    
    class PAYMENT_SUCCEEDED:
        details: "Payment"

        def __init__(self,details: "Payment"):
            self.details = details

        def __str__(self):
            return "SdkEvent.PAYMENT_SUCCEEDED(details={})".format(self.details)

        def __eq__(self, other):
            if not other.is_payment_succeeded():
                return False
            if self.details != other.details:
                return False
            return True
    
    class PAYMENT_WAITING_CONFIRMATION:
        details: "Payment"

        def __init__(self,details: "Payment"):
            self.details = details

        def __str__(self):
            return "SdkEvent.PAYMENT_WAITING_CONFIRMATION(details={})".format(self.details)

        def __eq__(self, other):
            if not other.is_payment_waiting_confirmation():
                return False
            if self.details != other.details:
                return False
            return True
    
    class PAYMENT_WAITING_FEE_ACCEPTANCE:
        details: "Payment"

        def __init__(self,details: "Payment"):
            self.details = details

        def __str__(self):
            return "SdkEvent.PAYMENT_WAITING_FEE_ACCEPTANCE(details={})".format(self.details)

        def __eq__(self, other):
            if not other.is_payment_waiting_fee_acceptance():
                return False
            if self.details != other.details:
                return False
            return True
    
    class SYNCED:

        def __init__(self,):
            pass

        def __str__(self):
            return "SdkEvent.SYNCED()".format()

        def __eq__(self, other):
            if not other.is_synced():
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_payment_failed(self) -> bool:
        return isinstance(self, SdkEvent.PAYMENT_FAILED)
    def is_payment_pending(self) -> bool:
        return isinstance(self, SdkEvent.PAYMENT_PENDING)
    def is_payment_refundable(self) -> bool:
        return isinstance(self, SdkEvent.PAYMENT_REFUNDABLE)
    def is_payment_refunded(self) -> bool:
        return isinstance(self, SdkEvent.PAYMENT_REFUNDED)
    def is_payment_refund_pending(self) -> bool:
        return isinstance(self, SdkEvent.PAYMENT_REFUND_PENDING)
    def is_payment_succeeded(self) -> bool:
        return isinstance(self, SdkEvent.PAYMENT_SUCCEEDED)
    def is_payment_waiting_confirmation(self) -> bool:
        return isinstance(self, SdkEvent.PAYMENT_WAITING_CONFIRMATION)
    def is_payment_waiting_fee_acceptance(self) -> bool:
        return isinstance(self, SdkEvent.PAYMENT_WAITING_FEE_ACCEPTANCE)
    def is_synced(self) -> bool:
        return isinstance(self, SdkEvent.SYNCED)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
SdkEvent.PAYMENT_FAILED = type("SdkEvent.PAYMENT_FAILED", (SdkEvent.PAYMENT_FAILED, SdkEvent,), {})  # type: ignore
SdkEvent.PAYMENT_PENDING = type("SdkEvent.PAYMENT_PENDING", (SdkEvent.PAYMENT_PENDING, SdkEvent,), {})  # type: ignore
SdkEvent.PAYMENT_REFUNDABLE = type("SdkEvent.PAYMENT_REFUNDABLE", (SdkEvent.PAYMENT_REFUNDABLE, SdkEvent,), {})  # type: ignore
SdkEvent.PAYMENT_REFUNDED = type("SdkEvent.PAYMENT_REFUNDED", (SdkEvent.PAYMENT_REFUNDED, SdkEvent,), {})  # type: ignore
SdkEvent.PAYMENT_REFUND_PENDING = type("SdkEvent.PAYMENT_REFUND_PENDING", (SdkEvent.PAYMENT_REFUND_PENDING, SdkEvent,), {})  # type: ignore
SdkEvent.PAYMENT_SUCCEEDED = type("SdkEvent.PAYMENT_SUCCEEDED", (SdkEvent.PAYMENT_SUCCEEDED, SdkEvent,), {})  # type: ignore
SdkEvent.PAYMENT_WAITING_CONFIRMATION = type("SdkEvent.PAYMENT_WAITING_CONFIRMATION", (SdkEvent.PAYMENT_WAITING_CONFIRMATION, SdkEvent,), {})  # type: ignore
SdkEvent.PAYMENT_WAITING_FEE_ACCEPTANCE = type("SdkEvent.PAYMENT_WAITING_FEE_ACCEPTANCE", (SdkEvent.PAYMENT_WAITING_FEE_ACCEPTANCE, SdkEvent,), {})  # type: ignore
SdkEvent.SYNCED = type("SdkEvent.SYNCED", (SdkEvent.SYNCED, SdkEvent,), {})  # type: ignore




class _UniffiConverterTypeSdkEvent(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SdkEvent.PAYMENT_FAILED(
                _UniffiConverterTypePayment.read(buf),
            )
        if variant == 2:
            return SdkEvent.PAYMENT_PENDING(
                _UniffiConverterTypePayment.read(buf),
            )
        if variant == 3:
            return SdkEvent.PAYMENT_REFUNDABLE(
                _UniffiConverterTypePayment.read(buf),
            )
        if variant == 4:
            return SdkEvent.PAYMENT_REFUNDED(
                _UniffiConverterTypePayment.read(buf),
            )
        if variant == 5:
            return SdkEvent.PAYMENT_REFUND_PENDING(
                _UniffiConverterTypePayment.read(buf),
            )
        if variant == 6:
            return SdkEvent.PAYMENT_SUCCEEDED(
                _UniffiConverterTypePayment.read(buf),
            )
        if variant == 7:
            return SdkEvent.PAYMENT_WAITING_CONFIRMATION(
                _UniffiConverterTypePayment.read(buf),
            )
        if variant == 8:
            return SdkEvent.PAYMENT_WAITING_FEE_ACCEPTANCE(
                _UniffiConverterTypePayment.read(buf),
            )
        if variant == 9:
            return SdkEvent.SYNCED(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_payment_failed():
            _UniffiConverterTypePayment.check_lower(value.details)
            return
        if value.is_payment_pending():
            _UniffiConverterTypePayment.check_lower(value.details)
            return
        if value.is_payment_refundable():
            _UniffiConverterTypePayment.check_lower(value.details)
            return
        if value.is_payment_refunded():
            _UniffiConverterTypePayment.check_lower(value.details)
            return
        if value.is_payment_refund_pending():
            _UniffiConverterTypePayment.check_lower(value.details)
            return
        if value.is_payment_succeeded():
            _UniffiConverterTypePayment.check_lower(value.details)
            return
        if value.is_payment_waiting_confirmation():
            _UniffiConverterTypePayment.check_lower(value.details)
            return
        if value.is_payment_waiting_fee_acceptance():
            _UniffiConverterTypePayment.check_lower(value.details)
            return
        if value.is_synced():
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_payment_failed():
            buf.write_i32(1)
            _UniffiConverterTypePayment.write(value.details, buf)
        if value.is_payment_pending():
            buf.write_i32(2)
            _UniffiConverterTypePayment.write(value.details, buf)
        if value.is_payment_refundable():
            buf.write_i32(3)
            _UniffiConverterTypePayment.write(value.details, buf)
        if value.is_payment_refunded():
            buf.write_i32(4)
            _UniffiConverterTypePayment.write(value.details, buf)
        if value.is_payment_refund_pending():
            buf.write_i32(5)
            _UniffiConverterTypePayment.write(value.details, buf)
        if value.is_payment_succeeded():
            buf.write_i32(6)
            _UniffiConverterTypePayment.write(value.details, buf)
        if value.is_payment_waiting_confirmation():
            buf.write_i32(7)
            _UniffiConverterTypePayment.write(value.details, buf)
        if value.is_payment_waiting_fee_acceptance():
            buf.write_i32(8)
            _UniffiConverterTypePayment.write(value.details, buf)
        if value.is_synced():
            buf.write_i32(9)







class SendDestination:
    def __init__(self):
        raise RuntimeError("SendDestination cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class LIQUID_ADDRESS:
        address_data: "LiquidAddressData"

        def __init__(self,address_data: "LiquidAddressData"):
            self.address_data = address_data

        def __str__(self):
            return "SendDestination.LIQUID_ADDRESS(address_data={})".format(self.address_data)

        def __eq__(self, other):
            if not other.is_liquid_address():
                return False
            if self.address_data != other.address_data:
                return False
            return True
    
    class BOLT11:
        invoice: "LnInvoice"
        bip353_address: "typing.Optional[str]"

        def __init__(self,invoice: "LnInvoice", bip353_address: "typing.Optional[str]"):
            self.invoice = invoice
            self.bip353_address = bip353_address

        def __str__(self):
            return "SendDestination.BOLT11(invoice={}, bip353_address={})".format(self.invoice, self.bip353_address)

        def __eq__(self, other):
            if not other.is_bolt11():
                return False
            if self.invoice != other.invoice:
                return False
            if self.bip353_address != other.bip353_address:
                return False
            return True
    
    class BOLT12:
        offer: "LnOffer"
        receiver_amount_sat: "int"
        bip353_address: "typing.Optional[str]"

        def __init__(self,offer: "LnOffer", receiver_amount_sat: "int", bip353_address: "typing.Optional[str]"):
            self.offer = offer
            self.receiver_amount_sat = receiver_amount_sat
            self.bip353_address = bip353_address

        def __str__(self):
            return "SendDestination.BOLT12(offer={}, receiver_amount_sat={}, bip353_address={})".format(self.offer, self.receiver_amount_sat, self.bip353_address)

        def __eq__(self, other):
            if not other.is_bolt12():
                return False
            if self.offer != other.offer:
                return False
            if self.receiver_amount_sat != other.receiver_amount_sat:
                return False
            if self.bip353_address != other.bip353_address:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_liquid_address(self) -> bool:
        return isinstance(self, SendDestination.LIQUID_ADDRESS)
    def is_bolt11(self) -> bool:
        return isinstance(self, SendDestination.BOLT11)
    def is_bolt12(self) -> bool:
        return isinstance(self, SendDestination.BOLT12)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
SendDestination.LIQUID_ADDRESS = type("SendDestination.LIQUID_ADDRESS", (SendDestination.LIQUID_ADDRESS, SendDestination,), {})  # type: ignore
SendDestination.BOLT11 = type("SendDestination.BOLT11", (SendDestination.BOLT11, SendDestination,), {})  # type: ignore
SendDestination.BOLT12 = type("SendDestination.BOLT12", (SendDestination.BOLT12, SendDestination,), {})  # type: ignore




class _UniffiConverterTypeSendDestination(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SendDestination.LIQUID_ADDRESS(
                _UniffiConverterTypeLiquidAddressData.read(buf),
            )
        if variant == 2:
            return SendDestination.BOLT11(
                _UniffiConverterTypeLnInvoice.read(buf),
                _UniffiConverterOptionalString.read(buf),
            )
        if variant == 3:
            return SendDestination.BOLT12(
                _UniffiConverterTypeLnOffer.read(buf),
                _UniffiConverterUInt64.read(buf),
                _UniffiConverterOptionalString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_liquid_address():
            _UniffiConverterTypeLiquidAddressData.check_lower(value.address_data)
            return
        if value.is_bolt11():
            _UniffiConverterTypeLnInvoice.check_lower(value.invoice)
            _UniffiConverterOptionalString.check_lower(value.bip353_address)
            return
        if value.is_bolt12():
            _UniffiConverterTypeLnOffer.check_lower(value.offer)
            _UniffiConverterUInt64.check_lower(value.receiver_amount_sat)
            _UniffiConverterOptionalString.check_lower(value.bip353_address)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_liquid_address():
            buf.write_i32(1)
            _UniffiConverterTypeLiquidAddressData.write(value.address_data, buf)
        if value.is_bolt11():
            buf.write_i32(2)
            _UniffiConverterTypeLnInvoice.write(value.invoice, buf)
            _UniffiConverterOptionalString.write(value.bip353_address, buf)
        if value.is_bolt12():
            buf.write_i32(3)
            _UniffiConverterTypeLnOffer.write(value.offer, buf)
            _UniffiConverterUInt64.write(value.receiver_amount_sat, buf)
            _UniffiConverterOptionalString.write(value.bip353_address, buf)




# SignerError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class SignerError(Exception):
    pass

_UniffiTempSignerError = SignerError

class SignerError:  # type: ignore
    class Generic(_UniffiTempSignerError):
        def __init__(self, err):
            super().__init__(", ".join([
                "err={!r}".format(err),
            ]))
            self.err = err

        def __repr__(self):
            return "SignerError.Generic({})".format(str(self))
    _UniffiTempSignerError.Generic = Generic # type: ignore

SignerError = _UniffiTempSignerError # type: ignore
del _UniffiTempSignerError


class _UniffiConverterTypeSignerError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SignerError.Generic(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, SignerError.Generic):
            _UniffiConverterString.check_lower(value.err)
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, SignerError.Generic):
            buf.write_i32(1)
            _UniffiConverterString.write(value.err, buf)





class SuccessAction:
    def __init__(self):
        raise RuntimeError("SuccessAction cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class AES:
        data: "AesSuccessActionData"

        def __init__(self,data: "AesSuccessActionData"):
            self.data = data

        def __str__(self):
            return "SuccessAction.AES(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_aes():
                return False
            if self.data != other.data:
                return False
            return True
    
    class MESSAGE:
        data: "MessageSuccessActionData"

        def __init__(self,data: "MessageSuccessActionData"):
            self.data = data

        def __str__(self):
            return "SuccessAction.MESSAGE(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_message():
                return False
            if self.data != other.data:
                return False
            return True
    
    class URL:
        data: "UrlSuccessActionData"

        def __init__(self,data: "UrlSuccessActionData"):
            self.data = data

        def __str__(self):
            return "SuccessAction.URL(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_url():
                return False
            if self.data != other.data:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_aes(self) -> bool:
        return isinstance(self, SuccessAction.AES)
    def is_message(self) -> bool:
        return isinstance(self, SuccessAction.MESSAGE)
    def is_url(self) -> bool:
        return isinstance(self, SuccessAction.URL)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
SuccessAction.AES = type("SuccessAction.AES", (SuccessAction.AES, SuccessAction,), {})  # type: ignore
SuccessAction.MESSAGE = type("SuccessAction.MESSAGE", (SuccessAction.MESSAGE, SuccessAction,), {})  # type: ignore
SuccessAction.URL = type("SuccessAction.URL", (SuccessAction.URL, SuccessAction,), {})  # type: ignore




class _UniffiConverterTypeSuccessAction(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SuccessAction.AES(
                _UniffiConverterTypeAesSuccessActionData.read(buf),
            )
        if variant == 2:
            return SuccessAction.MESSAGE(
                _UniffiConverterTypeMessageSuccessActionData.read(buf),
            )
        if variant == 3:
            return SuccessAction.URL(
                _UniffiConverterTypeUrlSuccessActionData.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_aes():
            _UniffiConverterTypeAesSuccessActionData.check_lower(value.data)
            return
        if value.is_message():
            _UniffiConverterTypeMessageSuccessActionData.check_lower(value.data)
            return
        if value.is_url():
            _UniffiConverterTypeUrlSuccessActionData.check_lower(value.data)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_aes():
            buf.write_i32(1)
            _UniffiConverterTypeAesSuccessActionData.write(value.data, buf)
        if value.is_message():
            buf.write_i32(2)
            _UniffiConverterTypeMessageSuccessActionData.write(value.data, buf)
        if value.is_url():
            buf.write_i32(3)
            _UniffiConverterTypeUrlSuccessActionData.write(value.data, buf)







class SuccessActionProcessed:
    def __init__(self):
        raise RuntimeError("SuccessActionProcessed cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class AES:
        result: "AesSuccessActionDataResult"

        def __init__(self,result: "AesSuccessActionDataResult"):
            self.result = result

        def __str__(self):
            return "SuccessActionProcessed.AES(result={})".format(self.result)

        def __eq__(self, other):
            if not other.is_aes():
                return False
            if self.result != other.result:
                return False
            return True
    
    class MESSAGE:
        data: "MessageSuccessActionData"

        def __init__(self,data: "MessageSuccessActionData"):
            self.data = data

        def __str__(self):
            return "SuccessActionProcessed.MESSAGE(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_message():
                return False
            if self.data != other.data:
                return False
            return True
    
    class URL:
        data: "UrlSuccessActionData"

        def __init__(self,data: "UrlSuccessActionData"):
            self.data = data

        def __str__(self):
            return "SuccessActionProcessed.URL(data={})".format(self.data)

        def __eq__(self, other):
            if not other.is_url():
                return False
            if self.data != other.data:
                return False
            return True
    
    

    # For each variant, we have an `is_NAME` method for easily checking
    # whether an instance is that variant.
    def is_aes(self) -> bool:
        return isinstance(self, SuccessActionProcessed.AES)
    def is_message(self) -> bool:
        return isinstance(self, SuccessActionProcessed.MESSAGE)
    def is_url(self) -> bool:
        return isinstance(self, SuccessActionProcessed.URL)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
SuccessActionProcessed.AES = type("SuccessActionProcessed.AES", (SuccessActionProcessed.AES, SuccessActionProcessed,), {})  # type: ignore
SuccessActionProcessed.MESSAGE = type("SuccessActionProcessed.MESSAGE", (SuccessActionProcessed.MESSAGE, SuccessActionProcessed,), {})  # type: ignore
SuccessActionProcessed.URL = type("SuccessActionProcessed.URL", (SuccessActionProcessed.URL, SuccessActionProcessed,), {})  # type: ignore




class _UniffiConverterTypeSuccessActionProcessed(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SuccessActionProcessed.AES(
                _UniffiConverterTypeAesSuccessActionDataResult.read(buf),
            )
        if variant == 2:
            return SuccessActionProcessed.MESSAGE(
                _UniffiConverterTypeMessageSuccessActionData.read(buf),
            )
        if variant == 3:
            return SuccessActionProcessed.URL(
                _UniffiConverterTypeUrlSuccessActionData.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_aes():
            _UniffiConverterTypeAesSuccessActionDataResult.check_lower(value.result)
            return
        if value.is_message():
            _UniffiConverterTypeMessageSuccessActionData.check_lower(value.data)
            return
        if value.is_url():
            _UniffiConverterTypeUrlSuccessActionData.check_lower(value.data)
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_aes():
            buf.write_i32(1)
            _UniffiConverterTypeAesSuccessActionDataResult.write(value.result, buf)
        if value.is_message():
            buf.write_i32(2)
            _UniffiConverterTypeMessageSuccessActionData.write(value.data, buf)
        if value.is_url():
            buf.write_i32(3)
            _UniffiConverterTypeUrlSuccessActionData.write(value.data, buf)





class EventListener(typing.Protocol):
    def on_event(self, e: "SdkEvent"):
        raise NotImplementedError
# Magic number for the Rust proxy to call using the same mechanism as every other method,
# to free the callback once it's dropped by Rust.
_UNIFFI_IDX_CALLBACK_FREE = 0
# Return codes for callback calls
_UNIFFI_CALLBACK_SUCCESS = 0
_UNIFFI_CALLBACK_ERROR = 1
_UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

class _UniffiCallbackInterfaceFfiConverter:
    _handle_map = _UniffiHandleMap()

    @classmethod
    def lift(cls, handle):
        return cls._handle_map.get(handle)

    @classmethod
    def read(cls, buf):
        handle = buf.read_u64()
        cls.lift(handle)

    @classmethod
    def check_lower(cls, cb):
        pass

    @classmethod
    def lower(cls, cb):
        handle = cls._handle_map.insert(cb)
        return handle

    @classmethod
    def write(cls, cb, buf):
        buf.write_u64(cls.lower(cb))

# Put all the bits inside a class to keep the top-level namespace clean
class _UniffiTraitImplEventListener:
    # For each method, generate a callback function to pass to Rust

    @_UNIFFI_CALLBACK_INTERFACE_EVENT_LISTENER_METHOD0
    def on_event(
            uniffi_handle,
            e,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeEventListener._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterTypeSdkEvent.lift(e), )
            method = uniffi_obj.on_event
            return method(*args)

        
        write_return_value = lambda v: None
        _uniffi_trait_interface_call(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
        )

    @_UNIFFI_CALLBACK_INTERFACE_FREE
    def _uniffi_free(uniffi_handle):
        _UniffiConverterTypeEventListener._handle_map.remove(uniffi_handle)

    # Generate the FFI VTable.  This has a field for each callback interface method.
    _uniffi_vtable = _UniffiVTableCallbackInterfaceEventListener(
        on_event,
        _uniffi_free
    )
    # Send Rust a pointer to the VTable.  Note: this means we need to keep the struct alive forever,
    # or else bad things will happen when Rust tries to access it.
    _UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_init_callback_vtable_eventlistener(ctypes.byref(_uniffi_vtable))

# The _UniffiConverter which transforms the Callbacks in to Handles to pass to Rust.
_UniffiConverterTypeEventListener = _UniffiCallbackInterfaceFfiConverter()



class Logger(typing.Protocol):
    def log(self, l: "LogEntry"):
        raise NotImplementedError


# Put all the bits inside a class to keep the top-level namespace clean
class _UniffiTraitImplLogger:
    # For each method, generate a callback function to pass to Rust

    @_UNIFFI_CALLBACK_INTERFACE_LOGGER_METHOD0
    def log(
            uniffi_handle,
            l,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeLogger._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterTypeLogEntry.lift(l), )
            method = uniffi_obj.log
            return method(*args)

        
        write_return_value = lambda v: None
        _uniffi_trait_interface_call(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
        )

    @_UNIFFI_CALLBACK_INTERFACE_FREE
    def _uniffi_free(uniffi_handle):
        _UniffiConverterTypeLogger._handle_map.remove(uniffi_handle)

    # Generate the FFI VTable.  This has a field for each callback interface method.
    _uniffi_vtable = _UniffiVTableCallbackInterfaceLogger(
        log,
        _uniffi_free
    )
    # Send Rust a pointer to the VTable.  Note: this means we need to keep the struct alive forever,
    # or else bad things will happen when Rust tries to access it.
    _UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_init_callback_vtable_logger(ctypes.byref(_uniffi_vtable))

# The _UniffiConverter which transforms the Callbacks in to Handles to pass to Rust.
_UniffiConverterTypeLogger = _UniffiCallbackInterfaceFfiConverter()



class Signer(typing.Protocol):
    def xpub(self, ):
        raise NotImplementedError
    def derive_xpub(self, derivation_path: "str"):
        raise NotImplementedError
    def sign_ecdsa(self, msg: "typing.List[int]",derivation_path: "str"):
        raise NotImplementedError
    def sign_ecdsa_recoverable(self, msg: "typing.List[int]"):
        raise NotImplementedError
    def slip77_master_blinding_key(self, ):
        raise NotImplementedError
    def hmac_sha256(self, msg: "typing.List[int]",derivation_path: "str"):
        raise NotImplementedError
    def ecies_encrypt(self, msg: "typing.List[int]"):
        raise NotImplementedError
    def ecies_decrypt(self, msg: "typing.List[int]"):
        raise NotImplementedError


# Put all the bits inside a class to keep the top-level namespace clean
class _UniffiTraitImplSigner:
    # For each method, generate a callback function to pass to Rust

    @_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD0
    def xpub(
            uniffi_handle,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeSigner._handle_map.get(uniffi_handle)
        def make_call():
            args = ()
            method = uniffi_obj.xpub
            return method(*args)

        
        def write_return_value(v):
            uniffi_out_return[0] = _UniffiConverterSequenceUInt8.lower(v)
        _uniffi_trait_interface_call_with_error(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
                SignerError,
                _UniffiConverterTypeSignerError.lower,
        )

    @_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD1
    def derive_xpub(
            uniffi_handle,
            derivation_path,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeSigner._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterString.lift(derivation_path), )
            method = uniffi_obj.derive_xpub
            return method(*args)

        
        def write_return_value(v):
            uniffi_out_return[0] = _UniffiConverterSequenceUInt8.lower(v)
        _uniffi_trait_interface_call_with_error(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
                SignerError,
                _UniffiConverterTypeSignerError.lower,
        )

    @_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD2
    def sign_ecdsa(
            uniffi_handle,
            msg,
            derivation_path,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeSigner._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterSequenceUInt8.lift(msg), _UniffiConverterString.lift(derivation_path), )
            method = uniffi_obj.sign_ecdsa
            return method(*args)

        
        def write_return_value(v):
            uniffi_out_return[0] = _UniffiConverterSequenceUInt8.lower(v)
        _uniffi_trait_interface_call_with_error(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
                SignerError,
                _UniffiConverterTypeSignerError.lower,
        )

    @_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD3
    def sign_ecdsa_recoverable(
            uniffi_handle,
            msg,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeSigner._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterSequenceUInt8.lift(msg), )
            method = uniffi_obj.sign_ecdsa_recoverable
            return method(*args)

        
        def write_return_value(v):
            uniffi_out_return[0] = _UniffiConverterSequenceUInt8.lower(v)
        _uniffi_trait_interface_call_with_error(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
                SignerError,
                _UniffiConverterTypeSignerError.lower,
        )

    @_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD4
    def slip77_master_blinding_key(
            uniffi_handle,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeSigner._handle_map.get(uniffi_handle)
        def make_call():
            args = ()
            method = uniffi_obj.slip77_master_blinding_key
            return method(*args)

        
        def write_return_value(v):
            uniffi_out_return[0] = _UniffiConverterSequenceUInt8.lower(v)
        _uniffi_trait_interface_call_with_error(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
                SignerError,
                _UniffiConverterTypeSignerError.lower,
        )

    @_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD5
    def hmac_sha256(
            uniffi_handle,
            msg,
            derivation_path,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeSigner._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterSequenceUInt8.lift(msg), _UniffiConverterString.lift(derivation_path), )
            method = uniffi_obj.hmac_sha256
            return method(*args)

        
        def write_return_value(v):
            uniffi_out_return[0] = _UniffiConverterSequenceUInt8.lower(v)
        _uniffi_trait_interface_call_with_error(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
                SignerError,
                _UniffiConverterTypeSignerError.lower,
        )

    @_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD6
    def ecies_encrypt(
            uniffi_handle,
            msg,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeSigner._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterSequenceUInt8.lift(msg), )
            method = uniffi_obj.ecies_encrypt
            return method(*args)

        
        def write_return_value(v):
            uniffi_out_return[0] = _UniffiConverterSequenceUInt8.lower(v)
        _uniffi_trait_interface_call_with_error(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
                SignerError,
                _UniffiConverterTypeSignerError.lower,
        )

    @_UNIFFI_CALLBACK_INTERFACE_SIGNER_METHOD7
    def ecies_decrypt(
            uniffi_handle,
            msg,
            uniffi_out_return,
            uniffi_call_status_ptr,
        ):
        uniffi_obj = _UniffiConverterTypeSigner._handle_map.get(uniffi_handle)
        def make_call():
            args = (_UniffiConverterSequenceUInt8.lift(msg), )
            method = uniffi_obj.ecies_decrypt
            return method(*args)

        
        def write_return_value(v):
            uniffi_out_return[0] = _UniffiConverterSequenceUInt8.lower(v)
        _uniffi_trait_interface_call_with_error(
                uniffi_call_status_ptr.contents,
                make_call,
                write_return_value,
                SignerError,
                _UniffiConverterTypeSignerError.lower,
        )

    @_UNIFFI_CALLBACK_INTERFACE_FREE
    def _uniffi_free(uniffi_handle):
        _UniffiConverterTypeSigner._handle_map.remove(uniffi_handle)

    # Generate the FFI VTable.  This has a field for each callback interface method.
    _uniffi_vtable = _UniffiVTableCallbackInterfaceSigner(
        xpub,
        derive_xpub,
        sign_ecdsa,
        sign_ecdsa_recoverable,
        slip77_master_blinding_key,
        hmac_sha256,
        ecies_encrypt,
        ecies_decrypt,
        _uniffi_free
    )
    # Send Rust a pointer to the VTable.  Note: this means we need to keep the struct alive forever,
    # or else bad things will happen when Rust tries to access it.
    _UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_init_callback_vtable_signer(ctypes.byref(_uniffi_vtable))

# The _UniffiConverter which transforms the Callbacks in to Handles to pass to Rust.
_UniffiConverterTypeSigner = _UniffiCallbackInterfaceFfiConverter()



class _UniffiConverterOptionalUInt32(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt32.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt32.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt32.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalUInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt64.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt64.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterInt64.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterInt64.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalDouble(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterDouble.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterDouble.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterDouble.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalBool(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterBool.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterBool.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterBool.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterString.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeAssetInfo(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeAssetInfo.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeAssetInfo.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeAssetInfo.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeLnUrlInfo(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeLnUrlInfo.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeLnUrlInfo.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeLnUrlInfo.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypePayment(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypePayment.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypePayment.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypePayment.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeSymbol(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeSymbol.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeSymbol.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeSymbol.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeAmount(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeAmount.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeAmount.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeAmount.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeListPaymentDetails(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeListPaymentDetails.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeListPaymentDetails.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeListPaymentDetails.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypePayAmount(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypePayAmount.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypePayAmount.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypePayAmount.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeReceiveAmount(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeReceiveAmount.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeReceiveAmount.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeReceiveAmount.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeSuccessAction(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeSuccessAction.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeSuccessAction.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeSuccessAction.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeSuccessActionProcessed(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeSuccessActionProcessed.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeSuccessActionProcessed.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeSuccessActionProcessed.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalSequenceUInt8(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterSequenceUInt8.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterSequenceUInt8.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterSequenceUInt8.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalSequenceTypeAssetMetadata(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterSequenceTypeAssetMetadata.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterSequenceTypeAssetMetadata.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterSequenceTypeAssetMetadata.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalSequenceTypeExternalInputParser(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterSequenceTypeExternalInputParser.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterSequenceTypeExternalInputParser.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterSequenceTypeExternalInputParser.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalSequenceTypePaymentState(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterSequenceTypePaymentState.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterSequenceTypePaymentState.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterSequenceTypePaymentState.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalSequenceTypePaymentType(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterSequenceTypePaymentType.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterSequenceTypePaymentType.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterSequenceTypePaymentType.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterSequenceUInt8(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterUInt8.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterUInt8.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterUInt8.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterString.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterString.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterString.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeAssetBalance(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeAssetBalance.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeAssetBalance.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeAssetBalance.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeAssetMetadata(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeAssetMetadata.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeAssetMetadata.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeAssetMetadata.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeExternalInputParser(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeExternalInputParser.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeExternalInputParser.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeExternalInputParser.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeFiatCurrency(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeFiatCurrency.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeFiatCurrency.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeFiatCurrency.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeLnOfferBlindedPath(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeLnOfferBlindedPath.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeLnOfferBlindedPath.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeLnOfferBlindedPath.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeLocaleOverrides(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeLocaleOverrides.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeLocaleOverrides.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeLocaleOverrides.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeLocalizedName(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeLocalizedName.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeLocalizedName.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeLocalizedName.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypePayment(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypePayment.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypePayment.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypePayment.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeRate(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeRate.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeRate.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeRate.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeRefundableSwap(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeRefundableSwap.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeRefundableSwap.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeRefundableSwap.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeRouteHint(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeRouteHint.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeRouteHint.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeRouteHint.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeRouteHintHop(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeRouteHintHop.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeRouteHintHop.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeRouteHintHop.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypePaymentState(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypePaymentState.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypePaymentState.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypePaymentState.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypePaymentType(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypePaymentType.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypePaymentType.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypePaymentType.read(buf) for i in range(count)
        ]

# Async support

def connect(req: "ConnectRequest") -> "BindingLiquidSdk":
    _UniffiConverterTypeConnectRequest.check_lower(req)
    
    return _UniffiConverterTypeBindingLiquidSdk.lift(_uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_func_connect,
        _UniffiConverterTypeConnectRequest.lower(req)))


def connect_with_signer(req: "ConnectWithSignerRequest",signer: "Signer") -> "BindingLiquidSdk":
    _UniffiConverterTypeConnectWithSignerRequest.check_lower(req)
    
    _UniffiConverterTypeSigner.check_lower(signer)
    
    return _UniffiConverterTypeBindingLiquidSdk.lift(_uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_func_connect_with_signer,
        _UniffiConverterTypeConnectWithSignerRequest.lower(req),
        _UniffiConverterTypeSigner.lower(signer)))


def default_config(network: "LiquidNetwork",breez_api_key: "typing.Optional[str]") -> "Config":
    _UniffiConverterTypeLiquidNetwork.check_lower(network)
    
    _UniffiConverterOptionalString.check_lower(breez_api_key)
    
    return _UniffiConverterTypeConfig.lift(_uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_func_default_config,
        _UniffiConverterTypeLiquidNetwork.lower(network),
        _UniffiConverterOptionalString.lower(breez_api_key)))


def parse_invoice(input: "str") -> "LnInvoice":
    _UniffiConverterString.check_lower(input)
    
    return _UniffiConverterTypeLnInvoice.lift(_uniffi_rust_call_with_error(_UniffiConverterTypePaymentError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_func_parse_invoice,
        _UniffiConverterString.lower(input)))


def set_logger(logger: "Logger") -> None:
    _UniffiConverterTypeLogger.check_lower(logger)
    
    _uniffi_rust_call_with_error(_UniffiConverterTypeSdkError,_UniffiLib.uniffi_breez_sdk_liquid_bindings_fn_func_set_logger,
        _UniffiConverterTypeLogger.lower(logger))


__all__ = [
    "InternalError",
    "AesSuccessActionDataResult",
    "Amount",
    "BuyBitcoinProvider",
    "GetPaymentRequest",
    "InputType",
    "LiquidNetwork",
    "ListPaymentDetails",
    "LnUrlAuthError",
    "LnUrlCallbackStatus",
    "LnUrlPayError",
    "LnUrlPayResult",
    "LnUrlWithdrawError",
    "LnUrlWithdrawResult",
    "Network",
    "PayAmount",
    "PaymentDetails",
    "PaymentError",
    "PaymentMethod",
    "PaymentState",
    "PaymentType",
    "ReceiveAmount",
    "SdkError",
    "SdkEvent",
    "SendDestination",
    "SignerError",
    "SuccessAction",
    "SuccessActionProcessed",
    "AcceptPaymentProposedFeesRequest",
    "AesSuccessActionData",
    "AesSuccessActionDataDecrypted",
    "AssetBalance",
    "AssetInfo",
    "AssetMetadata",
    "BackupRequest",
    "BitcoinAddressData",
    "BlockchainInfo",
    "BuyBitcoinRequest",
    "CheckMessageRequest",
    "CheckMessageResponse",
    "Config",
    "ConnectRequest",
    "ConnectWithSignerRequest",
    "CurrencyInfo",
    "ExternalInputParser",
    "FetchPaymentProposedFeesRequest",
    "FetchPaymentProposedFeesResponse",
    "FiatCurrency",
    "GetInfoResponse",
    "LightningPaymentLimitsResponse",
    "Limits",
    "LiquidAddressData",
    "ListPaymentsRequest",
    "LnInvoice",
    "LnOffer",
    "LnOfferBlindedPath",
    "LnUrlAuthRequestData",
    "LnUrlErrorData",
    "LnUrlInfo",
    "LnUrlPayErrorData",
    "LnUrlPayRequest",
    "LnUrlPayRequestData",
    "LnUrlPaySuccessData",
    "LnUrlWithdrawRequest",
    "LnUrlWithdrawRequestData",
    "LnUrlWithdrawSuccessData",
    "LocaleOverrides",
    "LocalizedName",
    "LogEntry",
    "MessageSuccessActionData",
    "OnchainPaymentLimitsResponse",
    "PayOnchainRequest",
    "Payment",
    "PrepareBuyBitcoinRequest",
    "PrepareBuyBitcoinResponse",
    "PrepareLnUrlPayRequest",
    "PrepareLnUrlPayResponse",
    "PreparePayOnchainRequest",
    "PreparePayOnchainResponse",
    "PrepareReceiveRequest",
    "PrepareReceiveResponse",
    "PrepareRefundRequest",
    "PrepareRefundResponse",
    "PrepareSendRequest",
    "PrepareSendResponse",
    "Rate",
    "ReceivePaymentRequest",
    "ReceivePaymentResponse",
    "RecommendedFees",
    "RefundRequest",
    "RefundResponse",
    "RefundableSwap",
    "RestoreRequest",
    "RouteHint",
    "RouteHintHop",
    "SendPaymentRequest",
    "SendPaymentResponse",
    "SignMessageRequest",
    "SignMessageResponse",
    "Symbol",
    "UrlSuccessActionData",
    "WalletInfo",
    "connect",
    "connect_with_signer",
    "default_config",
    "parse_invoice",
    "set_logger",
    "BindingLiquidSdk",
    "EventListener",
    "Logger",
    "Signer",
]

