# OpenFisca Survey Manager

[![Newsletter](https://img.shields.io/badge/newsletter-subscribe!-informational.svg?style=flat)](mailto:contact%40openfisca.org?subject=Subscribe%20to%20your%20newsletter%20%7C%20S'inscrire%20%C3%A0%20votre%20newsletter&body=%5BEnglish%20version%20below%5D%0A%0ABonjour%2C%0A%0AVotre%C2%A0pr%C3%A9sence%C2%A0ici%C2%A0nous%C2%A0ravit%C2%A0!%20%F0%9F%98%83%0A%0AEnvoyez-nous%20cet%20email%20pour%20que%20l'on%20puisse%20vous%20inscrire%20%C3%A0%20la%20newsletter.%20%0A%0AAh%C2%A0!%20Et%20si%20vous%20pouviez%20remplir%20ce%20petit%20questionnaire%2C%20%C3%A7a%20serait%20encore%20mieux%C2%A0!%0Ahttps%3A%2F%2Fgoo.gl%2Fforms%2F45M0VR1TYKD1RGzX2%0A%0AAmiti%C3%A9%2C%0AL%E2%80%99%C3%A9quipe%20OpenFisca%0A%0A%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%20ENGLISH%20VERSION%20%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%0A%0AHi%2C%20%0A%0AWe're%20glad%20to%20see%20you%20here!%20%F0%9F%98%83%0A%0APlease%20send%20us%20this%20email%2C%20so%20we%20can%20subscribe%20you%20to%20the%20newsletter.%0A%0AAlso%2C%20if%20you%20can%20fill%20out%20this%20short%20survey%2C%20even%20better!%0Ahttps%3A%2F%2Fgoo.gl%2Fforms%2FsOg8K1abhhm441LG2%0A%0ACheers%2C%0AThe%20OpenFisca%20Team)
[![Twitter](https://img.shields.io/badge/twitter-follow%20us!-9cf.svg?style=flat)](https://twitter.com/intent/follow?screen_name=openfisca)
[![Slack](https://img.shields.io/badge/slack-join%20us!-blueviolet.svg?style=flat)](mailto:contact%40openfisca.org?subject=Join%20you%20on%20Slack%20%7C%20Nous%20rejoindre%20sur%20Slack&body=%5BEnglish%20version%20below%5D%0A%0ABonjour%2C%0A%0AVotre%C2%A0pr%C3%A9sence%C2%A0ici%C2%A0nous%C2%A0ravit%C2%A0!%20%F0%9F%98%83%0A%0ARacontez-nous%20un%20peu%20de%20vous%2C%20et%20du%20pourquoi%20de%20votre%20int%C3%A9r%C3%AAt%20de%20rejoindre%20la%20communaut%C3%A9%20OpenFisca%20sur%20Slack.%0A%0AAh%C2%A0!%20Et%20si%20vous%20pouviez%20remplir%20ce%20petit%20questionnaire%2C%20%C3%A7a%20serait%20encore%20mieux%C2%A0!%0Ahttps%3A%2F%2Fgoo.gl%2Fforms%2F45M0VR1TYKD1RGzX2%0A%0AN%E2%80%99oubliez%20pas%20de%20nous%20envoyer%20cet%20email%C2%A0!%20Sinon%2C%20on%20ne%20pourra%20pas%20vous%20contacter%20ni%20vous%20inviter%20sur%20Slack.%0A%0AAmiti%C3%A9%2C%0AL%E2%80%99%C3%A9quipe%20OpenFisca%0A%0A%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%20ENGLISH%20VERSION%20%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%3D%0A%0AHi%2C%20%0A%0AWe're%20glad%20to%20see%20you%20here!%20%F0%9F%98%83%0A%0APlease%20tell%20us%20a%20bit%20about%20you%20and%20why%20you%20want%20to%20join%20the%20OpenFisca%20community%20on%20Slack.%0A%0AAlso%2C%20if%20you%20can%20fill%20out%20this%20short%20survey%2C%20even%20better!%0Ahttps%3A%2F%2Fgoo.gl%2Fforms%2FsOg8K1abhhm441LG2.%0A%0ADon't%20forget%20to%20send%20us%20this%20email!%20Otherwise%20we%20won't%20be%20able%20to%20contact%20you%20back%2C%20nor%20invite%20you%20on%20Slack.%0A%0ACheers%2C%0AThe%20OpenFisca%20Team)
[![CircleCI](https://img.shields.io/circleci/project/github/openfisca/openfisca-survey-manager/master.svg?style=flat)](https://circleci.com/gh/openfisca/openfisca-survey-manager)
[![Coveralls](https://img.shields.io/coveralls/github/openfisca/openfisca-survey-manager/master.svg?style=flat)](https://coveralls.io/github/openfisca/openfisca-survey-manager?branch=master)
[![Python](https://img.shields.io/pypi/pyversions/openfisca-survey-manager.svg)](https://pypi.python.org/pypi/openfisca-survey-manager)
[![PyPi](https://img.shields.io/pypi/v/openfisca-survey-manager.svg?style=flat)](https://pypi.python.org/pypi/openfisca-survey-manager)

[OpenFisca](https://openfisca.org/doc/) is a versatile microsimulation libre software. Check the [online documentation](https://openfisca.org/doc/) for more details.

This package contains the Survey-Manager module, to work with OpenFisca and survey data.

It provides an API to access HDF data.

It also provides a script that transforms SAS, Stata, SPSS, and CSV data files to HDF data files, along with some metadata so they can be used by the API.

## Environment

OpenFisca-Survey-Manager runs on Python 3.7. More recent versions should work, but are not tested.

Backward compatibility with Python 2.7 has been dropped since January 1st, 2019.

## Usage

### Installation

First, install the package with `pip`:

```bash
pip install --upgrade pip
pip install openfisca-survey-manager
```

### Getting the config files directory path

To be able to use OpenFisca-Survey-Manager, you have to create two configuration files.

To know where to copy them to, use the folling command:

```bash
build-collection --help
```

Take note of the default config files directory path:

```bash
usage: build-collection [-h] -c COLLECTION [-d] [-m] [-p PATH] [-s SURVEY]
                        [-v]

optional arguments:
  -h, --help            show this help message and exit
  -c COLLECTION, --collection COLLECTION
                        name of collection to build or update
  -d, --replace-data    erase existing survey data HDF5 file (instead of
                        failing when HDF5 file already exists)
  -m, --replace-metadata
                        erase existing collection metadata JSON file (instead
                        of just adding new surveys)
  -p PATH, --path PATH  path to the config files directory (default =
                        /your/path/.config/openfisca-survey-manager)
  -s SURVEY, --survey SURVEY
                        name of survey to build or update (default = all)
  -v, --verbose         increase output verbosity
```

In your case, it is `/Users/you/.config/openfisca-survey-manager`.

> If you want to use a different path, you can pass pass the `--path /another/path` option to `build-collection`. This feature is still expetimental though.

### Editing the config files

> `raw_data.ini` and `config.ini` must not be committed (they are already ignored by [`.gitignore`](.gitignore)).

#### raw_data.ini

Copy [raw_data_template.ini](openfisca_survey_manager/config_files_templates/raw_data_template.ini) to `/your/path/.config/openfisca-survey-manager/raw_data.ini` and edit the latter to reference the location of your raw data (SAS, stata, SPSS, CSV files).

> For paths in Windows, use `/` instead of `\` to separate folders. You do not need to put quotes, even when the path name contains spaces.

It should look similar to this:

```ini
[revenue_survey]

2014 = /path/to/your/raw/data/REVENUE_2014
2015 = /path/to/your/raw/data/REVENUE_2015
2016 = /path/to/your/raw/data/REVENUE_2016

[housing_survey]

2014 = /path/to/your/raw/data/HOUSING_2014
```

#### config.ini

Copy [config_template.ini](openfisca_survey_manager/config_files_templates/config_template.ini) to `/your/path/.config/openfisca-survey-manager/config.ini` and edit its mandatory fields.

It should look similar to this:

```ini
[collections]
collections_directory = /path/to/your/collections/directory

[data]
output_directory = /path/to/your/data/output/directory
tmp_directory = /path/to/your/data/tmp/directory
```

> Make sure those directories exist, otherwise the script will fail.

### Building the HDF5 files

To build the HDF5 files, we'll use the [`build-collection`](openfisca_survey_manager/scripts/build_collection.py) script:

```bash
build-collection -c revenue_survey -s 2015 -d -m -v
```

Or if you want to specify a different config files directory path:

```bash
build-collection -p /another/path -c housing_survey -s 2014 -d -m -v
```

> The `--path /another/path` option is still experimental though.

It should work. If it doesn't, please do not hesitate to [open an issue](https://github.com/openfisca/openfisca-survey-manager/issues/new).

## Development

If you want to contribute to OpenFisca-Survey-Manager, please be welcomed! To install it locally in development mode:

```bash
git clone https://github.com/openfisca/openfisca-survey-manager.git
cd openfisca-survey-manager
make install
```

## Testing

To run the entire test suite:

```sh
make test
```

## Style

This repository adheres to a certain coding style, and we invite you to follow it for your contributions to be integrated promptly.

To run the style checker:

```sh
make check-style
```

To automatically style-format your code changes:

```sh
make format-style
```

To automatically style-format your code changes each time you commit:

```sh
touch .git/hooks/pre-commit
chmod +x .git/hooks/pre-commit

tee -a .git/hooks/pre-commit << END
#!/bin/sh
#
# Automatically format your code before committing.
exec make format-style
END
```
