# AUTOGENERATED! DO NOT EDIT! File to edit: 03_config.ipynb (unless otherwise specified).

__all__ = ['DEFAULT_URLS', 'save_config', 'load_config', 'add_urls', 'remove_urls', 'show_blocklist']

# Cell
import yaml
from fastcore.utils import *
DEFAULT_URLS = ["twitter.com", "youtube.com", "facebook.com",
    "instagram.com", "reddit.com", "netflix.com",    "amazon.com", "linkedin.com"]

# Cell
def save_config(urls: list = None, default = False):
    if default:
        blocklist = DEFAULT_URLS
    else:
        blocklist = urls
    config = {
        "blocklist" :  blocklist
    }
    with open('blocklist.yaml', 'w') as configfile:
        yaml.dump(config, configfile)
    return True

# Cell
def load_config():
    try:
        with open('blocklist.yaml', 'r') as configfile:
            config = yaml.safe_load(configfile)
        return config['blocklist']
    except FileNotFoundError:
        return False

# Cell
def add_urls(urls):
    to_add = listify(urls)
    to_add = list(map(str.lower, to_add))
    stored_urls = load_config()
    stored_urls.extend(to_add)
    # Prevent double entries
    updated_urls = list(set(stored_urls))
    save_config(updated_urls)
    verb = "has" if len(to_add) == 1 else "have"
    print(f"{', '.join(to_add)} {verb} been added to the blocklist")

# Cell
def remove_urls(urls):
    to_remove = listify(urls)
    to_remove = list(map(str.lower, to_remove))
    stored_urls = load_config()
    updated_urls = [url for url in stored_urls if url not in to_remove]
    save_config(updated_urls)
    verb = "has" if len(to_remove) == 1 else "have"
    print(f"{', '.join(to_remove)} {verb} been removed from the blocklist")

# Cell
def show_blocklist():
    print('\n'.join(load_config()))