# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RepositoryArgs', 'Repository']

@pulumi.input_type
class RepositoryArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[builtins.str],
                 protocol: pulumi.Input[builtins.str],
                 enable_pki: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 server_name: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Repository resource.
        :param pulumi.Input[builtins.str] path: Path should always start with "/" and can contain alphanumeric, underscore, hyphen and dot characters.
        :param pulumi.Input[builtins.str] protocol: Protocol - Choices: `CDROM`, `DISK`, `FTP`, `HTTP`, `HTTPS`, `NFS`, `SFTP`, `TFTP`
        :param pulumi.Input[builtins.bool] enable_pki: Enable PKI
        :param pulumi.Input[builtins.str] name: Repository name should be less than 80 characters and can contain alphanumeric, underscore, hyphen and dot characters.
        :param pulumi.Input[builtins.str] password: Password can contain alphanumeric and/or special characters.
        :param pulumi.Input[builtins.str] server_name: Name of the server
        :param pulumi.Input[builtins.str] user_name: User name
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "protocol", protocol)
        if enable_pki is not None:
            pulumi.set(__self__, "enable_pki", enable_pki)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[builtins.str]:
        """
        Path should always start with "/" and can contain alphanumeric, underscore, hyphen and dot characters.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        Protocol - Choices: `CDROM`, `DISK`, `FTP`, `HTTP`, `HTTPS`, `NFS`, `SFTP`, `TFTP`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="enablePki")
    def enable_pki(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable PKI
        """
        return pulumi.get(self, "enable_pki")

    @enable_pki.setter
    def enable_pki(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_pki", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Repository name should be less than 80 characters and can contain alphanumeric, underscore, hyphen and dot characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password can contain alphanumeric and/or special characters.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the server
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User name
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class _RepositoryState:
    def __init__(__self__, *,
                 enable_pki: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 server_name: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Repository resources.
        :param pulumi.Input[builtins.bool] enable_pki: Enable PKI
        :param pulumi.Input[builtins.str] name: Repository name should be less than 80 characters and can contain alphanumeric, underscore, hyphen and dot characters.
        :param pulumi.Input[builtins.str] password: Password can contain alphanumeric and/or special characters.
        :param pulumi.Input[builtins.str] path: Path should always start with "/" and can contain alphanumeric, underscore, hyphen and dot characters.
        :param pulumi.Input[builtins.str] protocol: Protocol - Choices: `CDROM`, `DISK`, `FTP`, `HTTP`, `HTTPS`, `NFS`, `SFTP`, `TFTP`
        :param pulumi.Input[builtins.str] server_name: Name of the server
        :param pulumi.Input[builtins.str] user_name: User name
        """
        if enable_pki is not None:
            pulumi.set(__self__, "enable_pki", enable_pki)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="enablePki")
    def enable_pki(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable PKI
        """
        return pulumi.get(self, "enable_pki")

    @enable_pki.setter
    def enable_pki(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_pki", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Repository name should be less than 80 characters and can contain alphanumeric, underscore, hyphen and dot characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password can contain alphanumeric and/or special characters.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path should always start with "/" and can contain alphanumeric, underscore, hyphen and dot characters.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Protocol - Choices: `CDROM`, `DISK`, `FTP`, `HTTP`, `HTTPS`, `NFS`, `SFTP`, `TFTP`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the server
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User name
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.type_token("ise:system/repository:Repository")
class Repository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_pki: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 server_name: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.system.Repository("example",
            name="repo1",
            protocol="SFTP",
            path="/dir",
            server_name="server1",
            user_name="user9",
            password="cisco123",
            enable_pki=False)
        ```

        ## Import

        ```sh
        $ pulumi import ise:system/repository:Repository example "repo1"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enable_pki: Enable PKI
        :param pulumi.Input[builtins.str] name: Repository name should be less than 80 characters and can contain alphanumeric, underscore, hyphen and dot characters.
        :param pulumi.Input[builtins.str] password: Password can contain alphanumeric and/or special characters.
        :param pulumi.Input[builtins.str] path: Path should always start with "/" and can contain alphanumeric, underscore, hyphen and dot characters.
        :param pulumi.Input[builtins.str] protocol: Protocol - Choices: `CDROM`, `DISK`, `FTP`, `HTTP`, `HTTPS`, `NFS`, `SFTP`, `TFTP`
        :param pulumi.Input[builtins.str] server_name: Name of the server
        :param pulumi.Input[builtins.str] user_name: User name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.system.Repository("example",
            name="repo1",
            protocol="SFTP",
            path="/dir",
            server_name="server1",
            user_name="user9",
            password="cisco123",
            enable_pki=False)
        ```

        ## Import

        ```sh
        $ pulumi import ise:system/repository:Repository example "repo1"
        ```

        :param str resource_name: The name of the resource.
        :param RepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_pki: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 server_name: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryArgs.__new__(RepositoryArgs)

            __props__.__dict__["enable_pki"] = enable_pki
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = password
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["server_name"] = server_name
            __props__.__dict__["user_name"] = user_name
        super(Repository, __self__).__init__(
            'ise:system/repository:Repository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_pki: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            path: Optional[pulumi.Input[builtins.str]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            server_name: Optional[pulumi.Input[builtins.str]] = None,
            user_name: Optional[pulumi.Input[builtins.str]] = None) -> 'Repository':
        """
        Get an existing Repository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enable_pki: Enable PKI
        :param pulumi.Input[builtins.str] name: Repository name should be less than 80 characters and can contain alphanumeric, underscore, hyphen and dot characters.
        :param pulumi.Input[builtins.str] password: Password can contain alphanumeric and/or special characters.
        :param pulumi.Input[builtins.str] path: Path should always start with "/" and can contain alphanumeric, underscore, hyphen and dot characters.
        :param pulumi.Input[builtins.str] protocol: Protocol - Choices: `CDROM`, `DISK`, `FTP`, `HTTP`, `HTTPS`, `NFS`, `SFTP`, `TFTP`
        :param pulumi.Input[builtins.str] server_name: Name of the server
        :param pulumi.Input[builtins.str] user_name: User name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryState.__new__(_RepositoryState)

        __props__.__dict__["enable_pki"] = enable_pki
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["path"] = path
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["server_name"] = server_name
        __props__.__dict__["user_name"] = user_name
        return Repository(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enablePki")
    def enable_pki(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable PKI
        """
        return pulumi.get(self, "enable_pki")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Repository name should be less than 80 characters and can contain alphanumeric, underscore, hyphen and dot characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Password can contain alphanumeric and/or special characters.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[builtins.str]:
        """
        Path should always start with "/" and can contain alphanumeric, underscore, hyphen and dot characters.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[builtins.str]:
        """
        Protocol - Choices: `CDROM`, `DISK`, `FTP`, `HTTP`, `HTTPS`, `NFS`, `SFTP`, `TFTP`
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of the server
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User name
        """
        return pulumi.get(self, "user_name")

