# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v30</h1>       <p>Introduced in Cloudera Manager 6.0.0</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 6.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ClouderaManagerResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def begin_trial(self, **kwargs):
        """
        Begin trial license.
        Begin trial license.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.begin_trial(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.begin_trial_with_http_info(**kwargs)
        else:
            (data) = self.begin_trial_with_http_info(**kwargs)
            return data

    def begin_trial_with_http_info(self, **kwargs):
        """
        Begin trial license.
        Begin trial license.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.begin_trial_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method begin_trial" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/trial/begin', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def collect_diagnostic_data_command(self, **kwargs):
        """
        Collect diagnostic data from hosts managed by Cloudera Manager.
        Collect diagnostic data from hosts managed by Cloudera Manager. <p> After the command has completed, the ApiCommand will contain a resultDataUrl from where you can download the result. <p/> Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.collect_diagnostic_data_command(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiCollectDiagnosticDataArguments body: The command arguments.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.collect_diagnostic_data_command_with_http_info(**kwargs)
        else:
            (data) = self.collect_diagnostic_data_command_with_http_info(**kwargs)
            return data

    def collect_diagnostic_data_command_with_http_info(self, **kwargs):
        """
        Collect diagnostic data from hosts managed by Cloudera Manager.
        Collect diagnostic data from hosts managed by Cloudera Manager. <p> After the command has completed, the ApiCommand will contain a resultDataUrl from where you can download the result. <p/> Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.collect_diagnostic_data_command_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiCollectDiagnosticDataArguments body: The command arguments.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method collect_diagnostic_data_command" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/commands/collectDiagnosticData', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_credentials_command(self, **kwargs):
        """
        Delete existing Kerberos credentials.
        Delete existing Kerberos credentials. <p> This command will affect all services that have been configured to use Kerberos, and have existing credentials. In V18 this takes a new paramater to determine whether it needs to delete all credentials or just unused ones.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_credentials_command(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str delete_credentials_mode: this can be set to \"all\" or \"unused\"
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_credentials_command_with_http_info(**kwargs)
        else:
            (data) = self.delete_credentials_command_with_http_info(**kwargs)
            return data

    def delete_credentials_command_with_http_info(self, **kwargs):
        """
        Delete existing Kerberos credentials.
        Delete existing Kerberos credentials. <p> This command will affect all services that have been configured to use Kerberos, and have existing credentials. In V18 this takes a new paramater to determine whether it needs to delete all credentials or just unused ones.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_credentials_command_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str delete_credentials_mode: this can be set to \"all\" or \"unused\"
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['delete_credentials_mode']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_credentials_command" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'delete_credentials_mode' in params:
            query_params.append(('deleteCredentialsMode', params['delete_credentials_mode']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/commands/deleteCredentials', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def end_trial(self, **kwargs):
        """
        End trial license.
        End trial license.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.end_trial(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.end_trial_with_http_info(**kwargs)
        else:
            (data) = self.end_trial_with_http_info(**kwargs)
            return data

    def end_trial_with_http_info(self, **kwargs):
        """
        End trial license.
        End trial license.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.end_trial_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method end_trial" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/trial/end', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def generate_credentials_command(self, **kwargs):
        """
        Generate missing Kerberos credentials.
        Generate missing Kerberos credentials. <p> This command will affect all services that have been configured to use Kerberos, and haven't had their credentials generated yet.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.generate_credentials_command(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.generate_credentials_command_with_http_info(**kwargs)
        else:
            (data) = self.generate_credentials_command_with_http_info(**kwargs)
            return data

    def generate_credentials_command_with_http_info(self, **kwargs):
        """
        Generate missing Kerberos credentials.
        Generate missing Kerberos credentials. <p> This command will affect all services that have been configured to use Kerberos, and haven't had their credentials generated yet.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.generate_credentials_command_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_credentials_command" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/commands/generateCredentials', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_config(self, **kwargs):
        """
        Retrieve the Cloudera Manager settings.
        Retrieve the Cloudera Manager settings.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_config(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view: The view to materialize, either \"summary\" or \"full\".
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_config_with_http_info(**kwargs)
        else:
            (data) = self.get_config_with_http_info(**kwargs)
            return data

    def get_config_with_http_info(self, **kwargs):
        """
        Retrieve the Cloudera Manager settings.
        Retrieve the Cloudera Manager settings.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_config_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view: The view to materialize, either \"summary\" or \"full\".
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_config" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/config', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiConfigList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_deployment2(self, **kwargs):
        """
        Retrieve full description of the entire Cloudera Manager deployment including all hosts, clusters, services, roles, users, settings, etc.
        Retrieve full description of the entire Cloudera Manager deployment including all hosts, clusters, services, roles, users, settings, etc. <p/> This object can be used to reconstruct your entire deployment <p/> Note: Only users with sufficient privileges are allowed to call this. <ul> <li>Full Administrators</li> <li>Cluster Administrators (but Navigator config will be redacted)</li> </ul> <p/> Note: starting with v19, the deployment information contains a newer version of users ApiUser2 that can hold granular permissions.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_deployment2(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view: May be one of \"export\" (default) or \"export_redacted\".  The latter replaces configurations that are sensitive with the word \"REDACTED\".
        :return: ApiDeployment2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_deployment2_with_http_info(**kwargs)
        else:
            (data) = self.get_deployment2_with_http_info(**kwargs)
            return data

    def get_deployment2_with_http_info(self, **kwargs):
        """
        Retrieve full description of the entire Cloudera Manager deployment including all hosts, clusters, services, roles, users, settings, etc.
        Retrieve full description of the entire Cloudera Manager deployment including all hosts, clusters, services, roles, users, settings, etc. <p/> This object can be used to reconstruct your entire deployment <p/> Note: Only users with sufficient privileges are allowed to call this. <ul> <li>Full Administrators</li> <li>Cluster Administrators (but Navigator config will be redacted)</li> </ul> <p/> Note: starting with v19, the deployment information contains a newer version of users ApiUser2 that can hold granular permissions.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_deployment2_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view: May be one of \"export\" (default) or \"export_redacted\".  The latter replaces configurations that are sensitive with the word \"REDACTED\".
        :return: ApiDeployment2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deployment2" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/deployment', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiDeployment2',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_kerberos_info(self, **kwargs):
        """
        Provides Cloudera Manager Kerberos information.
        Provides Cloudera Manager Kerberos information
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_kerberos_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiKerberosInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_kerberos_info_with_http_info(**kwargs)
        else:
            (data) = self.get_kerberos_info_with_http_info(**kwargs)
            return data

    def get_kerberos_info_with_http_info(self, **kwargs):
        """
        Provides Cloudera Manager Kerberos information.
        Provides Cloudera Manager Kerberos information
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_kerberos_info_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiKerberosInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_kerberos_info" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/kerberosInfo', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiKerberosInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_kerberos_principals(self, **kwargs):
        """
        Returns the Kerberos principals needed by the services being managed by Cloudera Manager.
        Returns the Kerberos principals needed by the services being managed by Cloudera Manager.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_kerberos_principals(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool missing_only: Whether to include only those principals which do not already exist in Cloudera Manager's database.
        :return: ApiPrincipalList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_kerberos_principals_with_http_info(**kwargs)
        else:
            (data) = self.get_kerberos_principals_with_http_info(**kwargs)
            return data

    def get_kerberos_principals_with_http_info(self, **kwargs):
        """
        Returns the Kerberos principals needed by the services being managed by Cloudera Manager.
        Returns the Kerberos principals needed by the services being managed by Cloudera Manager.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_kerberos_principals_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool missing_only: Whether to include only those principals which do not already exist in Cloudera Manager's database.
        :return: ApiPrincipalList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['missing_only']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_kerberos_principals" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'missing_only' in params:
            query_params.append(('missingOnly', params['missing_only']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/kerberosPrincipals', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiPrincipalList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_licensed_feature_usage(self, **kwargs):
        """
        Retrieve a summary of licensed feature usage.
        Retrieve a summary of licensed feature usage. <p/> This command will return information about what Cloudera Enterprise licensed features are in use in the clusters being managed by this Cloudera Manager, as well as totals for usage across all clusters. <p/> The specific features described can vary between different versions of Cloudera Manager. <p/> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_licensed_feature_usage(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiLicensedFeatureUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_licensed_feature_usage_with_http_info(**kwargs)
        else:
            (data) = self.get_licensed_feature_usage_with_http_info(**kwargs)
            return data

    def get_licensed_feature_usage_with_http_info(self, **kwargs):
        """
        Retrieve a summary of licensed feature usage.
        Retrieve a summary of licensed feature usage. <p/> This command will return information about what Cloudera Enterprise licensed features are in use in the clusters being managed by this Cloudera Manager, as well as totals for usage across all clusters. <p/> The specific features described can vary between different versions of Cloudera Manager. <p/> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_licensed_feature_usage_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiLicensedFeatureUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_licensed_feature_usage" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/licensedFeatureUsage', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiLicensedFeatureUsage',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_log(self, **kwargs):
        """
        Returns the entire contents of the Cloudera Manager log file.
        Returns the entire contents of the Cloudera Manager log file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_log(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_log_with_http_info(**kwargs)
        else:
            (data) = self.get_log_with_http_info(**kwargs)
            return data

    def get_log_with_http_info(self, **kwargs):
        """
        Returns the entire contents of the Cloudera Manager log file.
        Returns the entire contents of the Cloudera Manager log file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_log_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_log" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/log', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_scm_db_info(self, **kwargs):
        """
        Provides Cloudera Manager server's database information.
        Provides Cloudera Manager server's database information
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_scm_db_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiScmDbInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_scm_db_info_with_http_info(**kwargs)
        else:
            (data) = self.get_scm_db_info_with_http_info(**kwargs)
            return data

    def get_scm_db_info_with_http_info(self, **kwargs):
        """
        Provides Cloudera Manager server's database information.
        Provides Cloudera Manager server's database information
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_scm_db_info_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiScmDbInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scm_db_info" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/scmDbInfo', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiScmDbInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_shutdown_readiness(self, **kwargs):
        """
        Retrieve Cloudera Manager's readiness for shutdown and destroy.
        Retrieve Cloudera Manager's readiness for shutdown and destroy. Applications that wish to destroy Cloudera Manager and its managed cluster should poll this API, repeatedly if necessary, to respect its readiness.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_shutdown_readiness(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str last_activity_time: End time of the last known activity/workload against the managed clusters, in ISO 8601 format.
        :return: ApiShutdownReadiness
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_shutdown_readiness_with_http_info(**kwargs)
        else:
            (data) = self.get_shutdown_readiness_with_http_info(**kwargs)
            return data

    def get_shutdown_readiness_with_http_info(self, **kwargs):
        """
        Retrieve Cloudera Manager's readiness for shutdown and destroy.
        Retrieve Cloudera Manager's readiness for shutdown and destroy. Applications that wish to destroy Cloudera Manager and its managed cluster should poll this API, repeatedly if necessary, to respect its readiness.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_shutdown_readiness_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str last_activity_time: End time of the last known activity/workload against the managed clusters, in ISO 8601 format.
        :return: ApiShutdownReadiness
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['last_activity_time']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shutdown_readiness" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'last_activity_time' in params:
            query_params.append(('lastActivityTime', params['last_activity_time']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/shutdownReadiness', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiShutdownReadiness',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_version(self, **kwargs):
        """
        Provides version information of Cloudera Manager itself.
        Provides version information of Cloudera Manager itself.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_version(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiVersionInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_version_with_http_info(**kwargs)
        else:
            (data) = self.get_version_with_http_info(**kwargs)
            return data

    def get_version_with_http_info(self, **kwargs):
        """
        Provides version information of Cloudera Manager itself.
        Provides version information of Cloudera Manager itself.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_version_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiVersionInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_version" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/version', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiVersionInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def host_install_command(self, **kwargs):
        """
        Perform installation on a set of hosts.
        Perform installation on a set of hosts. <p/> This command installs Cloudera Manager Agent on a set of hosts. <p/> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.host_install_command(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiHostInstallArguments body: Hosts to perform installation on
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.host_install_command_with_http_info(**kwargs)
        else:
            (data) = self.host_install_command_with_http_info(**kwargs)
            return data

    def host_install_command_with_http_info(self, **kwargs):
        """
        Perform installation on a set of hosts.
        Perform installation on a set of hosts. <p/> This command installs Cloudera Manager Agent on a set of hosts. <p/> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.host_install_command_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiHostInstallArguments body: Hosts to perform installation on
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method host_install_command" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/commands/hostInstall', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hosts_decommission_command(self, **kwargs):
        """
        Decommission the given hosts.
        Decommission the given hosts. All slave roles on the hosts will be decommissioned. All other roles will be stopped.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hosts_decommission_command(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiHostNameList body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hosts_decommission_command_with_http_info(**kwargs)
        else:
            (data) = self.hosts_decommission_command_with_http_info(**kwargs)
            return data

    def hosts_decommission_command_with_http_info(self, **kwargs):
        """
        Decommission the given hosts.
        Decommission the given hosts. All slave roles on the hosts will be decommissioned. All other roles will be stopped.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hosts_decommission_command_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiHostNameList body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hosts_decommission_command" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/commands/hostsDecommission', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hosts_offline_or_decommission_command(self, **kwargs):
        """
        Decommission the given hosts.
        Decommission the given hosts. All slave roles on the hosts will be offlined or decommissioned with preference being offlined if supported by the service. <p> Currently the offline operation is only supported by HDFS, where the offline operation will put DataNodes into <em>HDFS IN MAINTENANCE</em> state which prevents unnecessary re-replication which could occur if decommissioned. <p> All other roles on the hosts will be stopped. <p> The <em>offlineTimeout</em> parameter is used to specify a timeout for offline. For HDFS, when the timeout expires, the DataNode will automatically transition out of <em>HDFS IN MAINTENANCE</em> state, back to <em>HDFS IN SERVICE</em> state. <p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hosts_offline_or_decommission_command(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param float offline_timeout: offline timeout in seconds. Specify as null to get the default timeout (4 hours). Ignored if service does not support he offline operation.
        :param ApiHostNameList body: list of host names to decommission.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hosts_offline_or_decommission_command_with_http_info(**kwargs)
        else:
            (data) = self.hosts_offline_or_decommission_command_with_http_info(**kwargs)
            return data

    def hosts_offline_or_decommission_command_with_http_info(self, **kwargs):
        """
        Decommission the given hosts.
        Decommission the given hosts. All slave roles on the hosts will be offlined or decommissioned with preference being offlined if supported by the service. <p> Currently the offline operation is only supported by HDFS, where the offline operation will put DataNodes into <em>HDFS IN MAINTENANCE</em> state which prevents unnecessary re-replication which could occur if decommissioned. <p> All other roles on the hosts will be stopped. <p> The <em>offlineTimeout</em> parameter is used to specify a timeout for offline. For HDFS, when the timeout expires, the DataNode will automatically transition out of <em>HDFS IN MAINTENANCE</em> state, back to <em>HDFS IN SERVICE</em> state. <p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hosts_offline_or_decommission_command_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param float offline_timeout: offline timeout in seconds. Specify as null to get the default timeout (4 hours). Ignored if service does not support he offline operation.
        :param ApiHostNameList body: list of host names to decommission.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offline_timeout', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hosts_offline_or_decommission_command" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offline_timeout' in params:
            query_params.append(('offlineTimeout', params['offline_timeout']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/commands/hostsOfflineOrDecommission', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hosts_recommission_and_exit_maintenance_mode_command(self, **kwargs):
        """
        Recommission and exit maintenance on the given hosts.
        Recommission and exit maintenance on the given hosts. The recommission step may optionally start roles as well.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hosts_recommission_and_exit_maintenance_mode_command(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str recommission_type: 
        :param ApiHostNameList body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hosts_recommission_and_exit_maintenance_mode_command_with_http_info(**kwargs)
        else:
            (data) = self.hosts_recommission_and_exit_maintenance_mode_command_with_http_info(**kwargs)
            return data

    def hosts_recommission_and_exit_maintenance_mode_command_with_http_info(self, **kwargs):
        """
        Recommission and exit maintenance on the given hosts.
        Recommission and exit maintenance on the given hosts. The recommission step may optionally start roles as well.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hosts_recommission_and_exit_maintenance_mode_command_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str recommission_type: 
        :param ApiHostNameList body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['recommission_type', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hosts_recommission_and_exit_maintenance_mode_command" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'recommission_type' in params:
            query_params.append(('recommissionType', params['recommission_type']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/commands/hostsRecommissionAndExitMaintenanceMode', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hosts_recommission_command(self, **kwargs):
        """
        Recommission the given hosts.
        Recommission the given hosts. All slave roles on the hosts will be recommissioned. Roles are not started after this command. Use hostsStartRoles command for that.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hosts_recommission_command(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiHostNameList body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hosts_recommission_command_with_http_info(**kwargs)
        else:
            (data) = self.hosts_recommission_command_with_http_info(**kwargs)
            return data

    def hosts_recommission_command_with_http_info(self, **kwargs):
        """
        Recommission the given hosts.
        Recommission the given hosts. All slave roles on the hosts will be recommissioned. Roles are not started after this command. Use hostsStartRoles command for that.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hosts_recommission_command_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiHostNameList body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hosts_recommission_command" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/commands/hostsRecommission', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hosts_recommission_with_start_command(self, **kwargs):
        """
        Recommission the given hosts.
        Recommission the given hosts. If slave roles support start when decommissioned, start those roles before recommission. All slave roles on the hosts will be recommissioned.  Warning: Evolving. This method may change in the future and does not offer standard compatibility guarantees. Recommission the given hosts. If possible, start those roles before recommission. All slave roles on the hosts will be recommissioned. Do not use without guidance from Cloudera.  Currently, only HDFS DataNodes will be started by this command.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hosts_recommission_with_start_command(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiHostNameList body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hosts_recommission_with_start_command_with_http_info(**kwargs)
        else:
            (data) = self.hosts_recommission_with_start_command_with_http_info(**kwargs)
            return data

    def hosts_recommission_with_start_command_with_http_info(self, **kwargs):
        """
        Recommission the given hosts.
        Recommission the given hosts. If slave roles support start when decommissioned, start those roles before recommission. All slave roles on the hosts will be recommissioned.  Warning: Evolving. This method may change in the future and does not offer standard compatibility guarantees. Recommission the given hosts. If possible, start those roles before recommission. All slave roles on the hosts will be recommissioned. Do not use without guidance from Cloudera.  Currently, only HDFS DataNodes will be started by this command.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hosts_recommission_with_start_command_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiHostNameList body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hosts_recommission_with_start_command" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/commands/hostsRecommissionWithStart', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hosts_start_roles_command(self, **kwargs):
        """
        Start all the roles on the given hosts.
        Start all the roles on the given hosts.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hosts_start_roles_command(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiHostNameList body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hosts_start_roles_command_with_http_info(**kwargs)
        else:
            (data) = self.hosts_start_roles_command_with_http_info(**kwargs)
            return data

    def hosts_start_roles_command_with_http_info(self, **kwargs):
        """
        Start all the roles on the given hosts.
        Start all the roles on the given hosts.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hosts_start_roles_command_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiHostNameList body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hosts_start_roles_command" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/commands/hostsStartRoles', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def import_admin_credentials(self, **kwargs):
        """
        Imports the KDC Account Manager credentials needed by Cloudera Manager to create kerberos principals needed by CDH services.
        Imports the KDC Account Manager credentials needed by Cloudera Manager to create kerberos principals needed by CDH services.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_admin_credentials(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str password: Password for the Account Manager.  return Information about the submitted command.
        :param str username: Username of the Account Manager. Full name including the Kerberos realm must be specified.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.import_admin_credentials_with_http_info(**kwargs)
        else:
            (data) = self.import_admin_credentials_with_http_info(**kwargs)
            return data

    def import_admin_credentials_with_http_info(self, **kwargs):
        """
        Imports the KDC Account Manager credentials needed by Cloudera Manager to create kerberos principals needed by CDH services.
        Imports the KDC Account Manager credentials needed by Cloudera Manager to create kerberos principals needed by CDH services.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_admin_credentials_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str password: Password for the Account Manager.  return Information about the submitted command.
        :param str username: Username of the Account Manager. Full name including the Kerberos realm must be specified.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['password', 'username']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_admin_credentials" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'password' in params:
            query_params.append(('password', params['password']))
        if 'username' in params:
            query_params.append(('username', params['username']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/commands/importAdminCredentials', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def import_cluster_template(self, **kwargs):
        """
        Create cluster as per the given cluster template.
        Create cluster as per the given cluster template
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_cluster_template(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool add_repositories: if true the parcels repositories in the cluster template will be added.
        :param ApiClusterTemplate body: cluster template
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.import_cluster_template_with_http_info(**kwargs)
        else:
            (data) = self.import_cluster_template_with_http_info(**kwargs)
            return data

    def import_cluster_template_with_http_info(self, **kwargs):
        """
        Create cluster as per the given cluster template.
        Create cluster as per the given cluster template
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_cluster_template_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool add_repositories: if true the parcels repositories in the cluster template will be added.
        :param ApiClusterTemplate body: cluster template
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['add_repositories', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_cluster_template" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'add_repositories' in params:
            query_params.append(('addRepositories', params['add_repositories']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/importClusterTemplate', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def import_kerberos_principal(self, **kwargs):
        """
        Imports the Kerberos credentials for the specified principal which can then be used to add to a role's keytab by running Generate Credentials command.
        Imports the Kerberos credentials for the specified principal which can then be used to add to a role's keytab by running Generate Credentials command.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_kerberos_principal(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param float kvno: Key-version number of the password.  return Information about the submitted command.
        :param str password: Password for the Kerberos principal. Cloudera Manager will encrypt the principal and password and use it when needed for a daemon.
        :param str principal: Name of the principal. Full name including the Kerberos realm must be specified. If it already exists, it will be overwritten.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.import_kerberos_principal_with_http_info(**kwargs)
        else:
            (data) = self.import_kerberos_principal_with_http_info(**kwargs)
            return data

    def import_kerberos_principal_with_http_info(self, **kwargs):
        """
        Imports the Kerberos credentials for the specified principal which can then be used to add to a role's keytab by running Generate Credentials command.
        Imports the Kerberos credentials for the specified principal which can then be used to add to a role's keytab by running Generate Credentials command.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_kerberos_principal_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param float kvno: Key-version number of the password.  return Information about the submitted command.
        :param str password: Password for the Kerberos principal. Cloudera Manager will encrypt the principal and password and use it when needed for a daemon.
        :param str principal: Name of the principal. Full name including the Kerberos realm must be specified. If it already exists, it will be overwritten.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['kvno', 'password', 'principal']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_kerberos_principal" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'kvno' in params:
            query_params.append(('kvno', params['kvno']))
        if 'password' in params:
            query_params.append(('password', params['password']))
        if 'principal' in params:
            query_params.append(('principal', params['principal']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/commands/importKerberosPrincipal', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def inspect_hosts_command(self, **kwargs):
        """
        Runs the host inspector on the configured hosts.
        Runs the host inspector on the configured hosts.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.inspect_hosts_command(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.inspect_hosts_command_with_http_info(**kwargs)
        else:
            (data) = self.inspect_hosts_command_with_http_info(**kwargs)
            return data

    def inspect_hosts_command_with_http_info(self, **kwargs):
        """
        Runs the host inspector on the configured hosts.
        Runs the host inspector on the configured hosts.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.inspect_hosts_command_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method inspect_hosts_command" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/commands/inspectHosts', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_active_commands(self, **kwargs):
        """
        List active global commands.
        List active global commands.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_active_commands(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiCommandList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_active_commands_with_http_info(**kwargs)
        else:
            (data) = self.list_active_commands_with_http_info(**kwargs)
            return data

    def list_active_commands_with_http_info(self, **kwargs):
        """
        List active global commands.
        List active global commands.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_active_commands_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiCommandList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_active_commands" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/commands', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommandList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_license(self, **kwargs):
        """
        Retrieve information about the Cloudera Manager license.
        Retrieve information about the Cloudera Manager license.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_license(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiLicense
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_license_with_http_info(**kwargs)
        else:
            (data) = self.read_license_with_http_info(**kwargs)
            return data

    def read_license_with_http_info(self, **kwargs):
        """
        Retrieve information about the Cloudera Manager license.
        Retrieve information about the Cloudera Manager license.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_license_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiLicense
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_license" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/license', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiLicense',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def refresh_parcel_repos(self, **kwargs):
        """
        .
        <p> Submit a command to refresh parcels information. </p> <p> This API could be used following two scenarios.<br> - User updated Cloudera Manager's local parcel repository. <br> - User updated remote parcel locations. <p> User wants to invoke this API to make sure that Cloudera Manager gets latest parcels information. User can then monitor the returned command before proceeding to the next step. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.refresh_parcel_repos(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.refresh_parcel_repos_with_http_info(**kwargs)
        else:
            (data) = self.refresh_parcel_repos_with_http_info(**kwargs)
            return data

    def refresh_parcel_repos_with_http_info(self, **kwargs):
        """
        .
        <p> Submit a command to refresh parcels information. </p> <p> This API could be used following two scenarios.<br> - User updated Cloudera Manager's local parcel repository. <br> - User updated remote parcel locations. <p> User wants to invoke this API to make sure that Cloudera Manager gets latest parcels information. User can then monitor the returned command before proceeding to the next step. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.refresh_parcel_repos_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method refresh_parcel_repos" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/commands/refreshParcelRepos', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_config(self, **kwargs):
        """
        Update the Cloudera Manager settings.
        Update the Cloudera Manager settings. <p> If a value is set in the given configuration, it will be added to the manager's settings, replacing any existing entry. If a value is unset (its value is null), the existing the setting will be erased. <p> Settings that are not listed in the input will maintain their current values.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_config(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str message: Optional message describing the changes.
        :param ApiConfigList body: Settings to update.
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_config_with_http_info(**kwargs)
        else:
            (data) = self.update_config_with_http_info(**kwargs)
            return data

    def update_config_with_http_info(self, **kwargs):
        """
        Update the Cloudera Manager settings.
        Update the Cloudera Manager settings. <p> If a value is set in the given configuration, it will be added to the manager's settings, replacing any existing entry. If a value is unset (its value is null), the existing the setting will be erased. <p> Settings that are not listed in the input will maintain their current values.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_config_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str message: Optional message describing the changes.
        :param ApiConfigList body: Settings to update.
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['message', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_config" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'message' in params:
            query_params.append(('message', params['message']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/config', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiConfigList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_deployment2(self, **kwargs):
        """
        Apply the supplied deployment description to the system.
        Apply the supplied deployment description to the system. This will create the clusters, services, hosts and other objects specified in the argument. This call does not allow for any merge conflicts. If an entity already exists in the system, this call will fail. You can request, however, that all entities in the system are deleted before instantiating the new ones. <p/> You may specify a complete or partial deployment, e.g. you can provide host info with no clusters.  However, if you request that the current deployment be deleted, you are required to specify at least one admin user or this call will fail. This is to protect you from creating a system that cannot be logged into again. <p/> If there are any errors creating (or optionally deleting) a deployment, all changes will be rolled back leaving the system exactly as it was before calling this method.  The system will never be left in a state where part of the deployment is created and other parts are not. <p/> If the submitted deployment contains entities that require Cloudera Enterprise license, then the license should be provided to Cloudera Manager before making this API call.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_deployment2(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool delete_current_deployment: If true, the current deployment is deleted before the specified deployment is applied
        :param ApiDeployment2 body: The deployment to create
        :return: ApiDeployment2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_deployment2_with_http_info(**kwargs)
        else:
            (data) = self.update_deployment2_with_http_info(**kwargs)
            return data

    def update_deployment2_with_http_info(self, **kwargs):
        """
        Apply the supplied deployment description to the system.
        Apply the supplied deployment description to the system. This will create the clusters, services, hosts and other objects specified in the argument. This call does not allow for any merge conflicts. If an entity already exists in the system, this call will fail. You can request, however, that all entities in the system are deleted before instantiating the new ones. <p/> You may specify a complete or partial deployment, e.g. you can provide host info with no clusters.  However, if you request that the current deployment be deleted, you are required to specify at least one admin user or this call will fail. This is to protect you from creating a system that cannot be logged into again. <p/> If there are any errors creating (or optionally deleting) a deployment, all changes will be rolled back leaving the system exactly as it was before calling this method.  The system will never be left in a state where part of the deployment is created and other parts are not. <p/> If the submitted deployment contains entities that require Cloudera Enterprise license, then the license should be provided to Cloudera Manager before making this API call.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_deployment2_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool delete_current_deployment: If true, the current deployment is deleted before the specified deployment is applied
        :param ApiDeployment2 body: The deployment to create
        :return: ApiDeployment2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['delete_current_deployment', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_deployment2" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'delete_current_deployment' in params:
            query_params.append(('deleteCurrentDeployment', params['delete_current_deployment']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/deployment', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiDeployment2',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_license(self, **kwargs):
        """
        Updates the Cloudera Manager license.
        Updates the Cloudera Manager license. <p> After a new license is installed, the Cloudera Manager needs to be restarted for the changes to take effect. <p> The license file should be uploaded using a request with content type \"multipart/form-data\", instead of being encoded into a JSON representation.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_license(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param file body: 
        :return: ApiLicense
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_license_with_http_info(**kwargs)
        else:
            (data) = self.update_license_with_http_info(**kwargs)
            return data

    def update_license_with_http_info(self, **kwargs):
        """
        Updates the Cloudera Manager license.
        Updates the Cloudera Manager license. <p> After a new license is installed, the Cloudera Manager needs to be restarted for the changes to take effect. <p> The license file should be uploaded using a request with content type \"multipart/form-data\", instead of being encoded into a JSON representation.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_license_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param file body: 
        :return: ApiLicense
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_license" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'body' in params:
            local_var_files['body'] = params['body']

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['multipart/form-data'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/cm/license', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiLicense',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
