# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v30</h1>       <p>Introduced in Cloudera Manager 6.0.0</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 6.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class EventsResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def read_event(self, event_id, **kwargs):
        """
        Returns a specific event in the system.
        Returns a specific event in the system
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_event(event_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str event_id: The UUID of the event to read (required)
        :return: ApiEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_event_with_http_info(event_id, **kwargs)
        else:
            (data) = self.read_event_with_http_info(event_id, **kwargs)
            return data

    def read_event_with_http_info(self, event_id, **kwargs):
        """
        Returns a specific event in the system.
        Returns a specific event in the system
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_event_with_http_info(event_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str event_id: The UUID of the event to read (required)
        :return: ApiEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_id' is set
        if ('event_id' not in params) or (params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `read_event`")


        collection_formats = {}

        path_params = {}
        if 'event_id' in params:
            path_params['eventId'] = params['event_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/events/{eventId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiEvent',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_events(self, **kwargs):
        """
        Allows you to query events in the system.
        Allows you to query events in the system.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_events(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int max_results: The maximum number of events to return.
        :param str query: The query to perform to find events in the system. It accepts querying the intersection of a list of constraints, joined together with semicolons (without spaces). For example: </p> <dl> <dt>alert==true</dt> <dd>looks for alerts.</dd> <dt>alert==true;attributes.host!=flaky.mysite.com</dt> <dd>looks for alerts, but exclude those with the host attribute of \"flaky.mysite.com\".</dd> <dt>category==log_event;attributes.log_level==ERROR</dt> <dd>looks for error log events. Event attribute matching is case sensitive.</dd> <dt>attributes.service==hbase1;content==hlog</dt> <dd>looks for any events from the \"hbase1\" service that mention \"hlog\".</dd> <dt>attributes.service==hbase1;content!=hlog</dt> <dd>looks for any events from the \"hbase1\" service that do not mention \"hlog\".<br/> A query must not contain only negative constraints (<em>!=</em>). It returns empty results because there is nothing to perform exclusion on.</dd> <dt>attributes.role_type==NAMENODE;severity==critical important</dt> <dd>looks for any important or critical events related to all NameNodes.</dd> <dt>severity==critical;timeReceived=ge=2012-05-04T00:00;timeReceived=lt=2012-05-04T00:10</dt> <dd>looks for critical events received between the given 10 minute range. <br/> When polling for events, use <em>timeReceived</em> instead of <em>timeOccurred</em> because events arrive out of order.</dd> </dl>  You may query any fields present in the ApiEvent object. You can also query by event attribute values using the <em>attributes.*</em> syntax. Values for date time fields (e.g. <em>timeOccurred</em>, <em>timeReceived</em>) should be ISO8601 timestamps. <p> The other valid comparators are <em>=lt=</em>, <em>=le=</em>, <em>=ge=</em>, and <em>=gt=</em>. They stand for \"&lt;\", \"&lt;=\", \"&gt;=\", \"&gt;\" respectively. These comparators are only applicable for date time fields.
        :param int result_offset: Specified the offset of events to return.
        :return: ApiEventQueryResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_events_with_http_info(**kwargs)
        else:
            (data) = self.read_events_with_http_info(**kwargs)
            return data

    def read_events_with_http_info(self, **kwargs):
        """
        Allows you to query events in the system.
        Allows you to query events in the system.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_events_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int max_results: The maximum number of events to return.
        :param str query: The query to perform to find events in the system. It accepts querying the intersection of a list of constraints, joined together with semicolons (without spaces). For example: </p> <dl> <dt>alert==true</dt> <dd>looks for alerts.</dd> <dt>alert==true;attributes.host!=flaky.mysite.com</dt> <dd>looks for alerts, but exclude those with the host attribute of \"flaky.mysite.com\".</dd> <dt>category==log_event;attributes.log_level==ERROR</dt> <dd>looks for error log events. Event attribute matching is case sensitive.</dd> <dt>attributes.service==hbase1;content==hlog</dt> <dd>looks for any events from the \"hbase1\" service that mention \"hlog\".</dd> <dt>attributes.service==hbase1;content!=hlog</dt> <dd>looks for any events from the \"hbase1\" service that do not mention \"hlog\".<br/> A query must not contain only negative constraints (<em>!=</em>). It returns empty results because there is nothing to perform exclusion on.</dd> <dt>attributes.role_type==NAMENODE;severity==critical important</dt> <dd>looks for any important or critical events related to all NameNodes.</dd> <dt>severity==critical;timeReceived=ge=2012-05-04T00:00;timeReceived=lt=2012-05-04T00:10</dt> <dd>looks for critical events received between the given 10 minute range. <br/> When polling for events, use <em>timeReceived</em> instead of <em>timeOccurred</em> because events arrive out of order.</dd> </dl>  You may query any fields present in the ApiEvent object. You can also query by event attribute values using the <em>attributes.*</em> syntax. Values for date time fields (e.g. <em>timeOccurred</em>, <em>timeReceived</em>) should be ISO8601 timestamps. <p> The other valid comparators are <em>=lt=</em>, <em>=le=</em>, <em>=ge=</em>, and <em>=gt=</em>. They stand for \"&lt;\", \"&lt;=\", \"&gt;=\", \"&gt;\" respectively. These comparators are only applicable for date time fields.
        :param int result_offset: Specified the offset of events to return.
        :return: ApiEventQueryResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['max_results', 'query', 'result_offset']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_events" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'max_results' in params:
            query_params.append(('maxResults', params['max_results']))
        if 'query' in params:
            query_params.append(('query', params['query']))
        if 'result_offset' in params:
            query_params.append(('resultOffset', params['result_offset']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/events', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiEventQueryResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
