# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v30</h1>       <p>Introduced in Cloudera Manager 6.0.0</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 6.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class YarnApplicationsResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_yarn_application_attributes(self, cluster_name, service_name, **kwargs):
        """
        Returns the list of all attributes that the Service Monitor can associate with YARN applications.
        Returns the list of all attributes that the Service Monitor can associate with YARN applications. <p> Examples of attributes include the user who ran the application and the number of maps completed by the application. <p> These attributes can be used to search for specific YARN applications through the getYarnApplications API. For example the 'user' attribute could be used in the search 'user = root'. If the attribute is numeric it can also be used as a metric in a tsquery (ie, 'select maps_completed from YARN_APPLICATIONS'). <p> Note that this response is identical for all YARN services. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_yarn_application_attributes(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :return: ApiYarnApplicationAttributeList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_yarn_application_attributes_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.get_yarn_application_attributes_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def get_yarn_application_attributes_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Returns the list of all attributes that the Service Monitor can associate with YARN applications.
        Returns the list of all attributes that the Service Monitor can associate with YARN applications. <p> Examples of attributes include the user who ran the application and the number of maps completed by the application. <p> These attributes can be used to search for specific YARN applications through the getYarnApplications API. For example the 'user' attribute could be used in the search 'user = root'. If the attribute is numeric it can also be used as a metric in a tsquery (ie, 'select maps_completed from YARN_APPLICATIONS'). <p> Note that this response is identical for all YARN services. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_yarn_application_attributes_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :return: ApiYarnApplicationAttributeList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_yarn_application_attributes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_yarn_application_attributes`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_yarn_application_attributes`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/yarnApplications/attributes', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiYarnApplicationAttributeList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_yarn_applications(self, cluster_name, service_name, **kwargs):
        """
        Returns a list of applications that satisfy the filter.
        Returns a list of applications that satisfy the filter <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_yarn_applications(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :param str filter: A filter to apply to the applications. A basic filter tests the value of an attribute and looks something like 'executing = true' or 'user = root'. Multiple basic filters can be combined into a complex expression using standard and / or boolean logic and parenthesis. An example of a complex filter is: 'application_duration > 5s and (user = root or user = myUserName').
        :param str _from: Start of the period to query in ISO 8601 format (defaults to 5 minutes before the 'to' time).
        :param int limit: The maximum number of applications to return. Applications will be returned in the following order: <ul> <li> All executing applications, ordered from longest to shortest running </li> <li> All completed applications order by end time descending. </li> </ul>
        :param int offset: The offset to start returning applications from. This is useful for paging through lists of applications. Note that this has non-deterministic behavior if executing applications are included in the response because they can disappear from the list while paging. To exclude executing applications from the response and a 'executing = false' clause to your filter.
        :param str to: End of the period to query in ISO 8601 format (defaults to now).
        :return: ApiYarnApplicationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_yarn_applications_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.get_yarn_applications_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def get_yarn_applications_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Returns a list of applications that satisfy the filter.
        Returns a list of applications that satisfy the filter <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_yarn_applications_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :param str filter: A filter to apply to the applications. A basic filter tests the value of an attribute and looks something like 'executing = true' or 'user = root'. Multiple basic filters can be combined into a complex expression using standard and / or boolean logic and parenthesis. An example of a complex filter is: 'application_duration > 5s and (user = root or user = myUserName').
        :param str _from: Start of the period to query in ISO 8601 format (defaults to 5 minutes before the 'to' time).
        :param int limit: The maximum number of applications to return. Applications will be returned in the following order: <ul> <li> All executing applications, ordered from longest to shortest running </li> <li> All completed applications order by end time descending. </li> </ul>
        :param int offset: The offset to start returning applications from. This is useful for paging through lists of applications. Note that this has non-deterministic behavior if executing applications are included in the response because they can disappear from the list while paging. To exclude executing applications from the response and a 'executing = false' clause to your filter.
        :param str to: End of the period to query in ISO 8601 format (defaults to now).
        :return: ApiYarnApplicationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'filter', '_from', 'limit', 'offset', 'to']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_yarn_applications" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_yarn_applications`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_yarn_applications`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'to' in params:
            query_params.append(('to', params['to']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/yarnApplications', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiYarnApplicationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def kill_yarn_application(self, application_id, cluster_name, service_name, **kwargs):
        """
        Kills an YARN Application.
        Kills an YARN Application <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.kill_yarn_application(application_id, cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str application_id: The applicationId to kill (required)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :return: ApiYarnKillResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.kill_yarn_application_with_http_info(application_id, cluster_name, service_name, **kwargs)
        else:
            (data) = self.kill_yarn_application_with_http_info(application_id, cluster_name, service_name, **kwargs)
            return data

    def kill_yarn_application_with_http_info(self, application_id, cluster_name, service_name, **kwargs):
        """
        Kills an YARN Application.
        Kills an YARN Application <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.kill_yarn_application_with_http_info(application_id, cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str application_id: The applicationId to kill (required)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :return: ApiYarnKillResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['application_id', 'cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method kill_yarn_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'application_id' is set
        if ('application_id' not in params) or (params['application_id'] is None):
            raise ValueError("Missing the required parameter `application_id` when calling `kill_yarn_application`")
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `kill_yarn_application`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `kill_yarn_application`")


        collection_formats = {}

        path_params = {}
        if 'application_id' in params:
            path_params['applicationId'] = params['application_id']
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/yarnApplications/{applicationId}/kill', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiYarnKillResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
