# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v30</h1>       <p>Introduced in Cloudera Manager 6.0.0</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 6.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiCdhUpgradeArgs(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cdh_parcel_version': 'str',
        'cdh_package_version': 'str',
        'rolling_restart_args': 'ApiRollingUpgradeClusterArgs',
        'deploy_client_config': 'bool',
        'start_all_services': 'bool'
    }

    attribute_map = {
        'cdh_parcel_version': 'cdhParcelVersion',
        'cdh_package_version': 'cdhPackageVersion',
        'rolling_restart_args': 'rollingRestartArgs',
        'deploy_client_config': 'deployClientConfig',
        'start_all_services': 'startAllServices'
    }

    def __init__(self, cdh_parcel_version=None, cdh_package_version=None, rolling_restart_args=None, deploy_client_config=None, start_all_services=None):
        """
        ApiCdhUpgradeArgs - a model defined in Swagger
        """

        self._cdh_parcel_version = None
        self._cdh_package_version = None
        self._rolling_restart_args = None
        self._deploy_client_config = None
        self._start_all_services = None

        if cdh_parcel_version is not None:
          self.cdh_parcel_version = cdh_parcel_version
        if cdh_package_version is not None:
          self.cdh_package_version = cdh_package_version
        if rolling_restart_args is not None:
          self.rolling_restart_args = rolling_restart_args
        if deploy_client_config is not None:
          self.deploy_client_config = deploy_client_config
        if start_all_services is not None:
          self.start_all_services = start_all_services

    @property
    def cdh_parcel_version(self):
        """
        Gets the cdh_parcel_version of this ApiCdhUpgradeArgs.
        If using parcels, the full version of an already distributed parcel for the next major CDH version. Default is null, which indicates this is a package upgrade. Example versions are: '5.0.0-1.cdh5.0.0.p0.11' or '5.0.2-1.cdh5.0.2.p0.32'

        :return: The cdh_parcel_version of this ApiCdhUpgradeArgs.
        :rtype: str
        """
        return self._cdh_parcel_version

    @cdh_parcel_version.setter
    def cdh_parcel_version(self, cdh_parcel_version):
        """
        Sets the cdh_parcel_version of this ApiCdhUpgradeArgs.
        If using parcels, the full version of an already distributed parcel for the next major CDH version. Default is null, which indicates this is a package upgrade. Example versions are: '5.0.0-1.cdh5.0.0.p0.11' or '5.0.2-1.cdh5.0.2.p0.32'

        :param cdh_parcel_version: The cdh_parcel_version of this ApiCdhUpgradeArgs.
        :type: str
        """

        self._cdh_parcel_version = cdh_parcel_version

    @property
    def cdh_package_version(self):
        """
        Gets the cdh_package_version of this ApiCdhUpgradeArgs.
        If using packages, the full version of the CDH packages being upgraded to, such as \"5.1.2\". These packages must already be installed on the cluster before running the upgrade command. For backwards compatibility, if \"5.0.0\" is specified here, then the upgrade command will relax validation of installed packages to match v6 behavior, only checking major version. <p> Introduced in v9. Has no effect in older API versions, which assume \"5.0.0\"

        :return: The cdh_package_version of this ApiCdhUpgradeArgs.
        :rtype: str
        """
        return self._cdh_package_version

    @cdh_package_version.setter
    def cdh_package_version(self, cdh_package_version):
        """
        Sets the cdh_package_version of this ApiCdhUpgradeArgs.
        If using packages, the full version of the CDH packages being upgraded to, such as \"5.1.2\". These packages must already be installed on the cluster before running the upgrade command. For backwards compatibility, if \"5.0.0\" is specified here, then the upgrade command will relax validation of installed packages to match v6 behavior, only checking major version. <p> Introduced in v9. Has no effect in older API versions, which assume \"5.0.0\"

        :param cdh_package_version: The cdh_package_version of this ApiCdhUpgradeArgs.
        :type: str
        """

        self._cdh_package_version = cdh_package_version

    @property
    def rolling_restart_args(self):
        """
        Gets the rolling_restart_args of this ApiCdhUpgradeArgs.
        If provided and rolling restart is available, will perform rolling restart with the requested arguments. If provided and rolling restart is not available, errors. If omitted, will do a regular restart. <p> Introduced in v9. Has no effect in older API versions, which must always do a hard restart.

        :return: The rolling_restart_args of this ApiCdhUpgradeArgs.
        :rtype: ApiRollingUpgradeClusterArgs
        """
        return self._rolling_restart_args

    @rolling_restart_args.setter
    def rolling_restart_args(self, rolling_restart_args):
        """
        Sets the rolling_restart_args of this ApiCdhUpgradeArgs.
        If provided and rolling restart is available, will perform rolling restart with the requested arguments. If provided and rolling restart is not available, errors. If omitted, will do a regular restart. <p> Introduced in v9. Has no effect in older API versions, which must always do a hard restart.

        :param rolling_restart_args: The rolling_restart_args of this ApiCdhUpgradeArgs.
        :type: ApiRollingUpgradeClusterArgs
        """

        self._rolling_restart_args = rolling_restart_args

    @property
    def deploy_client_config(self):
        """
        Gets the deploy_client_config of this ApiCdhUpgradeArgs.
        Not used starting in v9 - Client config is always deployed as part of upgrade. For older versions, determines whether client configuration should be deployed as part of upgrade. Default is true.

        :return: The deploy_client_config of this ApiCdhUpgradeArgs.
        :rtype: bool
        """
        return self._deploy_client_config

    @deploy_client_config.setter
    def deploy_client_config(self, deploy_client_config):
        """
        Sets the deploy_client_config of this ApiCdhUpgradeArgs.
        Not used starting in v9 - Client config is always deployed as part of upgrade. For older versions, determines whether client configuration should be deployed as part of upgrade. Default is true.

        :param deploy_client_config: The deploy_client_config of this ApiCdhUpgradeArgs.
        :type: bool
        """

        self._deploy_client_config = deploy_client_config

    @property
    def start_all_services(self):
        """
        Gets the start_all_services of this ApiCdhUpgradeArgs.
        Not used starting in v9 - All servies are always started as part of upgrade. For older versions, determines whether all services should be started should be deployed as part of upgrade. Default is true.

        :return: The start_all_services of this ApiCdhUpgradeArgs.
        :rtype: bool
        """
        return self._start_all_services

    @start_all_services.setter
    def start_all_services(self, start_all_services):
        """
        Sets the start_all_services of this ApiCdhUpgradeArgs.
        Not used starting in v9 - All servies are always started as part of upgrade. For older versions, determines whether all services should be started should be deployed as part of upgrade. Default is true.

        :param start_all_services: The start_all_services of this ApiCdhUpgradeArgs.
        :type: bool
        """

        self._start_all_services = start_all_services

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiCdhUpgradeArgs):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
